/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.seq.io.WordTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class CrossProductTokenization
extends WordTokenization {
    private List subTokenizations;

    public CrossProductTokenization(Alphabet alpha) throws BioException {
        super(alpha);
        this.subTokenizations = new ArrayList();
        for (Alphabet subAlpha : alpha.getAlphabets()) {
            this.subTokenizations.add(subAlpha.getTokenization("name"));
        }
    }

    public CrossProductTokenization(Alphabet alpha, List tokenizers) {
        super(alpha);
        this.subTokenizations = tokenizers;
    }

    public Symbol parseToken(String token) throws IllegalSymbolException {
        char c = token.charAt(0);
        if (c == '(') {
            if (token.charAt(token.length() - 1) != ')') {
                throw new IllegalSymbolException("Mismatched parentheses: " + token);
            }
            List split = this.splitString(token.substring(1, token.length() - 1));
            ArrayList<Symbol> syms = new ArrayList<Symbol>();
            Iterator si = split.iterator();
            Iterator ti = this.subTokenizations.iterator();
            while (si.hasNext()) {
                String subToken = (String)si.next();
                SymbolTokenization subTokenization = (SymbolTokenization)ti.next();
                syms.add(subTokenization.parseToken(subToken));
            }
            return this.getAlphabet().getSymbol(syms);
        }
        if (c == '[') {
            if (token.charAt(token.length() - 1) != ']') {
                throw new IllegalSymbolException("Mismatched parentheses: " + token);
            }
            Symbol[] syms = this.parseString(token.substring(1, token.length() - 1));
            HashSet<Symbol> ambigSet = new HashSet<Symbol>();
            for (int i = 0; i < syms.length; ++i) {
                ambigSet.add(syms[i]);
            }
            return this.getAlphabet().getAmbiguity(ambigSet);
        }
        throw new IllegalSymbolException("Not in standard cross-product form: " + token);
    }

    public String tokenizeSymbol(Symbol s) throws IllegalSymbolException {
        this.getAlphabet().validate(s);
        if (s instanceof BasisSymbol) {
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            Iterator si = ((BasisSymbol)s).getSymbols().iterator();
            Iterator ti = this.subTokenizations.iterator();
            while (si.hasNext()) {
                Symbol subSym = (Symbol)si.next();
                SymbolTokenization subToke = (SymbolTokenization)ti.next();
                sb.append(subToke.tokenizeSymbol(subSym));
                if (!si.hasNext()) continue;
                sb.append(' ');
            }
            sb.append(')');
            return sb.substring(0);
        }
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        Iterator<Symbol> si = ((FiniteAlphabet)s.getMatches()).iterator();
        while (si.hasNext()) {
            Symbol aSym = si.next();
            sb.append(this.tokenizeSymbol(aSym));
            if (!si.hasNext()) continue;
            sb.append(' ');
        }
        sb.append(']');
        return sb.substring(0);
    }
}

