/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game12;

import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game12.StAXFeatureHandler;
import org.biojava.bio.seq.io.game12.StAXHandlerFactory;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.SAXException;

public class GAMEPropertyHandler
extends StAXFeatureHandler {
    String propertyType = null;
    String propertyValue = null;
    public static final StAXHandlerFactory GAME_PROPERTY_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMEPropertyHandler(staxenv);
        }
    };

    GAMEPropertyHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        super.addHandler(new ElementRecognizer.ByLocalName("type"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new TypeHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("value"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new ValueHandler();
            }
        });
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) throws SAXException {
        if (this.propertyType == null || this.propertyValue == null) {
            return;
        }
        try {
            this.listener.addFeatureProperty(this.propertyType, this.propertyValue);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SAXException("unexpected exception while adding <property> as a feature property.");
        }
    }

    private class ValueHandler
    extends StringElementHandlerBase {
        private ValueHandler() {
        }

        protected void setStringValue(String s) {
            GAMEPropertyHandler.this.propertyValue = s.trim();
        }
    }

    private class TypeHandler
    extends StringElementHandlerBase {
        private TypeHandler() {
        }

        protected void setStringValue(String s) {
            GAMEPropertyHandler.this.propertyType = s.trim();
        }
    }
}

