/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.complex.ComplexMatrix;
import flanagan.math.Fmath;
import flanagan.math.Matrix;

public class PhasorMatrix {
    private int nrow = 0;
    private int ncol = 0;
    private Phasor[][] matrix = null;
    private int[] index = null;
    private double dswap = 1.0;
    private static final double TINY = 1.0E-30;

    public PhasorMatrix(int nrow, int ncol) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.matrix = Phasor.twoDarray(nrow, ncol);
        this.index = new int[nrow];
        for (int i = 0; i < nrow; ++i) {
            this.index[i] = i;
        }
        this.dswap = 1.0;
    }

    public PhasorMatrix(int nrow, int ncol, Phasor constant) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.matrix = Phasor.twoDarray(nrow, ncol, constant);
        this.index = new int[nrow];
        for (int i = 0; i < nrow; ++i) {
            this.index[i] = i;
        }
        this.dswap = 1.0;
    }

    public PhasorMatrix(Phasor[][] twoD) {
        int i;
        this.nrow = twoD.length;
        this.ncol = twoD[0].length;
        for (i = 0; i < this.nrow; ++i) {
            if (twoD[i].length == this.ncol) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = twoD;
        this.index = new int[this.nrow];
        for (i = 0; i < this.nrow; ++i) {
            this.index[i] = i;
        }
        this.dswap = 1.0;
    }

    public PhasorMatrix(PhasorMatrix bb) {
        this.nrow = bb.nrow;
        this.ncol = bb.ncol;
        this.matrix = bb.matrix;
        this.index = bb.index;
        this.dswap = bb.dswap;
    }

    public void setTwoDarray(Phasor[][] aarray) {
        if (this.nrow != aarray.length) {
            throw new IllegalArgumentException("row length of this PhasorMatrix differs from that of the 2D array argument");
        }
        if (this.ncol != aarray[0].length) {
            throw new IllegalArgumentException("column length of this PhasorMatrix differs from that of the 2D array argument");
        }
        for (int i = 0; i < this.nrow; ++i) {
            if (aarray[i].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[i][j] = Phasor.copy(aarray[i][j]);
            }
        }
    }

    public void setElement(int i, int j, Phasor aa) {
        this.matrix[i][j] = Phasor.copy(aa);
    }

    public void setElement(int i, int j, double aa, double bb) {
        this.matrix[i][j].reset(aa, bb);
    }

    public void setSubMatrix(int i, int j, Phasor[][] subMatrix) {
        int k = subMatrix.length;
        int l = subMatrix[0].length;
        if (i > k) {
            throw new IllegalArgumentException("row indices inverted");
        }
        if (j > l) {
            throw new IllegalArgumentException("column indices inverted");
        }
        int n = k - i + 1;
        int m = l - j + 1;
        for (int p = 0; p < n; ++p) {
            for (int q = 0; q < m; ++q) {
                this.matrix[i + p][j + q] = Phasor.copy(subMatrix[p][q]);
            }
        }
    }

    public void setSubMatrix(int i, int j, int k, int l, Phasor[][] subMatrix) {
        if (i + k - 1 >= this.nrow) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (j + l - 1 >= this.ncol) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix");
        }
        int n = k - i + 1;
        int m = l - j + 1;
        for (int p = 0; p < n; ++p) {
            for (int q = 0; q < m; ++q) {
                this.matrix[i + p][j + q] = Phasor.copy(subMatrix[p][q]);
            }
        }
    }

    public void setSubMatrix(int[] row, int[] col, Phasor[][] subMatrix) {
        int n = row.length;
        int m = col.length;
        for (int p = 0; p < n; ++p) {
            for (int q = 0; q < m; ++q) {
                this.matrix[row[p]][col[q]] = Phasor.copy(subMatrix[p][q]);
            }
        }
    }

    public static PhasorMatrix identityMatrix(int nrow) {
        PhasorMatrix u = new PhasorMatrix(nrow, nrow);
        for (int i = 0; i < nrow; ++i) {
            u.matrix[i][i] = Phasor.plusOne();
        }
        return u;
    }

    public static PhasorMatrix scalarMatrix(int nrow, Phasor diagconst) {
        PhasorMatrix u = new PhasorMatrix(nrow, nrow);
        Phasor[][] uarray = u.getArrayReference();
        for (int i = 0; i < nrow; ++i) {
            for (int j = i; j < nrow; ++j) {
                if (i != j) continue;
                uarray[i][j] = Phasor.copy(diagconst);
            }
        }
        return u;
    }

    public static PhasorMatrix diagonalMatrix(int nrow, Phasor[] diag) {
        if (diag.length != nrow) {
            throw new IllegalArgumentException("matrix dimension differs from diagonal array length");
        }
        PhasorMatrix u = new PhasorMatrix(nrow, nrow);
        Phasor[][] uarray = u.getArrayReference();
        for (int i = 0; i < nrow; ++i) {
            for (int j = i; j < nrow; ++j) {
                if (i != j) continue;
                uarray[i][j] = Phasor.copy(diag[i]);
            }
        }
        return u;
    }

    public static PhasorMatrix columnMatrix(Phasor[] darray) {
        int nr = darray.length;
        PhasorMatrix pp = new PhasorMatrix(nr, 1);
        for (int i = 0; i < nr; ++i) {
            pp.matrix[i][0] = darray[i];
        }
        return pp;
    }

    public static PhasorMatrix rowMatrix(Phasor[] darray) {
        int nc = darray.length;
        PhasorMatrix pp = new PhasorMatrix(1, nc);
        for (int i = 0; i < nc; ++i) {
            pp.matrix[0][i] = darray[i];
        }
        return pp;
    }

    public int getNrow() {
        return this.nrow;
    }

    public int getNcol() {
        return this.ncol;
    }

    public Phasor[][] getArrayReference() {
        return this.matrix;
    }

    public Phasor[][] getArray() {
        return this.matrix;
    }

    public Phasor[][] getArrayPointer() {
        return this.matrix;
    }

    public Phasor[][] getArrayCopy() {
        Phasor[][] c = new Phasor[this.nrow][this.ncol];
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                c[i][j] = Phasor.copy(this.matrix[i][j]);
            }
        }
        return c;
    }

    public Phasor getElementReference(int i, int j) {
        return this.matrix[i][j];
    }

    public Phasor getElementPointer(int i, int j) {
        return this.matrix[i][j];
    }

    public Phasor getElementCopy(int i, int j) {
        return Phasor.copy(this.matrix[i][j]);
    }

    public PhasorMatrix getSubMatrix(int i, int j, int k, int l) {
        if (i + k - 1 >= this.nrow) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (j + l - 1 >= this.ncol) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix");
        }
        int n = k - i + 1;
        int m = l - j + 1;
        PhasorMatrix subMatrix = new PhasorMatrix(n, m);
        Phasor[][] sarray = subMatrix.getArrayReference();
        for (int p = 0; p < n; ++p) {
            for (int q = 0; q < m; ++q) {
                sarray[p][q] = Phasor.copy(this.matrix[i + p][j + q]);
            }
        }
        return subMatrix;
    }

    public PhasorMatrix getSubMatrix(int[] row, int[] col) {
        int n = row.length;
        int m = col.length;
        PhasorMatrix subMatrix = new PhasorMatrix(n, m);
        Phasor[][] sarray = subMatrix.getArrayReference();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                sarray[i][j] = Phasor.copy(this.matrix[row[i]][col[j]]);
            }
        }
        return subMatrix;
    }

    public int[] getIndexReference() {
        return this.index;
    }

    public int[] getIndexPointer() {
        return this.index;
    }

    public int[] getIndexCopy() {
        int[] indcopy = new int[this.nrow];
        for (int i = 0; i < this.nrow; ++i) {
            indcopy[i] = this.index[i];
        }
        return indcopy;
    }

    public double getSwap() {
        return this.dswap;
    }

    public static PhasorMatrix copy(PhasorMatrix a) {
        int i;
        if (a == null) {
            return null;
        }
        int nr = a.getNrow();
        int nc = a.getNcol();
        Phasor[][] aarray = a.getArrayReference();
        PhasorMatrix b = new PhasorMatrix(nr, nc);
        b.nrow = nr;
        b.ncol = nc;
        Phasor[][] barray = b.getArrayReference();
        for (i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                barray[i][j] = Phasor.copy(aarray[i][j]);
            }
        }
        for (i = 0; i < nr; ++i) {
            b.index[i] = a.index[i];
        }
        return b;
    }

    public PhasorMatrix copy() {
        int i;
        if (this == null) {
            return null;
        }
        int nr = this.nrow;
        int nc = this.ncol;
        PhasorMatrix b = new PhasorMatrix(nr, nc);
        Phasor[][] barray = b.getArrayReference();
        b.nrow = nr;
        b.ncol = nc;
        for (i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                barray[i][j] = Phasor.copy(this.matrix[i][j]);
            }
        }
        for (i = 0; i < nr; ++i) {
            b.index[i] = this.index[i];
        }
        return b;
    }

    public Object clone() {
        int i;
        if (this == null) {
            return null;
        }
        int nr = this.nrow;
        int nc = this.ncol;
        PhasorMatrix b = new PhasorMatrix(nr, nc);
        Phasor[][] barray = b.getArrayReference();
        b.nrow = nr;
        b.ncol = nc;
        for (i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                barray[i][j] = Phasor.copy(this.matrix[i][j]);
            }
        }
        for (i = 0; i < nr; ++i) {
            b.index[i] = this.index[i];
        }
        return b;
    }

    public static PhasorMatrix toPhasorRowMatrix(Phasor[] parray) {
        int nc = parray.length;
        PhasorMatrix pp = new PhasorMatrix(1, nc);
        for (int i = 0; i < nc; ++i) {
            pp.matrix[0][i] = parray[i].copy();
        }
        return pp;
    }

    public static PhasorMatrix toPhasorRowMatrix(Complex[] carray) {
        int nc = carray.length;
        PhasorMatrix pp = new PhasorMatrix(1, nc);
        for (int i = 0; i < nc; ++i) {
            pp.matrix[0][i] = Phasor.toPhasor(carray[i]).copy();
        }
        return pp;
    }

    public static PhasorMatrix toPhasorRowMatrix(double[] darray) {
        int nc = darray.length;
        PhasorMatrix pp = new PhasorMatrix(1, nc);
        for (int i = 0; i < nc; ++i) {
            pp.matrix[0][i] = new Phasor(darray[i], 0.0);
        }
        return pp;
    }

    public static PhasorMatrix toPhasorColumnMatrix(Phasor[] parray) {
        int nr = parray.length;
        PhasorMatrix pp = new PhasorMatrix(nr, 1);
        for (int i = 0; i < nr; ++i) {
            pp.matrix[i][0] = parray[i].copy();
        }
        return pp;
    }

    public static PhasorMatrix toPhasorColumnMatrix(Complex[] carray) {
        int nr = carray.length;
        PhasorMatrix pp = new PhasorMatrix(nr, 1);
        for (int i = 0; i < nr; ++i) {
            pp.matrix[i][0] = Phasor.toPhasor(carray[i]).copy();
        }
        return pp;
    }

    public static PhasorMatrix toPhasorColumnMatrix(double[] darray) {
        int nr = darray.length;
        PhasorMatrix pp = new PhasorMatrix(nr, 1);
        for (int i = 0; i < nr; ++i) {
            pp.matrix[i][0] = new Phasor(darray[i], 0.0);
        }
        return pp;
    }

    public static PhasorMatrix toPhasorMatrix(ComplexMatrix cc) {
        PhasorMatrix pp = new PhasorMatrix(cc.getNrow(), cc.getNcol());
        pp.index = cc.getIndexCopy();
        pp.dswap = cc.getSwap();
        for (int i = 0; i < pp.nrow; ++i) {
            int j = 0;
            while (j < pp.ncol) {
                pp.matrix[i][j] = Phasor.toPhasor(cc.getElementCopy(i, j));
                ++i;
            }
        }
        return pp;
    }

    public static PhasorMatrix toPhasorMatrix(Complex[][] carray) {
        ComplexMatrix cc = new ComplexMatrix(carray);
        PhasorMatrix pp = new PhasorMatrix(cc.getNrow(), cc.getNcol());
        for (int i = 0; i < pp.nrow; ++i) {
            int j = 0;
            while (j < pp.ncol) {
                pp.matrix[i][j] = Phasor.toPhasor(cc.getElementCopy(i, j));
                ++i;
            }
        }
        return pp;
    }

    public static PhasorMatrix toPhasorMatrix(Matrix marray) {
        int nr = marray.getNrow();
        int nc = marray.getNcol();
        PhasorMatrix pp = new PhasorMatrix(nr, nc);
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                pp.matrix[i][j].reset(marray.getElementCopy(i, j), 0.0);
            }
        }
        return pp;
    }

    public static PhasorMatrix toPhasorMatrix(double[][] darray) {
        int nr = darray.length;
        int nc = darray[0].length;
        for (int i = 1; i < nr; ++i) {
            if (darray[i].length == nc) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        PhasorMatrix pp = new PhasorMatrix(nr, nc);
        for (int i = 0; i < pp.nrow; ++i) {
            for (int j = 0; j < pp.ncol; ++j) {
                pp.matrix[i][j].reset(darray[i][j], 0.0);
            }
        }
        return pp;
    }

    public ComplexMatrix toComplexMatrix() {
        int nr = this.getNrow();
        int nc = this.getNcol();
        ComplexMatrix cc = new ComplexMatrix(nr, nc);
        for (int i = 0; i < nr; ++i) {
            int j = 0;
            while (j < nc) {
                cc.setElement(i, j, this.matrix[i][j].toRectangular());
                ++i;
            }
        }
        return cc;
    }

    public static ComplexMatrix toComplexMatrix(PhasorMatrix pp) {
        int nr = pp.getNrow();
        int nc = pp.getNcol();
        ComplexMatrix cc = new ComplexMatrix(nr, nc);
        for (int i = 0; i < nr; ++i) {
            int j = 0;
            while (j < nc) {
                cc.setElement(i, j, pp.matrix[i][j].toRectangular());
                ++i;
            }
        }
        return cc;
    }

    public PhasorMatrix plus(PhasorMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.nrow;
        int nc = bmat.ncol;
        PhasorMatrix cmat = new PhasorMatrix(nr, nc);
        Phasor[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j].plus(bmat.matrix[i][j]);
            }
        }
        return cmat;
    }

    public PhasorMatrix plus(Phasor[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        PhasorMatrix cmat = new PhasorMatrix(nr, nc);
        Phasor[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j].plus(bmat[i][j]);
            }
        }
        return cmat;
    }

    public PhasorMatrix plus(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.plus(pmat);
    }

    public PhasorMatrix plus(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.plus(pmat);
    }

    public PhasorMatrix plus(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.plus(pmat);
    }

    public PhasorMatrix plus(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.plus(pmat);
    }

    public void plusEquals(PhasorMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.nrow;
        int nc = bmat.ncol;
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                this.matrix[i][j].plusEquals(bmat.matrix[i][j]);
            }
        }
    }

    public void plusEquals(Phasor[][] bmat) {
        PhasorMatrix pmat = new PhasorMatrix(bmat);
        this.plusEquals(pmat);
    }

    public void plusEquals(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.plusEquals(pmat);
    }

    public void plusEquals(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.plusEquals(pmat);
    }

    public void plusEquals(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.plusEquals(pmat);
    }

    public void plusEquals(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.plusEquals(pmat);
    }

    public PhasorMatrix minus(PhasorMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = this.nrow;
        int nc = this.ncol;
        PhasorMatrix cmat = new PhasorMatrix(nr, nc);
        Phasor[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j].minus(bmat.matrix[i][j]);
            }
        }
        return cmat;
    }

    public PhasorMatrix minus(Phasor[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        PhasorMatrix cmat = new PhasorMatrix(nr, nc);
        Phasor[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j].minus(bmat[i][j]);
            }
        }
        return cmat;
    }

    public PhasorMatrix minus(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.minus(pmat);
    }

    public PhasorMatrix minus(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.minus(pmat);
    }

    public PhasorMatrix minus(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.minus(pmat);
    }

    public PhasorMatrix minus(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.minus(pmat);
    }

    public void minusEquals(PhasorMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.nrow;
        int nc = bmat.ncol;
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                this.matrix[i][j].minusEquals(bmat.matrix[i][j]);
            }
        }
    }

    public void minusEquals(Phasor[][] bmat) {
        PhasorMatrix pmat = new PhasorMatrix(bmat);
        this.minusEquals(pmat);
    }

    public void minusEquals(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.minusEquals(pmat);
    }

    public void minusEquals(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.minusEquals(pmat);
    }

    public void minusEquals(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.minusEquals(pmat);
    }

    public void minusEquals(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.minusEquals(pmat);
    }

    public PhasorMatrix times(PhasorMatrix bmat) {
        if (this.ncol != bmat.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        PhasorMatrix cmat = new PhasorMatrix(this.nrow, bmat.ncol);
        Phasor[][] carray = cmat.getArrayReference();
        Phasor sum = new Phasor();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < bmat.ncol; ++j) {
                sum = Phasor.zero();
                for (int k = 0; k < this.ncol; ++k) {
                    sum.plusEquals(this.matrix[i][k].times(bmat.matrix[k][j]));
                }
                carray[i][j] = Phasor.copy(sum);
            }
        }
        return cmat;
    }

    public PhasorMatrix times(Phasor[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.ncol != nr) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        PhasorMatrix cmat = new PhasorMatrix(this.nrow, nc);
        Phasor[][] carray = cmat.getArrayReference();
        Phasor sum = new Phasor();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < nc; ++j) {
                sum = Phasor.zero();
                for (int k = 0; k < this.ncol; ++k) {
                    sum.plusEquals(this.matrix[i][k].times(bmat[k][j]));
                }
                carray[i][j] = Phasor.copy(sum);
            }
        }
        return cmat;
    }

    public PhasorMatrix times(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.times(pmat);
    }

    public PhasorMatrix times(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.times(pmat);
    }

    public PhasorMatrix times(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.times(pmat);
    }

    public PhasorMatrix times(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.times(pmat);
    }

    public PhasorMatrix times(Phasor constant) {
        PhasorMatrix cmat = new PhasorMatrix(this.nrow, this.ncol);
        Phasor[][] carray = cmat.getArrayReference();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                carray[i][j] = this.matrix[i][j].times(constant);
            }
        }
        return cmat;
    }

    public PhasorMatrix times(double constant) {
        PhasorMatrix cmat = new PhasorMatrix(this.nrow, this.ncol);
        Phasor[][] carray = cmat.getArrayReference();
        Phasor cconstant = new Phasor(constant, 0.0);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                carray[i][j] = this.matrix[i][j].times(cconstant);
            }
        }
        return cmat;
    }

    public void timesEquals(PhasorMatrix bmat) {
        if (this.ncol != bmat.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Phasor sum = new Phasor();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < bmat.ncol; ++j) {
                sum = Phasor.zero();
                for (int k = 0; k < this.ncol; ++k) {
                    sum.plusEquals(this.matrix[i][k].times(bmat.matrix[k][j]));
                }
                this.matrix[i][j] = Phasor.copy(sum);
            }
        }
    }

    public void timesEquals(Phasor[][] bmat) {
        PhasorMatrix pmat = new PhasorMatrix(bmat);
        this.timesEquals(pmat);
    }

    public void timesEquals(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.timesEquals(pmat);
    }

    public void timesEquals(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.timesEquals(pmat);
    }

    public void timesEquals(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.timesEquals(pmat);
    }

    public void timesEquals(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.timesEquals(pmat);
    }

    public void timesEquals(Phasor constant) {
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[i][j].timesEquals(constant);
            }
        }
    }

    public void timesEquals(Complex constant) {
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[i][j].timesEquals(constant);
            }
        }
    }

    public void timesEquals(double constant) {
        Phasor cconstant = new Phasor(constant, 0.0);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[i][j].timesEquals(cconstant);
            }
        }
    }

    public void timesEquals(int constant) {
        Phasor cconstant = new Phasor(constant, 0.0);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[i][j].timesEquals(cconstant);
            }
        }
    }

    public PhasorMatrix over(PhasorMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return this.times(bmat.inverse());
    }

    public PhasorMatrix over(Phasor[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        PhasorMatrix cmat = new PhasorMatrix(bmat);
        return this.times(cmat.inverse());
    }

    public PhasorMatrix over(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.over(pmat);
    }

    public PhasorMatrix over(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.over(pmat);
    }

    public PhasorMatrix over(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.over(pmat);
    }

    public PhasorMatrix over(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        return this.over(pmat);
    }

    public void overEquals(PhasorMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        PhasorMatrix cmat = new PhasorMatrix(bmat);
        this.timesEquals(cmat.inverse());
    }

    public void overEquals(Phasor[][] bmat) {
        PhasorMatrix pmat = new PhasorMatrix(bmat);
        this.overEquals(pmat);
    }

    public void overEquals(ComplexMatrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.overEquals(pmat);
    }

    public void overEquals(Complex[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.overEquals(pmat);
    }

    public void overEquals(Matrix bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.overEquals(pmat);
    }

    public void overEquals(double[][] bmat) {
        PhasorMatrix pmat = PhasorMatrix.toPhasorMatrix(bmat);
        this.overEquals(pmat);
    }

    public PhasorMatrix inverse() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Phasor[] col = new Phasor[n];
        Phasor[] xvec = new Phasor[n];
        PhasorMatrix invmat = new PhasorMatrix(n, n);
        Phasor[][] invarray = invmat.getArrayReference();
        PhasorMatrix ludmat = this.luDecomp();
        for (int j = 0; j < n; ++j) {
            int i;
            for (i = 0; i < n; ++i) {
                col[i] = Phasor.zero();
            }
            col[j] = Phasor.plusOne();
            xvec = ludmat.luBackSub(col);
            for (i = 0; i < n; ++i) {
                invarray[i][j] = Phasor.copy(xvec[i]);
            }
        }
        return invmat;
    }

    public PhasorMatrix transpose() {
        PhasorMatrix tmat = new PhasorMatrix(this.ncol, this.nrow);
        Phasor[][] tarray = tmat.getArrayReference();
        for (int i = 0; i < this.ncol; ++i) {
            for (int j = 0; j < this.nrow; ++j) {
                tarray[i][j] = Phasor.copy(this.matrix[j][i]);
            }
        }
        return tmat;
    }

    public PhasorMatrix conjugate() {
        PhasorMatrix conj = PhasorMatrix.copy(this);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                conj.matrix[i][j] = this.matrix[i][j].conjugate();
            }
        }
        return conj;
    }

    public PhasorMatrix adjoin() {
        PhasorMatrix adj = PhasorMatrix.copy(this);
        adj = adj.transpose();
        adj = adj.conjugate();
        return adj;
    }

    public PhasorMatrix opposite() {
        PhasorMatrix opp = PhasorMatrix.copy(this);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                opp.matrix[i][j] = this.matrix[i][j].times(Phasor.minusOne());
            }
        }
        return opp;
    }

    public Phasor trace() {
        Phasor trac = new Phasor(0.0, 0.0);
        for (int i = 0; i < Math.min(this.ncol, this.ncol); ++i) {
            trac.plusEquals(this.matrix[i][i]);
        }
        return trac;
    }

    public Phasor determinant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Phasor det = new Phasor();
        PhasorMatrix ludmat = this.luDecomp();
        det.reset(ludmat.dswap, 0.0);
        for (int j = 0; j < n; ++j) {
            det.timesEquals(ludmat.matrix[j][j]);
        }
        return det;
    }

    public Phasor logDeterminant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Phasor det = new Phasor();
        PhasorMatrix ludmat = this.luDecomp();
        det.reset(ludmat.dswap, 0.0);
        det = Phasor.log(det);
        for (int j = 0; j < n; ++j) {
            det.plusEquals(Phasor.log(ludmat.matrix[j][j]));
        }
        return det;
    }

    public double frobeniusNorm() {
        double norm = 0.0;
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                norm = Fmath.hypot(norm, this.matrix[i][j].abs());
            }
        }
        return norm;
    }

    public double oneNorm() {
        double norm = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.nrow; ++i) {
            sum = 0.0;
            for (int j = 0; j < this.ncol; ++j) {
                sum += this.matrix[i][j].abs();
            }
            norm = Math.max(norm, sum);
        }
        return norm;
    }

    public double infinityNorm() {
        double norm = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.nrow; ++i) {
            sum = 0.0;
            for (int j = 0; j < this.ncol; ++j) {
                sum += this.matrix[i][j].abs();
            }
            norm = Math.max(norm, sum);
        }
        return norm;
    }

    public PhasorMatrix luDecomp() {
        if (this.nrow != this.ncol) {
            throw new IllegalArgumentException("A matrix is not square");
        }
        int n = this.nrow;
        int imax = 0;
        double dum = 0.0;
        double temp = 0.0;
        double big = 0.0;
        double[] vv = new double[n];
        Phasor sum = new Phasor();
        Phasor dumm = new Phasor();
        PhasorMatrix ludmat = PhasorMatrix.copy(this);
        Phasor[][] ludarray = ludmat.getArrayReference();
        ludmat.dswap = 1.0;
        for (int i = 0; i < n; ++i) {
            big = 0.0;
            for (int j = 0; j < n; ++j) {
                double d;
                temp = ludarray[i][j].abs();
                if (!(d > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                throw new ArithmeticException("Singular matrix");
            }
            vv[i] = 1.0 / big;
        }
        for (int j = 0; j < n; ++j) {
            int k;
            int i;
            for (i = 0; i < j; ++i) {
                sum = Phasor.copy(ludarray[i][j]);
                for (k = 0; k < i; ++k) {
                    sum.minusEquals(ludarray[i][k].times(ludarray[k][j]));
                }
                ludarray[i][j] = Phasor.copy(sum);
            }
            big = 0.0;
            for (i = j; i < n; ++i) {
                double d;
                sum = Phasor.copy(ludarray[i][j]);
                for (k = 0; k < j; ++k) {
                    sum.minusEquals(ludarray[i][k].times(ludarray[k][j]));
                }
                ludarray[i][j] = Phasor.copy(sum);
                dum = vv[i] * sum.abs();
                if (!(d >= big)) continue;
                big = dum;
                imax = i;
            }
            if (j != imax) {
                for (int k2 = 0; k2 < n; ++k2) {
                    dumm = Phasor.copy(ludarray[imax][k2]);
                    ludarray[imax][k2] = Phasor.copy(ludarray[j][k2]);
                    ludarray[j][k2] = Phasor.copy(dumm);
                }
                ludmat.dswap = -ludmat.dswap;
                vv[imax] = vv[j];
            }
            ludmat.index[j] = imax;
            if (ludarray[j][j].isZero()) {
                ludarray[j][j].reset(1.0E-30, 0.0);
            }
            if (j == n - 1) continue;
            dumm = ludarray[j][j].inverse();
            for (i = j + 1; i < n; ++i) {
                ludarray[i][j].timesEquals(dumm);
            }
        }
        return ludmat;
    }

    public Phasor[] luBackSub(Phasor[] bvec) {
        int j;
        int i;
        int ii = 0;
        int ip = 0;
        int n = bvec.length;
        if (n != this.ncol) {
            throw new IllegalArgumentException("vector length is not equal to matrix dimension");
        }
        if (this.ncol != this.nrow) {
            throw new IllegalArgumentException("matrix is not square");
        }
        Phasor sum = new Phasor();
        Phasor[] xvec = new Phasor[n];
        for (i = 0; i < n; ++i) {
            xvec[i] = Phasor.copy(bvec[i]);
        }
        for (i = 0; i < n; ++i) {
            ip = this.index[i];
            sum = Phasor.copy(xvec[ip]);
            xvec[ip] = Phasor.copy(xvec[i]);
            if (ii == 0) {
                for (j = ii; j <= i - 1; ++j) {
                    sum.minusEquals(this.matrix[i][j].times(xvec[j]));
                }
            } else if (sum.isZero()) {
                ii = i;
            }
            xvec[i] = Phasor.copy(sum);
        }
        for (i = n - 1; i >= 0; --i) {
            sum = Phasor.copy(xvec[i]);
            for (j = i + 1; j < n; ++j) {
                sum.minusEquals(this.matrix[i][j].times(xvec[j]));
            }
            xvec[i] = sum.over(this.matrix[i][i]);
        }
        return xvec;
    }

    public Phasor[] solveLinearSet(Phasor[] bvec) {
        PhasorMatrix ludmat = this.luDecomp();
        return ludmat.luBackSub(bvec);
    }
}

