/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.analysis.Stat;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.optics.FunctTE;
import flanagan.optics.FunctTEplot;
import flanagan.optics.FunctTEsuper;
import flanagan.optics.FunctTM;
import flanagan.optics.FunctTMplot;
import flanagan.optics.FunctTMsuper;
import flanagan.optics.RefractiveIndex;
import flanagan.plot.PlotGraph;
import flanagan.roots.RealRoot;
import java.util.ArrayList;

public class PlanarWaveguide {
    protected double[][] measurementsTE = null;
    protected int numberOfTEmeasurements = 0;
    protected double[] thicknessesUsedTE = null;
    protected double[] calcEffectRefrIndicesTE = null;
    protected boolean setMeasurementsTE = false;
    protected boolean setErrorsTE = false;
    protected double maximumTEmodeEffectiveRefractiveIndex = 0.0;
    protected double minimumTEmodeEffectiveRefractiveIndex = 0.0;
    protected double[][] measurementsTM = null;
    protected int numberOfTMmeasurements = 0;
    protected double[] thicknessesUsedTM = null;
    protected double[] calcEffectRefrIndicesTM = null;
    protected boolean setMeasurementsTM = false;
    protected boolean setErrorsTM = false;
    protected double maximumTMmodeEffectiveRefractiveIndex = 0.0;
    protected double minimumTMmodeEffectiveRefractiveIndex = 0.0;
    protected double maximumEffectiveRefractiveIndex = 0.0;
    protected double minimumEffectiveRefractiveIndex = 0.0;
    protected int numberOfMeasurements = 0;
    protected boolean setMeasurements = false;
    protected boolean setWeights = false;
    protected boolean[] eliminatedTE = null;
    protected boolean[] eliminatedTM = null;
    protected double wavelength = 0.0;
    protected boolean setWavelength = false;
    protected double ko = 0.0;
    protected double superstrateRefractiveIndex = 0.0;
    protected double superstrateRefractiveIndex2 = 0.0;
    protected double[] calcSuperstrateTEmodeRI = null;
    protected double[] calcSuperstrateTMmodeRI = null;
    protected double meanTEmodeSuperstrateRefractiveIndex = Double.NaN;
    protected double meanTMmodeSuperstrateRefractiveIndex = Double.NaN;
    protected double sdTEmodeSuperstrateRefractiveIndex = Double.NaN;
    protected double sdTMmodeSuperstrateRefractiveIndex = Double.NaN;
    protected double sdSuperstrateRefractiveIndex = Double.NaN;
    protected boolean setSuperstrate = false;
    protected boolean superCalculationDone = false;
    protected double substrateRefractiveIndex = 0.0;
    protected double substrateRefractiveIndex2 = 0.0;
    protected boolean setSubstrate = false;
    protected double coreFilmRefractiveIndex = 0.0;
    protected double coreFilmRefractiveIndex2 = 0.0;
    protected boolean setCore = false;
    protected double[] coreFilmTEmodeRefractiveIndices = null;
    protected double[] coreFilmTMmodeRefractiveIndices = null;
    protected double meanTEmodeCoreFilmRefractiveIndex = Double.NaN;
    protected double meanTMmodeCoreFilmRefractiveIndex = Double.NaN;
    protected double meanCoreFilmRefractiveIndex = Double.NaN;
    protected double meanCoreFilmRefractiveIndex2 = Double.NaN;
    protected double sdTEmodeCoreFilmRefractiveIndex = Double.NaN;
    protected double sdTMmodeCoreFilmRefractiveIndex = Double.NaN;
    protected double sdCoreFilmRefractiveIndex = Double.NaN;
    protected double lowerBound = 0.0;
    protected double upperBound = 0.0;
    protected double tolerance = 1.0E-9;
    protected boolean calculationDone = false;
    protected double prismToWaveguideGap = Double.POSITIVE_INFINITY;
    protected boolean setPrismToWaveguideGap = false;
    protected boolean fixedPrismToWaveguideGap = true;
    protected double prismRefractiveIndex = 0.0;
    protected double prismRefractiveIndex2 = 0.0;

    public void enterTEmodeData(double thickness, double effectiveRI, double modeNumber) {
        if (this.setMeasurementsTE) {
            if (this.setErrorsTE) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTEmeasurements + 1;
            double[][] hold = new double[nNew][4];
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                for (int j = 0; j < 4; ++j) {
                    hold[i][j] = this.measurementsTE[i][j];
                }
            }
            hold[this.numberOfTEmeasurements][0] = thickness;
            hold[this.numberOfTEmeasurements][1] = effectiveRI;
            hold[this.numberOfTEmeasurements][2] = 1.0;
            hold[this.numberOfTEmeasurements][3] = modeNumber;
            this.measurementsTE = hold;
            this.numberOfTEmeasurements = nNew;
        } else {
            this.measurementsTE = new double[1][4];
            this.measurementsTE[0][0] = thickness;
            this.measurementsTE[0][1] = effectiveRI;
            this.measurementsTE[0][2] = 1.0;
            this.measurementsTE[0][3] = modeNumber;
            this.numberOfTEmeasurements = 1;
        }
        this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTE = true;
        this.setMeasurements = true;
    }

    public void enterTEmodeData(double thickness, double effectiveRI, double weight, double modeNumber) {
        if (this.setMeasurementsTE) {
            if (!this.setErrorsTE) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTEmeasurements + 1;
            double[][] hold = new double[nNew][4];
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                for (int j = 0; j < 4; ++j) {
                    hold[i][j] = this.measurementsTE[i][j];
                }
            }
            hold[this.numberOfTEmeasurements][0] = thickness;
            hold[this.numberOfTEmeasurements][1] = effectiveRI;
            hold[this.numberOfTEmeasurements][2] = weight;
            hold[this.numberOfTEmeasurements][3] = modeNumber;
            this.measurementsTE = hold;
            this.numberOfTEmeasurements = nNew;
        } else {
            this.measurementsTE = new double[1][4];
            this.measurementsTE[0][0] = thickness;
            this.measurementsTE[0][1] = effectiveRI;
            this.measurementsTE[0][2] = weight;
            this.measurementsTE[0][3] = modeNumber;
            this.numberOfTEmeasurements = 1;
        }
        this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTE = true;
        this.setMeasurements = true;
        this.setErrorsTE = true;
    }

    public void enterTEmodeData(double[] thicknesses, double[] effectiveRIs, double[] modeNumbers) {
        int n = effectiveRIs.length;
        int o = thicknesses.length;
        if (n != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of effective refractive indices, " + n);
        }
        int m = modeNumbers.length;
        if (m != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of mode numbers, " + m);
        }
        if (this.setMeasurementsTE) {
            int i;
            if (this.setErrorsTE) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTEmeasurements + o;
            double[][] hold = new double[nNew][4];
            for (i = 0; i < this.numberOfTEmeasurements; ++i) {
                for (int j = 0; j < 4; ++j) {
                    hold[i][j] = this.measurementsTE[i][j];
                }
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTEmeasurements + i][0] = thicknesses[i];
                hold[this.numberOfTEmeasurements + i][1] = effectiveRIs[i];
                hold[this.numberOfTEmeasurements + i][2] = 1.0;
                hold[this.numberOfTEmeasurements + i][3] = modeNumbers[i];
            }
            this.measurementsTE = hold;
            this.numberOfTEmeasurements = nNew;
        } else {
            this.numberOfTEmeasurements = o;
            this.measurementsTE = new double[this.numberOfTEmeasurements][4];
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                this.measurementsTE[i][0] = thicknesses[i];
                this.measurementsTE[i][1] = effectiveRIs[i];
                this.measurementsTE[i][2] = 1.0;
                this.measurementsTE[i][3] = modeNumbers[i];
            }
        }
        this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTE = true;
        this.setMeasurements = true;
    }

    public void enterTEmodeData(double[] thicknesses, double[] effectiveRIs, double[] weights, double[] modeNumbers) {
        int n = effectiveRIs.length;
        int o = thicknesses.length;
        if (n != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of effective refractive indices, " + n);
        }
        int m = modeNumbers.length;
        if (m != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of mode numbers, " + m);
        }
        if (this.setMeasurementsTE) {
            int i;
            if (!this.setErrorsTE) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTEmeasurements + o;
            double[][] hold = new double[nNew][4];
            for (i = 0; i < this.numberOfTEmeasurements; ++i) {
                for (int j = 0; j < 4; ++j) {
                    hold[i][j] = this.measurementsTE[i][j];
                }
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTEmeasurements + i][0] = thicknesses[i];
                hold[this.numberOfTEmeasurements + i][1] = effectiveRIs[i];
                hold[this.numberOfTEmeasurements + i][2] = weights[i];
                hold[this.numberOfTEmeasurements + i][3] = modeNumbers[i];
            }
            this.measurementsTE = hold;
            this.numberOfTEmeasurements = nNew;
        } else {
            this.numberOfTEmeasurements = o;
            this.measurementsTE = new double[this.numberOfTEmeasurements][4];
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                this.measurementsTE[i][0] = thicknesses[i];
                this.measurementsTE[i][1] = effectiveRIs[i];
                this.measurementsTE[i][2] = weights[i];
                this.measurementsTE[i][3] = modeNumbers[i];
            }
        }
        this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTE = true;
        this.setMeasurements = true;
        this.setErrorsTE = true;
    }

    public void enterTMmodeData(double thickness, double effectiveRI, double modeNumber) {
        if (this.setMeasurementsTM) {
            if (this.setErrorsTM) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTMmeasurements + 1;
            double[][] hold = new double[nNew][4];
            for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                for (int j = 0; j < 4; ++j) {
                    hold[i][j] = this.measurementsTM[i][j];
                }
            }
            hold[this.numberOfTMmeasurements][0] = thickness;
            hold[this.numberOfTMmeasurements][1] = effectiveRI;
            hold[this.numberOfTMmeasurements][2] = 1.0;
            hold[this.numberOfTMmeasurements][3] = modeNumber;
            this.measurementsTM = hold;
            this.numberOfTMmeasurements = nNew;
        } else {
            this.measurementsTM = new double[1][4];
            this.measurementsTM[0][0] = thickness;
            this.measurementsTM[0][1] = effectiveRI;
            this.measurementsTM[0][2] = 1.0;
            this.measurementsTM[0][3] = modeNumber;
            this.numberOfTMmeasurements = 1;
        }
        this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTM = true;
        this.setMeasurements = true;
    }

    public void enterTMmodeData(double thickness, double effectiveRI, double weight, double modeNumber) {
        if (this.setMeasurementsTM) {
            if (!this.setErrorsTM) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTMmeasurements + 1;
            double[][] hold = new double[nNew][4];
            for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                for (int j = 0; j < 4; ++j) {
                    hold[i][j] = this.measurementsTM[i][j];
                }
            }
            hold[this.numberOfTMmeasurements][0] = thickness;
            hold[this.numberOfTMmeasurements][1] = effectiveRI;
            hold[this.numberOfTMmeasurements][2] = weight;
            hold[this.numberOfTMmeasurements][3] = modeNumber;
            this.measurementsTM = hold;
            this.numberOfTMmeasurements = nNew;
        } else {
            this.measurementsTM = new double[1][4];
            this.measurementsTM[0][0] = thickness;
            this.measurementsTM[0][1] = effectiveRI;
            this.measurementsTM[0][2] = weight;
            this.measurementsTM[0][3] = modeNumber;
            this.numberOfTMmeasurements = 1;
        }
        this.numberOfMeasurements = this.numberOfTMmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTM = true;
        this.setMeasurements = true;
        this.setErrorsTM = true;
    }

    public void enterTMmodeData(double[] thicknesses, double[] effectiveRIs, double[] modeNumbers) {
        int n = effectiveRIs.length;
        int o = thicknesses.length;
        if (n != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of effective refractive indices, " + n);
        }
        int m = modeNumbers.length;
        if (m != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of mode numbers, " + m);
        }
        if (this.setMeasurementsTM) {
            int i;
            if (this.setErrorsTM) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTMmeasurements + o;
            double[][] hold = new double[nNew][4];
            for (i = 0; i < this.numberOfTMmeasurements; ++i) {
                for (int j = 0; j < 4; ++j) {
                    hold[i][j] = this.measurementsTM[i][j];
                }
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTMmeasurements + i][0] = thicknesses[i];
                hold[this.numberOfTMmeasurements + i][1] = effectiveRIs[i];
                hold[this.numberOfTMmeasurements + i][2] = 1.0;
                hold[this.numberOfTMmeasurements + i][3] = modeNumbers[i];
            }
            this.measurementsTM = hold;
            this.numberOfTMmeasurements = nNew;
        } else {
            this.numberOfTMmeasurements = o;
            this.measurementsTM = new double[this.numberOfTMmeasurements][4];
            for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                this.measurementsTM[i][0] = thicknesses[i];
                this.measurementsTM[i][1] = effectiveRIs[i];
                this.measurementsTM[i][2] = 1.0;
                this.measurementsTM[i][3] = modeNumbers[i];
            }
        }
        this.numberOfMeasurements = this.numberOfTMmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTM = true;
        this.setMeasurements = true;
    }

    public void enterTMmodeData(double[] thicknesses, double[] effectiveRIs, double[] weights, double[] modeNumbers) {
        int n = effectiveRIs.length;
        int o = thicknesses.length;
        if (n != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of effective refractive indices, " + n);
        }
        int m = modeNumbers.length;
        if (m != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of mode numbers, " + m);
        }
        if (this.setMeasurementsTM) {
            int i;
            if (!this.setErrorsTM) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTMmeasurements + o;
            double[][] hold = new double[nNew][4];
            for (i = 0; i < this.numberOfTMmeasurements; ++i) {
                for (int j = 0; j < 4; ++j) {
                    hold[i][j] = this.measurementsTM[i][j];
                }
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTMmeasurements + i][0] = thicknesses[i];
                hold[this.numberOfTMmeasurements + i][1] = effectiveRIs[i];
                hold[this.numberOfTMmeasurements + i][2] = weights[i];
                hold[this.numberOfTMmeasurements + i][3] = modeNumbers[i];
            }
            this.measurementsTM = hold;
            this.numberOfTMmeasurements = nNew;
        } else {
            this.numberOfTMmeasurements = o;
            this.measurementsTM = new double[this.numberOfTMmeasurements][4];
            for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                this.measurementsTM[i][0] = thicknesses[i];
                this.measurementsTM[i][1] = effectiveRIs[i];
                this.measurementsTM[i][2] = weights[i];
                this.measurementsTM[i][3] = modeNumbers[i];
            }
        }
        this.numberOfMeasurements = this.numberOfTMmeasurements + this.numberOfTMmeasurements;
        this.setMeasurementsTM = true;
        this.setMeasurements = true;
        this.setErrorsTM = true;
    }

    public void clearData() {
        this.numberOfMeasurements = 0;
        this.setMeasurements = false;
        this.setWeights = false;
        this.numberOfTEmeasurements = 0;
        this.setMeasurementsTE = false;
        this.setErrorsTE = false;
        this.numberOfTMmeasurements = 0;
        this.setMeasurementsTM = false;
        this.setErrorsTM = false;
    }

    public void setWavelength(double wavelength) {
        this.wavelength = wavelength;
        this.setWavelength = true;
        this.ko = Math.PI * 2 / this.wavelength;
        if (!this.setSuperstrate) {
            this.superstrateRefractiveIndex = RefractiveIndex.air(this.wavelength);
        }
    }

    public void setSubstrateRefractiveIndex(double refIndex) {
        this.substrateRefractiveIndex = refIndex;
        this.substrateRefractiveIndex2 = refIndex * refIndex;
        this.setSubstrate = true;
    }

    public void setSuperstrateRefractiveIndex(double refIndex) {
        this.superstrateRefractiveIndex = refIndex;
        this.superstrateRefractiveIndex2 = refIndex * refIndex;
        this.setSuperstrate = true;
    }

    public double getSuperstrateRefractiveIndex() {
        if (!this.superCalculationDone && this.setCore) {
            this.calcSuperstrateRefractiveIndex();
        }
        return this.superstrateRefractiveIndex;
    }

    public double getStandardDeviationSuperstrateRefractiveIndex() {
        if (!this.superCalculationDone && this.setCore) {
            this.calcSuperstrateRefractiveIndex();
        }
        if (this.setCore) {
            if (this.numberOfTMmeasurements + this.numberOfTEmeasurements == 1) {
                System.out.println("Method: getStandardDeviationSuperstrateRefractiveIndex - Only one measurement entered - NO standard deviation returned");
            }
        } else {
            System.out.println("Method: getStandardDeviationSuperstrateRefractiveIndex - Superstrate refractive index was entered and NOT calculated - NO standard deviation returned");
        }
        return this.sdCoreFilmRefractiveIndex;
    }

    public void setCoreLayerRefractiveIndex(double refIndex) {
        this.coreFilmRefractiveIndex = refIndex;
        this.coreFilmRefractiveIndex2 = refIndex * refIndex;
        this.setCore = true;
    }

    public double[] getTEmodeCoreFilmRefractiveIndices() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTEmeasurements == 0) {
            System.out.println("Method: getTEmodeCoreFilmRefractiveIndices - NO TE mode data entered - NO refractive indices returned");
        }
        return this.coreFilmTEmodeRefractiveIndices;
    }

    public double[] getTMmodeCoreFilmRefractiveIndices() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTMmeasurements == 0) {
            System.out.println("Method: getTMmodeCoreFilmRefractiveIndices - NO TM mode data entered - NO refractive indices returned");
        }
        return this.coreFilmTMmodeRefractiveIndices;
    }

    public double getMeanTEmodeCoreFilmRefractiveIndex() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTEmeasurements == 0) {
            System.out.println("Method: getMeanTEmodeCoreFilmRefractiveIndices - NO TE mode data entered - NO refractive index returned");
        }
        return this.meanTEmodeCoreFilmRefractiveIndex;
    }

    public double getMeanTMmodeCoreFilmRefractiveIndex() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTMmeasurements == 0) {
            System.out.println("Method: getMeanTMmodeCoreFilmRefractiveIndices - NO TM mode data entered - NO refractive index returned");
        }
        return this.meanTMmodeCoreFilmRefractiveIndex;
    }

    public double getMeanCoreFilmRefractiveIndex() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        return this.meanCoreFilmRefractiveIndex;
    }

    public double getCoreFilmRefractiveIndex() {
        if (!this.calculationDone && !this.setCore) {
            this.calcCoreFilmRefractiveIndices();
        }
        return this.coreFilmRefractiveIndex;
    }

    public double getStandardDeviationTEmodeCoreFilmRefractiveIndex() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTEmeasurements == 0) {
            System.out.println("Method: getStandardDeviationTEmodeCoreFilmRefractiveIndex - NO TE mode data entered - NO standard deviation returned");
        }
        if (this.numberOfTEmeasurements == 1) {
            System.out.println("Method: getStandardDeviationTEmodeCoreFilmRefractiveIndex - Only one measurement entered - NO standard deviation returned");
        }
        return this.sdTEmodeCoreFilmRefractiveIndex;
    }

    public double getStandardDeviationTMmodeCoreFilmRefractiveIndex() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTMmeasurements == 0) {
            System.out.println("Method: getStandardDeviationTMmodeCoreFilmRefractiveIndex - NO TM mode data entered - NO standard deviation returned");
        }
        if (this.numberOfTMmeasurements == 1) {
            System.out.println("Method: getStandardDeviationTMmodeCoreFilmRefractiveIndex - Only one measurement entered - NO standard deviation returned");
        }
        return this.sdTMmodeCoreFilmRefractiveIndex;
    }

    public double getStandardDeviationCoreFilmRefractiveIndex() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTMmeasurements + this.numberOfTEmeasurements == 1) {
            System.out.println("Method: getStandardDeviationCoreFilmRefractiveIndex - Only one measurement entered - NO standard deviation returned");
        }
        return this.sdCoreFilmRefractiveIndex;
    }

    public double[][] getTEmodeExperimentalEffectiveRefractiveIndices() {
        double[][] returnedArray = null;
        if (this.numberOfTEmeasurements == 0) {
            System.out.println("Method: getTEmodeExperimentalEffectiveRefractiveIndices - NO TE mode data entered - NO effective refractive indices returned");
        } else {
            returnedArray = new double[2][this.numberOfTEmeasurements];
            returnedArray[0] = this.thicknessesUsedTE;
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                returnedArray[1][i] = this.measurementsTE[i][1];
            }
        }
        return returnedArray;
    }

    public double[][] getTEmodeEffectiveRefractiveIndicesErrors() {
        double[][] returnedArray = null;
        if (this.numberOfTEmeasurements == 0) {
            System.out.println("Method: getTEmodeExperimentalEffectiveRefractiveIndices - NO TE mode data entered - NO errors returned");
        } else if (!this.setErrorsTE) {
            System.out.println("Method: getTEmodeExperimentalEffectiveRefractiveIndices - NO TE mode errors entered - NO errors returned");
        } else {
            returnedArray = new double[2][this.numberOfTEmeasurements];
            returnedArray[0] = this.thicknessesUsedTE;
            for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                returnedArray[1][i] = this.measurementsTE[i][2];
            }
        }
        return returnedArray;
    }

    public double[][] getTMmodeExperimentalEffectiveRefractiveIndices() {
        double[][] returnedArray = null;
        if (this.numberOfTMmeasurements == 0) {
            System.out.println("Method: getTMmodeExperimentalEffectiveRefractiveIndices - NO TM mode data entered - NO effective refractive indices returned");
        } else {
            returnedArray = new double[2][this.numberOfTMmeasurements];
            returnedArray[0] = this.thicknessesUsedTM;
            for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                returnedArray[1][i] = this.measurementsTM[i][1];
            }
        }
        return returnedArray;
    }

    public double[][] getTMmodeEffectiveRefractiveIndicesErrors() {
        double[][] returnedArray = null;
        if (this.numberOfTMmeasurements == 0) {
            System.out.println("Method: getTMmodeExperimentalEffectiveRefractiveIndices - NO TM mode data entered - NO errors returned");
        } else if (!this.setErrorsTM) {
            System.out.println("Method: getTMmodeExperimentalEffectiveRefractiveIndices - NO TM mode errors entered - NO errors returned");
        } else {
            returnedArray = new double[2][this.numberOfTMmeasurements];
            returnedArray[0] = this.thicknessesUsedTM;
            for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                returnedArray[1][i] = this.measurementsTM[i][2];
            }
        }
        return returnedArray;
    }

    public double[][] getTEmodeCalculatedEffectiveRefractiveIndices() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTEmeasurements == 0) {
            System.out.println("Method: getStandardDeviationTEmodeCoreFilmRefractiveIndices - NO TE mode data entered - NO effective refractive indices returned");
        }
        double[][] returnedArray = new double[2][this.numberOfTEmeasurements];
        FunctTEplot func = new FunctTEplot();
        func.substrateRefractiveIndex2 = this.substrateRefractiveIndex2;
        func.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex2;
        func.coreFilmRefractiveIndex2 = this.coreFilmRefractiveIndex2;
        func.prismRefractiveIndex2 = this.prismRefractiveIndex2;
        func.prismToWaveguideGap = this.prismToWaveguideGap;
        func.setPrismToWaveguideGap = this.setPrismToWaveguideGap;
        func.ko = this.ko;
        this.lowerBound = Math.max(this.substrateRefractiveIndex, this.superstrateRefractiveIndex);
        this.upperBound = Math.min(this.coreFilmRefractiveIndex, this.prismRefractiveIndex);
        for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
            func.thickness = this.measurementsTE[i][0];
            func.modeNumber = this.measurementsTE[i][3];
            RealRoot rr = new RealRoot();
            rr.noBoundsExtensions();
            rr.setTolerance(this.tolerance);
            this.calcEffectRefrIndicesTE[i] = rr.bisect(func, this.lowerBound, this.upperBound);
        }
        returnedArray[0] = this.thicknessesUsedTE;
        returnedArray[1] = this.calcEffectRefrIndicesTE;
        return returnedArray;
    }

    public double[][] getTMmodeCalculatedEffectiveRefractiveIndices() {
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        if (this.numberOfTMmeasurements == 0) {
            System.out.println("Method: getStandardDeviationTMmodeCoreFilmRefractiveIndices - NO TM mode data entered - NO effective refractive indices returned");
        }
        double[][] returnedArray = new double[2][this.numberOfTMmeasurements];
        FunctTMplot func = new FunctTMplot();
        func.substrateRefractiveIndex2 = this.substrateRefractiveIndex2;
        func.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex2;
        func.coreFilmRefractiveIndex2 = this.coreFilmRefractiveIndex2;
        func.prismRefractiveIndex2 = this.prismRefractiveIndex2;
        func.prismToWaveguideGap = this.prismToWaveguideGap;
        func.setPrismToWaveguideGap = this.setPrismToWaveguideGap;
        func.ko = this.ko;
        this.lowerBound = Math.max(this.substrateRefractiveIndex, this.superstrateRefractiveIndex);
        this.upperBound = Math.min(this.coreFilmRefractiveIndex, this.prismRefractiveIndex);
        for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
            func.thickness = this.measurementsTM[i][0];
            func.modeNumber = this.measurementsTM[i][3];
            RealRoot rr = new RealRoot();
            rr.noBoundsExtensions();
            rr.setTolerance(this.tolerance);
            this.calcEffectRefrIndicesTM[i] = rr.bisect(func, this.lowerBound, this.upperBound);
        }
        returnedArray[0] = this.thicknessesUsedTM;
        returnedArray[1] = this.calcEffectRefrIndicesTM;
        return returnedArray;
    }

    public void calcCoreFilmRefractiveIndices() {
        int i;
        int i2;
        if (!this.setMeasurements) {
            throw new IllegalArgumentException("Either no thickness, angle/effective refractive index, mode number data has been entered or a key subclass variable, e.g. coupling prism corner angle has not been entered");
        }
        if (!this.setWavelength) {
            throw new IllegalArgumentException("No wavelength has been entered");
        }
        if (!this.setSubstrate) {
            throw new IllegalArgumentException("No substrate refractive index has been entered");
        }
        this.lowerBound = Math.max(this.substrateRefractiveIndex, this.superstrateRefractiveIndex);
        this.upperBound = 0.0;
        if (this.numberOfTEmeasurements > 0) {
            this.eliminatedTE = new boolean[this.numberOfTEmeasurements];
        }
        int elimNumberTE = 0;
        for (i2 = 0; i2 < this.numberOfTEmeasurements; ++i2) {
            this.eliminatedTE[i2] = false;
            if (this.measurementsTE[i2][1] < this.lowerBound) {
                System.out.println("TE mode measurement point, " + i2 + ", eliminated as the effective refractive index, " + this.measurementsTE[i2][1] + ", lies below the physical limit, " + this.lowerBound);
                this.eliminatedTE[i2] = true;
                ++elimNumberTE;
                continue;
            }
            if (!(this.upperBound < this.measurementsTE[i2][1])) continue;
            this.upperBound = this.measurementsTE[i2][1];
        }
        if (elimNumberTE > 0) {
            int newNumber = this.numberOfTEmeasurements - elimNumberTE;
            if (newNumber == 0) {
                this.numberOfTEmeasurements = 0;
            } else {
                double[][] temp = new double[newNumber][3];
                int nIndex = 0;
                for (int i3 = 0; i3 < this.numberOfTEmeasurements; ++i3) {
                    if (this.eliminatedTE[i3]) continue;
                    temp[nIndex][0] = this.measurementsTE[i3][0];
                    temp[nIndex][1] = this.measurementsTE[i3][1];
                    temp[nIndex][2] = this.measurementsTE[i3][2];
                    temp[nIndex][3] = this.measurementsTE[i3][3];
                    ++nIndex;
                }
                this.measurementsTE = temp;
                this.numberOfTEmeasurements = newNumber;
                this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
            }
        }
        this.thicknessesUsedTE = new double[this.numberOfTEmeasurements];
        this.calcEffectRefrIndicesTE = new double[this.numberOfTEmeasurements];
        for (i2 = 0; i2 < this.numberOfTEmeasurements; ++i2) {
            this.thicknessesUsedTE[i2] = this.measurementsTE[i2][0];
        }
        this.maximumTEmodeEffectiveRefractiveIndex = this.upperBound;
        this.upperBound = 0.0;
        if (this.numberOfTMmeasurements > 0) {
            this.eliminatedTM = new boolean[this.numberOfTMmeasurements];
        }
        int elimNumberTM = 0;
        for (i = 0; i < this.numberOfTMmeasurements; ++i) {
            this.eliminatedTM[i] = false;
            if (this.measurementsTM[i][1] < this.lowerBound) {
                System.out.println("TM mode measurement point, " + i + ", eliminated as the effective refractive index, " + this.measurementsTM[i][1] + ", lies below the physical limit, " + this.lowerBound);
                this.eliminatedTM[i] = true;
                ++elimNumberTM;
                continue;
            }
            if (!(this.upperBound < this.measurementsTM[i][1])) continue;
            this.upperBound = this.measurementsTM[i][1];
        }
        if (elimNumberTM > 0) {
            int newNumber = this.numberOfTMmeasurements - elimNumberTM;
            if (newNumber == 0) {
                this.numberOfTMmeasurements = 0;
            } else {
                double[][] temp = new double[newNumber][3];
                int nIndex = 0;
                for (int i4 = 0; i4 < this.numberOfTMmeasurements; ++i4) {
                    if (this.eliminatedTM[i4]) continue;
                    temp[nIndex][0] = this.measurementsTM[i4][0];
                    temp[nIndex][1] = this.measurementsTM[i4][1];
                    temp[nIndex][2] = this.measurementsTM[i4][2];
                    temp[nIndex][3] = this.measurementsTM[i4][3];
                    ++nIndex;
                }
                this.measurementsTM = temp;
                this.numberOfTMmeasurements = newNumber;
                this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
            }
        }
        this.thicknessesUsedTM = new double[this.numberOfTMmeasurements];
        this.calcEffectRefrIndicesTM = new double[this.numberOfTMmeasurements];
        for (i = 0; i < this.numberOfTMmeasurements; ++i) {
            this.thicknessesUsedTM[i] = this.measurementsTM[i][0];
        }
        this.maximumTMmodeEffectiveRefractiveIndex = this.upperBound;
        if (this.numberOfMeasurements == 0) {
            throw new IllegalArgumentException("All data points rejected as lying outside the physically meaningful bounds");
        }
        if (this.fixedPrismToWaveguideGap) {
            this.calcCoreFilmRefractiveIndicesFixedGap();
        } else {
            this.calcCoreFilmRefractiveIndicesEstimatedGap();
        }
    }

    public void calcCoreFilmRefractiveIndicesEstimatedGap() {
        int i;
        ArrayList<Double> arrayl = new ArrayList<Double>();
        this.prismToWaveguideGap = 10.0;
        this.fixedPrismToWaveguideGap = true;
        double[] effectExpl = new double[this.numberOfMeasurements];
        double[] effectCalc = new double[this.numberOfMeasurements];
        for (i = 0; i < this.numberOfTEmeasurements; ++i) {
            effectExpl[i] = this.measurementsTE[i][1];
        }
        for (i = 0; i < this.numberOfTMmeasurements; ++i) {
            effectExpl[i + this.numberOfTEmeasurements] = this.measurementsTM[i][1];
        }
        double sumOfSquares = 0.0;
        double sumOfSquaresLast = Double.POSITIVE_INFINITY;
        int numberOfDecrements = 0;
        boolean test = true;
        while (test) {
            int i2;
            this.setCore = false;
            this.calculationDone = false;
            this.fixedPrismToWaveguideGap = true;
            this.setPrismToWaveguideGap = true;
            double coreRI = this.getMeanCoreFilmRefractiveIndex();
            if (coreRI != coreRI) {
                System.out.println("NaN");
                test = false;
                continue;
            }
            double[][] effectTECalc = this.getTEmodeCalculatedEffectiveRefractiveIndices();
            for (int i3 = 0; i3 < this.numberOfTEmeasurements; ++i3) {
                effectCalc[i3] = effectTECalc[1][i3];
            }
            double[][] effectTMCalc = this.getTMmodeCalculatedEffectiveRefractiveIndices();
            for (i2 = 0; i2 < this.numberOfTMmeasurements; ++i2) {
                effectCalc[i2 + this.numberOfTEmeasurements] = effectTMCalc[1][i2];
            }
            sumOfSquares = 0.0;
            for (i2 = 0; i2 < this.numberOfMeasurements; ++i2) {
                sumOfSquares += Fmath.square(effectExpl[i2] - effectCalc[i2]);
            }
            System.out.println(this.prismToWaveguideGap + " " + coreRI + " " + sumOfSquares);
            arrayl.add(new Double(coreRI));
            arrayl.add(new Double(sumOfSquares));
            ++numberOfDecrements;
            this.prismToWaveguideGap /= 2.0;
            if (!(this.prismToWaveguideGap < 1.0E-10)) continue;
            test = false;
        }
    }

    public void calcCoreFilmRefractiveIndicesFixedGap() {
        if (this.numberOfTEmeasurements > 0) {
            this.calcTEmodeCoreFilmRefractiveIndices();
        }
        if (this.numberOfTMmeasurements > 0) {
            this.calcTMmodeCoreFilmRefractiveIndices();
        }
        if (this.numberOfTEmeasurements > 0 && this.numberOfTMmeasurements == 0) {
            this.coreFilmRefractiveIndex = this.meanCoreFilmRefractiveIndex = this.meanTEmodeCoreFilmRefractiveIndex;
            this.sdCoreFilmRefractiveIndex = this.sdTEmodeCoreFilmRefractiveIndex;
        } else if (this.numberOfTMmeasurements > 0 && this.numberOfTEmeasurements == 0) {
            this.coreFilmRefractiveIndex = this.meanCoreFilmRefractiveIndex = this.meanTMmodeCoreFilmRefractiveIndex;
            this.sdCoreFilmRefractiveIndex = this.sdTMmodeCoreFilmRefractiveIndex;
        } else {
            int i;
            double[] values = new double[this.numberOfMeasurements];
            double[] weights = new double[this.numberOfMeasurements];
            for (i = 0; i < this.numberOfTEmeasurements; ++i) {
                values[i] = this.coreFilmTEmodeRefractiveIndices[i];
                weights[i] = this.measurementsTE[i][2];
            }
            for (i = 0; i < this.numberOfTMmeasurements; ++i) {
                values[i + this.numberOfTEmeasurements] = this.coreFilmTMmodeRefractiveIndices[i];
                weights[i + this.numberOfTEmeasurements] = this.measurementsTM[i][2];
            }
            this.meanCoreFilmRefractiveIndex = Stat.mean(values, weights);
            this.sdCoreFilmRefractiveIndex = Stat.standardDeviation(values, weights);
            this.coreFilmRefractiveIndex = this.meanCoreFilmRefractiveIndex;
        }
        this.coreFilmRefractiveIndex2 = this.meanCoreFilmRefractiveIndex2 = this.meanCoreFilmRefractiveIndex * this.meanCoreFilmRefractiveIndex;
        this.maximumEffectiveRefractiveIndex = Math.max(this.maximumTEmodeEffectiveRefractiveIndex, this.maximumTMmodeEffectiveRefractiveIndex);
        this.setCore = true;
        this.calculationDone = true;
    }

    public void calcTEmodeCoreFilmRefractiveIndices() {
        this.coreFilmTEmodeRefractiveIndices = new double[this.numberOfTEmeasurements];
        FunctTE func = new FunctTE();
        func.substrateRefractiveIndex2 = this.substrateRefractiveIndex2;
        func.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex2;
        func.prismRefractiveIndex2 = this.prismRefractiveIndex2;
        func.prismToWaveguideGap = this.prismToWaveguideGap;
        func.setPrismToWaveguideGap = this.setPrismToWaveguideGap;
        func.ko = this.ko;
        double[] weights = new double[this.numberOfTEmeasurements];
        this.lowerBound = this.maximumTEmodeEffectiveRefractiveIndex;
        this.upperBound = 2.0 * this.lowerBound;
        for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
            weights[i] = this.measurementsTE[i][2];
            func.thickness = this.measurementsTE[i][0];
            func.effectiveRefractiveIndex2 = this.measurementsTE[i][1] * this.measurementsTE[i][1];
            func.modeNumber = this.measurementsTE[i][3];
            RealRoot rr = new RealRoot();
            rr.noLowerBoundExtension();
            rr.setTolerance(this.tolerance);
            this.coreFilmTEmodeRefractiveIndices[i] = rr.bisect(func, this.lowerBound, this.upperBound);
        }
        if (this.numberOfTEmeasurements > 1) {
            this.meanTEmodeCoreFilmRefractiveIndex = Stat.mean(this.coreFilmTEmodeRefractiveIndices, weights);
            this.sdTEmodeCoreFilmRefractiveIndex = Stat.standardDeviation(this.coreFilmTEmodeRefractiveIndices, weights);
        } else {
            this.meanTEmodeCoreFilmRefractiveIndex = this.coreFilmTEmodeRefractiveIndices[0];
        }
    }

    public void calcTMmodeCoreFilmRefractiveIndices() {
        this.coreFilmTMmodeRefractiveIndices = new double[this.numberOfTMmeasurements];
        FunctTM func = new FunctTM();
        func.substrateRefractiveIndex2 = this.substrateRefractiveIndex2;
        func.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex2;
        func.prismRefractiveIndex2 = this.prismRefractiveIndex2;
        func.prismToWaveguideGap = this.prismToWaveguideGap;
        func.setPrismToWaveguideGap = this.setPrismToWaveguideGap;
        func.ko = this.ko;
        double[] weights = new double[this.numberOfTMmeasurements];
        this.lowerBound = this.maximumTMmodeEffectiveRefractiveIndex;
        this.upperBound = 2.0 * this.lowerBound;
        for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
            weights[i] = this.measurementsTM[i][2];
            func.thickness = this.measurementsTM[i][0];
            func.effectiveRefractiveIndex2 = this.measurementsTM[i][1] * this.measurementsTM[i][1];
            func.modeNumber = this.measurementsTM[i][3];
            RealRoot rr = new RealRoot();
            rr.noLowerBoundExtension();
            rr.setTolerance(this.tolerance);
            this.coreFilmTMmodeRefractiveIndices[i] = rr.bisect(func, this.lowerBound, this.upperBound);
        }
        if (this.numberOfTMmeasurements > 1) {
            this.meanTMmodeCoreFilmRefractiveIndex = Stat.mean(this.coreFilmTMmodeRefractiveIndices, weights);
            this.sdTMmodeCoreFilmRefractiveIndex = Stat.standardDeviation(this.coreFilmTMmodeRefractiveIndices, weights);
        } else {
            this.meanTMmodeCoreFilmRefractiveIndex = this.coreFilmTMmodeRefractiveIndices[0];
        }
    }

    public double[][] dispersionCurveTE(double lowThickness, double highThickness, int numberOfPoints, double modeNumber) {
        if (!this.setWavelength) {
            throw new IllegalArgumentException("No wavelength has been entered");
        }
        if (!this.setSubstrate) {
            throw new IllegalArgumentException("No substrate refractive index has been entered");
        }
        if (!this.setCore) {
            throw new IllegalArgumentException("No core film refractive index has been calculated or entered");
        }
        double[] thickness = new double[numberOfPoints];
        double[] effective = new double[numberOfPoints];
        double[][] returnedArray = new double[2][numberOfPoints];
        double incr = (Fmath.log10(highThickness) - Fmath.log10(lowThickness)) / (double)(numberOfPoints - 1);
        thickness[0] = Fmath.log10(lowThickness);
        thickness[numberOfPoints - 1] = Fmath.log10(highThickness);
        for (int i = 1; i < numberOfPoints - 1; ++i) {
            thickness[i] = thickness[i - 1] + incr;
        }
        returnedArray[0] = thickness;
        FunctTEplot func = new FunctTEplot();
        func.substrateRefractiveIndex2 = this.substrateRefractiveIndex2;
        func.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex2;
        func.coreFilmRefractiveIndex2 = this.coreFilmRefractiveIndex2;
        func.prismRefractiveIndex2 = this.prismRefractiveIndex2;
        func.prismToWaveguideGap = this.prismToWaveguideGap;
        func.setPrismToWaveguideGap = this.setPrismToWaveguideGap;
        func.ko = this.ko;
        func.modeNumber = modeNumber;
        this.lowerBound = Math.max(this.substrateRefractiveIndex, this.superstrateRefractiveIndex);
        this.upperBound = Math.min(this.coreFilmRefractiveIndex, this.prismRefractiveIndex);
        for (int i = 0; i < numberOfPoints; ++i) {
            func.thickness = Math.pow(10.0, thickness[i]);
            RealRoot rr = new RealRoot();
            rr.noBoundsExtensions();
            rr.setTolerance(this.tolerance);
            effective[i] = rr.bisect(func, this.lowerBound, this.upperBound);
        }
        returnedArray[1] = effective;
        return returnedArray;
    }

    public double[][] dispersionCurveTM(double lowThickness, double highThickness, int numberOfPoints, double modeNumber) {
        if (!this.setWavelength) {
            throw new IllegalArgumentException("No wavelength has been entered");
        }
        if (!this.setSubstrate) {
            throw new IllegalArgumentException("No substrate refractive index has been entered");
        }
        if (!this.setCore) {
            throw new IllegalArgumentException("No core film refractive index has been calculated or entered");
        }
        double[] thickness = new double[numberOfPoints];
        double[] effective = new double[numberOfPoints];
        double[][] returnedArray = new double[2][numberOfPoints];
        double incr = (Fmath.log10(highThickness) - Fmath.log10(lowThickness)) / (double)(numberOfPoints - 1);
        thickness[0] = Fmath.log10(lowThickness);
        thickness[numberOfPoints - 1] = Fmath.log10(highThickness);
        for (int i = 1; i < numberOfPoints - 1; ++i) {
            thickness[i] = thickness[i - 1] + incr;
        }
        returnedArray[0] = thickness;
        FunctTMplot func = new FunctTMplot();
        func.substrateRefractiveIndex2 = this.substrateRefractiveIndex2;
        func.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex2;
        func.coreFilmRefractiveIndex2 = this.coreFilmRefractiveIndex2;
        func.prismRefractiveIndex2 = this.prismRefractiveIndex2;
        func.prismToWaveguideGap = this.prismToWaveguideGap;
        func.setPrismToWaveguideGap = this.setPrismToWaveguideGap;
        func.ko = this.ko;
        func.modeNumber = modeNumber;
        this.lowerBound = Math.max(this.substrateRefractiveIndex, this.superstrateRefractiveIndex);
        this.upperBound = Math.min(this.coreFilmRefractiveIndex, this.prismRefractiveIndex);
        for (int i = 0; i < numberOfPoints; ++i) {
            func.thickness = Math.pow(10.0, thickness[i]);
            RealRoot rr = new RealRoot();
            rr.noBoundsExtensions();
            rr.setTolerance(this.tolerance);
            effective[i] = rr.bisect(func, this.lowerBound, this.upperBound);
        }
        returnedArray[1] = effective;
        return returnedArray;
    }

    public double[][] plotDispersionCurveTE(double lowThickness, double highThickness, int numberOfPoints, double modeNumber) {
        String legend1 = " ";
        return this.plotDispersionCurveTE(lowThickness, highThickness, numberOfPoints, modeNumber, legend1);
    }

    public double[][] plotDispersionCurveTE(double lowThickness, double highThickness, int numberOfPoints, double modeNumber, String legend1) {
        double[][] curve = this.dispersionCurveTE(lowThickness, highThickness, numberOfPoints, modeNumber);
        PlotGraph pg1 = new PlotGraph(curve);
        int lineOption = 3;
        if (numberOfPoints < 100) {
            lineOption = 1;
        }
        pg1.setLine(lineOption);
        pg1.setPoint(0);
        String legend0 = "Dispersion curve: TE mode  -  mode number " + (int)modeNumber;
        pg1.setGraphTitle(legend0);
        pg1.setGraphTitle2(legend1);
        pg1.setXaxisLegend("Log10( Core Film Thickness / metres )");
        pg1.setYaxisLegend("Effective Refractive Index (kz/ko)");
        pg1.plot();
        return curve;
    }

    public double[][] plotDispersionCurveTM(double lowThickness, double highThickness, int numberOfPoints, double modeNumber) {
        String legend1 = " ";
        return this.plotDispersionCurveTM(lowThickness, highThickness, numberOfPoints, modeNumber, legend1);
    }

    public double[][] plotDispersionCurveTM(double lowThickness, double highThickness, int numberOfPoints, double modeNumber, String legend1) {
        double[][] curve = this.dispersionCurveTM(lowThickness, highThickness, numberOfPoints, modeNumber);
        PlotGraph pg2 = new PlotGraph(curve);
        int lineOption = 3;
        if (numberOfPoints < 100) {
            lineOption = 1;
        }
        pg2.setLine(lineOption);
        pg2.setPoint(0);
        String legend0 = "Dispersion curve: TM mode  -  mode number " + (int)modeNumber;
        pg2.setGraphTitle(legend0);
        pg2.setGraphTitle2(legend1);
        pg2.setXaxisLegend("Log10( Core Film Thickness / metres )");
        pg2.setYaxisLegend("Effective Refractive Index (kz/ko)");
        pg2.plot();
        return curve;
    }

    public void plotFittedDispersionCurves() {
        String legend = "PlanarWaveguide.plotDispersion - Dispersion Plot";
        this.plotFittedDispersionCurve(legend);
    }

    public void plotFittedDispersionCurve(String legend) {
        double[] log10TempThick;
        double[] tempRefra;
        double[] tempThick;
        int arraylSize;
        int testVec;
        if (!this.calculationDone) {
            this.calcCoreFilmRefractiveIndices();
        }
        ArrayList<Number> arraylTE = null;
        int pOrderNumberTE = 0;
        int pOrdersCheckedTE = 0;
        int maximumNumberOfPoints = 0;
        if (this.numberOfTEmeasurements > 0) {
            arraylTE = new ArrayList<Number>();
            boolean testModes = true;
            int pOrder = 0;
            int numberTestedPositive = 0;
            while (testModes) {
                int pNumber = 0;
                for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
                    if (this.measurementsTE[i][3] != (double)pOrder) continue;
                    ++pNumber;
                    ++numberTestedPositive;
                    arraylTE.add(new Double(this.measurementsTE[i][0]));
                    arraylTE.add(new Double(this.measurementsTE[i][1]));
                }
                arraylTE.add(2 * pOrder, new Integer(pOrder));
                arraylTE.add(2 * pOrder + 1, new Integer(pNumber));
                if (pNumber > 0) {
                    ++pOrderNumberTE;
                }
                if (pNumber > maximumNumberOfPoints) {
                    maximumNumberOfPoints = pNumber;
                }
                if (numberTestedPositive == this.numberOfTEmeasurements) {
                    testModes = false;
                    continue;
                }
                ++pOrder;
            }
            pOrdersCheckedTE = pOrder;
        }
        int numberOfCurves = pOrderNumberTE;
        ArrayList<Number> arraylTM = null;
        int pOrderNumberTM = 0;
        int pOrdersCheckedTM = 0;
        if (this.numberOfTMmeasurements > 0) {
            arraylTM = new ArrayList<Number>();
            boolean testModes = true;
            int pOrder = 0;
            int numberTestedPositive = 0;
            while (testModes) {
                int pNumber = 0;
                for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
                    if (this.measurementsTM[i][3] != (double)pOrder) continue;
                    ++pNumber;
                    ++numberTestedPositive;
                    arraylTM.add(new Double(this.measurementsTM[i][0]));
                    arraylTM.add(new Double(this.measurementsTM[i][1]));
                }
                arraylTM.add(2 * pOrder, new Integer(pOrder));
                arraylTM.add(2 * pOrder + 1, new Integer(pNumber));
                if (pNumber > 0) {
                    ++pOrderNumberTM;
                }
                if (pNumber > maximumNumberOfPoints) {
                    maximumNumberOfPoints = pNumber;
                }
                if (numberTestedPositive == this.numberOfTMmeasurements) {
                    testModes = false;
                    continue;
                }
                ++pOrder;
            }
            pOrdersCheckedTM = pOrder;
        }
        numberOfCurves += pOrderNumberTM;
        numberOfCurves *= 2;
        if (maximumNumberOfPoints < 200) {
            maximumNumberOfPoints = 200;
        }
        double[][] plotData = PlotGraph.data(numberOfCurves, maximumNumberOfPoints);
        double[] modeNumber = new double[numberOfCurves];
        String[] modeType = new String[numberOfCurves];
        int atCurveNumber = 0;
        int plotNumber = 0;
        int arraylIndex = 2 * (pOrdersCheckedTE + 1);
        int arraylHeaderIndex = 1;
        double tempD = 0.0;
        int tempI = 0;
        if (this.numberOfTEmeasurements > 0) {
            testVec = 0;
            arraylSize = arraylTE.size();
            while (testVec < arraylSize) {
                tempI = (Integer)arraylTE.get(arraylHeaderIndex);
                ++testVec;
                if (tempI > 0) {
                    modeType[atCurveNumber] = "TE";
                    modeType[atCurveNumber + 1] = "TE";
                    modeNumber[atCurveNumber] = ((Integer)arraylTE.get(arraylHeaderIndex - 1)).intValue();
                    modeNumber[atCurveNumber + 1] = modeNumber[atCurveNumber];
                    ++testVec;
                    tempThick = new double[tempI];
                    tempRefra = new double[tempI];
                    for (int i = 0; i < tempI; ++i) {
                        tempThick[i] = (Double)arraylTE.get(arraylIndex++);
                        tempRefra[i] = (Double)arraylTE.get(arraylIndex++);
                        testVec += 2;
                    }
                    log10TempThick = Conv.copy(tempThick);
                    for (int i = 0; i < tempI; ++i) {
                        log10TempThick[i] = Fmath.log10(tempThick[i]);
                    }
                    plotData[plotNumber++] = log10TempThick;
                    plotData[plotNumber++] = tempRefra;
                    Fmath.selectionSort(tempThick, tempRefra, tempThick, tempRefra);
                    double[][] curveTE = this.dispersionCurveTE(tempThick[0], tempThick[tempI - 1], maximumNumberOfPoints, modeNumber[atCurveNumber]);
                    plotData[plotNumber++] = curveTE[0];
                    plotData[plotNumber++] = curveTE[1];
                    atCurveNumber += 2;
                }
                arraylHeaderIndex = 2;
            }
        }
        arraylIndex = 2 * (pOrdersCheckedTM + 1);
        arraylHeaderIndex = 1;
        tempD = 0.0;
        tempI = 0;
        if (this.numberOfTMmeasurements > 0) {
            testVec = 0;
            arraylSize = arraylTM.size();
            while (testVec < arraylSize) {
                tempI = (Integer)arraylTM.get(arraylHeaderIndex);
                ++testVec;
                if (tempI > 0) {
                    modeType[atCurveNumber] = "TM";
                    modeType[atCurveNumber + 1] = "TM";
                    modeNumber[atCurveNumber] = ((Integer)arraylTM.get(arraylHeaderIndex - 1)).intValue();
                    ++testVec;
                    modeNumber[atCurveNumber + 1] = modeNumber[atCurveNumber];
                    tempThick = new double[tempI];
                    tempRefra = new double[tempI];
                    for (int i = 0; i < tempI; ++i) {
                        tempThick[i] = (Double)arraylTM.get(arraylIndex++);
                        tempRefra[i] = (Double)arraylTM.get(arraylIndex++);
                        testVec += 2;
                    }
                    log10TempThick = Conv.copy(tempThick);
                    for (int i = 0; i < tempI; ++i) {
                        log10TempThick[i] = Fmath.log10(tempThick[i]);
                    }
                    plotData[plotNumber++] = log10TempThick;
                    plotData[plotNumber++] = tempRefra;
                    Fmath.selectionSort(tempThick, tempRefra, tempThick, tempRefra);
                    double[][] curveTM = this.dispersionCurveTM(tempThick[0], tempThick[tempI - 1], maximumNumberOfPoints, modeNumber[atCurveNumber]);
                    plotData[plotNumber++] = curveTM[0];
                    plotData[plotNumber++] = curveTM[1];
                    atCurveNumber += 2;
                }
                arraylHeaderIndex = 2;
            }
        }
        PlotGraph pg0 = new PlotGraph(plotData);
        int[] lineOptions = new int[numberOfCurves];
        for (int i = 0; i < numberOfCurves; i += 2) {
            lineOptions[i] = 0;
            lineOptions[i + 1] = 3;
            if (maximumNumberOfPoints >= 100) continue;
            lineOptions[i + 1] = 1;
        }
        pg0.setLine(lineOptions);
        int[] pointOptions = new int[numberOfCurves];
        int jj = 1;
        for (int i = 0; i < numberOfCurves; i += 2) {
            pointOptions[i] = jj++;
            pointOptions[i + 1] = 0;
        }
        pg0.setPoint(pointOptions);
        pg0.setGraphTitle(legend);
        pg0.setXaxisLegend("Log10( Core Film Thickness / metres )");
        pg0.setYaxisLegend("Effective Refractive Index (kz/ko)");
        pg0.plot();
    }

    public void calcSuperstrateRefractiveIndex() {
        int i;
        int i2;
        int i3;
        if (!this.setMeasurements) {
            throw new IllegalArgumentException("Either no thickness, angle/effective refractive index, mode number data has been entered or a key subclass variable, e.g. coupling prism corner angle has not been entered");
        }
        if (!this.setWavelength) {
            throw new IllegalArgumentException("No wavelength has been entered");
        }
        if (!this.setSubstrate) {
            throw new IllegalArgumentException("No substrate refractive index has been entered");
        }
        if (!this.setCore) {
            throw new IllegalArgumentException("No core layer refractive index has been entered");
        }
        this.lowerBound = 1.0;
        this.upperBound = this.coreFilmRefractiveIndex;
        if (this.numberOfTEmeasurements > 0) {
            this.eliminatedTE = new boolean[this.numberOfTEmeasurements];
        }
        int elimNumberTE = 0;
        for (i3 = 0; i3 < this.numberOfTEmeasurements; ++i3) {
            this.eliminatedTE[i3] = false;
            if (this.measurementsTE[i3][1] > this.coreFilmRefractiveIndex) {
                System.out.println("TE mode measurement point, " + i3 + ", eliminated as the effective refractive index, " + this.measurementsTE[i3][1] + ", lies above the physical limit, " + this.coreFilmRefractiveIndex);
                this.eliminatedTE[i3] = true;
                ++elimNumberTE;
                continue;
            }
            if (!(this.upperBound > this.measurementsTE[i3][1])) continue;
            this.upperBound = this.measurementsTE[i3][1];
        }
        if (elimNumberTE > 0) {
            int newNumber = this.numberOfTEmeasurements - elimNumberTE;
            if (newNumber == 0) {
                this.numberOfTEmeasurements = 0;
            } else {
                double[][] temp = new double[newNumber][3];
                int nIndex = 0;
                for (i2 = 0; i2 < this.numberOfTEmeasurements; ++i2) {
                    if (this.eliminatedTE[i2]) continue;
                    temp[nIndex][0] = this.measurementsTE[i2][0];
                    temp[nIndex][1] = this.measurementsTE[i2][1];
                    temp[nIndex][2] = this.measurementsTE[i2][2];
                    temp[nIndex][3] = this.measurementsTE[i2][3];
                    ++nIndex;
                }
                this.measurementsTE = temp;
                this.numberOfTEmeasurements = newNumber;
                this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
            }
        }
        this.thicknessesUsedTE = new double[this.numberOfTEmeasurements];
        this.calcEffectRefrIndicesTE = new double[this.numberOfTEmeasurements];
        for (i3 = 0; i3 < this.numberOfTEmeasurements; ++i3) {
            this.thicknessesUsedTE[i3] = this.measurementsTE[i3][0];
        }
        this.minimumTEmodeEffectiveRefractiveIndex = this.upperBound;
        this.upperBound = 0.0;
        if (this.numberOfTMmeasurements > 0) {
            this.eliminatedTM = new boolean[this.numberOfTMmeasurements];
        }
        int elimNumberTM = 0;
        for (i = 0; i < this.numberOfTMmeasurements; ++i) {
            this.eliminatedTM[i] = false;
            if (this.measurementsTM[i][1] > this.coreFilmRefractiveIndex) {
                System.out.println("TM mode measurement point, " + i + ", eliminated as the effective refractive index, " + this.measurementsTM[i][1] + ", lies above the physical limit, " + this.coreFilmRefractiveIndex);
                this.eliminatedTM[i] = true;
                ++elimNumberTM;
                continue;
            }
            if (!(this.upperBound > this.measurementsTM[i][1])) continue;
            this.upperBound = this.measurementsTM[i][1];
        }
        if (elimNumberTM > 0) {
            int newNumber = this.numberOfTMmeasurements - elimNumberTM;
            if (newNumber == 0) {
                this.numberOfTMmeasurements = 0;
            } else {
                double[][] temp = new double[newNumber][3];
                int nIndex = 0;
                for (int i4 = 0; i4 < this.numberOfTMmeasurements; ++i4) {
                    if (this.eliminatedTM[i4]) continue;
                    temp[nIndex][0] = this.measurementsTM[i4][0];
                    temp[nIndex][1] = this.measurementsTM[i4][1];
                    temp[nIndex][2] = this.measurementsTM[i4][2];
                    temp[nIndex][3] = this.measurementsTM[i4][3];
                    ++nIndex;
                }
                this.measurementsTM = temp;
                this.numberOfTMmeasurements = newNumber;
                this.numberOfMeasurements = this.numberOfTEmeasurements + this.numberOfTMmeasurements;
            }
        }
        this.thicknessesUsedTM = new double[this.numberOfTMmeasurements];
        this.calcEffectRefrIndicesTM = new double[this.numberOfTMmeasurements];
        for (i = 0; i < this.numberOfTMmeasurements; ++i) {
            this.thicknessesUsedTM[i] = this.measurementsTM[i][0];
        }
        this.minimumTMmodeEffectiveRefractiveIndex = this.upperBound;
        if (this.numberOfMeasurements == 0) {
            throw new IllegalArgumentException("All data points rejected as lying outside the physically meaningful bounds");
        }
        if (this.numberOfTEmeasurements > 0) {
            this.calcTEmodeSuperstrateRefractiveIndices();
        }
        if (this.numberOfTMmeasurements > 0) {
            this.calcTMmodeSuperstrateRefractiveIndices();
        }
        if (this.numberOfTEmeasurements > 0 && this.numberOfTMmeasurements == 0) {
            this.superstrateRefractiveIndex = this.meanTEmodeSuperstrateRefractiveIndex;
            this.sdSuperstrateRefractiveIndex = this.sdTEmodeSuperstrateRefractiveIndex;
        } else if (this.numberOfTMmeasurements > 0 && this.numberOfTEmeasurements == 0) {
            this.superstrateRefractiveIndex = this.meanTMmodeSuperstrateRefractiveIndex;
            this.sdSuperstrateRefractiveIndex = this.sdTMmodeSuperstrateRefractiveIndex;
        } else {
            double[] values = new double[this.numberOfMeasurements];
            double[] weights = new double[this.numberOfMeasurements];
            for (i2 = 0; i2 < this.numberOfTEmeasurements; ++i2) {
                values[i2] = this.calcSuperstrateTEmodeRI[i2];
                weights[i2] = this.measurementsTE[i2][2];
            }
            for (i2 = 0; i2 < this.numberOfTMmeasurements; ++i2) {
                values[i2 + this.numberOfTEmeasurements] = this.calcSuperstrateTMmodeRI[i2];
                weights[i2 + this.numberOfTEmeasurements] = this.measurementsTM[i2][2];
            }
            this.superstrateRefractiveIndex = Stat.mean(values, weights);
            this.sdSuperstrateRefractiveIndex = Stat.standardDeviation(values, weights);
        }
        this.superstrateRefractiveIndex2 = this.superstrateRefractiveIndex * this.superstrateRefractiveIndex;
        this.minimumEffectiveRefractiveIndex = Math.min(this.minimumTEmodeEffectiveRefractiveIndex, this.minimumTMmodeEffectiveRefractiveIndex);
        this.superCalculationDone = true;
    }

    public void calcTEmodeSuperstrateRefractiveIndices() {
        this.calcSuperstrateTEmodeRI = new double[this.numberOfTEmeasurements];
        FunctTEsuper func = new FunctTEsuper();
        func.coreFilmRefractiveIndex2 = this.coreFilmRefractiveIndex2;
        func.ko = this.ko;
        double[] weights = new double[this.numberOfTEmeasurements];
        this.lowerBound = 1.0;
        this.upperBound = this.minimumTEmodeEffectiveRefractiveIndex;
        for (int i = 0; i < this.numberOfTEmeasurements; ++i) {
            weights[i] = this.measurementsTE[i][2];
            func.thickness = this.measurementsTE[i][0];
            func.effectiveRefractiveIndex2 = this.measurementsTE[i][1] * this.measurementsTE[i][1];
            func.modeNumber = this.measurementsTE[i][3];
            RealRoot rr = new RealRoot();
            rr.noBoundsExtensions();
            rr.setTolerance(this.tolerance);
            this.calcSuperstrateTEmodeRI[i] = rr.bisect(func, this.lowerBound, this.upperBound);
        }
        if (this.numberOfTEmeasurements > 1) {
            this.meanTEmodeSuperstrateRefractiveIndex = Stat.mean(this.calcSuperstrateTEmodeRI, weights);
            this.sdTEmodeSuperstrateRefractiveIndex = Stat.standardDeviation(this.calcSuperstrateTEmodeRI, weights);
        } else {
            this.meanTEmodeSuperstrateRefractiveIndex = this.calcSuperstrateTEmodeRI[0];
        }
    }

    public void calcTMmodeSuperstrateRefractiveIndices() {
        this.calcSuperstrateTMmodeRI = new double[this.numberOfTMmeasurements];
        FunctTMsuper func = new FunctTMsuper();
        func.coreFilmRefractiveIndex2 = this.coreFilmRefractiveIndex2;
        func.ko = this.ko;
        double[] weights = new double[this.numberOfTMmeasurements];
        this.lowerBound = 1.0;
        this.upperBound = this.minimumTMmodeEffectiveRefractiveIndex;
        for (int i = 0; i < this.numberOfTMmeasurements; ++i) {
            weights[i] = this.measurementsTM[i][2];
            func.thickness = this.measurementsTM[i][0];
            func.effectiveRefractiveIndex2 = this.measurementsTM[i][1] * this.measurementsTM[i][1];
            func.modeNumber = this.measurementsTM[i][3];
            RealRoot rr = new RealRoot();
            rr.noBoundsExtensions();
            rr.setTolerance(this.tolerance);
            this.calcSuperstrateTMmodeRI[i] = rr.bisect(func, this.lowerBound, this.upperBound);
        }
        if (this.numberOfTMmeasurements > 1) {
            this.meanTMmodeSuperstrateRefractiveIndex = Stat.mean(this.calcSuperstrateTMmodeRI, weights);
            this.sdTMmodeSuperstrateRefractiveIndex = Stat.standardDeviation(this.calcSuperstrateTMmodeRI, weights);
        } else {
            this.meanTMmodeSuperstrateRefractiveIndex = this.calcSuperstrateTMmodeRI[0];
        }
    }
}

