/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.exec.AbnormalExitException;
import edu.mayo.exec.UnixStreamCommand;
import edu.mayo.pipes.history.History;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AnnotateEXE
extends AbstractPipe<History, History> {
    private static final Logger sLogger = Logger.getLogger(AnnotateEXE.class);
    private UnixStreamCommand mAnnotate;
    private boolean mWasEndLineSent = false;
    private boolean mWasEndLineAddedToQ = false;
    private boolean mIsInputDone = false;
    private Queue<History> mInQueue = new LinkedList<History>();
    private int mMaxLinesInFlight = 10;
    private List<History> mInFlightQ = new ArrayList<History>();
    private int mCmdTimeout = 10;
    private int mLinesSent = 0;
    private int mLinesRcvd = 0;
    private String mLastLineSent = null;
    private final String TERMINATE_LINE = "1\t1\trsXXXXXXXX\tA\tC\t.\t.\t.";
    private final String TERMINATE_RSID = "rsXXXXXXXX";
    private int mMaxAlts;
    private HashMap<String, History> mUuidToOriginalInputLineMap = new HashMap();
    private String mLastUuidReceived = "";

    public AnnotateEXE(String[] annotateCmd, Map<String, String> environmentProps, int maxLinesInFlight, int cmdTimeout, int numJsonColsToAdd, int maxAlts) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        this.mMaxLinesInFlight = maxLinesInFlight;
        this.mCmdTimeout = cmdTimeout;
        this.mMaxAlts = maxAlts;
        this.mAnnotate = new UnixStreamCommand(annotateCmd, environmentProps, true, false);
        this.mAnnotate.launch();
        this.mAnnotate.send("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO");
        this.mAnnotate.send("1\t1\trs0\tG\tA\t0.0\t.\t.");
        String result = "#";
        while (result.startsWith("#")) {
            result = this.mAnnotate.receive();
        }
    }

    protected History processNextStart() throws NoSuchElementException {
        this.sendLine();
        return this.receiveLine();
    }

    private int numAlts(History vcfLineHistory) {
        return ((String)vcfLineHistory.get(4)).split(",").length;
    }

    private void sendLine() {
        try {
            boolean isMoreData;
            boolean bl = isMoreData = this.mIsInputDone ? false : this.starts.hasNext();
            if (!isMoreData) {
                this.mIsInputDone = true;
            }
            if (isMoreData) {
                this.mInQueue.add((History)this.starts.next());
            }
            if (!isMoreData && !this.mWasEndLineAddedToQ) {
                this.mInQueue.add(new History("1\t1\trsXXXXXXXX\tA\tC\t.\t.\t."));
                this.mWasEndLineAddedToQ = true;
            }
            if (this.mInFlightQ.size() >= this.mMaxLinesInFlight || !isMoreData && this.mWasEndLineSent) {
                return;
            }
            ++this.mLinesSent;
            History originalLine = this.mInQueue.remove();
            History lineToSend = this.stripTo5Cols(originalLine);
            this.checkAlts(lineToSend);
            String uuid = (String)lineToSend.get(7);
            this.mUuidToOriginalInputLineMap.put(uuid, originalLine);
            sLogger.info((Object)"----------------------");
            String lineStr = lineToSend.getMergedData("\t");
            if (lineStr.contains("rsXXXXXXXX")) {
                this.mWasEndLineSent = true;
            }
            sLogger.info((Object)("AnnotateEXE sending line (data line #" + this.mLinesSent + "): \n" + this.firstXchars(lineStr, 100)));
            this.mInFlightQ.add(lineToSend);
            sLogger.info((Object)"------");
            sLogger.info((Object)("mInQueue size   = " + this.mInQueue.size()));
            sLogger.info((Object)("mInFlightQ size = " + this.mInFlightQ.size()));
            sLogger.info((Object)("UUID map size   = " + this.mUuidToOriginalInputLineMap.size()));
            sLogger.info((Object)("Lines sent      = " + this.mLinesSent));
            sLogger.info((Object)("Lines received  = " + this.mLinesRcvd));
            this.mAnnotate.send(lineStr);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            this.terminate();
            throw new NoSuchElementException("ERROR: " + e.getMessage());
        }
    }

    private void checkAlts(History lineToSend) {
        int numAlts = this.numAlts(lineToSend);
        if (numAlts > this.mMaxAlts) {
            String msg = "Warning: Data Line #" + this.mLinesSent + " has > " + this.mMaxAlts + " alts : " + numAlts + "\n  The number of alts will be truncated to " + this.mMaxAlts;
            System.err.println(msg);
            System.err.println("  Line: " + this.firstXchars(lineToSend.getMergedData("\t"), 100));
            sLogger.warn((Object)msg);
            sLogger.warn((Object)lineToSend);
            String[] alts = ((String)lineToSend.get(4)).split(",");
            String altsTruncatedStr = StringUtils.join((Object[])Arrays.copyOf(alts, this.mMaxAlts), (String)",");
            lineToSend.set(4, (Object)altsTruncatedStr);
        }
    }

    private History receiveLine() {
        try {
            sLogger.info((Object)"----------------------");
            sLogger.info((Object)"Receiving next line...");
            String result = this.mAnnotate.receive((long)this.mCmdTimeout, TimeUnit.SECONDS);
            sLogger.info((Object)("Line received: (line #" + ++this.mLinesRcvd + "): \n" + this.firstXchars(result, 100)));
            if (result.contains("rsXXXXXXXX")) {
                this.terminate();
                throw new NoSuchElementException("AnnotateEXE: Received the end line - no more valid data being processed by bior_annotate, so end.");
            }
            History histOut = this.mergeResults(result);
            return histOut;
        }
        catch (NoSuchElementException nse) {
            sLogger.info((Object)nse.getMessage());
            throw nse;
        }
        catch (TimeoutException te) {
            String msg = String.format("Timeout of %s seconds reached when receiving VCF line.  Last line sent was (#%s): ", this.mCmdTimeout, this.mLinesSent);
            sLogger.error((Object)(msg + this.mLastLineSent));
            System.err.println(msg + this.firstXchars(this.mLastLineSent, 100));
            this.terminate();
            throw new NoSuchElementException(te.getMessage());
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            this.terminate();
            throw new NoSuchElementException("ERROR: " + e.getMessage());
        }
    }

    private History stripTo5Cols(History h) {
        UUID uuid = UUID.randomUUID();
        History hist = new History();
        for (int i = 0; i < 5; ++i) {
            hist.add(h.get(i));
        }
        hist.add((Object)".");
        hist.add((Object)".");
        hist.add((Object)uuid.toString());
        return hist;
    }

    private History mergeResults(String resultLine) {
        History histResult = new History(resultLine);
        String uuid = (String)histResult.get(7);
        History histOut = (History)this.mUuidToOriginalInputLineMap.get(uuid).clone();
        if (!this.mLastUuidReceived.equals("") && !uuid.equals(this.mLastUuidReceived)) {
            this.mUuidToOriginalInputLineMap.remove(this.mLastUuidReceived);
            this.mInFlightQ.remove(0);
        }
        for (int i = 8; i < histResult.size(); ++i) {
            histOut.add(histResult.get(i));
        }
        this.mLastUuidReceived = uuid;
        return histOut;
    }

    private String firstXchars(String str, int charLimit) {
        if (str == null || str.length() < charLimit) {
            return str;
        }
        return str.substring(0, charLimit) + "........";
    }

    private boolean isFirst8ColsSame(History h1, History h2) {
        if (h1 == null && h2 == null) {
            return true;
        }
        if (h1 == null || h2 == null) {
            return false;
        }
        return h1.size() >= 8 && h2.size() >= 8 && ((String)h1.get(0)).equals(h2.get(0)) && ((String)h1.get(1)).equals(h2.get(1)) && ((String)h1.get(2)).equals(h2.get(2)) && ((String)h1.get(3)).equals(h2.get(3)) && ((String)h1.get(4)).equals(h2.get(4)) && ((String)h1.get(5)).equals(h2.get(5)) && ((String)h1.get(6)).equals(h2.get(6)) && ((String)h1.get(7)).equals(h2.get(7));
    }

    public void terminate() {
        try {
            this.mAnnotate.terminate();
        }
        catch (Exception e) {
            sLogger.error((Object)("Error terminating AnnotateEXE pipe" + e));
        }
    }
}

