/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesFileUtil {
    private static Logger sLogger = Logger.getLogger(PropertiesFileUtil.class);
    private String filename = null;
    private Properties prop = null;

    public PropertiesFileUtil(String filename) throws IOException {
        this.filename = filename;
        this.ProcessPropertiesFile();
    }

    public void ProcessPropertiesFile() throws IOException {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(this.filename);
            this.prop = new Properties();
            this.prop.load(inStream);
        }
        catch (IOException ex) {
            sLogger.error((Object)("Error loading properties file: " + this.filename), (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ex) {
                sLogger.error((Object)("Error closing properties file: " + this.filename), (Throwable)ex);
                throw ex;
            }
        }
    }

    public Properties getProperties() {
        return this.prop;
    }

    public String get(String key) {
        return this.prop.getProperty(key);
    }
}

