/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics.sequence;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.JSON.tabix.TabixReader;
import edu.mayo.pipes.JSON.tabix.TabixSearchPipe;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import edu.mayo.pipes.history.History;
import java.io.IOException;
import java.util.NoSuchElementException;

public class RefAllelePipe
extends AbstractPipe<History, History> {
    TabixSearchPipe mTabixSearch;
    private int mJsonCol = -1;
    private JsonPath mChromJsonPath;
    private JsonPath mMinBpJsonPath;
    private JsonPath mMaxBpJsonPath;
    private TabixReader.Iterator mTabixRecords;

    public RefAllelePipe(String catalogFile) throws IOException {
        this(catalogFile, -1);
    }

    public RefAllelePipe(String catalogFile, int jsonCol) throws IOException {
        this.mTabixSearch = new TabixSearchPipe(catalogFile);
        this.mJsonCol = jsonCol;
        this.mChromJsonPath = JsonPath.compile((String)CoreAttributes._landmark.toString(), (Filter[])new Filter[0]);
        this.mMinBpJsonPath = JsonPath.compile((String)CoreAttributes._minBP.toString(), (Filter[])new Filter[0]);
        this.mMaxBpJsonPath = JsonPath.compile((String)CoreAttributes._maxBP.toString(), (Filter[])new Filter[0]);
    }

    public History processNextStart() throws NoSuchElementException {
        try {
            History history = (History)this.starts.next();
            if (history == null || history.size() == 0) {
                return history;
            }
            String tabixQuery = this.getTabixQueryString(history);
            String subsequence = this.getSequence(tabixQuery);
            history.add(subsequence);
            return history;
        }
        catch (IOException ex) {
            throw new NoSuchElementException();
        }
    }

    private String getSequence(String tabixQuery) throws NumberFormatException, IOException {
        StringBuilder subsequence = new StringBuilder();
        this.mTabixRecords = this.mTabixSearch.tquery(tabixQuery);
        if (this.mTabixRecords == null) {
            return ".";
        }
        String rec = null;
        boolean isFirst = true;
        int seqEndPos = 0;
        while ((rec = this.mTabixRecords.next()) != null) {
            String[] split = rec.split("\t");
            String seq = split[3];
            if (isFirst) {
                int numToTrimOffFront = this.getMin(tabixQuery) - Integer.parseInt(split[1]);
                seq = seq.substring(numToTrimOffFront);
                isFirst = false;
            }
            subsequence.append(seq);
            seqEndPos = Integer.parseInt(split[2]);
        }
        int numToTrimOffEnd = seqEndPos - this.getMax(tabixQuery);
        return subsequence.substring(0, subsequence.length() - numToTrimOffEnd);
    }

    private String getTabixQueryString(History history) {
        int jsonIdx = this.mJsonCol > 0 ? this.mJsonCol - 1 : history.size() + this.mJsonCol;
        String json = (String)history.get(jsonIdx);
        String chr = (String)this.mChromJsonPath.read(json);
        Object minBpObj = this.mMinBpJsonPath.read(json);
        int min = minBpObj instanceof String ? Integer.parseInt((String)minBpObj) : (Integer)minBpObj;
        Object maxBpObj = this.mMaxBpJsonPath.read(json);
        int max = maxBpObj instanceof String ? Integer.parseInt((String)maxBpObj) : (Integer)maxBpObj;
        return chr + ":" + min + "-" + max;
    }

    private int getMin(String query) {
        return Integer.parseInt(query.substring(query.indexOf(":") + 1, query.indexOf("-")));
    }

    private int getMax(String query) {
        return Integer.parseInt(query.substring(query.indexOf("-") + 1));
    }
}

