/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.control.OpenLoop;
import java.util.ArrayList;
import java.util.Vector;

public class ClosedLoop
extends BlackBox {
    private OpenLoop forwardPath = new OpenLoop();
    private OpenLoop closedPath = new OpenLoop();
    private ArrayList<BlackBox> feedbackPath = new ArrayList();
    private int nFeedbackBoxes = 0;
    private boolean checkNoMix = true;
    private boolean checkConsolidate = false;
    private double deadTimeSum = 0.0;

    public ClosedLoop() {
        super("ClosedLoop");
    }

    public void addBoxToForwardPath(BlackBox box) {
        this.forwardPath.addBoxToPath(box);
    }

    public void addBoxToFeedbackPath(BlackBox box) {
        this.feedbackPath.add(box);
        ++this.nFeedbackBoxes;
    }

    public void consolidate() {
        this.closedPath = this.forwardPath.copy();
        for (int i = 0; i < this.nFeedbackBoxes; ++i) {
            this.closedPath.addBoxToPath(this.feedbackPath.get(i));
        }
        this.forwardPath.consolidate();
        if (!this.forwardPath.getCheckNoMix()) {
            this.checkNoMix = false;
        }
        this.closedPath.consolidate();
        if (!this.closedPath.getCheckNoMix()) {
            this.checkNoMix = false;
        }
        ComplexPoly fpNumer = this.forwardPath.getSnumer();
        ComplexPoly fpDenom = this.forwardPath.getSdenom();
        ComplexPoly cpNumer = this.closedPath.getSnumer();
        ComplexPoly cpDenom = this.closedPath.getSdenom();
        if (fpDenom.isEqual(cpDenom)) {
            super.setSnumer(fpNumer.copy());
            super.setSdenom(cpNumer.plus(fpDenom).copy());
        } else {
            super.setSnumer(fpNumer.times(cpDenom));
            super.setSdenom(cpNumer.times(fpDenom).plus(cpDenom.times(fpDenom)));
        }
        this.checkConsolidate = true;
        this.deadTimeSum = this.closedPath.getDeadTime();
        this.deadTime = 0.0;
        this.checkConsolidate = true;
    }

    public int getNumberOfBoxesInForwardPath() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.forwardPath.getNumberOfBoxes();
    }

    public int getNumberOfBoxesInClosedLoop() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.closedPath.getNumberOfBoxes();
    }

    public ArrayList<Object> getForwardPathSegmentsArrayList() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.forwardPath.getSegmentsArrayList();
    }

    public Vector<Object> getForwardPathSegmentsVector() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.forwardPath.getSegmentsVector();
    }

    public ArrayList<Object> getClosedLoopSegmentsArrayList() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.closedPath.getSegmentsArrayList();
    }

    public Vector<Object> getClosedLoopSegmentsVector() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.closedPath.getSegmentsVector();
    }

    public int getNumberOfSegmentsInForwardPath() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.forwardPath.getNumberOfSegments();
    }

    public int getNumberOfSegmentsInClosedLoop() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.closedPath.getNumberOfSegments();
    }

    public String getNamesOfBoxesInForwardPath() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.forwardPath.getNamesOfBoxes();
    }

    public String getNamesOfBoxesInClosedLoop() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.closedPath.getNamesOfBoxes();
    }

    public void removeAllBoxes() {
        this.forwardPath.removeAllBoxes();
        this.closedPath.removeAllBoxes();
        this.feedbackPath.clear();
        this.checkNoMix = true;
        this.checkConsolidate = false;
        this.nFeedbackBoxes = 0;
    }

    @Override
    public double getDeadTime() {
        return this.deadTimeSum;
    }

    @Override
    public ClosedLoop copy() {
        if (this == null) {
            return null;
        }
        ClosedLoop bb = new ClosedLoop();
        this.copyBBvariables(bb);
        bb.nFeedbackBoxes = this.nFeedbackBoxes;
        bb.checkNoMix = this.checkNoMix;
        bb.checkConsolidate = this.checkConsolidate;
        bb.forwardPath = this.forwardPath.copy();
        bb.closedPath = this.closedPath.copy();
        bb.feedbackPath = new ArrayList();
        if (this.feedbackPath.size() != 0) {
            for (int i = 0; i < this.feedbackPath.size(); ++i) {
                bb.feedbackPath.add(this.feedbackPath.get(i).copy());
            }
        }
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

