/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.util.GprHtml;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class CountByType
implements Serializable {
    public static final String TOTAL_TYPE = "Total";
    HashMap<String, Long> countByType = new HashMap();
    HashMap<String, Double> scoreByType = new HashMap();

    public void addScore(String type, double score) {
        Double currScore = this.scoreByType.get(type);
        if (currScore == null) {
            currScore = 0.0;
        }
        this.scoreByType.put(type, currScore + score);
    }

    public long get(String type) {
        return this.getCount(this.countByType, type);
    }

    public String getColorHtml(String type) {
        if (this.countByType.get(type) == null) {
            return "ffffff";
        }
        long count = this.get(type);
        Long max = Long.MIN_VALUE;
        Long min = Long.MAX_VALUE;
        for (String key : this.countByType.keySet()) {
            long v = this.get(key);
            max = Math.max(max, v);
            min = Math.min(min, v);
        }
        return GprHtml.heatMapColor(count, max, min, 0xFF0000, 65280);
    }

    long getCount(HashMap<String, Long> hash, String type) {
        if (type.equalsIgnoreCase(TOTAL_TYPE)) {
            long total = 0L;
            for (Long count : hash.values()) {
                total += count != null ? count : 0L;
            }
            return total;
        }
        Long count = hash.get(type);
        return count != null ? count : 0L;
    }

    public double getScore(String type) {
        Double score = this.scoreByType.get(type);
        return score != null ? score : 0.0;
    }

    public List<String> getTypeList() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.countByType.keySet());
        Collections.sort(list);
        return list;
    }

    public boolean hasData() {
        return !this.countByType.isEmpty();
    }

    void inc(HashMap<String, Long> hash, String type, int toAdd) {
        Long count = hash.get(type);
        if (count == null) {
            count = 0L;
        }
        count = count + (long)toAdd;
        hash.put(type, count);
    }

    public void inc(String type) {
        this.inc(this.countByType, type, 1);
    }

    public void inc(String type, int increment) {
        this.inc(this.countByType, type, increment);
    }

    public Set<String> keySet() {
        return this.countByType.keySet();
    }

    public long max() {
        long max = Long.MIN_VALUE;
        for (Long count : this.countByType.values()) {
            max = Math.max(max, count);
        }
        return max;
    }

    public long min() {
        long min = Long.MAX_VALUE;
        for (Long count : this.countByType.values()) {
            min = Math.min(min, count);
        }
        return min;
    }

    public double percent(String type) {
        long total = this.get(TOTAL_TYPE);
        long meth = this.get(type);
        return this.toProb(meth, total);
    }

    public long sum() {
        return this.get(TOTAL_TYPE);
    }

    double toProb(long num, long total) {
        double p = 0.0;
        if (total > 0L) {
            p = (double)num / (double)total;
        }
        return p;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        for (String type : this.getTypeList()) {
            out.append(type + "\t" + this.get(type) + "\n");
        }
        return out.toString();
    }

    public String toStringLine() {
        StringBuffer out = new StringBuffer();
        for (String type : this.getTypeList()) {
            out.append(type + ":" + this.get(type) + "\t");
        }
        return out.toString();
    }

    public String toStringSort() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.countByType.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return (int)(CountByType.this.get(arg1) - CountByType.this.get(arg0));
            }
        });
        StringBuffer out = new StringBuffer();
        for (String type : keys) {
            out.append(type + "\t" + this.get(type) + "\n");
        }
        return out.toString();
    }
}

