/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.factory;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGff;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.Random;

public class SnpEffPredictorFactoryRand
extends SnpEffPredictorFactoryGff {
    Random random;
    int maxTranscripts;
    int maxExons;
    int maxGeneLen;
    int minGeneSize = 100;
    String chromoSequence = "";
    Chromosome chromo;
    boolean forcePositive = false;

    public SnpEffPredictorFactoryRand(Config config, int inOffset, Random random, int maxGeneLen, int maxTranscripts, int maxExons) {
        super(config, inOffset);
        this.random = random;
        this.maxGeneLen = maxGeneLen;
        this.maxTranscripts = maxTranscripts;
        this.maxExons = maxExons;
    }

    @Override
    public SnpEffectPredictor create() {
        int strand;
        this.chromo = new Chromosome(this.genome, 0, 2 * this.maxGeneLen, 1, "chr1");
        this.genome.add(this.chromo);
        this.chromoSequence = GprSeq.randSequence(this.random, this.chromo.size());
        int start = this.random.nextInt(this.maxGeneLen);
        int end = start + Math.max(this.minGeneSize, this.random.nextInt(this.maxGeneLen));
        int n = strand = this.random.nextBoolean() ? 1 : -1;
        if (this.forcePositive) {
            strand = 1;
        }
        Gene gene = new Gene(this.chromo, start, end, strand, "gene1", "gene1", "gene");
        this.add(gene);
        int numTr = Math.max(this.random.nextInt(this.maxTranscripts), 1);
        for (int nt = 0; nt < numTr; ++nt) {
            Transcript tr = new Transcript(gene, gene.getStart(), gene.getEnd(), strand, "transcript_" + nt);
            tr.setProteinCoding(true);
            this.add(tr);
            int numEx = Math.max(this.random.nextInt(this.maxExons), 1);
            for (int ne = 0; ne < numEx; ++ne) {
                int size = tr.size() / numEx;
                start = tr.getStart() + size * ne + this.random.nextInt(size / 2);
                end = start + this.random.nextInt(size / 2);
                Exon exon = new Exon(tr, start, end, strand, "exon_" + nt + "_" + ne, ne + 1);
                String seq = this.chromoSequence.substring(start, end + 1);
                if (exon.isStrandMinus()) {
                    seq = GprSeq.reverseWc(seq);
                }
                exon.setSequence(seq);
                this.add(exon);
            }
            tr.rankExons();
        }
        return this.snpEffectPredictor;
    }

    public Chromosome getChromo() {
        return this.chromo;
    }

    public String getChromoSequence() {
        return this.chromoSequence;
    }

    @Override
    protected boolean parse(String line, String typeToRead) {
        return false;
    }

    public void setChromo(Chromosome chromo) {
        this.chromo = chromo;
    }

    public void setForcePositive(boolean forcePositive) {
        this.forcePositive = forcePositive;
    }
}

