/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.RegulationFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Regulation;
import java.io.IOException;

public class RegulationBedFileIterator
extends RegulationFileIterator {
    public static final int BED_OFFSET = 0;
    String name = "";
    String cellType = "";

    public RegulationBedFileIterator(String fileName, Genome genome, String name, String cellType) {
        super(fileName, genome, 0);
        this.name = name;
        this.cellType = cellType;
    }

    public RegulationBedFileIterator(String fileName, String name, String cellType) {
        super(fileName, 0);
        this.name = name;
        this.cellType = cellType;
    }

    @Override
    protected Regulation readNext() {
        try {
            while (this.ready()) {
                int start;
                String[] fields;
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (this.line.length() <= 0 || this.line.startsWith("#") || (fields = this.line.split("\t")).length < 3) continue;
                String chromosome = fields[0].trim();
                Chromosome chromo = this.getChromosome(chromosome);
                this.sanityCheckChromo(chromosome, chromo);
                int end = start = this.parsePosition(fields[1]);
                if (fields.length > 2) {
                    end = this.parsePosition(fields[2]) - 1;
                }
                String id = "line_" + this.lineNum;
                if (fields.length > 3 && !fields[3].isEmpty()) {
                    id = fields[3];
                }
                return new Regulation(chromo, start, end, 1, id, this.name, this.cellType);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

