/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.sideeffect;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import com.tinkerpop.pipes.util.AsPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import com.tinkerpop.pipes.util.structures.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TablePipe<S>
extends AbstractPipe<S, S>
implements SideEffectPipe<S, Table> {
    private Table table;
    private final PipeFunction[] columnFunctions;
    private int currentFunction;
    private final List<AsPipe> asPipes = new ArrayList<AsPipe>();
    private final Collection<String> stepNames;
    private final boolean doFunctions;

    public TablePipe(Table table, Collection<String> stepNames, List<AsPipe> allPreviousAsPipes, PipeFunction ... columnFunctions) {
        this.table = table;
        this.columnFunctions = columnFunctions;
        this.stepNames = stepNames;
        this.doFunctions = this.columnFunctions.length > 0;
        if (this.doFunctions) {
            this.currentFunction = 0;
        }
        ArrayList<String> tempNames = new ArrayList<String>();
        for (AsPipe asPipe : allPreviousAsPipes) {
            String columnName = asPipe.getName();
            if (null != this.stepNames && !this.stepNames.contains(columnName)) continue;
            tempNames.add(columnName);
            this.asPipes.add(asPipe);
        }
        if (tempNames.size() > 0) {
            table.setColumnNames(tempNames.toArray(new String[tempNames.size()]));
        }
    }

    @Override
    public Table getSideEffect() {
        return this.table;
    }

    @Override
    public S processNextStart() {
        Object s = this.starts.next();
        ArrayList<Object> row = new ArrayList<Object>();
        for (AsPipe asPipe : this.asPipes) {
            if (this.doFunctions) {
                row.add(this.columnFunctions[this.currentFunction++ % this.columnFunctions.length].compute(asPipe.getCurrentEnd()));
                continue;
            }
            row.add(asPipe.getCurrentEnd());
        }
        this.table.addRow(row);
        return (S)s;
    }

    @Override
    public void reset() {
        this.table = new Table();
        this.currentFunction = 0;
        super.reset();
    }

    @Override
    public String toString() {
        if (null == this.stepNames) {
            return PipeHelper.makePipeString(this, new Object[0]);
        }
        return PipeHelper.makePipeString(this, this.stepNames.toArray());
    }
}

