/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics.sequence;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.pipes.HeaderPipe;
import edu.mayo.pipes.UNIX.CatPipe;
import edu.mayo.pipes.WritePipe;
import edu.mayo.pipes.util.GenomicObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Fasta2Tabix {
    List<String> landmarks = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "X", "Y", "MT");

    public List<String> createRefFileList(String dir, String build) {
        ArrayList<String> paths = new ArrayList<String>();
        for (String l : this.landmarks) {
            paths.add(dir + "hs_ref_" + build + "_chr" + l + ".fa.gz");
        }
        return paths;
    }

    public void processDir(String dir, String build, String output) {
        List<String> paths = this.createRefFileList(dir, build);
        int i = 0;
        for (String path : paths) {
            this.process(path, output, this.landmarks.get(i));
            ++i;
        }
    }

    public void process(String inputFile, String outputFile, String landmark) {
        String chr = GenomicObjectUtils.computechr(landmark);
        System.out.println("Opening File: " + inputFile);
        System.out.println("Using Landmark: " + landmark);
        System.out.println("Writing File: " + outputFile);
        TransformFunctionPipe t = new TransformFunctionPipe((PipeFunction)new Fasta2SequenceTabix(chr));
        WritePipe write = new WritePipe(outputFile, true);
        Pipeline p = new Pipeline(new Pipe[]{new CatPipe(), new HeaderPipe(1), t, write});
        p.setStarts(Arrays.asList(inputFile));
        int i = 0;
        while (p.hasNext()) {
            p.next();
            ++i;
        }
    }

    public static void main(String[] args) {
        Fasta2Tabix f2t = new Fasta2Tabix();
        String dir = "/data/NCBIgene/genomes/H_sapiens/Assembled_chromosomes/seq/";
        String out = "/tmp/hs_ref_GRCh37.p10.fa.tsv";
        f2t.processDir(dir, "GRCh37.p10", out);
    }

    public static class Fasta2SequenceTabix
    implements PipeFunction<String, String> {
        private String landmark = "";
        private int count = 1;

        public Fasta2SequenceTabix(String landmark) {
            this.landmark = landmark;
        }

        public String compute(String s) {
            StringBuilder sb = new StringBuilder();
            if (this.count > 10) {
                ++this.count;
            }
            sb.append(this.landmark);
            sb.append("\t");
            sb.append(this.count);
            sb.append("\t");
            this.count += s.length() - 1;
            sb.append(this.count);
            sb.append("\t");
            sb.append(s);
            sb.append("\n");
            return sb.toString();
        }
    }
}

