/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.history;

import edu.mayo.pipes.history.HistoryMetaData;
import edu.mayo.pipes.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class History
extends ArrayList<String>
implements List<String>,
Cloneable {
    private static final String COL_DELIMITER = "\t";
    private static final long serialVersionUID = 1L;
    private static HistoryMetaData sMetaData = null;
    private static boolean sMetaDataInitialized = false;

    @Override
    public Object clone() {
        History h2 = new History();
        for (int i = 0; i < this.size(); ++i) {
            h2.add(new String((String)this.get(i)));
        }
        return h2;
    }

    public History() {
    }

    public History(String lineTabDelimited) {
        this(StringUtils.safeSplit(lineTabDelimited, COL_DELIMITER));
    }

    public History(List<String> line) {
        this(line.toArray(new String[line.size()]));
    }

    public History(String[] line) {
        for (String colData : line) {
            this.add(colData);
        }
    }

    public static void clearMetaData() {
        sMetaData = null;
        sMetaDataInitialized = false;
    }

    public void setMetaData(HistoryMetaData hMetaData) {
        sMetaData = hMetaData;
        sMetaDataInitialized = true;
    }

    public boolean isMetaDataInitialized() {
        return sMetaDataInitialized;
    }

    public static HistoryMetaData getMetaData() {
        return sMetaData;
    }

    public String getMergedData(String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            String dataStr = (String)this.get(i);
            sb.append(dataStr);
            if (i >= this.size() - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }
}

