/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.vcf;

import ca.mcgill.mcb.pcingola.util.Gpr;

public class VcfLof {
    String geneName;
    String geneId;
    int numTranscripts;
    double percentAffected;

    public static int fieldNum(String name) {
        int fieldNum = 0;
        if (name.equals("LOF.GENE")) {
            return fieldNum;
        }
        ++fieldNum;
        if (name.equals("LOF.GENEID")) {
            return fieldNum;
        }
        ++fieldNum;
        if (name.equals("LOF.NUMTR")) {
            return fieldNum;
        }
        ++fieldNum;
        if (name.equals("LOF.PERC")) {
            return fieldNum;
        }
        ++fieldNum;
        return -1;
    }

    public VcfLof(String lofStr) {
        this.parse(lofStr);
    }

    void parse(String lof) {
        String[] lofFields = lof.split("|");
        try {
            Gpr.debug("PARSE: '" + lof + "'");
            int index = 0;
            if (lofFields.length > index && !lofFields[index].isEmpty()) {
                this.geneName = lofFields[index];
            }
            if (lofFields.length > ++index && !lofFields[index].isEmpty()) {
                this.geneId = lofFields[index];
            }
            if (lofFields.length > ++index && !lofFields[index].isEmpty()) {
                this.numTranscripts = Gpr.parseIntSafe(lofFields[index]);
            }
            if (lofFields.length > ++index && !lofFields[index].isEmpty()) {
                this.percentAffected = Gpr.parseDoubleSafe(lofFields[index]);
            }
            ++index;
        }
        catch (Exception e) {
            String fields = "";
            for (int i = 0; i < lofFields.length; ++i) {
                fields = fields + "\t" + i + " : '" + lofFields[i] + "'\n";
            }
            throw new RuntimeException("Error parsing: '" + lof + "'\n" + fields, e);
        }
    }

    public String toString() {
        return String.format("(%s|%s|%d|%.2f)", this.geneName, this.geneId, this.numTranscripts, this.percentAffected);
    }
}

