/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.biojava.bio.BioException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.proteomics.Protease;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public class Digest {
    private Protease protease;
    private Sequence sequence;
    private int maxMissedCleavages = 0;
    public static String PEPTIDE_FEATURE_TYPE = "Peptide";
    private LinkedList peptideQue;

    public void setProtease(Protease protease) {
        this.protease = protease;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setMaxMissedCleavages(int maxMissedCleavages) {
        this.maxMissedCleavages = maxMissedCleavages;
    }

    public void addDigestFeatures() throws BioException, ChangeVetoException {
        this.peptideQue = new LinkedList();
        if (this.protease == null) {
            throw new BioException("Protease is null, use Digest.setProtease()");
        }
        if (this.sequence == null) {
            throw new BioException("Sequence is null, use Digest.setSequence()");
        }
        List<Symbol> cleaveSites = this.protease.getCleaveageResidues().toList();
        boolean endoProtease = this.protease.isEndoProtease();
        List<Symbol> notCleave = this.protease.getNotCleaveResidues().toList();
        if (notCleave == null) {
            notCleave = new LinkedList<Symbol>();
        }
        int nTerm = 1;
        if (cleaveSites == null || notCleave == null) {
            throw new BioException("Protease contains null parameter");
        }
        for (int j = 1; j <= this.sequence.length(); ++j) {
            Symbol aa = this.sequence.symbolAt(j);
            if (!cleaveSites.contains(aa)) continue;
            if (endoProtease) {
                Symbol nextAA;
                boolean cleave = true;
                if (j < this.sequence.length() && notCleave.contains(nextAA = this.sequence.symbolAt(j + 1))) {
                    cleave = false;
                }
                if (!cleave) continue;
                RangeLocation loc = new RangeLocation(nTerm, j);
                this.peptideQue.add(loc);
                nTerm = j + 1;
                continue;
            }
            if (j <= 1) continue;
            RangeLocation loc = new RangeLocation(nTerm, j - 1);
            this.peptideQue.add(loc);
            nTerm = j;
        }
        if (nTerm <= this.sequence.length()) {
            RangeLocation loc = new RangeLocation(nTerm, this.sequence.length());
            this.peptideQue.add(loc);
        }
        this.addMissedCleavages();
        ListIterator li = this.peptideQue.listIterator();
        while (li.hasNext()) {
            this.createPeptideFeature((Location)li.next());
        }
    }

    private void addMissedCleavages() throws BioException {
        LinkedList<RangeLocation> missedList = new LinkedList<RangeLocation>();
        if (this.maxMissedCleavages > 0) {
            ListIterator li = this.peptideQue.listIterator();
            while (li.hasNext()) {
                int i;
                Location loc = (Location)li.next();
                Location loc2 = null;
                int min = loc.getMin();
                int max = 0;
                int numAdvanced = 0;
                for (i = 0; i < this.maxMissedCleavages; ++i) {
                    if (!li.hasNext()) continue;
                    ++numAdvanced;
                    loc2 = (Location)li.next();
                    max = loc2.getMax();
                    missedList.add(new RangeLocation(min, max));
                }
                for (i = 0; i < numAdvanced; ++i) {
                    loc = (Location)li.previous();
                }
            }
            this.peptideQue.addAll(missedList);
        }
    }

    private void createPeptideFeature(Location loc) throws BioException, ChangeVetoException {
        SmallAnnotation anno = new SmallAnnotation();
        anno.setProperty("Protease", this.protease.getName());
        Feature.Template template = new Feature.Template();
        template.type = PEPTIDE_FEATURE_TYPE;
        template.source = this.getClass().getName();
        template.location = loc;
        template.annotation = anno;
        this.sequence.createFeature(template);
    }
}

