/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.threadedpipe;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.PipeHelper;
import com.tinkerpop.pipes.util.iterators.HistoryIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class ThreadedPipe2<S, E>
implements Pipe<S, E> {
    protected Iterator<S> starts;
    private E nextEnd;
    protected E currentEnd;
    private boolean available = false;
    protected boolean pathEnabled = false;
    protected AbstractPipe pipeToThread = null;
    protected Vector<E> outputQ = new Vector();
    protected boolean isDone = false;
    protected boolean isFirstCall = true;
    protected int maxOutputBufferSize = 1000;
    protected ThreadedInput pipeThread = null;

    public ThreadedPipe2(AbstractPipe pipeToThread, int maxOutputBufferSize) {
        if (maxOutputBufferSize < 1) {
            throw new IllegalArgumentException("Buffer size is too small for threaded pipe.  It must be >= 1.");
        }
        this.maxOutputBufferSize = maxOutputBufferSize;
        this.pipeToThread = pipeToThread;
        this.pipeToThread.setStarts(this.starts);
    }

    public void setStarts(Iterator<S> starts) {
        this.starts = starts instanceof Pipe ? starts : new HistoryIterator(starts);
    }

    public void setStarts(Iterable<S> starts) {
        this.setStarts(starts.iterator());
    }

    public void setStarts(Pipe<?, S> starts) {
        this.setStarts(starts.iterator());
    }

    public void reset() {
        if (this.starts instanceof Pipe) {
            ((Pipe)this.starts).reset();
        }
        this.nextEnd = null;
        this.currentEnd = null;
        this.available = false;
    }

    public List getCurrentPath() {
        if (this.pathEnabled) {
            List pathElements = this.getPathToHere();
            int size = pathElements.size();
            if (size == 0 || pathElements.get(size - 1) != this.currentEnd) {
                pathElements.add(this.currentEnd);
            }
            return pathElements;
        }
        throw new RuntimeException("Path calculations are not enabled");
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public E next() {
        if (this.available) {
            this.available = false;
            this.currentEnd = this.nextEnd;
            return this.currentEnd;
        }
        this.currentEnd = this.processNextStart();
        return this.currentEnd;
    }

    public boolean hasNext() {
        if (this.available) {
            return true;
        }
        try {
            this.nextEnd = this.processNextStart();
            this.available = true;
            return true;
        }
        catch (NoSuchElementException e) {
            this.available = false;
            return false;
        }
    }

    public void enablePath(boolean enable) {
        this.pathEnabled = enable;
        if (this.starts instanceof Pipe) {
            ((Pipe)this.starts).enablePath(enable);
        }
    }

    public Iterator<E> iterator() {
        return this;
    }

    public String toString() {
        return PipeHelper.makePipeString((Pipe)this, (Object[])new Object[0]);
    }

    protected List getPathToHere() {
        if (this.starts instanceof Pipe) {
            return ((Pipe)this.starts).getCurrentPath();
        }
        if (this.starts instanceof HistoryIterator) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(((HistoryIterator)this.starts).getLast());
            return list;
        }
        return new ArrayList();
    }

    protected E processNextStart() throws NoSuchElementException {
        boolean isPrevPipeThreaded = this.starts instanceof ThreadedPipe2;
        if (this.isFirstCall) {
            this.pipeThread = new ThreadedInput();
            this.pipeThread.run();
        }
        if (this.isDone) {
            throw new NoSuchElementException();
        }
        try {
            while (this.outputQ.size() == 0) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException intExc) {
            System.err.println("Thread interrupted in " + this.getClass().getName() + ": " + intExc);
        }
        E output = this.outputQ.remove(0);
        return output;
    }

    private class ThreadedInput
    implements Runnable {
        private ThreadedInput() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!ThreadedPipe2.this.isDone) {
                    while (ThreadedPipe2.this.outputQ.size() >= ThreadedPipe2.this.maxOutputBufferSize) {
                        Thread.sleep(1L);
                    }
                    try {
                        if (!ThreadedPipe2.this.pipeToThread.hasNext()) continue;
                        ThreadedPipe2.this.outputQ.add(ThreadedPipe2.this.pipeToThread.next());
                    }
                    catch (NoSuchElementException noSuchElemExc) {
                        ThreadedPipe2.this.isDone = true;
                    }
                }
                return;
            }
            catch (Exception e) {
                ThreadedPipe2.this.isDone = true;
            }
        }
    }
}

