/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.VEP;

import com.google.gson.JsonArray;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.pipeline.VEP.VEPEXE;
import edu.mayo.bior.pipeline.VEP.VepFunctions;
import edu.mayo.exec.AbnormalExitException;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.string.TrimSpacesPipe;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;

public class VEPPipeline
extends Pipeline {
    private VEPEXE mVepExe = null;
    private boolean mIsWorstCaseOnly = true;
    private Queue<History> mLastLineQ = new ArrayDeque<History>();

    public VEPPipeline(String[] command, boolean pickworst) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        this.mIsWorstCaseOnly = pickworst;
        this.mVepExe = new VEPEXE(VEPEXE.getVEPCommand(new String[]{"1"}));
        Pipeline pipeline = new Pipeline(new Pipe[]{new TrimSpacesPipe(), new TransformFunctionPipe((PipeFunction)new VepPrePipe()), new TransformFunctionPipe((PipeFunction)this.mVepExe), new TransformFunctionPipe((PipeFunction)new VepPostPipe())});
        this.setPipes(pipeline.getPipes());
    }

    public void terminate() throws InterruptedException {
        this.mVepExe.terminate();
    }

    class VepPostPipe
    implements PipeFunction<String, History> {
        private VepFunctions mVepFunctions = new VepFunctions();

        VepPostPipe() {
        }

        public History compute(String histFromVep) {
            String vepCsq = histFromVep.split("\t")[7];
            JsonArray csqAsJsonArray = this.mVepFunctions.vepCsqToJsonList(vepCsq);
            String vepOut = VEPPipeline.this.mIsWorstCaseOnly ? this.mVepFunctions.getWorstCase(csqAsJsonArray).toString() : "{\"CSQ\":" + csqAsJsonArray.toString() + "}";
            History original = (History)VEPPipeline.this.mLastLineQ.remove();
            original.add((Object)vepOut);
            return original;
        }
    }

    class VepPrePipe
    implements PipeFunction<History, String> {
        VepPrePipe() {
        }

        public String compute(History hist) {
            VEPPipeline.this.mLastLineQ.add((History)hist.clone());
            for (int i = hist.size() - 1; i > 6; --i) {
                hist.remove(i);
            }
            return hist.getMergedData("\t");
        }
    }
}

