/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.iterators;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;

public class FileLineIterator
implements Iterator<String> {
    protected BufferedReader br;
    private LinkedList<String> queue = new LinkedList();
    private boolean readok = true;

    public FileLineIterator(String filename) throws IOException {
        this.open(filename);
    }

    @Override
    public boolean hasNext() {
        if (this.queue.size() > 0) {
            return true;
        }
        if (!this.readok) {
            return false;
        }
        try {
            String line = this.br.readLine();
            if (line != null) {
                this.queue.add(line);
                return true;
            }
            this.readok = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public String next() {
        if (this.queue.size() < 1) {
            this.hasNext();
        }
        return this.queue.pollFirst();
    }

    @Override
    public void remove() {
    }

    public BufferedReader open(String filename) throws IOException {
        this.readok = true;
        this.br = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        return this.br;
    }

    public void close() throws IOException {
        this.br.close();
        this.readok = false;
    }
}

