/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics;

import com.tinkerpop.pipes.AbstractPipe;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import org.biojava.bio.BioException;
import org.biojavax.Namespace;
import org.biojavax.SimpleNamespace;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class GenbankPipe
extends AbstractPipe<String, RichSequence> {
    private RichSequenceIterator mRichSeqIter = null;
    private boolean mIsFileGzip = false;

    public GenbankPipe() {
    }

    public GenbankPipe(boolean isGzipFile) {
        this.mIsFileGzip = isGzipFile;
    }

    private BufferedReader openFile(String filename) throws Exception {
        BufferedReader reader = this.mIsFileGzip ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename)))) : new BufferedReader(new FileReader(filename));
        SimpleNamespace namespace = new SimpleNamespace("biojava");
        this.mRichSeqIter = RichSequence.IOTools.readGenbankDNA((BufferedReader)reader, (Namespace)namespace);
        return reader;
    }

    protected RichSequence processNextStart() throws NoSuchElementException {
        if (this.mRichSeqIter == null) {
            try {
                this.openFile((String)this.starts.next());
            }
            catch (Exception e) {
                throw new NoSuchElementException(e.getMessage());
            }
        }
        if (this.mRichSeqIter.hasNext()) {
            try {
                return this.mRichSeqIter.nextRichSequence();
            }
            catch (BioException ex) {
                throw new NoSuchElementException(ex.getMessage());
            }
        }
        try {
            this.openFile((String)this.starts.next());
            if (this.mRichSeqIter.hasNext()) {
                return this.mRichSeqIter.nextRichSequence();
            }
        }
        catch (Exception e) {
            throw new NoSuchElementException(e.getMessage());
        }
        throw new NoSuchElementException();
    }
}

