/*
 * Decompiled with CFR 0.152.
 */
package flanagan.plot;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.io.FileOutput;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;

public class PlotPoleZero {
    private ComplexPoly numerPoly = null;
    private ComplexPoly denomPoly = null;
    private Complex[] numerRoots = null;
    private Complex[] denomRoots = null;
    private double[][] data = null;
    private int nDeg = 0;
    private int dDeg = 0;
    private int mDeg = 0;
    private int sORz = 0;
    private boolean zerosSet = false;
    private boolean polesSet = false;
    private boolean zCircle = false;
    private boolean noImag = true;
    private boolean noReal = true;
    private boolean noZeros = true;
    private boolean noPoles = true;
    private boolean setUnitAxes = false;
    private boolean setEqualAxes = false;
    private double scaleFactor = 1.0;

    public PlotPoleZero() {
    }

    public PlotPoleZero(ComplexPoly numer, ComplexPoly denom) {
        if (numer != null) {
            this.nDeg = numer.getDeg();
            if (this.nDeg > 0) {
                this.numerPoly = ComplexPoly.copy(numer);
                this.numerRoots = Complex.oneDarray(this.nDeg);
                this.mDeg = this.nDeg;
                this.noZeros = false;
            }
        }
        if (denom != null) {
            this.dDeg = denom.getDeg();
            if (this.dDeg > 0) {
                this.denomPoly = ComplexPoly.copy(denom);
                this.denomRoots = Complex.oneDarray(this.dDeg);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
        }
        if (this.noZeros && this.noPoles) {
            throw new IllegalArgumentException("No poles or zeros entered");
        }
    }

    public PlotPoleZero(Complex[] numer, Complex[] denom) {
        if (numer != null) {
            this.nDeg = numer.length - 1;
            if (this.nDeg > 0) {
                this.numerPoly = new ComplexPoly(numer);
                this.numerRoots = Complex.oneDarray(this.nDeg);
                this.mDeg = this.nDeg;
                this.noZeros = false;
            }
        }
        if (denom != null) {
            this.dDeg = denom.length - 1;
            if (this.dDeg > 0) {
                this.denomPoly = new ComplexPoly(denom);
                this.denomRoots = Complex.oneDarray(this.dDeg);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
            if (this.noZeros && this.noPoles) {
                throw new IllegalArgumentException("No poles or zeros entered");
            }
        }
    }

    public PlotPoleZero(double[] numer, double[] denom) {
        if (numer != null) {
            this.nDeg = numer.length - 1;
            if (this.nDeg > 0) {
                this.numerPoly = new ComplexPoly(numer);
                this.numerRoots = Complex.oneDarray(this.nDeg);
                this.mDeg = this.nDeg;
                this.noZeros = false;
            }
        }
        if (denom != null) {
            this.dDeg = denom.length - 1;
            if (this.dDeg > 0) {
                this.denomPoly = new ComplexPoly(denom);
                this.denomRoots = Complex.oneDarray(this.dDeg);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
            if (this.noZeros && this.noPoles) {
                throw new IllegalArgumentException("No poles or zeros entered");
            }
        }
    }

    public void setNumerator(ComplexPoly numer) {
        if (numer != null) {
            this.nDeg = numer.getDeg();
            if (this.nDeg > 0) {
                this.numerPoly = ComplexPoly.copy(numer);
                this.numerRoots = Complex.oneDarray(this.nDeg);
                this.mDeg = !this.noPoles ? Math.max(this.nDeg, this.dDeg) : this.nDeg;
                this.noZeros = false;
            }
        } else {
            this.noZeros = true;
        }
    }

    public void setNumerator(Complex[] numer) {
        if (numer != null) {
            this.nDeg = numer.length - 1;
            if (this.nDeg > 0) {
                this.numerPoly = new ComplexPoly(numer);
                this.numerRoots = Complex.oneDarray(this.nDeg);
                this.mDeg = !this.noPoles ? Math.max(this.nDeg, this.dDeg) : this.nDeg;
                this.noZeros = false;
            }
        } else {
            this.noZeros = true;
        }
    }

    public void setNumerator(double[] numer) {
        if (numer != null) {
            this.nDeg = numer.length - 1;
            if (this.nDeg > 0) {
                this.numerPoly = new ComplexPoly(numer);
                this.numerRoots = Complex.oneDarray(this.nDeg);
                this.mDeg = !this.noPoles ? Math.max(this.nDeg, this.dDeg) : this.nDeg;
                this.noZeros = false;
            }
        } else {
            this.noZeros = true;
        }
    }

    public void setZeros(Complex[] zeros) {
        if (zeros != null) {
            this.nDeg = zeros.length;
            if (this.nDeg > 0) {
                this.numerRoots = zeros;
                this.numerPoly = ComplexPoly.rootsToPoly(zeros);
                this.mDeg = !this.noPoles ? Math.max(this.nDeg, this.dDeg) : this.nDeg;
                this.noZeros = false;
            }
            this.zerosSet = true;
        } else {
            this.noZeros = true;
        }
    }

    public void setZeros(double[] zeros) {
        int n = zeros.length;
        Complex[] czeros = Complex.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            czeros[i] = new Complex(zeros[i], 0.0);
        }
        this.setZeros(czeros);
    }

    public void setDenominator(ComplexPoly denom) {
        if (denom != null) {
            this.dDeg = denom.getDeg();
            if (this.dDeg > 0) {
                this.denomPoly = ComplexPoly.copy(denom);
                this.denomRoots = Complex.oneDarray(this.dDeg);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
        } else {
            this.noPoles = true;
        }
    }

    public void setDenominator(Complex[] denom) {
        if (denom != null) {
            this.dDeg = denom.length - 1;
            if (this.dDeg > 0) {
                this.denomPoly = new ComplexPoly(denom);
                this.denomRoots = Complex.oneDarray(this.dDeg);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
        } else {
            this.noPoles = true;
        }
    }

    public void setDenominator(double[] denom) {
        if (denom != null) {
            this.dDeg = denom.length - 1;
            if (this.dDeg > 0) {
                this.denomPoly = new ComplexPoly(denom);
                this.denomRoots = Complex.oneDarray(this.dDeg);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
        } else {
            this.noPoles = true;
        }
    }

    public void setPoles(Complex[] poles) {
        if (poles != null) {
            this.dDeg = poles.length;
            if (this.dDeg > 0) {
                this.denomRoots = poles;
                this.denomPoly = ComplexPoly.rootsToPoly(poles);
                this.mDeg = !this.noZeros ? Math.max(this.nDeg, this.dDeg) : this.dDeg;
                this.noPoles = false;
            }
            this.polesSet = true;
        } else {
            this.noPoles = true;
        }
    }

    public void setPoles(double[] poles) {
        int n = poles.length;
        Complex[] cpoles = Complex.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            cpoles[i] = new Complex(poles[i], 0.0);
        }
        this.setPoles(cpoles);
    }

    public void setScaleFactor(double scale) {
        this.scaleFactor = scale;
    }

    public void setS() {
        this.sORz = 1;
    }

    public void setZ() {
        this.sORz = 2;
        this.zCircle = true;
    }

    public void setUnitAxes() {
        this.setUnitAxes = true;
        this.setEqualAxes = false;
    }

    public void setEqualAxes() {
        this.setEqualAxes = true;
        this.setUnitAxes = false;
    }

    public void setCircle() {
        this.zCircle = true;
        if (this.sORz != 2) {
            this.sORz = 2;
        }
    }

    public void unsetCircle() {
        this.zCircle = false;
    }

    public Complex[][] pzPlot(String title) {
        int i;
        int i2;
        if (this.noPoles && this.noZeros) {
            throw new IllegalArgumentException("No poles or zeros have been entered");
        }
        double absReal = 0.0;
        double absImag = 0.0;
        double zeroLimit = 1.0E-5;
        double minall = 0.0;
        double maxall = 0.0;
        int ncirc = 600;
        double stp = 2.0 / (double)(ncirc - 1);
        int maxPoints = 0;
        double[] zerosReal = null;
        double[] zerosImag = null;
        double[] polesReal = null;
        double[] polesImag = null;
        double[] xAxisIfRealZero = null;
        double[] yAxisIfRealZero = null;
        double[] xAxisIfImagZero = null;
        double[] yAxisIfImagZero = null;
        double[] xAxisCircle1 = new double[ncirc];
        double[] yAxisCircle1 = new double[ncirc];
        double[] xAxisCircle2 = new double[ncirc];
        double[] yAxisCircle2 = new double[ncirc];
        Complex[][] zerosAndPoles = new Complex[][]{null, null};
        int mm = 0;
        if (this.nDeg > 0) {
            ++mm;
            zerosReal = new double[this.nDeg];
            zerosImag = new double[this.nDeg];
            if (!this.zerosSet) {
                this.numerRoots = this.numerPoly.roots();
            }
            zerosAndPoles[0] = this.numerRoots;
            for (i2 = 0; i2 < this.nDeg; ++i2) {
                zerosReal[i2] = this.numerRoots[i2].getReal();
                zerosImag[i2] = this.numerRoots[i2].getImag();
                if (!this.numerRoots[i2].isZero()) {
                    absReal = Math.abs(zerosReal[i2]);
                    if (absReal > (absImag = Math.abs(zerosImag[i2]))) {
                        if (absImag < zeroLimit * absReal) {
                            zerosImag[i2] = 0.0;
                        }
                    } else if (absReal < zeroLimit * absImag) {
                        zerosReal[i2] = 0.0;
                    }
                }
                if (zerosReal[i2] != 0.0) {
                    this.noReal = false;
                }
                if (zerosImag[i2] == 0.0) continue;
                this.noImag = false;
            }
            maxPoints = this.nDeg;
        }
        if (this.dDeg > 0) {
            ++mm;
            polesReal = new double[this.dDeg];
            polesImag = new double[this.dDeg];
            if (!this.polesSet) {
                this.denomRoots = this.denomPoly.roots();
            }
            zerosAndPoles[1] = this.denomRoots;
            for (i2 = 0; i2 < this.dDeg; ++i2) {
                polesReal[i2] = this.denomRoots[i2].getReal();
                polesImag[i2] = this.denomRoots[i2].getImag();
                if (!this.denomRoots[i2].isZero()) {
                    absReal = Math.abs(polesReal[i2]);
                    if (absReal > (absImag = Math.abs(polesImag[i2]))) {
                        if (absImag < zeroLimit * absReal) {
                            polesImag[i2] = 0.0;
                        }
                    } else if (absReal < zeroLimit * absImag) {
                        polesReal[i2] = 0.0;
                    }
                }
                if (polesReal[i2] != 0.0) {
                    this.noReal = false;
                }
                if (polesImag[i2] == 0.0) continue;
                this.noImag = false;
            }
            if (this.dDeg > maxPoints) {
                maxPoints = this.dDeg;
            }
        }
        if (this.noReal) {
            ++mm;
            xAxisIfRealZero = new double[]{1.0, -1.0};
            yAxisIfRealZero = new double[]{0.0, 0.0};
            if (2 > maxPoints) {
                maxPoints = 2;
            }
        }
        if (this.noImag) {
            ++mm;
            xAxisIfImagZero = new double[]{0.0, 0.0};
            yAxisIfImagZero = new double[]{1.0, -1.0};
            if (2 > maxPoints) {
                maxPoints = 2;
            }
        }
        if (this.zCircle) {
            mm += 2;
            xAxisCircle1[0] = -1.0;
            yAxisCircle1[0] = 0.0;
            xAxisCircle2[0] = -1.0;
            yAxisCircle2[0] = 0.0;
            for (i2 = 1; i2 < ncirc; ++i2) {
                xAxisCircle1[i2] = xAxisCircle1[i2 - 1] + stp;
                yAxisCircle1[i2] = Math.sqrt(1.0 - xAxisCircle1[i2] * xAxisCircle1[i2]);
                xAxisCircle2[i2] = xAxisCircle2[i2 - 1] + stp;
                yAxisCircle2[i2] = -yAxisCircle1[i2];
            }
            if (ncirc > maxPoints) {
                maxPoints = ncirc;
            }
        }
        if (this.setEqualAxes) {
            ++mm;
            double maxpr = Fmath.maximum(polesReal);
            double maxzr = Fmath.maximum(zerosReal);
            double maxr = Math.max(maxpr, maxzr);
            double maxpi = Fmath.maximum(polesImag);
            double maxzi = Fmath.maximum(zerosImag);
            double maxi = Math.max(maxpi, maxzi);
            maxall = Math.max(maxr, maxi);
            double minpr = Fmath.minimum(polesReal);
            double minzr = Fmath.minimum(zerosReal);
            double minr = Math.min(minpr, minzr);
            double minpi = Fmath.minimum(polesImag);
            double minzi = Fmath.minimum(zerosImag);
            double mini = Math.min(minpi, minzi);
            minall = Math.min(minr, mini);
        }
        int ii = 0;
        double[][] data = PlotGraph.data(mm, maxPoints);
        boolean[] trim = new boolean[mm];
        boolean[] minmax = new boolean[mm];
        int[] line = new int[mm];
        int[] point = new int[mm];
        ii = 0;
        if (this.nDeg > 0) {
            line[ii] = 0;
            point[ii] = 1;
            trim[ii] = false;
            minmax[ii] = true;
            for (int i3 = 0; i3 < this.nDeg; ++i3) {
                data[2 * ii][i3] = zerosReal[i3];
                data[2 * ii + 1][i3] = zerosImag[i3];
            }
            ++ii;
        }
        if (this.dDeg > 0) {
            line[ii] = 0;
            point[ii] = 7;
            trim[ii] = false;
            minmax[ii] = true;
            for (int i4 = 0; i4 < this.dDeg; ++i4) {
                data[2 * ii][i4] = polesReal[i4];
                data[2 * ii + 1][i4] = polesImag[i4];
            }
            ++ii;
        }
        if (this.zCircle) {
            int i5;
            line[ii] = 3;
            point[ii] = 0;
            trim[ii] = true;
            minmax[ii] = false;
            if (this.setUnitAxes) {
                minmax[ii] = true;
            }
            for (i5 = 0; i5 < ncirc; ++i5) {
                data[2 * ii][i5] = xAxisCircle1[i5];
                data[2 * ii + 1][i5] = yAxisCircle1[i5];
            }
            line[++ii] = 3;
            point[ii] = 0;
            trim[ii] = true;
            minmax[ii] = false;
            if (this.setUnitAxes) {
                minmax[ii] = true;
            }
            for (i5 = 0; i5 < ncirc; ++i5) {
                data[2 * ii][i5] = xAxisCircle2[i5];
                data[2 * ii + 1][i5] = yAxisCircle2[i5];
            }
            ++ii;
        }
        if (this.noReal) {
            line[ii] = 0;
            point[ii] = 0;
            trim[ii] = false;
            minmax[ii] = true;
            for (int i6 = 0; i6 < 2; ++i6) {
                data[2 * ii][i6] = xAxisIfRealZero[i6];
                data[2 * ii + 1][i6] = yAxisIfRealZero[i6];
            }
            ++ii;
        }
        if (this.noImag) {
            line[ii] = 0;
            point[ii] = 0;
            trim[ii] = false;
            minmax[ii] = true;
            for (int i7 = 0; i7 < 2; ++i7) {
                data[2 * ii][i7] = xAxisIfImagZero[i7];
                data[2 * ii + 1][i7] = yAxisIfImagZero[i7];
            }
            ++ii;
        }
        if (this.setEqualAxes) {
            line[ii] = 0;
            point[ii] = 0;
            trim[ii] = false;
            minmax[ii] = true;
            data[2 * ii][0] = minall;
            data[2 * ii + 1][0] = minall;
            data[2 * ii][1] = maxall;
            data[2 * ii + 1][1] = maxall;
            ++ii;
        }
        PlotGraph pg = new PlotGraph(data);
        pg.setLine(line);
        pg.setPoint(point);
        pg.setTrimOpt(trim);
        pg.setMinMaxOpt(minmax);
        pg.setXlowFac(0.0);
        pg.setYlowFac(0.0);
        pg.setGraphWidth((int)(this.scaleFactor * 760.0));
        pg.setGraphHeight((int)(this.scaleFactor * 700.0));
        pg.setXaxisLen((int)(this.scaleFactor * 560.0));
        pg.setYaxisLen((int)(this.scaleFactor * 560.0));
        pg.setYhigh((int)(this.scaleFactor * 80.0));
        pg.setNoOffset(true);
        switch (this.sORz) {
            case 0: {
                pg.setGraphTitle("Pole Zero Plot: " + title);
                pg.setXaxisLegend("Real part of s or z");
                pg.setYaxisLegend("Imaginary part of s or z");
                break;
            }
            case 1: {
                pg.setGraphTitle("Pole Zero Plot (s-plane): " + title);
                pg.setXaxisLegend("Real part of s");
                pg.setYaxisLegend("Imaginary part of s");
                break;
            }
            case 2: {
                pg.setGraphTitle("Pole Zero Plot (z-plane): " + title);
                pg.setXaxisLegend("Real part of z");
                pg.setYaxisLegend("Imaginary part of z");
            }
        }
        pg.plot();
        Complex[] numval = null;
        Complex[] denval = null;
        FileOutput fout = new FileOutput("PoleZeroOutput.txt");
        fout.println("Output File for Program PlotPoleZero");
        if (this.sORz == 1) {
            fout.println("An s-plane plot");
        }
        if (this.sORz == 2) {
            fout.println("A z-plane plot");
        }
        fout.dateAndTimeln(title);
        fout.println();
        if (!this.noZeros) {
            numval = this.numerPoly.polyNomCopy();
            fout.println("Numerator polynomial coefficients");
            for (int i8 = 0; i8 <= this.nDeg; ++i8) {
                fout.print(numval[i8].toString());
                if (i8 >= this.nDeg) continue;
                fout.printcomma();
                fout.printsp();
            }
            fout.println();
            fout.println();
        }
        if (!this.noPoles) {
            denval = this.denomPoly.polyNomCopy();
            fout.println("Denominator polynomial coefficients");
            for (int i9 = 0; i9 <= this.dDeg; ++i9) {
                fout.print(denval[i9].toString());
                if (i9 >= this.dDeg) continue;
                fout.printcomma();
                fout.printsp();
            }
            fout.println();
            fout.println();
        }
        fout.println("Numerator roots (zeros)");
        if (this.nDeg < 1) {
            fout.println("No zeros");
        } else {
            for (int i10 = 0; i10 < this.nDeg; ++i10) {
                fout.print(Complex.truncate(this.numerRoots[i10], 6));
                if (i10 >= this.nDeg - 1) continue;
                fout.printcomma();
                fout.printsp();
            }
            fout.println();
            fout.println();
        }
        fout.println("Denominator roots (poles)");
        if (this.dDeg < 1) {
            fout.println("No poles");
        } else {
            for (int i11 = 0; i11 < this.dDeg; ++i11) {
                fout.print(Complex.truncate(this.denomRoots[i11], 6));
                if (i11 >= this.dDeg - 1) continue;
                fout.printcomma();
                fout.printsp();
            }
            fout.println();
            fout.println();
        }
        if (this.sORz == 2) {
            fout.println("Denominator pole radial distances on the z-plane");
            if (this.dDeg < 1) {
                fout.println("No poles");
            } else {
                for (int i12 = 0; i12 < this.dDeg; ++i12) {
                    fout.print(Fmath.truncate(this.denomRoots[i12].abs(), 6));
                    if (i12 >= this.dDeg - 1) continue;
                    fout.printcomma();
                    fout.printsp();
                }
            }
            fout.println();
            fout.println();
        }
        boolean testroots = true;
        if (this.sORz == 1) {
            for (i = 0; i < this.dDeg; ++i) {
                if (!(this.denomRoots[i].getReal() > 0.0)) continue;
                testroots = false;
            }
            if (testroots) {
                fout.println("All pole real parts are less than or equal to zero - stable system");
            } else {
                fout.println("At least one pole real part is greater than zero - unstable system");
            }
        }
        if (this.sORz == 2) {
            for (i = 0; i < this.dDeg; ++i) {
                if (!(Fmath.truncate(this.denomRoots[i].abs(), 6) > 1.0)) continue;
                testroots = false;
            }
            if (testroots) {
                fout.println("All pole distances from the z-plane zero are less than or equal to one - stable system");
            } else {
                fout.println("At least one pole distance from the z-plane zero is greater than one - unstable system");
            }
        }
        fout.println();
        fout.println("End of file");
        fout.close();
        return zerosAndPoles;
    }

    public Complex[][] pzPlot() {
        String title = "no file title provided";
        return this.pzPlot(title);
    }
}

