/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.complex.Complex;
import flanagan.io.FileInput;
import flanagan.io.FileOutput;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JFrame;

public class FourierTransform
extends Canvas
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Complex[] complexData = null;
    private Complex[] complexCorr = null;
    private boolean complexDataSet = false;
    private int originalDataLength = 0;
    private int fftDataLength = 0;
    private boolean dataAltered = false;
    private double[] fftData = null;
    private double[] fftCorr = null;
    private double[] fftResp = null;
    private boolean fftDataSet = false;
    private double[] fftDataWindow = null;
    private double[] fftCorrWindow = null;
    private int windowOption = 0;
    private String[] windowNames = new String[]{"no windowing applied", "Rectangular (square, box-car)", "Bartlett (triangular)", "Welch", "Hann (Hanning)", "Hamming", "Kaiser", "Gaussian"};
    private String windowName = this.windowNames[0];
    private double kaiserAlpha = 2.0;
    private double gaussianAlpha = 2.5;
    private double[] weights = null;
    private boolean windowSet = false;
    private boolean windowApplied = false;
    private double sumOfSquaredWeights = 0.0;
    private Complex[] transformedDataComplex = null;
    private double[] transformedDataFft = null;
    private boolean fftDone = false;
    private double[][] powerSpectrumEstimate = null;
    private boolean powSpecDone = false;
    private int psdNumberOfPoints = 0;
    private int segmentNumber = 1;
    private int segmentLength = 0;
    private boolean overlap = false;
    private boolean segNumSet = false;
    private boolean segLenSet = false;
    private double deltaT = 1.0;
    private boolean deltaTset = false;
    private double[][] correlationArray = null;
    private boolean correlateDone = false;
    private int numberOfWarnings = 9;
    private boolean[] warning = new boolean[this.numberOfWarnings];
    private int plotLineOption = 0;
    private int plotPointOption = 0;
    private double[][] timeFrequency = null;
    private boolean shortTimeDone = false;
    private int numShortFreq = 0;
    private int numShortTimes = 0;
    private String shortTitle = " ";

    public FourierTransform() {
        for (int i = 0; i < this.numberOfWarnings; ++i) {
            this.warning[i] = false;
        }
    }

    public FourierTransform(double[] realData) {
        int i;
        int i2;
        this.originalDataLength = realData.length;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.complexData = Complex.oneDarray(this.fftDataLength);
        for (i2 = 0; i2 < this.originalDataLength; ++i2) {
            this.complexData[i2].setReal(realData[i2]);
            this.complexData[i2].setImag(0.0);
        }
        for (i2 = this.originalDataLength; i2 < this.fftDataLength; ++i2) {
            this.complexData[i2].reset(0.0, 0.0);
        }
        this.complexDataSet = true;
        this.fftData = new double[2 * this.fftDataLength];
        int j = 0;
        for (i = 0; i < this.fftDataLength; ++i) {
            this.fftData[j] = this.complexData[i].getReal();
            this.fftData[++j] = 0.0;
            ++j;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        this.segmentLength = this.fftDataLength;
        for (i = 0; i < this.numberOfWarnings; ++i) {
            this.warning[i] = false;
        }
    }

    public FourierTransform(Complex[] data) {
        int i;
        int i2;
        this.originalDataLength = data.length;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.complexData = Complex.oneDarray(this.fftDataLength);
        for (i2 = 0; i2 < this.originalDataLength; ++i2) {
            this.complexData[i2] = data[i2].copy();
        }
        for (i2 = this.originalDataLength; i2 < this.fftDataLength; ++i2) {
            this.complexData[i2].reset(0.0, 0.0);
        }
        this.complexDataSet = true;
        this.fftData = new double[2 * this.fftDataLength];
        int j = 0;
        for (i = 0; i < this.fftDataLength; ++i) {
            this.fftData[j] = this.complexData[i].getReal();
            this.fftData[++j] = this.complexData[i].getImag();
            ++j;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        this.segmentLength = this.fftDataLength;
        for (i = 0; i < this.numberOfWarnings; ++i) {
            this.warning[i] = false;
        }
    }

    public void setData(double[] realData) {
        int i;
        this.originalDataLength = realData.length;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.complexData = Complex.oneDarray(this.fftDataLength);
        for (i = 0; i < this.originalDataLength; ++i) {
            this.complexData[i].setReal(realData[i]);
            this.complexData[i].setImag(0.0);
        }
        for (i = this.originalDataLength; i < this.fftDataLength; ++i) {
            this.complexData[i].reset(0.0, 0.0);
        }
        this.complexDataSet = true;
        this.fftData = new double[2 * this.fftDataLength];
        int j = 0;
        for (int i2 = 0; i2 < this.fftDataLength; ++i2) {
            this.fftData[j] = this.complexData[i2].getReal();
            this.fftData[++j] = 0.0;
            ++j;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        if (this.segNumSet) {
            this.setSegmentNumber(this.segmentNumber);
        } else if (this.segLenSet) {
            this.setSegmentLength(this.segmentLength);
        } else {
            this.segmentLength = this.fftDataLength;
        }
    }

    public void setData(Complex[] data) {
        int i;
        this.originalDataLength = data.length;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.complexData = Complex.oneDarray(this.fftDataLength);
        for (i = 0; i < this.originalDataLength; ++i) {
            this.complexData[i] = data[i].copy();
        }
        for (i = this.originalDataLength; i < this.fftDataLength; ++i) {
            this.complexData[i].reset(0.0, 0.0);
        }
        this.complexDataSet = true;
        this.fftData = new double[2 * this.fftDataLength];
        int j = 0;
        for (int i2 = 0; i2 < this.fftDataLength; ++i2) {
            this.fftData[j] = this.complexData[i2].getReal();
            this.fftData[++j] = this.complexData[i2].getImag();
            ++j;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        if (this.segNumSet) {
            this.setSegmentNumber(this.segmentNumber);
        } else if (this.segLenSet) {
            this.setSegmentLength(this.segmentLength);
        } else {
            this.segmentLength = this.fftDataLength;
        }
    }

    public void setFftData(double[] fftdata) {
        int i;
        if (fftdata.length % 2 != 0) {
            throw new IllegalArgumentException("data length must be an even number");
        }
        this.originalDataLength = fftdata.length / 2;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.fftData = new double[2 * this.fftDataLength];
        for (i = 0; i < 2 * this.originalDataLength; ++i) {
            this.fftData[i] = fftdata[i];
        }
        for (i = 2 * this.originalDataLength; i < 2 * this.fftDataLength; ++i) {
            this.fftData[i] = 0.0;
        }
        this.fftDataSet = true;
        this.complexData = Complex.oneDarray(this.fftDataLength);
        int j = -1;
        for (int i2 = 0; i2 < this.fftDataLength; ++i2) {
            this.complexData[i2].setReal(this.fftData[++j]);
            this.complexData[i2].setImag(this.fftData[++j]);
        }
        this.complexDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        if (this.segNumSet) {
            this.setSegmentNumber(this.segmentNumber);
        } else if (this.segLenSet) {
            this.setSegmentLength(this.segmentLength);
        } else {
            this.segmentLength = this.fftDataLength;
        }
    }

    public Complex[] getComplexInputData() {
        if (!this.complexDataSet) {
            System.out.println("complex data set not entered or calculated - null returned");
        }
        return this.complexData;
    }

    public double[] getAlternateInputData() {
        if (!this.fftDataSet) {
            System.out.println("fft data set not entered or calculted - null returned");
        }
        return this.fftData;
    }

    public double[] getAlternateWindowedInputData() {
        if (!this.fftDataSet) {
            System.out.println("fft data set not entered or calculted - null returned");
        }
        if (!this.fftDataSet) {
            System.out.println("fft data set not entered or calculted - null returned");
        }
        if (!this.windowApplied) {
            System.out.println("fft data set has not been multiplied by windowing weights");
        }
        return this.fftDataWindow;
    }

    public int getOriginalDataLength() {
        return this.originalDataLength;
    }

    public int getUsedDataLength() {
        return this.fftDataLength;
    }

    public void setDeltaT(double deltaT) {
        this.deltaT = deltaT;
        this.deltaTset = true;
    }

    public double getDeltaT() {
        double ret = 0.0;
        if (this.deltaTset) {
            ret = this.deltaT;
        } else {
            System.out.println("detaT has not been set - zero returned");
        }
        return ret;
    }

    public void setRectangular() {
        this.windowOption = 1;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setBartlett() {
        this.windowOption = 2;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setWelch() {
        this.windowOption = 3;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setHann() {
        this.windowOption = 4;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setHamming() {
        this.windowOption = 5;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setKaiser(double alpha) {
        this.kaiserAlpha = alpha;
        this.windowOption = 6;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setKaiser() {
        this.windowOption = 6;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setGaussian(double alpha) {
        if (alpha < 2.0) {
            alpha = 2.0;
            System.out.println("setGaussian; alpha must be greater than or equal to 2 - alpha has been reset to 2");
        }
        this.gaussianAlpha = alpha;
        this.windowOption = 7;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setGaussian() {
        this.windowOption = 7;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void removeWindow() {
        this.windowOption = 0;
        this.windowSet = false;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = false;
        }
    }

    private double windowData(double[] data, double[] window, double[] weight) {
        int m = data.length;
        int n = m / 2 - 1;
        int j = 0;
        double sum = 0.0;
        switch (this.windowOption) {
            case 0: 
            case 1: {
                for (int i = 0; i <= n; ++i) {
                    weight[i] = 1.0;
                    window[j] = data[j++];
                    window[j] = data[j++];
                }
                sum = n + 1;
                break;
            }
            case 2: {
                for (int i = 0; i <= n; ++i) {
                    weight[i] = 1.0 - (double)Math.abs((i - n / 2) / n / 2);
                    sum += weight[i] * weight[i];
                    window[j] = data[j++] * weight[i];
                    window[j] = data[j++] * weight[i];
                }
                break;
            }
            case 3: {
                for (int i = 0; i <= n; ++i) {
                    weight[i] = 1.0 - (double)Fmath.square((i - n / 2) / n / 2);
                    sum += weight[i] * weight[i];
                    window[j] = data[j++] * weight[i];
                    window[j] = data[j++] * weight[i];
                }
                break;
            }
            case 4: {
                for (int i = 0; i <= n; ++i) {
                    weight[i] = (1.0 - Math.cos(2.0 * (double)i * Math.PI / (double)n)) / 2.0;
                    sum += weight[i] * weight[i];
                    window[j] = data[j++] * weight[i];
                    window[j] = data[j++] * weight[i];
                }
                break;
            }
            case 5: {
                for (int i = 0; i <= n; ++i) {
                    weight[i] = 0.54 + 0.46 * Math.cos(2.0 * (double)i * Math.PI / (double)n);
                    sum += weight[i] * weight[i];
                    window[j] = data[j++] * weight[i];
                    window[j] = data[j++] * weight[i];
                }
                break;
            }
            case 6: {
                double denom = FourierTransform.modBesselIo(Math.PI * this.kaiserAlpha);
                double numer = 0.0;
                for (int i = 0; i <= n; ++i) {
                    numer = FourierTransform.modBesselIo(Math.PI * this.kaiserAlpha * Math.sqrt(1.0 - Fmath.square(2.0 * (double)i / (double)n - 1.0)));
                    weight[i] = numer / denom;
                    sum += weight[i] * weight[i];
                    window[j] = data[j++] * weight[i];
                    window[j] = data[j++] * weight[i];
                }
                break;
            }
            case 7: {
                for (int i = 0; i <= n; ++i) {
                    weight[i] = Math.exp(-0.5 * Fmath.square(this.gaussianAlpha * (double)(2 * i - n) / (double)n));
                    sum += weight[i] * weight[i];
                    window[j] = data[j++] * weight[i];
                    window[j] = data[j++] * weight[i];
                }
                break;
            }
        }
        return sum;
    }

    public static double modBesselIo(double arg) {
        double d;
        double absArg = 0.0;
        double poly = 0.0;
        double bessel = 0.0;
        absArg = Math.abs(arg);
        if (d < 3.75) {
            poly = arg / 3.75;
            poly *= poly;
            bessel = 1.0 + poly * (3.5156229 + poly * (3.08989424 + poly * (1.2067492 + poly * (0.2659732 + poly * (0.0360768 + poly * 0.0045813)))));
        } else {
            bessel = Math.exp(absArg) / Math.sqrt(absArg) * (0.39894228 + poly * (0.01328592 + poly * (0.00225319 + poly * (-0.00157565 + poly * (0.00916281 + poly * (-0.02057706 + poly * (0.02635537 + poly * (-0.01647633 + poly * 0.00392377))))))));
        }
        return bessel;
    }

    public String getWindowOption() {
        String option = " ";
        switch (this.windowOption) {
            case 0: {
                option = "No windowing applied";
                break;
            }
            case 1: {
                option = "Rectangular";
                break;
            }
            case 2: {
                option = "Bartlett";
                break;
            }
            case 3: {
                option = "Welch";
                break;
            }
            case 4: {
                option = "Hann";
                break;
            }
            case 5: {
                option = "Hamming";
                break;
            }
            case 6: {
                option = "Kaiser";
                break;
            }
            case 7: {
                option = "Gaussian";
            }
        }
        return option;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setSegmentNumber(int sNum) {
        this.segmentNumber = sNum;
        this.segNumSet = true;
        if (this.segLenSet) {
            this.segLenSet = false;
        }
    }

    public void setSegmentLength(int sLen) {
        this.segmentLength = sLen;
        this.segLenSet = true;
        if (this.segNumSet) {
            this.segNumSet = false;
        }
    }

    private void checkSegmentDetails() {
        int segL;
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No fft data has been entered or calculated");
        }
        if (this.fftDataLength < 2) {
            throw new IllegalArgumentException("More than one point, MANY MORE, are needed");
        }
        if (this.fftDataLength % 2 != 0) {
            System.out.println("Number of data points must be an even number");
            System.out.println("last point deleted");
            --this.fftDataLength;
            this.dataAltered = true;
            this.warning[0] = true;
        }
        if (this.segNumSet && !this.overlap) {
            if (this.fftDataLength % this.segmentNumber == 0) {
                segL = this.fftDataLength / this.segmentNumber;
                if (FourierTransform.checkPowerOfTwo(segL)) {
                    this.segmentLength = segL;
                    this.segLenSet = true;
                } else {
                    System.out.println("segment length is not an integer power of two");
                    System.out.println("segment length reset to total data length, i.e. no segmentation");
                    this.warning[1] = true;
                    this.segmentNumber = 1;
                    this.segmentLength = this.fftDataLength;
                    this.segLenSet = true;
                }
            } else {
                System.out.println("total data length divided by the number of segments is not an integer");
                System.out.println("segment length reset to total data length, i.e. no segmentation");
                this.warning[2] = true;
                this.segmentNumber = 1;
                this.segmentLength = this.fftDataLength;
                this.segLenSet = true;
            }
        }
        if (this.segLenSet && !this.overlap) {
            if (this.fftDataLength % this.segmentLength == 0) {
                if (FourierTransform.checkPowerOfTwo(this.segmentLength)) {
                    this.segmentNumber = this.fftDataLength / this.segmentLength;
                    this.segNumSet = true;
                } else {
                    System.out.println("segment length is not an integer power of two");
                    System.out.println("segment length reset to total data length, i.e. no segmentation");
                    this.warning[1] = true;
                    this.segmentNumber = 1;
                    this.segmentLength = this.fftDataLength;
                    this.segNumSet = true;
                }
            } else {
                System.out.println("total data length divided by the segment length is not an integer");
                System.out.println("segment length reset to total data length, i.e. no segmentation");
                this.warning[3] = true;
                this.segmentNumber = 1;
                this.segmentLength = this.fftDataLength;
                this.segNumSet = true;
            }
        }
        if (this.segNumSet && this.overlap) {
            if (this.fftDataLength % (this.segmentNumber + 1) == 0) {
                segL = 2 * this.fftDataLength / (this.segmentNumber + 1);
                if (FourierTransform.checkPowerOfTwo(segL)) {
                    this.segmentLength = segL;
                    this.segLenSet = true;
                } else {
                    System.out.println("segment length is not an integer power of two");
                    System.out.println("segment length reset to total data length, i.e. no segmentation");
                    this.warning[1] = true;
                    this.segmentNumber = 1;
                    this.segmentLength = this.fftDataLength;
                    this.segLenSet = true;
                    this.overlap = false;
                }
            } else {
                System.out.println("total data length divided by the number of segments plus one is not an integer");
                System.out.println("segment length reset to total data length, i.e. no segmentation");
                this.warning[4] = true;
                this.segmentNumber = 1;
                this.segmentLength = this.fftDataLength;
                this.segLenSet = true;
                this.overlap = false;
            }
        }
        if (this.segLenSet && this.overlap) {
            if (2 * this.fftDataLength % this.segmentLength == 0) {
                if (FourierTransform.checkPowerOfTwo(this.segmentLength)) {
                    this.segmentNumber = 2 * this.fftDataLength / this.segmentLength - 1;
                    this.segNumSet = true;
                } else {
                    System.out.println("segment length is not an integer power of two");
                    System.out.println("segment length reset to total data length, i.e. no segmentation");
                    this.warning[1] = true;
                    this.segmentNumber = 1;
                    this.segmentLength = this.fftDataLength;
                    this.segNumSet = true;
                    this.overlap = false;
                }
            } else {
                System.out.println("twice the total data length divided by the segment length is not an integer");
                System.out.println("segment length reset to total data length, i.e. no segmentation");
                this.warning[5] = true;
                this.segmentNumber = 1;
                this.segmentLength = this.fftDataLength;
                this.segNumSet = true;
                this.overlap = false;
            }
        }
        if (!this.segNumSet && !this.segLenSet) {
            this.segmentNumber = 1;
            this.segNumSet = true;
            this.overlap = false;
        }
        if (this.overlap && this.segmentNumber < 2) {
            System.out.println("Overlap is not possible with less than two segments.");
            System.out.println("Overlap option has been reset to 'no overlap' i.e. to false.");
            this.overlap = false;
            this.segmentNumber = 1;
            this.segNumSet = true;
            this.warning[6] = true;
        }
        int segLno = 0;
        int segNno = 0;
        int segLov = 0;
        int segNov = 0;
        if (this.segmentNumber == 1 && !FourierTransform.checkPowerOfTwo(this.fftDataLength)) {
            boolean test0 = true;
            boolean test1 = true;
            boolean test2 = true;
            int newL = 0;
            int ii = 2;
            while (test0) {
                newL = this.fftDataLength / ii;
                if (FourierTransform.checkPowerOfTwo(newL) && this.fftDataLength % ii == 0) {
                    test0 = false;
                    segLno = newL;
                    segNno = ii;
                    continue;
                }
                if (newL < 2) {
                    test1 = false;
                    test0 = false;
                    continue;
                }
                ++ii;
            }
            test0 = true;
            ii = 2;
            while (test0) {
                newL = 2 * (this.fftDataLength / (ii + 1));
                if (FourierTransform.checkPowerOfTwo(newL) && this.fftDataLength % (ii + 1) == 0) {
                    test0 = false;
                    segLov = newL;
                    segNov = ii;
                    continue;
                }
                if (newL < 2) {
                    test2 = false;
                    test0 = false;
                    continue;
                }
                ++ii;
            }
            boolean setSegment = true;
            int segL2 = 0;
            int segN = 0;
            boolean ovrlp = false;
            if (test1) {
                if (test2) {
                    if (segLov > segLno) {
                        segL2 = segLov;
                        segN = segNov;
                        ovrlp = true;
                    } else {
                        segL2 = segLno;
                        segN = segNno;
                        ovrlp = false;
                    }
                } else {
                    segL2 = segLno;
                    segN = segNno;
                    ovrlp = false;
                }
            } else if (test2) {
                segL2 = segLov;
                segN = segNov;
                ovrlp = true;
            } else {
                setSegment = false;
            }
            if (setSegment && this.originalDataLength - segL2 <= this.fftDataLength - this.originalDataLength) {
                System.out.println("Data length is not an integer power of two");
                System.out.println("Data cannot be transformed as a single segment");
                System.out.print("The data has been split into " + segN + " segments of length " + segL2);
                if (ovrlp) {
                    System.out.println(" with 50% overlap");
                } else {
                    System.out.println(" with no overlap");
                }
                this.segmentLength = segL2;
                this.segmentNumber = segN;
                this.overlap = ovrlp;
                this.warning[7] = true;
            } else {
                System.out.println("Data length is not an integer power of two");
                if (this.dataAltered) {
                    System.out.println("Deleted point has been restored and the data has been padded with zeros to give a power of two length");
                    this.warning[0] = false;
                } else {
                    System.out.println("Data has been padded with zeros to give a power of two length");
                }
                this.fftDataLength = this.fftDataLength;
                this.warning[8] = true;
            }
        }
    }

    private void printWarnings(FileOutput fout) {
        if (this.warning[0]) {
            fout.println("WARNING!");
            fout.println("Number of data points must be an even number");
            fout.println("The last point was deleted");
            fout.println();
        }
        if (this.warning[1]) {
            fout.println("WARNING!");
            fout.println("Segment length was not an integer power of two");
            fout.println("Segment length was reset to total data length, i.e. no segmentation");
            fout.println();
        }
        if (this.warning[2]) {
            fout.println("WARNING!");
            fout.println("Total data length divided by the number of segments was not an integer");
            fout.println("Segment length was reset to total data length, i.e. no segmentation");
            fout.println();
        }
        if (this.warning[3]) {
            fout.println("WARNING!");
            fout.println("Total data length divided by the segment length was not an integer");
            fout.println("Segment length was reset to total data length, i.e. no segmentation");
            fout.println();
        }
        if (this.warning[4]) {
            fout.println("WARNING!");
            fout.println("Total data length divided by the number of segments plus one was not an integer");
            fout.println("Segment length was reset to total data length, i.e. no segmentation");
            fout.println();
        }
        if (this.warning[5]) {
            fout.println("WARNING!");
            fout.println("Twice the total data length divided by the segment length was not an integer");
            fout.println("Segment length was reset to total data length, i.e. no segmentation");
            fout.println();
        }
        if (this.warning[6]) {
            fout.println("WARNING!");
            fout.println("Overlap is not possible with less than two segments");
            fout.println("Overlap option has been reset to 'no overlap' i.e. to false");
            fout.println();
        }
        if (this.warning[7]) {
            fout.println("WARNING!");
            fout.println("Data length was not an integer power of two");
            fout.println("The data could not be transformed as a single segment");
            fout.print("The data has been split into " + this.segmentNumber + " segment/s of length " + this.segmentLength);
            if (this.overlap) {
                fout.println(" with 50% overlap");
            } else {
                fout.println(" with no overlap");
            }
            fout.println();
        }
        if (this.warning[8]) {
            fout.println("WARNING!");
            fout.println("Data length was not an integer power of two");
            fout.println("Data has been padded with " + (this.fftDataLength - this.originalDataLength) + " zeros to give an integer power of two length");
            fout.println();
        }
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public int getSegmentLength() {
        return this.segmentLength;
    }

    public void setOverlapOption(boolean overlapOpt) {
        boolean old = this.overlap;
        this.overlap = overlapOpt;
        if (old != this.overlap && this.fftDataSet) {
            this.setSegmentNumber(this.segmentNumber);
        }
    }

    public boolean getOverlapOption() {
        return this.overlap;
    }

    public static int calcDataLength(boolean overlap, int segLen, int segNum) {
        if (overlap) {
            return (segNum + 1) * segLen / 2;
        }
        return segNum * segLen;
    }

    public void transform() {
        int i;
        int isign = 1;
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No data has been entered for the Fast Fourier Transform");
        }
        if (this.originalDataLength != this.fftDataLength) {
            System.out.println("Fast Fourier Transform data length ," + this.originalDataLength + ", is not an integer power of two");
            System.out.println("WARNING!!! Data has been padded with zeros to fill to nearest integer power of two length " + this.fftDataLength);
        }
        double[] hold = new double[this.fftDataLength * 2];
        for (i = 0; i < this.fftDataLength * 2; ++i) {
            hold[i] = this.fftDataWindow[i];
        }
        this.basicFft(hold, this.fftDataLength, isign);
        for (i = 0; i < this.fftDataLength * 2; ++i) {
            this.transformedDataFft[i] = hold[i];
        }
        for (i = 0; i < this.fftDataLength; ++i) {
            this.transformedDataComplex[i].reset(this.transformedDataFft[2 * i], this.transformedDataFft[2 * i + 1]);
        }
    }

    public void inverse() {
        int i;
        int isign = -1;
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No data has been entered for the inverse Fast Fourier Transform");
        }
        if (this.originalDataLength != this.fftDataLength) {
            System.out.println("Fast Fourier Transform data length ," + this.originalDataLength + ", is not an integer power of two");
            System.out.println("WARNING!!! Data has been padded with zeros to fill to nearest integer power of two length " + this.fftDataLength);
        }
        double[] hold = new double[this.fftDataLength * 2];
        for (i = 0; i < this.fftDataLength * 2; ++i) {
            hold[i] = this.fftDataWindow[i];
        }
        this.basicFft(hold, this.fftDataLength, isign);
        for (i = 0; i < this.fftDataLength * 2; ++i) {
            this.transformedDataFft[i] = hold[i] / (double)this.fftDataLength;
        }
        for (i = 0; i < this.fftDataLength; ++i) {
            this.transformedDataComplex[i].reset(this.transformedDataFft[2 * i], this.transformedDataFft[2 * i + 1]);
        }
    }

    public void basicFft(double[] data, int nn, int isign) {
        int ii;
        int i;
        double dtemp = 0.0;
        double wtemp = 0.0;
        double tempr = 0.0;
        double tempi = 0.0;
        double theta = 0.0;
        double wr = 0.0;
        double wpr = 0.0;
        double wpi = 0.0;
        double wi = 0.0;
        int istep = 0;
        int m = 0;
        int mmax = 0;
        int n = nn << 1;
        int j = 1;
        int jj = 0;
        for (i = 1; i < n; i += 2) {
            jj = j - 1;
            if (j > i) {
                ii = i - 1;
                dtemp = data[jj];
                data[jj] = data[ii];
                data[ii] = dtemp;
                dtemp = data[jj + 1];
                data[jj + 1] = data[ii + 1];
                data[ii + 1] = dtemp;
            }
            for (m = n >> 1; m >= 2 && j > m; j -= m, m >>= 1) {
            }
            j += m;
        }
        mmax = 2;
        while (n > mmax) {
            istep = mmax << 1;
            theta = (double)isign * (6.28318530717959 / (double)mmax);
            wtemp = Math.sin(0.5 * theta);
            wpr = -2.0 * wtemp * wtemp;
            wpi = Math.sin(theta);
            wr = 1.0;
            wi = 0.0;
            m = 1;
            while (m < mmax) {
                for (i = m; i <= n; i += istep) {
                    ii = i - 1;
                    jj = ii + mmax;
                    tempr = wr * data[jj] - wi * data[jj + 1];
                    tempi = wr * data[jj + 1] + wi * data[jj];
                    data[jj] = data[ii] - tempr;
                    data[jj + 1] = data[ii + 1] - tempi;
                    int n2 = ii;
                    data[n2] = data[n2] + tempr;
                    int n3 = ii + 1;
                    data[n3] = data[n3] + tempi;
                }
                wtemp = wr;
                wr = wtemp * wpr - wi * wpi + wr;
                wi = wi * wpr + wtemp * wpi + wi;
                m = (int)((long)m + 2L);
            }
            mmax = istep;
        }
    }

    public Complex[] getTransformedDataAsComplex() {
        return this.transformedDataComplex;
    }

    public double[] getTransformedDataAsAlternate() {
        return this.transformedDataFft;
    }

    public double[][] powerSpectrum() {
        this.checkSegmentDetails();
        this.psdNumberOfPoints = this.segmentLength / 2;
        this.powerSpectrumEstimate = new double[2][this.psdNumberOfPoints];
        if (!this.overlap && this.segmentNumber < 2) {
            int i;
            int isign = 1;
            if (!this.fftDataSet) {
                throw new IllegalArgumentException("No data has been entered for the Fast Fourier Transform");
            }
            if (!FourierTransform.checkPowerOfTwo(this.fftDataLength)) {
                throw new IllegalArgumentException("Fast Fourier Transform data length ," + this.fftDataLength + ", is not an integer power of two");
            }
            double[] hold = new double[this.fftDataLength * 2];
            for (i = 0; i < this.fftDataLength * 2; ++i) {
                hold[i] = this.fftDataWindow[i];
            }
            this.basicFft(hold, this.fftDataLength, isign);
            for (i = 0; i < this.fftDataLength * 2; ++i) {
                this.transformedDataFft[i] = hold[i];
            }
            for (i = 0; i < this.fftDataLength; ++i) {
                this.transformedDataComplex[i].reset(this.transformedDataFft[2 * i], this.transformedDataFft[2 * i + 1]);
            }
            this.powerSpectrumEstimate[1][0] = Fmath.square(hold[0]) + Fmath.square(hold[1]);
            for (i = 1; i < this.psdNumberOfPoints; ++i) {
                this.powerSpectrumEstimate[1][i] = Fmath.square(hold[2 * i]) + Fmath.square(hold[2 * i + 1]) + Fmath.square(hold[2 * this.segmentLength - 2 * i]) + Fmath.square(hold[2 * this.segmentLength - 2 * i + 1]);
            }
            for (i = 0; i < this.psdNumberOfPoints; ++i) {
                this.powerSpectrumEstimate[1][i] = 2.0 * this.powerSpectrumEstimate[1][i] / ((double)this.fftDataLength * this.sumOfSquaredWeights);
            }
            for (i = 0; i < this.psdNumberOfPoints; ++i) {
                this.powerSpectrumEstimate[0][i] = (double)i / ((double)this.segmentLength * this.deltaT);
            }
        } else {
            this.powerSpectrumEstimate = this.powerSpectrumSeg();
        }
        this.powSpecDone = true;
        return this.powerSpectrumEstimate;
    }

    public double[][] powerSpectrum(String fileName) {
        if (!FourierTransform.checkPowerOfTwo(this.segmentLength)) {
            throw new IllegalArgumentException("Fast Fourier Transform segment length ," + this.segmentLength + ", is not an integer power of two");
        }
        FileInput fin = new FileInput(fileName);
        this.psdNumberOfPoints = this.segmentLength / 2;
        this.powerSpectrumEstimate = new double[2][this.psdNumberOfPoints];
        this.fftDataLength = FourierTransform.calcDataLength(this.overlap, this.segmentLength, this.segmentNumber);
        if (!this.overlap && this.segmentNumber < 2) {
            int i;
            int i2;
            this.fftData = new double[2 * this.fftDataLength];
            int j = -1;
            for (i2 = 0; i2 < this.segmentLength; ++i2) {
                this.fftData[++j] = fin.readDouble();
                this.fftData[++j] = fin.readDouble();
            }
            this.complexData = Complex.oneDarray(this.fftDataLength);
            j = -1;
            for (i2 = 0; i2 < this.fftDataLength; ++i2) {
                this.complexData[i2].setReal(this.fftData[++j]);
                this.complexData[i2].setImag(this.fftData[++j]);
            }
            this.fftDataWindow = new double[2 * this.fftDataLength];
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            int isign = 1;
            double[] hold = new double[this.fftDataLength * 2];
            for (i = 0; i < this.fftDataLength * 2; ++i) {
                hold[i] = this.fftDataWindow[i];
            }
            this.basicFft(hold, this.fftDataLength, isign);
            for (i = 0; i < this.fftDataLength * 2; ++i) {
                this.transformedDataFft[i] = hold[i];
            }
            for (i = 0; i < this.fftDataLength; ++i) {
                this.transformedDataComplex[i].reset(this.transformedDataFft[2 * i], this.transformedDataFft[2 * i + 1]);
            }
            this.powerSpectrumEstimate[1][0] = Fmath.square(hold[0]) + Fmath.square(hold[1]);
            for (i = 1; i < this.psdNumberOfPoints; ++i) {
                this.powerSpectrumEstimate[1][i] = Fmath.square(hold[2 * i]) + Fmath.square(hold[2 * i + 1]) + Fmath.square(hold[2 * this.segmentLength - 2 * i]) + Fmath.square(hold[2 * this.segmentLength - 2 * i + 1]);
            }
            for (i = 0; i < this.psdNumberOfPoints; ++i) {
                this.powerSpectrumEstimate[1][i] = 2.0 * this.powerSpectrumEstimate[1][i] / ((double)this.fftDataLength * this.sumOfSquaredWeights);
            }
            for (i = 0; i < this.psdNumberOfPoints; ++i) {
                this.powerSpectrumEstimate[0][i] = (double)i / ((double)this.segmentLength * this.deltaT);
            }
        } else {
            this.powerSpectrumEstimate = this.powerSpectrumSeg(fin);
        }
        this.powSpecDone = true;
        return this.powerSpectrumEstimate;
    }

    private double[][] powerSpectrumSeg() {
        int i;
        int segmentStartIndex = 0;
        int segmentStartIncrement = this.segmentLength;
        if (this.overlap) {
            segmentStartIncrement /= 2;
        }
        double[] data = new double[2 * this.segmentLength];
        this.psdNumberOfPoints = this.segmentLength / 2;
        double[] segPSD = new double[this.psdNumberOfPoints];
        double[][] avePSD = new double[2][this.psdNumberOfPoints];
        for (int j = 0; j < this.psdNumberOfPoints; ++j) {
            avePSD[1][j] = 0.0;
        }
        int isign = 1;
        for (i = 1; i <= this.segmentNumber; ++i) {
            int j;
            for (j = 0; j < 2 * this.segmentLength; ++j) {
                data[j] = this.fftData[segmentStartIndex + j];
            }
            if (i == 1) {
                this.sumOfSquaredWeights = this.windowData(data, data, this.weights);
            } else {
                int k = 0;
                for (int j2 = 0; j2 < this.segmentLength; ++j2) {
                    data[k] = data[k] * this.weights[j2];
                    data[++k] = data[k] * this.weights[j2];
                    ++k;
                }
            }
            this.basicFft(data, this.segmentLength, isign);
            segPSD[0] = Fmath.square(data[0]) + Fmath.square(data[1]);
            for (j = 1; j < this.psdNumberOfPoints; ++j) {
                segPSD[j] = Fmath.square(data[2 * j]) + Fmath.square(data[2 * j + 1]) + Fmath.square(data[2 * this.segmentLength - 2 * j]) + Fmath.square(data[2 * this.segmentLength - 2 * j + 1]);
            }
            for (j = 0; j < this.psdNumberOfPoints; ++j) {
                segPSD[j] = 2.0 * segPSD[j] / ((double)this.segmentLength * this.sumOfSquaredWeights);
            }
            for (j = 0; j < this.psdNumberOfPoints; ++j) {
                double[] dArray = avePSD[1];
                int n = j;
                dArray[n] = dArray[n] + segPSD[j];
            }
            segmentStartIndex += segmentStartIncrement;
        }
        int j = 0;
        while (j < this.psdNumberOfPoints) {
            double[] dArray = avePSD[1];
            int n = j++;
            dArray[n] = dArray[n] / (double)this.segmentNumber;
        }
        for (i = 0; i < this.psdNumberOfPoints; ++i) {
            avePSD[0][i] = (double)i / ((double)this.segmentLength * this.deltaT);
        }
        return avePSD;
    }

    private double[][] powerSpectrumSeg(FileInput fin) {
        int j;
        int k;
        int j2;
        int i;
        int j3;
        double[] data = new double[2 * this.segmentLength];
        this.weights = new double[this.segmentLength];
        double[] hold = new double[2 * this.segmentLength];
        this.psdNumberOfPoints = this.segmentLength / 2;
        double[] segPSD = new double[this.psdNumberOfPoints];
        double[][] avePSD = new double[2][this.psdNumberOfPoints];
        for (int j4 = 0; j4 < this.psdNumberOfPoints; ++j4) {
            avePSD[1][j4] = 0.0;
        }
        int isign = 1;
        this.sumOfSquaredWeights = this.windowData(hold, hold, this.weights);
        if (this.overlap) {
            for (j3 = 0; j3 < this.segmentLength; ++j3) {
                data[j3] = fin.readDouble();
            }
            for (i = 1; i <= this.segmentNumber; ++i) {
                for (j2 = 0; j2 < this.segmentLength; ++j2) {
                    data[j2 + this.segmentLength] = fin.readDouble();
                }
                k = -1;
                for (j = 0; j < this.segmentLength; ++j) {
                    data[++k] = data[k] * this.weights[j];
                    data[++k] = data[k] * this.weights[j];
                }
                this.basicFft(data, this.segmentLength, isign);
                segPSD[0] = Fmath.square(data[0]) + Fmath.square(data[1]);
                for (j = 1; j < this.psdNumberOfPoints; ++j) {
                    segPSD[j] = Fmath.square(data[2 * j]) + Fmath.square(data[2 * j + 1]) + Fmath.square(data[2 * this.segmentLength - 2 * j]) + Fmath.square(data[2 * this.segmentLength - 2 * j + 1]);
                }
                for (j = 0; j < this.psdNumberOfPoints; ++j) {
                    segPSD[j] = 2.0 * segPSD[j] / ((double)this.segmentLength * this.sumOfSquaredWeights);
                }
                for (j = 0; j < this.psdNumberOfPoints; ++j) {
                    double[] dArray = avePSD[1];
                    int n = j;
                    dArray[n] = dArray[n] + segPSD[j];
                }
                for (j = 0; j < this.segmentLength; ++j) {
                    data[j] = data[j + this.segmentLength];
                }
            }
        } else {
            for (i = 1; i <= this.segmentNumber; ++i) {
                for (j2 = 0; j2 < 2 * this.segmentLength; ++j2) {
                    data[j2] = fin.readDouble();
                }
                k = -1;
                for (j = 0; j < this.segmentLength; ++j) {
                    data[++k] = data[k] * this.weights[j];
                    data[++k] = data[k] * this.weights[j];
                }
                this.basicFft(data, this.segmentLength, isign);
                segPSD[0] = Fmath.square(data[0]) + Fmath.square(data[1]);
                for (j = 1; j < this.psdNumberOfPoints; ++j) {
                    segPSD[j] = Fmath.square(data[2 * j]) + Fmath.square(data[2 * j + 1]) + Fmath.square(data[2 * this.segmentLength - 2 * j]) + Fmath.square(data[2 * this.segmentLength - 2 * j + 1]);
                }
                for (j = 1; j < this.psdNumberOfPoints; ++j) {
                    segPSD[j] = 2.0 * segPSD[j] / ((double)this.segmentLength * this.sumOfSquaredWeights);
                }
                for (j = 0; j < this.psdNumberOfPoints; ++j) {
                    double[] dArray = avePSD[1];
                    int n = j;
                    dArray[n] = dArray[n] + segPSD[j];
                }
            }
        }
        j3 = 0;
        while (j3 < this.psdNumberOfPoints) {
            double[] dArray = avePSD[1];
            int n = j3++;
            dArray[n] = dArray[n] / (double)this.segmentNumber;
        }
        for (i = 0; i < this.psdNumberOfPoints; ++i) {
            avePSD[0][i] = (double)i / ((double)this.segmentLength * this.deltaT);
        }
        return avePSD;
    }

    public double[][] getpowerSpectrumEstimate() {
        if (!this.powSpecDone) {
            System.out.println("getpowerSpectrumEstimate - powerSpectrum has not been called - null returned");
        }
        return this.powerSpectrumEstimate;
    }

    public int getNumberOfPsdPoints() {
        return this.psdNumberOfPoints;
    }

    public void printPowerSpectrum() {
        String filename = "FourierTransformPSD.txt";
        this.printPowerSpectrum(filename);
    }

    public void printPowerSpectrum(String filename) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        FileOutput fout = new FileOutput(filename);
        fout.println("Power Spectrum Density Estimate Output File from FourierTransform");
        fout.dateAndTimeln(filename);
        String title = "Window: " + this.windowNames[this.windowOption];
        if (this.windowOption == 6) {
            title = title + ", alpha = " + this.kaiserAlpha;
        }
        if (this.windowOption == 7) {
            title = title + ", alpha = " + this.gaussianAlpha;
        }
        fout.println(title);
        fout.printtab("Number of segments = ");
        fout.println(this.segmentNumber);
        fout.printtab("Segment length = ");
        fout.println(this.segmentLength);
        if (this.segmentNumber > 1) {
            if (this.overlap) {
                fout.printtab("Segments overlap by 50%");
            } else {
                fout.printtab("Segments do not overlap");
            }
        }
        fout.println();
        this.printWarnings(fout);
        fout.printtab("Frequency");
        fout.println("Mean Square");
        fout.printtab("(cycles per");
        fout.println("Amplitude");
        if (this.deltaTset) {
            fout.printtab("unit time)");
        } else {
            fout.printtab("gridpoint)");
        }
        fout.println(" ");
        int n = this.powerSpectrumEstimate[0].length;
        for (int i = 0; i < n; ++i) {
            fout.printtab(Fmath.truncate(this.powerSpectrumEstimate[0][i], 4));
            fout.println(Fmath.truncate(this.powerSpectrumEstimate[1][i], 4));
        }
        fout.close();
    }

    public void plotPowerSpectrum(int lowPoint) {
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrum(lowPoint, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    public void plotPowerSpectrum(int lowPoint, String graphTitle) {
        this.plotPowerSpectrum(lowPoint, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    public void plotPowerSpectrum(int lowPoint, int highPoint) {
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrum(lowPoint, highPoint, graphTitle);
    }

    public void plotPowerSpectrum(int lowPoint, int highPoint, String graphTitle) {
        if (!this.powSpecDone) {
            System.out.println("plotPowerSpectrum - powerSpectrum has not been called - no plot displayed");
        } else {
            int n = this.powerSpectrumEstimate[0].length - 1;
            if (lowPoint < 0 || lowPoint >= n) {
                lowPoint = 0;
            }
            if (highPoint < 0 || highPoint > n) {
                highPoint = n;
            }
            this.plotPowerSpectrumLinear(lowPoint, highPoint, graphTitle);
        }
    }

    public void plotPowerSpectrum(double lowFreq) {
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrum(lowFreq, graphTitle);
    }

    public void plotPowerSpectrum(double lowFreq, String graphTitle) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        double highFreq = this.powerSpectrumEstimate[1][this.powerSpectrumEstimate[0].length - 1];
        this.plotPowerSpectrum(lowFreq, highFreq, graphTitle);
    }

    public void plotPowerSpectrum(double lowFreq, double highFreq) {
        if (!this.powSpecDone) {
            System.out.println("plotPowerSpectrum - powerSpectrum has not been called - no plot displayed");
        } else {
            String graphTitle = "Estimation of Power Spectrum Density";
            this.plotPowerSpectrum(lowFreq, highFreq, graphTitle);
        }
    }

    public void plotPowerSpectrum(double lowFreq, double highFreq, String graphTitle) {
        if (!this.powSpecDone) {
            System.out.println("plotPowerSpectrum - powerSpectrum has not been called - no plot displayed");
        } else {
            int low = 0;
            int high = 0;
            if (!this.deltaTset) {
                System.out.println("plotPowerSpectrum - deltaT has not been set");
                System.out.println("full spectrum plotted");
            } else {
                int ii = 0;
                int n = this.powerSpectrumEstimate[0].length - 1;
                boolean test = true;
                if (lowFreq == -1.0) {
                    low = 1;
                } else {
                    while (test) {
                        if (this.powerSpectrumEstimate[0][ii] > lowFreq) {
                            low = ii - 1;
                            if (low < 0) {
                                low = 0;
                            }
                            test = false;
                            continue;
                        }
                        if (++ii < n) continue;
                        low = 0;
                        System.out.println("plotPowerSpectrum - lowFreq out of range -  reset to zero");
                        test = false;
                    }
                }
                test = true;
                ii = 0;
                while (test) {
                    if (this.powerSpectrumEstimate[0][ii] > highFreq) {
                        high = ii - 1;
                        if (high < 0) {
                            System.out.println("plotPowerSpectrum - highFreq out of range -  reset to highest value");
                            high = n;
                        }
                        test = false;
                        continue;
                    }
                    if (++ii < n) continue;
                    high = n;
                    System.out.println("plotPowerSpectrum - highFreq out of range -  reset to highest value");
                    test = false;
                }
                this.plotPowerSpectrumLinear(low, high, graphTitle);
            }
        }
    }

    public void plotPowerSpectrum() {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrumLinear(0, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    public void plotPowerSpectrum(String graphTitle) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        this.plotPowerSpectrumLinear(0, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    private void plotPowerSpectrumLinear(int low, int high, String graphTitle) {
        int nData = this.powerSpectrumEstimate[0].length;
        int nNew = high - low + 1;
        double[][] spectrum = new double[2][nNew];
        for (int i = 0; i < nNew; ++i) {
            spectrum[0][i] = this.powerSpectrumEstimate[0][i + low];
            spectrum[1][i] = this.powerSpectrumEstimate[1][i + low];
        }
        String yLegend = "Mean Square Amplitude";
        this.plotPowerDisplay(spectrum, low, high, graphTitle, yLegend);
    }

    public void plotPowerLog(int lowPoint) {
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerLog(lowPoint, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    public void plotPowerLog(int lowPoint, String graphTitle) {
        this.plotPowerLog(lowPoint, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    public void plotPowerLog(int lowPoint, int highPoint) {
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerLog(lowPoint, highPoint, graphTitle);
    }

    public void plotPowerLog(int lowPoint, int highPoint, String graphTitle) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        int n = this.powerSpectrumEstimate[0].length - 1;
        if (lowPoint < 0 || lowPoint >= n) {
            lowPoint = 0;
        }
        if (highPoint < 0 || highPoint > n) {
            highPoint = n;
        }
        this.plotPowerSpectrumLog(lowPoint, highPoint, graphTitle);
    }

    public void plotPowerLog(double lowFreq) {
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerLog(lowFreq, graphTitle);
    }

    public void plotPowerLog(double lowFreq, String graphTitle) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        double highFreq = this.powerSpectrumEstimate[1][this.powerSpectrumEstimate[0].length - 1];
        this.plotPowerLog(lowFreq, highFreq, graphTitle);
    }

    public void plotPowerLog(double lowFreq, double highFreq) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerLog(lowFreq, highFreq, graphTitle);
    }

    public void plotPowerLog(double lowFreq, double highFreq, String graphTitle) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        int low = 0;
        int high = 0;
        if (!this.deltaTset) {
            System.out.println("plotPowerLog - deltaT has not been set");
            System.out.println("full spectrum plotted");
        } else {
            int ii = 0;
            int n = this.powerSpectrumEstimate[0].length - 1;
            boolean test = true;
            if (lowFreq == -1.0) {
                low = 1;
            } else {
                while (test) {
                    if (this.powerSpectrumEstimate[0][ii] > lowFreq) {
                        low = ii - 1;
                        if (low < 0) {
                            low = 0;
                        }
                        test = false;
                        continue;
                    }
                    if (++ii < n) continue;
                    low = 0;
                    System.out.println("plotPowerLog - lowFreq out of range -  reset to zero");
                    test = false;
                }
            }
            test = true;
            ii = 0;
            while (test) {
                if (this.powerSpectrumEstimate[0][ii] > highFreq) {
                    high = ii - 1;
                    if (high < 0) {
                        System.out.println("plotPowerLog - highFreq out of range -  reset to highest value");
                        high = n;
                    }
                    test = false;
                    continue;
                }
                if (++ii < n) continue;
                high = n;
                System.out.println("plotPowerSpectrum - highFreq out of range -  reset to highest value");
                test = false;
            }
            this.plotPowerSpectrumLog(low, high, graphTitle);
        }
    }

    public void plotPowerLog() {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrumLog(0, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    public void plotPowerLog(String graphTitle) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        this.plotPowerSpectrumLog(0, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    private void plotPowerSpectrumLog(int low, int high, String graphTitle) {
        int i;
        int nData = this.powerSpectrumEstimate[0].length;
        int nNew = high - low + 1;
        double[][] spectrum = new double[2][nNew];
        for (int i2 = 0; i2 < nNew; ++i2) {
            spectrum[0][i2] = this.powerSpectrumEstimate[0][i2 + low];
            spectrum[1][i2] = this.powerSpectrumEstimate[1][i2 + low];
        }
        boolean test = true;
        int ii = 0;
        double minimum = 0.0;
        while (test) {
            if (spectrum[1][ii] > 0.0) {
                minimum = spectrum[1][ii];
                test = false;
                continue;
            }
            if (++ii < nNew) continue;
            test = false;
            System.out.println("plotPowerSpectrumLog:  no non-zero amplitudes");
            System.exit(0);
        }
        for (i = ii + 1; i < nNew; ++i) {
            if (!(spectrum[1][i] < minimum)) continue;
            minimum = spectrum[1][i];
        }
        for (i = 0; i < nNew; ++i) {
            if (!(spectrum[1][i] <= 0.0)) continue;
            spectrum[1][i] = minimum;
        }
        for (i = 0; i < nNew; ++i) {
            spectrum[1][i] = Fmath.log10(spectrum[1][i]);
        }
        String yLegend = "Log10(Mean Square Amplitude)";
        this.plotPowerDisplay(spectrum, low, high, graphTitle, yLegend);
    }

    private void plotPowerDisplay(double[][] spectrum, int low, int high, String graphTitle, String yLegend) {
        PlotGraph pg = new PlotGraph(spectrum);
        graphTitle = graphTitle + "  [plot between points " + low + " and " + high + "]";
        pg.setGraphTitle(graphTitle);
        String graphTitle2 = "Window: " + this.windowNames[this.windowOption];
        if (this.windowOption == 6) {
            graphTitle2 = graphTitle2 + " - alpha = " + this.kaiserAlpha;
        }
        if (this.windowOption == 7) {
            graphTitle2 = graphTitle2 + " - alpha = " + this.gaussianAlpha;
        }
        graphTitle2 = graphTitle2 + ", " + this.segmentNumber + " segment/s of length " + this.segmentLength;
        if (this.segmentNumber > 1) {
            graphTitle2 = this.overlap ? graphTitle2 + ", segments overlap by 50%" : graphTitle2 + ", segments do not overlap";
        }
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Frequency");
        if (this.deltaTset) {
            pg.setXaxisUnitsName("cycles per unit time");
        } else {
            pg.setXaxisUnitsName("cycles per grid point");
        }
        pg.setYaxisLegend(yLegend);
        switch (this.plotLineOption) {
            case 0: {
                pg.setLine(3);
                break;
            }
            case 1: {
                pg.setLine(1);
                break;
            }
            case 2: {
                pg.setLine(2);
                break;
            }
            default: {
                pg.setLine(3);
            }
        }
        switch (this.plotPointOption) {
            case 0: {
                pg.setPoint(0);
                break;
            }
            case 1: {
                pg.setPoint(4);
                break;
            }
            default: {
                pg.setPoint(0);
            }
        }
        pg.plot();
    }

    public void setPlotLineOption(int lineOpt) {
        this.plotLineOption = lineOpt;
    }

    public int getPlotLineOption() {
        return this.plotLineOption;
    }

    public void setPlotPointOption(int pointOpt) {
        this.plotPointOption = pointOpt;
    }

    public int getPlotPointOption() {
        return this.plotPointOption;
    }

    public double[][] correlate(double[] data) {
        int nLen = data.length;
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No data has been previously entered");
        }
        if (nLen != this.originalDataLength) {
            throw new IllegalArgumentException("The two data sets to be correlated are of different length");
        }
        if (!FourierTransform.checkPowerOfTwo(nLen)) {
            throw new IllegalArgumentException("The length of the correlation data sets is not equal to an integer power of two");
        }
        this.complexCorr = Complex.oneDarray(nLen);
        for (int i = 0; i < nLen; ++i) {
            this.complexCorr[i].setReal(data[i]);
            this.complexCorr[i].setImag(0.0);
        }
        this.fftCorr = new double[2 * nLen];
        int j = -1;
        for (int i = 0; i < nLen; ++i) {
            this.fftCorr[++j] = data[i];
            this.fftCorr[++j] = 0.0;
        }
        return this.correlation(nLen);
    }

    public double[][] correlate(double[] data1, double[] data2) {
        int i;
        int nLen = data1.length;
        int nLen2 = data2.length;
        if (nLen != nLen2) {
            throw new IllegalArgumentException("The two data sets to be correlated are of different length");
        }
        if (!FourierTransform.checkPowerOfTwo(nLen)) {
            throw new IllegalArgumentException("The length of the correlation data sets is not equal to an integer power of two");
        }
        this.fftDataLength = nLen;
        this.complexData = Complex.oneDarray(this.fftDataLength);
        for (int i2 = 0; i2 < this.fftDataLength; ++i2) {
            this.complexData[i2].setReal(data1[i2]);
            this.complexData[i2].setImag(0.0);
        }
        this.fftData = new double[2 * this.fftDataLength];
        int j = 0;
        for (i = 0; i < this.fftDataLength; ++i) {
            this.fftData[j] = data1[i];
            this.fftData[++j] = 0.0;
            ++j;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        this.complexCorr = Complex.oneDarray(nLen);
        for (i = 0; i < nLen; ++i) {
            this.complexCorr[i].setReal(data2[i]);
            this.complexCorr[i].setImag(0.0);
        }
        this.fftCorr = new double[2 * nLen];
        j = -1;
        for (i = 0; i < nLen; ++i) {
            this.fftCorr[++j] = data2[i];
            this.fftCorr[++j] = 0.0;
        }
        return this.correlation(nLen);
    }

    private double[][] correlation(int nLen) {
        int i;
        int i2;
        this.fftDataWindow = new double[2 * nLen];
        this.fftCorrWindow = new double[2 * nLen];
        this.weights = new double[nLen];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.windowData(this.fftCorr, this.fftCorrWindow, this.weights);
        int isign = 1;
        double[] hold1 = new double[2 * nLen];
        for (int i3 = 0; i3 < nLen * 2; ++i3) {
            hold1[i3] = this.fftDataWindow[i3];
        }
        this.basicFft(hold1, nLen, isign);
        isign = 1;
        double[] hold2 = new double[2 * nLen];
        for (int i4 = 0; i4 < nLen * 2; ++i4) {
            hold2[i4] = this.fftCorrWindow[i4];
        }
        this.basicFft(hold2, nLen, isign);
        double[] hold3 = new double[2 * nLen];
        int j = 0;
        for (i2 = 0; i2 < nLen; ++i2) {
            hold3[j] = (hold1[j] * hold2[j] + hold1[j + 1] * hold2[j + 1]) / (double)nLen;
            hold3[j + 1] = (-hold1[j] * hold2[j + 1] + hold1[j + 1] * hold2[j]) / (double)nLen;
            j += 2;
        }
        isign = -1;
        this.basicFft(hold3, nLen, isign);
        for (i2 = 0; i2 < 2 * nLen; ++i2) {
            this.transformedDataFft[i2] = hold3[i2];
        }
        this.correlationArray = new double[2][nLen];
        j = 0;
        int k = nLen;
        for (i = nLen / 2 + 1; i < nLen; ++i) {
            this.correlationArray[1][j] = hold3[k] / (double)nLen;
            ++j;
            k += 2;
        }
        k = 0;
        for (i = 0; i < nLen / 2; ++i) {
            this.correlationArray[1][j] = hold3[k] / (double)nLen;
            ++j;
            k += 2;
        }
        this.correlationArray[0][0] = -((double)(nLen / 2)) * this.deltaT;
        for (i = 1; i < nLen; ++i) {
            this.correlationArray[0][i] = this.correlationArray[0][i - 1] + this.deltaT;
        }
        this.correlateDone = true;
        return this.correlationArray;
    }

    public double[][] getCorrelation() {
        if (!this.correlateDone) {
            System.out.println("getCorrelation - correlation has not been called - no correlation returned");
        }
        return this.correlationArray;
    }

    public void printCorrelation() {
        String filename = "Correlation.txt";
        this.printCorrelation(filename);
    }

    public void printCorrelation(String filename) {
        if (!this.correlateDone) {
            System.out.println("printCorrelation - correlate has not been called - no file printed");
        } else {
            FileOutput fout = new FileOutput(filename);
            fout.println("Correlation Output File from FourierTransform");
            fout.dateAndTimeln(filename);
            String title = "Window: " + this.windowNames[this.windowOption];
            if (this.windowOption == 6) {
                title = title + ", alpha = " + this.kaiserAlpha;
            }
            if (this.windowOption == 7) {
                title = title + ", alpha = " + this.gaussianAlpha;
            }
            fout.println(title);
            fout.printtab("Data length = ");
            fout.println(this.fftDataLength);
            fout.println();
            fout.printtab("Time lag");
            fout.println("Correlation");
            if (this.deltaTset) {
                fout.printtab("/unit time");
            } else {
                fout.printtab("/grid interval)");
            }
            fout.println("Coefficient");
            int n = this.correlationArray[0].length;
            for (int i = 0; i < n; ++i) {
                fout.printtab(Fmath.truncate(this.correlationArray[0][i], 4));
                fout.println(Fmath.truncate(this.correlationArray[1][i], 4));
            }
            fout.close();
        }
    }

    public void plotCorrelation() {
        if (!this.correlateDone) {
            System.out.println("plotCorrelation - correlation has not been called - no plot displayed");
        } else {
            String graphTitle = "Correlation Plot";
            this.plotCorrelation(graphTitle);
        }
    }

    public void plotCorrelation(String graphTitle) {
        if (!this.correlateDone) {
            System.out.println("plotCorrelation - correlate has not been called - no plot displayed");
        } else {
            PlotGraph pg = new PlotGraph(this.correlationArray);
            pg.setGraphTitle(graphTitle);
            String graphTitle2 = "Window: " + this.windowNames[this.windowOption];
            if (this.windowOption == 6) {
                graphTitle2 = graphTitle2 + " - alpha = " + this.kaiserAlpha;
            }
            if (this.windowOption == 7) {
                graphTitle2 = graphTitle2 + " - alpha = " + this.gaussianAlpha;
            }
            pg.setGraphTitle2(graphTitle2);
            pg.setXaxisLegend("Correlation Lag");
            if (this.deltaTset) {
                pg.setXaxisUnitsName("unit time");
            } else {
                pg.setXaxisUnitsName("grid interval");
            }
            pg.setYaxisLegend("Correlation coefficient");
            switch (this.plotLineOption) {
                case 0: {
                    pg.setLine(3);
                    break;
                }
                case 1: {
                    pg.setLine(1);
                    break;
                }
                case 2: {
                    pg.setLine(2);
                    break;
                }
                default: {
                    pg.setLine(3);
                }
            }
            switch (this.plotPointOption) {
                case 0: {
                    pg.setPoint(0);
                    break;
                }
                case 1: {
                    pg.setPoint(4);
                    break;
                }
                default: {
                    pg.setPoint(0);
                }
            }
            pg.plot();
        }
    }

    public double[][] shortTime(double windowTime) {
        int windowLength = (int)Math.round(windowTime / this.deltaT);
        if (!FourierTransform.checkPowerOfTwo(windowLength)) {
            int low = FourierTransform.lastPowerOfTwo(windowLength);
            int high = FourierTransform.nextPowerOfTwo(windowLength);
            if (windowLength - low <= high - windowLength) {
                windowLength = low;
                if (low == 0) {
                    windowLength = high;
                }
            } else {
                windowLength = high;
            }
            System.out.println("Method - shortTime");
            System.out.println("Window length, provided as time, " + windowTime + ", did not convert to an integer power of two data points");
            System.out.println("A value of " + (double)(windowLength - 1) * this.deltaT + " was substituted");
        }
        return this.shortTime(windowLength);
    }

    public double[][] shortTime(int windowLength) {
        int i;
        if (!FourierTransform.checkPowerOfTwo(windowLength)) {
            throw new IllegalArgumentException("Moving window data length ," + windowLength + ", is not an integer power of two");
        }
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No data has been entered for the Fast Fourier Transform");
        }
        if (windowLength > this.originalDataLength) {
            throw new IllegalArgumentException("The window length, " + windowLength + ", is greater than the data length, " + this.originalDataLength + ".");
        }
        if (this.windowOption == 0) {
            this.setGaussian();
        }
        this.numShortTimes = this.originalDataLength - windowLength + 1;
        this.numShortFreq = windowLength / 2;
        this.timeFrequency = new double[this.numShortFreq + 1][this.numShortTimes + 1];
        this.timeFrequency[0][0] = 0.0;
        this.timeFrequency[0][1] = (double)(windowLength - 1) * this.deltaT / 2.0;
        for (i = 2; i <= this.numShortTimes; ++i) {
            this.timeFrequency[0][i] = this.timeFrequency[0][i - 1] + this.deltaT;
        }
        for (i = 0; i < this.numShortFreq; ++i) {
            this.timeFrequency[i + 1][0] = (double)i / ((double)windowLength * this.deltaT);
        }
        this.segmentLength = windowLength;
        int windowStartIndex = 0;
        double[] data = new double[2 * windowLength];
        double[] winPSD = new double[this.numShortFreq];
        int isign = 1;
        for (int i2 = 1; i2 <= this.numShortTimes; ++i2) {
            int j;
            for (j = 0; j < 2 * windowLength; ++j) {
                data[j] = this.fftData[windowStartIndex + j];
            }
            if (i2 == 1) {
                this.sumOfSquaredWeights = this.windowData(data, data, this.weights);
            } else {
                int k = 0;
                for (int j2 = 0; j2 < this.segmentLength; ++j2) {
                    data[k] = data[k] * this.weights[j2];
                    data[++k] = data[k] * this.weights[j2];
                    ++k;
                }
            }
            this.basicFft(data, windowLength, isign);
            winPSD[0] = Fmath.square(data[0]) + Fmath.square(data[1]);
            for (j = 1; j < this.numShortFreq; ++j) {
                winPSD[j] = Fmath.square(data[2 * j]) + Fmath.square(data[2 * j + 1]) + Fmath.square(data[2 * windowLength - 2 * j]) + Fmath.square(data[2 * windowLength - 2 * j + 1]);
            }
            for (j = 0; j < this.numShortFreq; ++j) {
                this.timeFrequency[j + 1][i2] = 2.0 * winPSD[j] / ((double)windowLength * this.sumOfSquaredWeights);
            }
            windowStartIndex += 2;
        }
        this.shortTimeDone = true;
        return this.timeFrequency;
    }

    public double[][] getTimeFrequencyMatrix() {
        if (!this.shortTimeDone) {
            throw new IllegalArgumentException("No short time Fourier transform has been performed");
        }
        return this.timeFrequency;
    }

    public int getShortTimeNumberOfTimes() {
        if (!this.shortTimeDone) {
            throw new IllegalArgumentException("No short time Fourier transform has been performed");
        }
        return this.numShortTimes;
    }

    public int getShortTimeNumberOfFrequencies() {
        if (!this.shortTimeDone) {
            throw new IllegalArgumentException("No short time Fourier transform has been performed");
        }
        return this.numShortFreq;
    }

    public int getShortTimeWindowLength() {
        if (!this.shortTimeDone) {
            throw new IllegalArgumentException("No short time Fourier transform has been performed");
        }
        return this.segmentLength;
    }

    public void printShortTime() {
        String filename = "ShortTime.txt";
        this.printShortTime(filename);
    }

    public void printShortTime(String filename) {
        if (!this.shortTimeDone) {
            System.out.println("printShortTime- shortTime has not been called - no file printed");
        } else {
            FileOutput fout = new FileOutput(filename);
            fout.println("Short Time Fourier Transform Output File from FourierTransform");
            fout.dateAndTimeln(filename);
            String title = "Window: " + this.windowNames[this.windowOption];
            if (this.windowOption == 6) {
                title = title + ", alpha = " + this.kaiserAlpha;
            }
            if (this.windowOption == 7) {
                title = title + ", alpha = " + this.gaussianAlpha;
            }
            fout.println(title);
            fout.printtab("Data length = ");
            fout.println(this.originalDataLength);
            fout.printtab("Delta T = ");
            fout.println(this.deltaT);
            fout.printtab("Window length (points) = ");
            fout.println(this.segmentLength);
            fout.printtab("Window length (time units) = ");
            fout.println((double)(this.segmentLength - 1) * this.deltaT);
            fout.printtab("Number of frequency points = ");
            fout.println(this.numShortFreq);
            fout.printtab("Number of time points = ");
            fout.println(this.numShortTimes);
            boolean checkAve = false;
            int newTp = this.numShortTimes;
            int maxN = 100;
            int nAve = this.numShortTimes / maxN;
            int nLast = this.numShortTimes % maxN;
            if (this.numShortTimes > 127) {
                checkAve = true;
                if (nLast > 0) {
                    newTp = maxN;
                    nLast = this.numShortTimes - ++nAve * (newTp - 1);
                } else {
                    newTp = maxN;
                    nLast = nAve;
                }
                if (nLast != nAve) {
                    fout.println("In the output below, each of the first " + (newTp - 2) + " magnitude points, along the time axis, is the average of " + nAve + " calculated points");
                    fout.println("The last point is the average of " + nLast + " calculated points");
                } else {
                    fout.println("In the output below, each magnitude point is the average of " + nAve + " calculated points");
                }
                fout.println("The data, without averaging, may be accessed using the method getTimeFrequencyMatrix()");
            }
            fout.println();
            fout.println("first row = times");
            fout.println("first column = frequencies");
            fout.println("all other cells = mean square amplitudes at the corresponding time and frequency");
            if (checkAve) {
                double sum = 0.0;
                int start = 1;
                int workingAve = nAve;
                for (int i = 0; i <= this.numShortFreq; ++i) {
                    fout.printtab(Fmath.truncate(this.timeFrequency[i][0], 4));
                    start = 1;
                    for (int j = 1; j <= newTp; ++j) {
                        workingAve = nAve;
                        if (j == newTp) {
                            workingAve = nLast;
                        }
                        sum = 0.0;
                        for (int k = start; k <= start + workingAve - 1; ++k) {
                            sum += this.timeFrequency[i][k];
                        }
                        fout.printtab(Fmath.truncate(sum /= (double)workingAve, 4));
                        start += workingAve;
                    }
                    fout.println();
                }
            } else {
                for (int i = 0; i <= this.numShortFreq; ++i) {
                    for (int j = 0; j <= newTp; ++j) {
                        fout.printtab(Fmath.truncate(this.timeFrequency[i][j], 4));
                    }
                    fout.println();
                }
            }
            fout.close();
        }
    }

    @Override
    public void paint(Graphics g) {
        this.graph(g);
    }

    public void plotShortTime(String title) {
        this.shortTitle = title;
        this.plotShortTime();
    }

    public void plotShortTime() {
        JFrame window = new JFrame("Michael T Flanagan's plotting program - FourierTransform.plotShortTime");
        this.setSize(800, 600);
        window.getContentPane().setBackground(Color.white);
        window.setDefaultCloseOperation(3);
        window.getContentPane().add("Center", this);
        window.pack();
        window.setResizable(true);
        window.toFront();
        window.setVisible(true);
    }

    public void graph(Graphics g) {
        int i;
        double max;
        int j;
        int i2;
        int j2;
        int i3;
        int xLen = 512;
        int yLen = 256;
        int yTop = 100;
        int xBot = 100;
        int numBands = 18;
        Color[] color = new Color[numBands + 1];
        color[18] = Color.black;
        color[17] = Color.darkGray;
        color[16] = Color.gray;
        color[15] = Color.lightGray;
        color[14] = Color.red.darker();
        color[13] = Color.red;
        color[12] = Color.magenta.darker();
        color[11] = Color.magenta;
        color[10] = Color.pink;
        color[9] = Color.pink.darker();
        color[8] = Color.orange.darker();
        color[7] = Color.orange;
        color[6] = Color.yellow;
        color[5] = Color.green;
        color[4] = Color.green.darker();
        color[3] = Color.cyan;
        color[2] = Color.cyan.darker();
        color[1] = Color.blue;
        color[0] = Color.blue.darker();
        int pixelsPerXpoint = 0;
        int xTp = 0;
        int xAve = 0;
        int xLast = 0;
        boolean xCheck = true;
        if (this.numShortTimes <= xLen) {
            pixelsPerXpoint = xLen / this.numShortTimes;
            xLen = pixelsPerXpoint * this.numShortTimes;
            xTp = this.numShortTimes;
        } else {
            xCheck = false;
            pixelsPerXpoint = 1;
            xTp = this.numShortTimes;
            xAve = this.numShortTimes / xLen;
            xLast = this.numShortTimes % xLen;
            if (xLast > 0) {
                xTp = this.numShortTimes / ++xAve + 1;
                xLast = this.numShortTimes - xAve * (xTp - 1);
            } else {
                xTp = this.numShortTimes / xAve;
                xLast = xAve;
            }
            xLen = xTp;
        }
        int pixelsPerYpoint = 0;
        int yTp = 0;
        int yAve = 0;
        int yLast = 0;
        boolean yCheck = true;
        if (this.numShortFreq <= yLen) {
            pixelsPerYpoint = yLen / this.numShortFreq;
            yLen = pixelsPerYpoint * this.numShortFreq;
            yTp = this.numShortFreq;
        } else {
            yCheck = false;
            pixelsPerYpoint = 1;
            yTp = this.numShortFreq;
            yAve = this.numShortFreq / yLen;
            yLast = this.numShortFreq % yLen;
            if (yLast > 0) {
                yTp = this.numShortFreq / ++yAve + 1;
                yLast = this.numShortFreq - yAve * (yTp - 1);
            } else {
                yTp = this.numShortFreq / yAve;
                yLast = yAve;
            }
            yLen = yTp;
        }
        int yBot = yTop + yLen;
        int xTop = xBot + xLen;
        double[][] averages = new double[yTp][xTp];
        int[][] pixels = new int[yTp][xTp];
        double[] times = new double[xTp];
        int[] timesPixels = new int[xTp];
        double[] freqs = new double[yTp];
        int[] freqPixels = new int[yTp];
        double[][] hold = new double[this.numShortFreq][xTp];
        if (xCheck) {
            for (i3 = 0; i3 <= this.numShortFreq; ++i3) {
                for (j2 = 1; j2 <= this.numShortTimes; ++j2) {
                    if (i3 == 0) {
                        times[j2 - 1] = this.timeFrequency[0][j2];
                        continue;
                    }
                    hold[i3 - 1][j2 - 1] = this.timeFrequency[i3][j2];
                }
            }
        } else {
            double sum = 0.0;
            int start = 1;
            int workingAve = xAve;
            for (i2 = 0; i2 <= this.numShortFreq; ++i2) {
                start = 1;
                for (j = 1; j <= xTp; ++j) {
                    workingAve = xAve;
                    if (j == xTp) {
                        workingAve = xLast;
                    }
                    sum = 0.0;
                    for (int k = start; k <= start + workingAve - 1; ++k) {
                        sum += this.timeFrequency[i2][k];
                    }
                    if (i2 == 0) {
                        times[j - 1] = sum / (double)workingAve;
                    } else {
                        hold[i2 - 1][j - 1] = sum / (double)workingAve;
                    }
                    start += workingAve;
                }
            }
        }
        if (yCheck) {
            for (i3 = 0; i3 < this.numShortFreq; ++i3) {
                freqs[i3] = this.timeFrequency[i3 + 1][0];
                for (j2 = 0; j2 < xTp; ++j2) {
                    averages[i3][j2] = hold[i3][j2];
                }
            }
        } else {
            double sum = 0.0;
            double sFreq = 0.0;
            int start = 0;
            int workingAve = yAve;
            for (int i4 = 0; i4 < xTp; ++i4) {
                start = 0;
                for (int j3 = 0; j3 < yTp; ++j3) {
                    workingAve = yAve;
                    if (j3 == yTp - 1) {
                        workingAve = yLast;
                    }
                    sum = 0.0;
                    sFreq = 0.0;
                    for (int k = start; k <= start + workingAve - 1; ++k) {
                        sum += hold[k][i4];
                        sFreq += this.timeFrequency[k + 1][0];
                    }
                    averages[j3][i4] = sum;
                    freqs[j3] = sFreq / (double)workingAve;
                    start += workingAve;
                }
            }
        }
        double min = max = averages[0][0];
        for (i2 = 0; i2 < yTp; ++i2) {
            for (j = 0; j < xTp; ++j) {
                if (averages[i2][j] > max) {
                    max = averages[i2][j];
                }
                if (!(averages[i2][j] < min)) continue;
                min = averages[i2][j];
            }
        }
        double bandZero = 0.0;
        if (min > 0.1 * max) {
            bandZero = 0.99 * min;
        }
        double bandWidth = (1.01 * max - 0.99 * min) / (double)numBands;
        double[] band = new double[numBands];
        band[0] = bandZero + bandWidth;
        for (int i5 = 1; i5 < numBands; ++i5) {
            band[i5] = band[i5 - 1] + bandWidth;
        }
        boolean test = true;
        for (int i6 = 0; i6 < yTp; ++i6) {
            for (int j4 = 0; j4 < xTp; ++j4) {
                test = true;
                int k = 0;
                while (test) {
                    if (averages[i6][j4] <= band[k]) {
                        pixels[i6][j4] = k;
                        test = false;
                        continue;
                    }
                    ++k;
                }
            }
        }
        int yPixels = 0;
        int xPixels = 0;
        int yInner = 0;
        int xInner = 0;
        int xx = xBot;
        int yy = yTop;
        for (int i7 = 0; i7 < yTp; ++i7) {
            for (int j5 = 0; j5 < xTp; ++j5) {
                yInner = 0;
                for (int k = 0; k < pixelsPerYpoint; ++k) {
                    xInner = 0;
                    for (int l = 0; l < pixelsPerXpoint; ++l) {
                        g.setColor(color[pixels[i7][j5]]);
                        xx = xBot + (xPixels + xInner);
                        yy = yBot - (yPixels + yInner);
                        g.drawLine(xx, yy, xx, yy);
                        ++xInner;
                    }
                    ++yInner;
                }
                xPixels += xInner;
            }
            yPixels += yInner;
            xPixels = 0;
        }
        g.setColor(color[numBands]);
        g.drawLine(xBot, yBot, xBot, yTop);
        g.drawLine(xTop, yBot, xTop, yTop);
        g.drawLine(xBot, yBot, xTop, yBot);
        g.drawLine(xBot, yTop, xTop, yTop);
        int yInc = yLen / 4;
        int yScale = this.numShortFreq / 4;
        double yUnits = (double)yInc * (freqs[1] - freqs[0]) / (double)(pixelsPerYpoint * yScale);
        String[] yArray = new String[5];
        int yArr = 0;
        yArray[0] = "0  ";
        for (int i8 = 1; i8 < 5; ++i8) {
            yArray[i8] = (yArr += yScale) + "  ";
        }
        xx = xBot;
        yy = yBot;
        int yWord = 6 * (yArray[4].length() + 1);
        for (int i9 = 0; i9 < 5; ++i9) {
            g.drawLine(xx - 5, yy, xx, yy);
            g.drawString(yArray[i9], xx - yWord, yy + 4);
            yy -= yInc;
        }
        int xInc = xLen / 8;
        int xScale = this.numShortTimes / 8;
        double xUnits = (double)xInc * (times[1] - times[0]) / (double)(pixelsPerXpoint * xScale);
        String[] xArray = new String[9];
        int xArr = 0;
        xArray[0] = "0 ";
        for (i = 1; i < 9; ++i) {
            xArray[i] = (xArr += xScale) + " ";
        }
        xx = xBot;
        yy = yBot;
        for (i = 0; i < 9; ++i) {
            g.drawLine(xx, yy, xx, yy + 5);
            g.drawString(xArray[i], xx - 4, yy + 20);
            xx += xInc;
        }
        g.drawString("Short Time Fourier Transfer Time-Frequency Plot", xBot - 80, yTop - 80);
        g.drawString(this.shortTitle, xBot - 80, yTop - 60);
        String yAxis = "Frequency / (" + Fmath.truncate(yUnits, 3) + " cycles per time unit)";
        g.drawString(yAxis, xBot - 60, yTop - 20);
        String xAxis = "Time / (" + Fmath.truncate(xUnits, 3) + " time units)";
        g.drawString(xAxis, xBot, yBot + 40);
        String totalTime = "Total time = " + Fmath.truncate((double)xLen * (times[1] - times[0]) / (double)pixelsPerXpoint, 3) + " time units";
        g.drawString(totalTime, xBot, yBot + 80);
        String totalFreq = "Frequecy range = 0 to " + Fmath.truncate((double)yLen * (freqs[1] - freqs[0]) / (double)pixelsPerYpoint, 3) + " cycles per time unit";
        g.drawString(totalFreq, xBot, yBot + 100);
        g.drawString("Widow length = " + Fmath.truncate((double)(this.segmentLength - 1) * this.deltaT, 3) + " time units", xBot, yBot + 120);
        String filter = "Window filter = " + this.windowNames[this.windowOption];
        if (this.windowOption == 6) {
            filter = filter + ", alpha = " + this.kaiserAlpha;
        }
        if (this.windowOption == 7) {
            filter = filter + ", alpha = " + this.gaussianAlpha;
        }
        g.drawString(filter, xBot, yBot + 140);
        yy = yBot + 100;
        xx = xTop + 40;
        double ss = Fmath.truncate(bandZero, 3);
        for (int i10 = 0; i10 < numBands; ++i10) {
            double ff = Fmath.truncate(band[i10], 3);
            g.setColor(color[numBands]);
            g.drawString(ss + " - " + ff, xx + 25, yy);
            ss = ff;
            g.setColor(color[i10]);
            for (int j6 = 0; j6 < 20; ++j6) {
                g.drawLine(xx, --yy, xx + 20, yy);
            }
        }
        g.setColor(Color.black);
        g.drawString("Mean square", xx + 25, yy - 25);
        g.drawString("amplitudes ", xx + 25, yy - 10);
    }

    public static int lastPowerOfTwo(int len) {
        boolean test0 = true;
        while (test0) {
            if (FourierTransform.checkPowerOfTwo(len)) {
                test0 = false;
                continue;
            }
            --len;
        }
        return len;
    }

    public static int nextPowerOfTwo(int len) {
        boolean test0 = true;
        while (test0) {
            if (FourierTransform.checkPowerOfTwo(len)) {
                test0 = false;
                continue;
            }
            ++len;
        }
        return len;
    }

    public static boolean checkPowerOfTwo(int n) {
        boolean test = true;
        int m = n;
        while (test && m > 1) {
            if (m % 2 != 0) {
                test = false;
                continue;
            }
            m /= 2;
        }
        return test;
    }

    public static int checkIntegerTimesPowerOfTwo(int n) {
        boolean testOuter1 = true;
        boolean testInner1 = true;
        boolean testInner2 = true;
        boolean testReturn = true;
        int m = n;
        int j = 1;
        int mult = 0;
        while (testOuter1) {
            testInner1 = FourierTransform.checkPowerOfTwo(m);
            if (testInner1) {
                testReturn = true;
                testOuter1 = false;
                continue;
            }
            testInner2 = true;
            while (testInner2) {
                if ((m /= ++j) < 1) {
                    testInner2 = false;
                    testInner1 = false;
                    testOuter1 = false;
                    testReturn = false;
                    continue;
                }
                if (m % 2 != 0) continue;
                testInner2 = false;
            }
        }
        if (testReturn) {
            mult = j;
        }
        return mult;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }
}

