/*
 * Decompiled with CFR 0.152.
 */
package flanagan.complex;

import flanagan.analysis.ErrorProp;
import flanagan.math.Fmath;
import flanagan.math.PsRandom;

public class ComplexErrorProp {
    private ErrorProp eReal = new ErrorProp();
    private ErrorProp eImag = new ErrorProp();
    private double corrCoeff = 0.0;
    private static int monteCarloLength = 10000;

    public ComplexErrorProp() {
        this.eReal.reset(0.0, 0.0);
        this.eImag.reset(0.0, 0.0);
        this.corrCoeff = 0.0;
    }

    public ComplexErrorProp(ErrorProp eReal, ErrorProp eImag) {
        this.eReal = eReal.copy();
        this.eImag = eImag.copy();
        this.corrCoeff = 0.0;
    }

    public ComplexErrorProp(ErrorProp eReal, ErrorProp eImag, double corrCoeff) {
        this.eReal = eReal.copy();
        this.eImag = eImag.copy();
        this.corrCoeff = corrCoeff;
    }

    public ComplexErrorProp(double eRealValue, double eRealError, double eImagValue, double eImagError) {
        this.eReal.reset(eRealValue, eRealError);
        this.eImag.reset(eImagValue, eImagError);
        this.corrCoeff = 0.0;
    }

    public ComplexErrorProp(double eRealValue, double eRealError, double eImagValue, double eImagError, double corrCoeff) {
        this.eReal.reset(eRealValue, eRealError);
        this.eImag.reset(eImagValue, eImagError);
        this.corrCoeff = corrCoeff;
    }

    public void reset(ErrorProp eReal, ErrorProp eImag) {
        this.eReal = eReal.copy();
        this.eImag = eImag.copy();
        this.corrCoeff = 0.0;
    }

    public void reset(ErrorProp eReal, ErrorProp eImag, double corrCoeff) {
        this.eReal = eReal.copy();
        this.eImag = eImag.copy();
        this.corrCoeff = corrCoeff;
    }

    public void reset(double eRealValue, double eRealError, double eImagValue, double eImagError) {
        this.eReal.setValue(eRealValue);
        this.eReal.setError(eRealError);
        this.eImag.setValue(eImagValue);
        this.eImag.setError(eImagError);
        this.corrCoeff = 0.0;
    }

    public void reset(double eRealValue, double eRealError, double eImagValue, double eImagError, double corrCoeff) {
        this.eReal.setValue(eRealValue);
        this.eReal.setError(eRealError);
        this.eImag.setValue(eImagValue);
        this.eImag.setError(eImagError);
        this.corrCoeff = corrCoeff;
    }

    public void polar(ErrorProp eMag, ErrorProp ePhase) {
        this.polar(eMag, ePhase, 0.0);
    }

    public void polar(ErrorProp eMag, ErrorProp ePhase, double corrCoeff) {
        ErrorProp a = new ErrorProp();
        this.eReal = a = eMag.times(ErrorProp.cos(ePhase), corrCoeff);
        this.eImag = a = eMag.times(ErrorProp.sin(ePhase), corrCoeff);
        PsRandom rr = new PsRandom();
        double[][] ran = rr.correlatedGaussianArrays(eMag.getValue(), ePhase.getValue(), eMag.getError(), ePhase.getError(), corrCoeff, monteCarloLength);
        double[] rV = new double[monteCarloLength];
        double[] iV = new double[monteCarloLength];
        for (int i = 0; i < monteCarloLength; ++i) {
            rV[i] = ran[0][i] * Math.cos(ran[1][i]);
            iV[i] = ran[0][i] * Math.sin(ran[1][i]);
        }
        this.corrCoeff = ComplexErrorProp.calcRho(rV, iV);
    }

    public static double calcRho(double[] x, double[] y) {
        int n = x.length;
        if (n != y.length) {
            throw new IllegalArgumentException("length of x and y must be the same");
        }
        double meanX = 0.0;
        double meanY = 0.0;
        for (int i = 0; i < n; ++i) {
            meanX += x[i];
            meanY += y[i];
        }
        meanX /= (double)n;
        meanY /= (double)n;
        double varX = 0.0;
        double varY = 0.0;
        double covarXY = 0.0;
        for (int i = 0; i < n; ++i) {
            varX += Fmath.square(x[i] - meanX);
            varY += Fmath.square(y[i] - meanY);
            covarXY += (x[i] - meanX) * (y[i] - meanY);
        }
        varX = Math.sqrt(varX / (double)(n - 1));
        varY = Math.sqrt(varY / (double)(n - 1));
        return (covarXY /= (double)(n - 1)) / (varX * varY);
    }

    public void polar(double eMagValue, double eMagError, double ePhaseValue, double ePhaseError) {
        ErrorProp eMag = new ErrorProp(eMagValue, eMagError);
        ErrorProp ePhase = new ErrorProp(ePhaseValue, ePhaseError);
        this.polar(eMag, ePhase, 0.0);
    }

    public void polar(double eMagValue, double eMagError, double ePhaseValue, double ePhaseError, double corrCoeff) {
        ErrorProp eMag = new ErrorProp(eMagValue, eMagError);
        ErrorProp ePhase = new ErrorProp(ePhaseValue, ePhaseError);
        this.polar(eMag, ePhase, corrCoeff);
    }

    public void setReal(ErrorProp eReal) {
        this.eReal = eReal.copy();
    }

    public void setReal(double eRealValue, double eRealError) {
        this.eReal.setValue(eRealValue);
        this.eReal.setError(eRealError);
    }

    public void setImag(ErrorProp eImag) {
        this.eImag = eImag.copy();
    }

    public void setImag(double eImagValue, double eImagError) {
        this.eImag.setValue(eImagValue);
        this.eImag.setError(eImagError);
    }

    public void setDouble(double errorFree) {
        this.eReal.reset(errorFree, 0.0);
        this.eImag.reset(0.0, 0.0);
    }

    public void setCorrCoeff(double corrCoeff) {
        this.corrCoeff = corrCoeff;
    }

    public static void setMonteCarloLength(int length) {
        monteCarloLength = length;
    }

    public ErrorProp getReal() {
        return this.eReal.copy();
    }

    public double getRealValue() {
        return this.eReal.getValue();
    }

    public double getRealError() {
        return this.eReal.getError();
    }

    public ErrorProp getImag() {
        return this.eImag.copy();
    }

    public double getImagValue() {
        return this.eImag.getValue();
    }

    public double getImagError() {
        return this.eImag.getError();
    }

    public double getCorrCoeff() {
        return this.corrCoeff;
    }

    public static int getMonteCarloLength() {
        return monteCarloLength;
    }

    public static ComplexErrorProp copy(ComplexErrorProp a) {
        if (a == null) {
            return null;
        }
        ComplexErrorProp b = new ComplexErrorProp();
        b.eReal = a.eReal.copy();
        b.eImag = a.eImag.copy();
        return b;
    }

    public ComplexErrorProp copy() {
        if (this == null) {
            return null;
        }
        ComplexErrorProp b = new ComplexErrorProp();
        b.eReal = this.eReal.copy();
        b.eImag = this.eImag.copy();
        return b;
    }

    public Object clone() {
        if (this == null) {
            return null;
        }
        ComplexErrorProp b = new ComplexErrorProp();
        b.eReal = this.eReal.copy();
        b.eImag = this.eImag.copy();
        return b;
    }

    public static ComplexErrorProp plus(ComplexErrorProp a, ComplexErrorProp b) {
        ComplexErrorProp c = new ComplexErrorProp();
        c.eReal = a.eReal.plus(b.eReal);
        c.eImag = a.eImag.plus(b.eImag);
        return c;
    }

    public ComplexErrorProp plus(ComplexErrorProp a) {
        ComplexErrorProp b = new ComplexErrorProp();
        b.eReal = this.eReal.plus(a.eReal);
        b.eImag = this.eImag.plus(a.eImag);
        return b;
    }

    public static ComplexErrorProp minus(ComplexErrorProp a, ComplexErrorProp b) {
        ComplexErrorProp c = new ComplexErrorProp();
        c.eReal = a.eReal.minus(b.eReal);
        c.eImag = a.eImag.minus(b.eImag);
        return c;
    }

    public ComplexErrorProp minus(ComplexErrorProp a) {
        ComplexErrorProp b = new ComplexErrorProp();
        b.eReal = this.eReal.minus(a.eReal);
        b.eImag = this.eImag.minus(a.eImag);
        return b;
    }

    public static ComplexErrorProp times(ComplexErrorProp a, ComplexErrorProp b) {
        ComplexErrorProp c = new ComplexErrorProp();
        c.eReal = a.eReal.times(b.eReal).minus(a.eImag.times(b.eImag));
        c.eImag = a.eReal.times(b.eImag).plus(a.eImag.times(b.eReal));
        return c;
    }

    public ComplexErrorProp times(ComplexErrorProp b) {
        ComplexErrorProp c = new ComplexErrorProp();
        c.eReal = this.eReal.times(b.eReal).minus(this.eImag.times(b.eImag));
        c.eImag = this.eReal.times(b.eImag).plus(this.eImag.times(b.eReal));
        return c;
    }

    public void timesEquals(ComplexErrorProp a) {
        ComplexErrorProp b = new ComplexErrorProp();
        b.eReal = a.eReal.times(this.eReal).minus(a.eImag.times(this.eImag));
        b.eImag = a.eReal.times(this.eImag).plus(a.eImag.times(this.eReal));
        this.eReal = b.eReal.copy();
        this.eImag = b.eImag.copy();
    }

    public static ComplexErrorProp over(ComplexErrorProp a, ComplexErrorProp b) {
        int i;
        ComplexErrorProp c = new ComplexErrorProp();
        PsRandom ran = new PsRandom();
        double[] aReal = ran.gaussianArray(a.eReal.getValue(), a.eReal.getError(), monteCarloLength);
        double[] aImag = ran.gaussianArray(a.eImag.getValue(), a.eImag.getError(), monteCarloLength);
        double[] bReal = ran.gaussianArray(b.eReal.getValue(), b.eReal.getError(), monteCarloLength);
        double[] bImag = ran.gaussianArray(b.eImag.getValue(), b.eImag.getError(), monteCarloLength);
        double[] rat = new double[monteCarloLength];
        double[] denm = new double[monteCarloLength];
        double[] cReal = new double[monteCarloLength];
        double[] cImag = new double[monteCarloLength];
        for (int i2 = 0; i2 < monteCarloLength; ++i2) {
            if (Math.abs(bReal[i2]) >= Math.abs(bImag[i2])) {
                rat[i2] = bImag[i2] / bReal[i2];
                denm[i2] = bReal[i2] + bImag[i2] * rat[i2];
                cReal[i2] = (aReal[i2] + aImag[i2] * rat[i2]) / denm[i2];
                cImag[i2] = (aImag[i2] - aReal[i2] * rat[i2]) / denm[i2];
                continue;
            }
            rat[i2] = bReal[i2] / bImag[i2];
            denm[i2] = bReal[i2] * rat[i2] + bImag[i2];
            cReal[i2] = (aReal[i2] * rat[i2] + aImag[i2]) / denm[i2];
            cImag[i2] = (aImag[i2] * rat[i2] - aReal[i2]) / denm[i2];
        }
        double cRealSum = 0.0;
        double cImagSum = 0.0;
        double cRealErrorSum = 0.0;
        double cImagErrorSum = 0.0;
        for (i = 0; i < monteCarloLength; ++i) {
            cRealSum += cReal[i];
            cImagSum += cImag[i];
        }
        cRealSum /= (double)monteCarloLength;
        cImagSum /= (double)monteCarloLength;
        for (i = 0; i < monteCarloLength; ++i) {
            cRealErrorSum += Fmath.square(cRealSum - cReal[i]);
            cImagErrorSum += Fmath.square(cImagSum - cImag[i]);
        }
        cRealErrorSum = Math.sqrt(cRealErrorSum / (double)(monteCarloLength - 1));
        cImagErrorSum = Math.sqrt(cImagErrorSum / (double)(monteCarloLength - 1));
        c.eReal.setError(cRealErrorSum);
        c.eImag.setError(cImagErrorSum);
        double denom = 0.0;
        double ratio = 0.0;
        if (Math.abs(b.eReal.getValue()) >= Math.abs(b.eImag.getValue())) {
            ratio = b.eImag.getValue() / b.eReal.getValue();
            denom = b.eReal.getValue() + b.eImag.getValue() * ratio;
            c.eReal.setValue((a.eReal.getValue() + a.eImag.getValue() * ratio) / denom);
            c.eImag.setValue((a.eImag.getValue() - a.eReal.getValue() * ratio) / denom);
        } else {
            ratio = b.eReal.getValue() / b.eImag.getValue();
            denom = b.eReal.getValue() * ratio + b.eImag.getValue();
            c.eReal.setValue((a.eReal.getValue() * ratio + a.eImag.getValue()) / denom);
            c.eImag.setValue((a.eImag.getValue() * ratio - a.eReal.getValue()) / denom);
        }
        return c;
    }

    public ComplexErrorProp over(ComplexErrorProp b) {
        int i;
        ComplexErrorProp c = new ComplexErrorProp();
        PsRandom ran = new PsRandom();
        double[] aReal = ran.gaussianArray(this.eReal.getValue(), this.eReal.getError(), monteCarloLength);
        double[] aImag = ran.gaussianArray(this.eImag.getValue(), this.eImag.getError(), monteCarloLength);
        double[] bReal = ran.gaussianArray(b.eReal.getValue(), b.eReal.getError(), monteCarloLength);
        double[] bImag = ran.gaussianArray(b.eImag.getValue(), b.eImag.getError(), monteCarloLength);
        double[] rat = new double[monteCarloLength];
        double[] denm = new double[monteCarloLength];
        double[] cReal = new double[monteCarloLength];
        double[] cImag = new double[monteCarloLength];
        for (int i2 = 0; i2 < monteCarloLength; ++i2) {
            if (Math.abs(bReal[i2]) >= Math.abs(bImag[i2])) {
                rat[i2] = bImag[i2] / bReal[i2];
                denm[i2] = bReal[i2] + bImag[i2] * rat[i2];
                cReal[i2] = (aReal[i2] + aImag[i2] * rat[i2]) / denm[i2];
                cImag[i2] = (aImag[i2] - aReal[i2] * rat[i2]) / denm[i2];
                continue;
            }
            rat[i2] = bReal[i2] / bImag[i2];
            denm[i2] = bReal[i2] * rat[i2] + bImag[i2];
            cReal[i2] = (aReal[i2] * rat[i2] + aImag[i2]) / denm[i2];
            cImag[i2] = (aImag[i2] * rat[i2] - aReal[i2]) / denm[i2];
        }
        double cRealSum = 0.0;
        double cImagSum = 0.0;
        double cRealErrorSum = 0.0;
        double cImagErrorSum = 0.0;
        for (i = 0; i < monteCarloLength; ++i) {
            cRealSum += cReal[i];
            cImagSum += cImag[i];
        }
        cRealSum /= (double)monteCarloLength;
        cImagSum /= (double)monteCarloLength;
        for (i = 0; i < monteCarloLength; ++i) {
            cRealErrorSum += Fmath.square(cRealSum - cReal[i]);
            cImagErrorSum += Fmath.square(cImagSum - cImag[i]);
        }
        cRealErrorSum = Math.sqrt(cRealErrorSum / (double)(monteCarloLength - 1));
        cImagErrorSum = Math.sqrt(cImagErrorSum / (double)(monteCarloLength - 1));
        c.eReal.setError(cRealErrorSum);
        c.eImag.setError(cImagErrorSum);
        double denom = 0.0;
        double ratio = 0.0;
        if (Math.abs(b.eReal.getValue()) >= Math.abs(b.eImag.getValue())) {
            ratio = b.eImag.getValue() / b.eReal.getValue();
            denom = b.eReal.getValue() + b.eImag.getValue() * ratio;
            c.eReal.setValue((this.eReal.getValue() + this.eImag.getValue() * ratio) / denom);
            c.eImag.setValue((this.eImag.getValue() - this.eReal.getValue() * ratio) / denom);
        } else {
            ratio = b.eReal.getValue() / b.eImag.getValue();
            denom = b.eReal.getValue() * ratio + b.eImag.getValue();
            c.eReal.setValue((this.eReal.getValue() * ratio + this.eImag.getValue()) / denom);
            c.eImag.setValue((this.eImag.getValue() * ratio - this.eReal.getValue()) / denom);
        }
        return c;
    }

    public static ComplexErrorProp exp(ComplexErrorProp aa) {
        ComplexErrorProp bb = new ComplexErrorProp();
        ErrorProp pre = ErrorProp.exp(aa.eReal);
        bb.eReal = pre.times(ErrorProp.cos(aa.eImag), aa.corrCoeff);
        bb.eImag = pre.times(ErrorProp.sin(aa.eImag), aa.corrCoeff);
        return bb;
    }

    public ComplexErrorProp exp() {
        ComplexErrorProp bb = new ComplexErrorProp();
        ErrorProp pre = ErrorProp.exp(this.eReal);
        bb.eReal = pre.times(ErrorProp.cos(this.eImag), this.corrCoeff);
        bb.eImag = pre.times(ErrorProp.sin(this.eImag), this.corrCoeff);
        return bb;
    }

    public static ErrorProp abs(ComplexErrorProp aa) {
        ErrorProp bb = new ErrorProp();
        double realV = aa.eReal.getValue();
        double imagV = aa.eImag.getValue();
        double rmod = Math.abs(realV);
        double imod = Math.abs(imagV);
        double ratio = 0.0;
        double res = 0.0;
        if (rmod == 0.0) {
            res = imod;
        } else {
            if (imod == 0.0) {
                res = rmod;
            }
            if (rmod >= imod) {
                ratio = imagV / realV;
                res = rmod * Math.sqrt(1.0 + ratio * ratio);
            } else {
                ratio = realV / imagV;
                res = imod * Math.sqrt(1.0 + ratio * ratio);
            }
        }
        bb.setValue(res);
        double realE = aa.eReal.getError();
        double imagE = aa.eImag.getError();
        res = ComplexErrorProp.hypotWithRho(2.0 * realE * realV, 2.0 * imagE * imagV, aa.corrCoeff);
        bb.setError(res);
        return bb;
    }

    public ErrorProp abs() {
        ErrorProp aa = new ErrorProp();
        double realV = this.eReal.getValue();
        double imagV = this.eImag.getValue();
        double rmod = Math.abs(realV);
        double imod = Math.abs(imagV);
        double ratio = 0.0;
        double res = 0.0;
        if (rmod == 0.0) {
            res = imod;
        } else {
            if (imod == 0.0) {
                res = rmod;
            }
            if (rmod >= imod) {
                ratio = imagV / realV;
                res = rmod * Math.sqrt(1.0 + ratio * ratio);
            } else {
                ratio = realV / imagV;
                res = imod * Math.sqrt(1.0 + ratio * ratio);
            }
        }
        aa.setValue(res);
        double realE = this.eReal.getError();
        double imagE = this.eImag.getError();
        res = ComplexErrorProp.hypotWithRho(2.0 * realE * realV, 2.0 * imagE * imagV, this.corrCoeff);
        aa.setError(res);
        return aa;
    }

    public static ErrorProp arg(ComplexErrorProp a) {
        ErrorProp b = new ErrorProp();
        b = ErrorProp.atan2(a.eReal, a.eImag, a.corrCoeff);
        return b;
    }

    public ErrorProp arg(double rho) {
        ErrorProp a = new ErrorProp();
        a = ErrorProp.atan2(this.eReal, this.eImag, this.corrCoeff);
        return a;
    }

    public static double hypotWithRho(double aa, double bb, double rho) {
        double amod = Math.abs(aa);
        double bmod = Math.abs(bb);
        double cc = 0.0;
        double ratio = 0.0;
        if (amod == 0.0) {
            cc = bmod;
        } else if (bmod == 0.0) {
            cc = amod;
        } else if (amod >= bmod) {
            ratio = bmod / amod;
            cc = amod * Math.sqrt(1.0 + ratio * ratio + 2.0 * rho * ratio);
        } else {
            ratio = amod / bmod;
            cc = bmod * Math.sqrt(1.0 + ratio * ratio + 2.0 * rho * ratio);
        }
        return cc;
    }

    public static ComplexErrorProp truncate(ComplexErrorProp x, int prec) {
        if (prec < 0) {
            return x;
        }
        double rV = x.eReal.getValue();
        double rE = x.eReal.getError();
        double iV = x.eImag.getValue();
        double iE = x.eImag.getError();
        ComplexErrorProp y = new ComplexErrorProp();
        rV = Fmath.truncate(rV, prec);
        rE = Fmath.truncate(rE, prec);
        iV = Fmath.truncate(iV, prec);
        iE = Fmath.truncate(iE, prec);
        y.reset(rV, rE, iV, iE);
        return y;
    }

    public ComplexErrorProp truncate(int prec) {
        if (prec < 0) {
            return this;
        }
        double rV = this.eReal.getValue();
        double rE = this.eReal.getError();
        double iV = this.eImag.getValue();
        double iE = this.eImag.getError();
        ComplexErrorProp y = new ComplexErrorProp();
        rV = Fmath.truncate(rV, prec);
        rE = Fmath.truncate(rE, prec);
        iV = Fmath.truncate(iV, prec);
        iE = Fmath.truncate(iE, prec);
        y.reset(rV, rE, iV, iE);
        return y;
    }

    public String toString() {
        return "Real part: " + this.eReal.getValue() + ", error = " + this.eReal.getError() + "; Imaginary part: " + this.eImag.getValue() + ", error = " + this.eImag.getError();
    }

    public static String toString(ComplexErrorProp aa) {
        return "Real part: " + aa.eReal.getValue() + ", error = " + aa.eReal.getError() + "; Imaginary part: " + aa.eImag.getValue() + ", error = " + aa.eImag.getError();
    }

    public void println(String message) {
        System.out.println(message + " " + this.toString());
    }

    public void println() {
        System.out.println(" " + this.toString());
    }

    public void print(String message) {
        System.out.print(message + " " + this.toString());
    }

    public void print() {
        System.out.print(" " + this.toString());
    }
}

