/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.complex.Complex;
import flanagan.math.Fmath;

public class Impedance {
    protected static int numberOfModels = 44;

    public static Complex resistanceImpedance(double resistance) {
        return new Complex(resistance, 0.0);
    }

    public static Complex capacitanceImpedance(double capacitance, double omega) {
        return new Complex(0.0, -1.0 / (capacitance * omega));
    }

    public static Complex inductanceImpedance(double inductance, double omega) {
        return new Complex(0.0, inductance * omega);
    }

    public static Complex infiniteWarburgImpedance(double sigma, double omega) {
        double term = sigma / Math.sqrt(omega);
        return new Complex(term, -term);
    }

    public static Complex finiteWarburgImpedance(double sigma, double tanhConst, double omega) {
        Complex zVal1 = new Complex(sigma * Math.sqrt(omega), 0.0);
        Complex zVal2 = new Complex(tanhConst, 0.0);
        Complex zVal3 = new Complex(0.0, omega);
        Complex zVal4 = Complex.sqrt(zVal3);
        Complex zVal5 = zVal2.times(zVal4);
        Complex zVal6 = Complex.tanh(zVal5);
        Complex zVal7 = zVal1.times(zVal6);
        Complex zVal8 = Complex.plusOne().minus(Complex.plusJay());
        return zVal8.times(zVal7);
    }

    public static Complex constantPhaseElementImpedance(double cpeCoeff, double alpha, double omega) {
        Complex jOmega = new Complex(0.0, omega);
        Complex jOmegaAlpha = Complex.pow(jOmega, -alpha);
        Complex coeff = new Complex(cpeCoeff, 0.0);
        return coeff.times(jOmegaAlpha);
    }

    public static Complex impedanceInSeries(Complex z1, Complex z2) {
        return z1.plus(z2);
    }

    public static Complex impedanceInSeries(double z1, Complex z2) {
        return z2.plus(z1);
    }

    public static Complex impedanceInSeries(Complex z1, double z2) {
        return z1.plus(z2);
    }

    public static Complex impedanceInSeries(double z1, double z2) {
        return new Complex(z1 + z2, 0.0);
    }

    public static Complex rInSeriesWithC(double res, double cap, double omega) {
        Complex ret = new Complex(res, -1.0 / (cap * omega));
        return ret;
    }

    public static Complex rInSeriesWithL(double res, double ind, double omega) {
        Complex ret = new Complex(res, ind * omega);
        return ret;
    }

    public static Complex cInSeriesWithL(double cap, double ind, double omega) {
        Complex z1 = new Complex(0.0, -1.0 / (cap * omega));
        Complex z2 = new Complex(0.0, ind * omega);
        return z1.plus(z2);
    }

    public static Complex impedanceInParallel(Complex z1, Complex z2) {
        Complex ret = z1.times(z2);
        return ret.over(z1.plus(z2));
    }

    public static Complex impedanceInParallel(Complex z1, double z2) {
        Complex ret = z1.times(z2);
        return ret.over(z1.plus(z2));
    }

    public static Complex impedanceInParallel(double z1, Complex z2) {
        Complex ret = z2.times(z1);
        return ret.over(z2.plus(z1));
    }

    public static Complex impedanceInParallel(double z1, double z2) {
        return new Complex(z1 * z2 / (z1 + z2), 0.0);
    }

    public static Complex rInParallelWithC(double res, double cap, double omega) {
        Complex zC = new Complex(0.0, -1.0 / (cap * omega));
        Complex zR = new Complex(res, 0.0);
        Complex ret = zC.times(zR);
        return ret.over(zC.plus(zR));
    }

    public static Complex rInParallelWithL(double res, double ind, double omega) {
        Complex zL = new Complex(0.0, ind * omega);
        Complex zR = new Complex(res, 0.0);
        Complex ret = zL.times(zR);
        return ret.over(zL.plus(zR));
    }

    public static Complex cInParallelWithL(double cap, double ind, double omega) {
        Complex z1 = new Complex(0.0, -1.0 / (cap * omega));
        Complex z2 = new Complex(0.0, ind * omega);
        Complex z3 = z1.plus(z2);
        Complex z4 = z1.times(z2);
        return z4.over(z3);
    }

    public static String[] modelComponents(int modelNumber) {
        String[][] compName = new String[][]{{" "}, {"R1"}, {"C1"}, {"L1"}, {"W1"}, {"Fsigma1", "Fdelta1"}, {"Qsigma1", "Qalpha1"}, {"R1", "C1"}, {"R1", "L1"}, {"L1", "C1"}, {"R1", "C1"}, {"R1", "L1"}, {"L1", "C1"}, {"R1", "C1", "R2"}, {"R1", "C1", "R2", "L1"}, {"R1", "C1", "R2", "L1"}, {"R1", "C1", "C2"}, {"R1", "C1", "C2"}, {"R1", "C1", "R2", "C2"}, {"R1", "C1", "R2", "C2"}, {"R1", "C1", "R2", "C2", "R3"}, {"R1", "C1", "R2", "C2", "R3"}, {"R1", "C1", "R2", "C2", "R3", "C3"}, {"R1", "C1", "R2", "C2", "R3", "C3", "R4"}, {"R1", "C1", "W1", "R2"}, {"R1", "C1", "Fsigma1", "Fdelta1", "R2"}, {"R1", "C1", "Qsigma1", "Qalpha1", "R2"}, {"R1", "C1", "R2", "C2", "W1"}, {"R1", "C1", "R2", "C2", "W3", "C3", "R4"}, {"R1", "C1", "R2", "Qsigma1", "Qalpha1"}, {"R1", "C1", "R2", "Qsigma1", "Qalpha1", "R3"}, {"R1", "Qsigma1", "Qalpha1", "R2", "Qsigma2", "Qalpha2", "R3", "Qsigma3", "Qalpha3"}, {"R1", "Qsigma1", "Qalpha1", "R2", "Qsigma2", "Qalpha2", "R3", "Qsigma3", "Qalpha3", "R4"}, {"R1", "Qsigma1", "Qalpha1", "R2", "Qsigma2", "Qalpha2", "R3", "Qsigma3", "Qalpha3", "R4", "C1"}, {"C1", "Qsigma1", "Qalpha1", "C2", "Qsigma2", "Qalpha2", "C3", "Qsigma3", "Qalpha3"}, {"C1", "Qsigma1", "Qalpha1", "C2", "Qsigma2", "Qalpha2", "C3", "Qsigma3", "Qalpha3", "R1"}, {"R1", "Qsigma1", "Qalpha1", "C1", "R2", "Qsigma2", "Qalpha2", "C2", "R3", "Qsigma3", "Qalpha3", "C3"}, {"R1", "Qsigma1", "Qalpha1", "C1", "R2", "Qsigma2", "Qalpha2", "C2", "R3", "Qsigma3", "Qalpha3", "C3", "R4"}, {"R1", "Qsigma1", "Qalpha1", "C1", "R2", "Qsigma2", "Qalpha2", "C2"}, {"R1", "Qsigma1", "Qalpha1", "C1", "R2", "Qsigma2", "Qalpha2", "C2", "R3"}, {"R1", "Qsigma1", "Qalpha1", "R2", "Qsigma2", "Qalpha2", "R3", "Qsigma3", "Qalpha3", "R4", "C1"}, {"R1", "Qsigma1", "Qalpha1", "R2", "C2", "R3", "Qsigma3", "Qalpha3", "R4", "C1"}, {"R1", "Qsigma1", "Qalpha1", "R2", "C2", "R3", "Qsigma3", "Qalpha3", "R4"}, {"R1", "Qsigma1", "Qalpha1", "R2", "Qsigma2", "Qalpha2", "R3", "Qsigma3", "Qalpha3", "R4", "C1"}, {"R1", "Qsigma1", "Qalpha1", "R2", "Qsigma2", "Qalpha2", "R3", "C1"}};
        return compName[modelNumber];
    }

    public static Complex modelImpedance(double[] parameter, double omega, int modelNumber) {
        Complex zVal = null;
        Complex z1 = null;
        Complex z2 = null;
        Complex z3 = null;
        Complex z4 = null;
        switch (modelNumber) {
            case 1: {
                zVal = Impedance.resistanceImpedance(parameter[0]);
                break;
            }
            case 2: {
                zVal = Impedance.capacitanceImpedance(parameter[0], omega);
                break;
            }
            case 3: {
                zVal = Impedance.inductanceImpedance(parameter[0], omega);
                break;
            }
            case 4: {
                zVal = Impedance.infiniteWarburgImpedance(parameter[0], omega);
                break;
            }
            case 5: {
                zVal = Impedance.finiteWarburgImpedance(parameter[0], parameter[1], omega);
                break;
            }
            case 6: {
                zVal = Impedance.constantPhaseElementImpedance(parameter[0], parameter[1], omega);
                break;
            }
            case 7: {
                zVal = Impedance.rInSeriesWithC(parameter[0], parameter[1], omega);
                break;
            }
            case 8: {
                zVal = new Complex(parameter[0], parameter[1] * omega);
                break;
            }
            case 9: {
                z1 = new Complex(0.0, -1.0 / (parameter[0] * omega));
                z2 = new Complex(0.0, parameter[1] * omega);
                zVal = Impedance.impedanceInSeries(z1, z2);
                break;
            }
            case 10: {
                zVal = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                break;
            }
            case 11: {
                z1 = new Complex(parameter[0], 0.0);
                z2 = new Complex(0.0, parameter[1] * omega);
                zVal = Impedance.impedanceInParallel(z1, z2);
                break;
            }
            case 12: {
                z1 = new Complex(0.0, -1.0 / (parameter[0] * omega));
                z2 = new Complex(0.0, parameter[1] * omega);
                zVal = Impedance.impedanceInParallel(z1, z2);
                break;
            }
            case 13: {
                zVal = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                zVal = zVal.plus(parameter[2]);
                break;
            }
            case 14: {
                zVal = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                zVal = zVal.plus(parameter[2]);
                z1 = new Complex(0.0, parameter[3] * omega);
                zVal = zVal.plus(z1);
                break;
            }
            case 15: {
                zVal = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                zVal = zVal.plus(parameter[2]);
                z1 = new Complex(0.0, parameter[3] * omega);
                zVal = Impedance.impedanceInParallel(zVal, z1);
                break;
            }
            case 16: {
                zVal = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                z2 = new Complex(0.0, -1.0 / (parameter[2] * omega));
                zVal = zVal.plus(z2);
                break;
            }
            case 17: {
                z1 = new Complex(parameter[0], -1.0 / (parameter[1] * omega));
                z2 = new Complex(0.0, -1.0 / (parameter[2] * omega));
                zVal = z1.times(z2).over(z2.plus(z1));
                break;
            }
            case 18: {
                z1 = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                z2 = new Complex(parameter[2], -1.0 / (parameter[3] * omega));
                zVal = z1.plus(z2);
                break;
            }
            case 19: {
                z1 = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                z2 = Impedance.rInParallelWithC(parameter[2], parameter[3], omega);
                zVal = z1.plus(z2);
                break;
            }
            case 20: {
                z1 = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                z2 = Impedance.rInParallelWithC(parameter[2], parameter[3], omega);
                zVal = z1.plus(z2);
                zVal = zVal.plus(parameter[4]);
                break;
            }
            case 21: {
                z1 = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                z2 = z1.plus(parameter[2]);
                z3 = new Complex(0.0, -1.0 / (parameter[3] * omega));
                z4 = Impedance.impedanceInParallel(z2, z3);
                zVal = z4.plus(parameter[4]);
                break;
            }
            case 22: {
                z1 = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                z2 = Impedance.rInParallelWithC(parameter[2], parameter[3], omega);
                zVal = z1.plus(z2);
                z3 = Impedance.rInParallelWithC(parameter[4], parameter[5], omega);
                zVal = zVal.plus(z3);
                break;
            }
            case 23: {
                z1 = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                z2 = Impedance.rInParallelWithC(parameter[2], parameter[3], omega);
                zVal = z1.plus(z2);
                z3 = Impedance.rInParallelWithC(parameter[4], parameter[5], omega);
                zVal = zVal.plus(z3);
                zVal = zVal.plus(parameter[6]);
                break;
            }
            case 24: {
                z1 = Impedance.infiniteWarburgImpedance(parameter[2], omega);
                z2 = Impedance.impedanceInSeries(parameter[0], z1);
                z3 = Impedance.capacitanceImpedance(parameter[1], omega);
                z4 = Impedance.impedanceInParallel(z2, z3);
                zVal = Impedance.impedanceInSeries(z4, parameter[3]);
                break;
            }
            case 25: {
                z1 = Impedance.finiteWarburgImpedance(parameter[2], parameter[3], omega);
                z2 = Impedance.impedanceInSeries(parameter[0], z1);
                z3 = Impedance.capacitanceImpedance(parameter[1], omega);
                z4 = Impedance.impedanceInParallel(z2, z3);
                zVal = Impedance.impedanceInSeries(z4, parameter[4]);
                break;
            }
            case 26: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[2], parameter[3], omega);
                z2 = Impedance.impedanceInSeries(parameter[0], z1);
                z3 = Impedance.capacitanceImpedance(parameter[1], omega);
                z4 = Impedance.impedanceInParallel(z2, z3);
                zVal = Impedance.impedanceInSeries(z4, parameter[4]);
                break;
            }
            case 27: {
                z1 = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                z2 = Impedance.rInParallelWithC(parameter[2], parameter[3], omega);
                zVal = z1.plus(z2);
                z3 = Impedance.infiniteWarburgImpedance(parameter[4], omega);
                zVal = zVal.plus(z3);
                break;
            }
            case 28: {
                z1 = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                z2 = Impedance.rInParallelWithC(parameter[2], parameter[3], omega);
                zVal = z1.plus(z2);
                z3 = Impedance.infiniteWarburgImpedance(parameter[4], omega);
                z4 = new Complex(0.0, -1.0 / (parameter[5] * omega));
                z4 = Impedance.impedanceInParallel(z3, z4);
                zVal = zVal.plus(z4);
                zVal = zVal.plus(parameter[6]);
                break;
            }
            case 29: {
                z1 = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                z2 = Impedance.constantPhaseElementImpedance(parameter[3], parameter[4], omega);
                z3 = Impedance.impedanceInParallel(z2, parameter[2]);
                zVal = z1.plus(z3);
                break;
            }
            case 30: {
                z1 = Impedance.rInParallelWithC(parameter[0], parameter[1], omega);
                z2 = Impedance.constantPhaseElementImpedance(parameter[3], parameter[4], omega);
                z3 = Impedance.impedanceInParallel(z2, parameter[2]);
                zVal = z1.plus(z3);
                zVal = zVal.plus(parameter[5]);
                break;
            }
            case 31: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                zVal = Impedance.impedanceInParallel(z1, parameter[0]);
                z1 = Impedance.constantPhaseElementImpedance(parameter[4], parameter[5], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[3]);
                zVal = zVal.plus(z2);
                z1 = Impedance.constantPhaseElementImpedance(parameter[7], parameter[8], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[6]);
                zVal = zVal.plus(z2);
                break;
            }
            case 32: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                zVal = Impedance.impedanceInParallel(z1, parameter[0]);
                z1 = Impedance.constantPhaseElementImpedance(parameter[4], parameter[5], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[3]);
                zVal = zVal.plus(z2);
                z1 = Impedance.constantPhaseElementImpedance(parameter[7], parameter[8], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[6]);
                zVal = zVal.plus(z2);
                zVal = zVal.plus(parameter[9]);
                break;
            }
            case 33: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                zVal = Impedance.impedanceInParallel(z1, parameter[0]);
                z1 = Impedance.constantPhaseElementImpedance(parameter[4], parameter[5], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[3]);
                zVal = zVal.plus(z2);
                z1 = Impedance.constantPhaseElementImpedance(parameter[7], parameter[8], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[6]);
                zVal = zVal.plus(z2);
                zVal = zVal.plus(parameter[9]);
                z3 = new Complex(0.0, -1.0 / (parameter[10] * omega));
                zVal = Impedance.impedanceInParallel(zVal, z3);
                break;
            }
            case 34: {
                z1 = new Complex(0.0, -1.0 / (parameter[0] * omega));
                z2 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                zVal = Impedance.impedanceInParallel(z1, z2);
                z1 = new Complex(0.0, -1.0 / (parameter[3] * omega));
                z2 = Impedance.constantPhaseElementImpedance(parameter[4], parameter[5], omega);
                z3 = Impedance.impedanceInParallel(z1, z2);
                zVal = zVal.plus(z3);
                z1 = new Complex(0.0, -1.0 / (parameter[6] * omega));
                z2 = Impedance.constantPhaseElementImpedance(parameter[7], parameter[8], omega);
                z3 = Impedance.impedanceInParallel(z1, z2);
                zVal = zVal.plus(z3);
                break;
            }
            case 35: {
                z1 = new Complex(0.0, -1.0 / (parameter[0] * omega));
                z2 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                zVal = Impedance.impedanceInParallel(z1, z2);
                z1 = new Complex(0.0, -1.0 / (parameter[3] * omega));
                z2 = Impedance.constantPhaseElementImpedance(parameter[4], parameter[5], omega);
                z3 = Impedance.impedanceInParallel(z1, z2);
                zVal = zVal.plus(z3);
                z1 = new Complex(0.0, -1.0 / (parameter[6] * omega));
                z2 = Impedance.constantPhaseElementImpedance(parameter[7], parameter[8], omega);
                z3 = Impedance.impedanceInParallel(z1, z2);
                zVal = zVal.plus(z3);
                zVal = zVal.plus(parameter[9]);
                break;
            }
            case 36: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                z2 = z1.plus(parameter[0]);
                z3 = new Complex(0.0, -1.0 / (parameter[3] * omega));
                zVal = Impedance.impedanceInParallel(z2, z3);
                z1 = Impedance.constantPhaseElementImpedance(parameter[5], parameter[6], omega);
                z2 = z1.plus(parameter[4]);
                z3 = new Complex(0.0, -1.0 / (parameter[7] * omega));
                z4 = Impedance.impedanceInParallel(z2, z3);
                zVal = zVal.plus(z4);
                z1 = Impedance.constantPhaseElementImpedance(parameter[9], parameter[10], omega);
                z2 = z1.plus(parameter[8]);
                z3 = new Complex(0.0, -1.0 / (parameter[11] * omega));
                z4 = Impedance.impedanceInParallel(z2, z3);
                zVal = zVal.plus(z4);
                break;
            }
            case 37: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                z2 = z1.plus(parameter[0]);
                z3 = new Complex(0.0, -1.0 / (parameter[3] * omega));
                zVal = Impedance.impedanceInParallel(z2, z3);
                z1 = Impedance.constantPhaseElementImpedance(parameter[5], parameter[6], omega);
                z2 = z1.plus(parameter[4]);
                z3 = new Complex(0.0, -1.0 / (parameter[7] * omega));
                z4 = Impedance.impedanceInParallel(z2, z3);
                zVal = zVal.plus(z4);
                z1 = Impedance.constantPhaseElementImpedance(parameter[9], parameter[10], omega);
                z2 = z1.plus(parameter[8]);
                z3 = new Complex(0.0, -1.0 / (parameter[11] * omega));
                z4 = Impedance.impedanceInParallel(z2, z3);
                zVal = zVal.plus(z4);
                zVal = zVal.plus(parameter[12]);
                break;
            }
            case 38: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                z2 = z1.plus(parameter[0]);
                z3 = new Complex(0.0, -1.0 / (parameter[3] * omega));
                zVal = Impedance.impedanceInParallel(z2, z3);
                z1 = Impedance.constantPhaseElementImpedance(parameter[5], parameter[6], omega);
                z2 = z1.plus(parameter[4]);
                z3 = new Complex(0.0, -1.0 / (parameter[7] * omega));
                z4 = Impedance.impedanceInParallel(z2, z3);
                zVal = zVal.plus(z4);
                break;
            }
            case 39: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                z2 = z1.plus(parameter[0]);
                z3 = new Complex(0.0, -1.0 / (parameter[3] * omega));
                zVal = Impedance.impedanceInParallel(z2, z3);
                z1 = Impedance.constantPhaseElementImpedance(parameter[5], parameter[6], omega);
                z2 = z1.plus(parameter[4]);
                z3 = new Complex(0.0, -1.0 / (parameter[7] * omega));
                z4 = Impedance.impedanceInParallel(z2, z3);
                zVal = zVal.plus(z4);
                zVal = z4.plus(parameter[8]);
                break;
            }
            case 40: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                zVal = Impedance.impedanceInParallel(z1, parameter[0]);
                z1 = Impedance.constantPhaseElementImpedance(parameter[4], parameter[5], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[3]);
                zVal = zVal.plus(z2);
                z1 = Impedance.constantPhaseElementImpedance(parameter[7], parameter[8], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[6]);
                zVal = zVal.plus(z2);
                z3 = new Complex(0.0, -1.0 / (parameter[10] * omega));
                zVal = Impedance.impedanceInParallel(zVal, z3);
                zVal = zVal.plus(parameter[9]);
                break;
            }
            case 41: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                zVal = Impedance.impedanceInParallel(z1, parameter[0]);
                z1 = new Complex(0.0, -1.0 / (parameter[4] * omega));
                z2 = Impedance.impedanceInParallel(z1, parameter[3]);
                zVal = zVal.plus(z2);
                z1 = Impedance.constantPhaseElementImpedance(parameter[6], parameter[7], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[5]);
                zVal = zVal.plus(z2);
                z3 = new Complex(0.0, -1.0 / (parameter[9] * omega));
                zVal = Impedance.impedanceInParallel(zVal, z3);
                zVal = zVal.plus(parameter[8]);
                break;
            }
            case 42: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                zVal = Impedance.impedanceInParallel(z1, parameter[0]);
                z1 = new Complex(0.0, -1.0 / (parameter[4] * omega));
                z2 = Impedance.impedanceInParallel(z1, parameter[3]);
                zVal = zVal.plus(z2);
                z1 = Impedance.constantPhaseElementImpedance(parameter[6], parameter[7], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[5]);
                zVal = zVal.plus(z2);
                zVal = zVal.plus(parameter[8]);
                break;
            }
            case 43: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                zVal = Impedance.impedanceInParallel(z1, parameter[0]);
                z1 = Impedance.constantPhaseElementImpedance(parameter[4], parameter[5], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[3]);
                zVal = zVal.plus(z2);
                z1 = Impedance.constantPhaseElementImpedance(parameter[7], parameter[8], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[6]);
                zVal = zVal.plus(z2);
                zVal = zVal.plus(parameter[9]);
                z3 = new Complex(0.0, -1.0 / (parameter[10] * omega));
                zVal = Impedance.impedanceInParallel(zVal, z3);
                break;
            }
            case 44: {
                z1 = Impedance.constantPhaseElementImpedance(parameter[1], parameter[2], omega);
                zVal = Impedance.impedanceInParallel(z1, parameter[0]);
                z1 = Impedance.constantPhaseElementImpedance(parameter[4], parameter[5], omega);
                z2 = Impedance.impedanceInParallel(z1, parameter[3]);
                zVal = zVal.plus(z2);
                zVal = zVal.plus(parameter[6]);
                z3 = new Complex(0.0, -1.0 / (parameter[7] * omega));
                zVal = Impedance.impedanceInParallel(zVal, z3);
                break;
            }
            default: {
                throw new IllegalArgumentException("No model " + modelNumber + " exists");
            }
        }
        return zVal;
    }

    public static double warburgSigma(double electrodeArea, double oxidantDiffCoeff, double oxidantConcn, double reductantDiffCoeff, double reductantConcn, double tempCelsius, int electronsTransferred) {
        double firstTerm = 8.31447215 * (tempCelsius - -273.15) / (Fmath.square((double)electronsTransferred * 96485.341539) * electrodeArea * Math.sqrt(2.0));
        double secondTerm = 1.0 / (oxidantConcn * Math.sqrt(oxidantDiffCoeff));
        double thirdTerm = 1.0 / (reductantConcn * Math.sqrt(reductantDiffCoeff));
        return firstTerm * (secondTerm + thirdTerm);
    }

    public static double parallelPlateCapacitance(double plateArea, double plateSeparation, double relativePermittivity) {
        return plateArea * relativePermittivity * 8.854187817E-12 / plateSeparation;
    }

    public static double parallelPlateCapacitance(double plateLength, double plateWidth, double plateSeparation, double relativePermittivity) {
        return plateLength * plateWidth * relativePermittivity * 8.854187817E-12 / plateSeparation;
    }

    public static double coaxialCapacitance(double cylinderLength, double innerRadius, double outerRadius, double relativePermittivity) {
        return Math.PI * 2 * relativePermittivity * 8.854187817E-12 * cylinderLength / Math.log(outerRadius / innerRadius);
    }

    public static double parallelWiresCapacitance(double wireLength, double wireRadius, double wireSeparation, double relativePermittivity) {
        return Math.PI * relativePermittivity * 8.854187817E-12 * wireLength / Math.log((wireSeparation - wireRadius) / wireRadius);
    }

    public static double parallelPlateInductance(double plateLength, double plateWidth, double plateSeparation, double relativePermeability) {
        return relativePermeability * 1.2566370614359173E-6 * plateSeparation * plateLength / plateWidth;
    }

    public static double coaxialInductance(double cylinderLength, double innerRadius, double outerRadius, double relativePermeability) {
        return relativePermeability * 1.2566370614359173E-6 * cylinderLength * Math.log(outerRadius / innerRadius) / (Math.PI * 2);
    }

    public static double parallelWiresInductance(double wireLength, double wireRadius, double wireSeparation, double relativePermeability) {
        return relativePermeability * 1.2566370614359173E-6 * wireLength * Math.log((wireSeparation - wireRadius) / wireRadius) / Math.PI;
    }

    public static double getMagnitude(Complex variable) {
        return variable.abs();
    }

    public static double getPhaseRad(Complex variable) {
        return variable.argRad();
    }

    public static double getPhaseDeg(Complex variable) {
        return variable.argDeg();
    }

    public static Complex polarRad(double magnitude, double phase) {
        Complex aa = new Complex();
        aa.polarRad(magnitude, phase);
        return aa;
    }

    public static Complex polarDeg(double magnitude, double phase) {
        Complex aa = new Complex();
        aa.polarDeg(magnitude, phase);
        return aa;
    }

    public static double frequencyToRadialFrequency(double frequency) {
        return Math.PI * 2 * frequency;
    }

    public static double radialFrequencyToFrequency(double omega) {
        return omega / (Math.PI * 2);
    }

    public static double resistanceAluminium(double length, double area, double tempC) {
        double rho = 2.824E-8;
        double alpha = 0.0039;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceAluminum(double length, double area, double tempC) {
        double rho = 2.824E-8;
        double alpha = 0.0039;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceHardDrawnCopper(double length, double area, double tempC) {
        double rho = 1.771E-8;
        double alpha = 0.00382;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceAnnealedCopper(double length, double area, double tempC) {
        double rho = 1.7241E-8;
        double alpha = 0.00393;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceIron(double length, double area, double tempC) {
        double rho = 1.0E-7;
        double alpha = 0.005;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceManganeseSteel(double length, double area, double tempC) {
        double rho = 7.0E-7;
        double alpha = 0.001;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceSiemensMartinSteel(double length, double area, double tempC) {
        double rho = 1.8E-7;
        double alpha = 0.003;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceBBSteel(double length, double area, double tempC) {
        double rho = 1.19E-7;
        double alpha = 0.004;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceEBBSteel(double length, double area, double tempC) {
        double rho = 1.04E-7;
        double alpha = 0.005;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceBrass(double length, double area, double tempC) {
        double rho = 7.4E-8;
        double alpha = 0.002;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceDrawnTunsten(double length, double area, double tempC) {
        double rho = 5.6E-8;
        double alpha = 0.0045;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceSilver(double length, double area, double tempC) {
        double rho = 1.59E-8;
        double alpha = 0.0038;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceGold(double length, double area, double tempC) {
        double rho = 2.84E-8;
        double alpha = 0.0034;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistancePlatinum(double length, double area, double tempC) {
        double rho = 1.0E-7;
        double alpha = 0.003;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceNickel(double length, double area, double tempC) {
        double rho = 7.8E-8;
        double alpha = 0.006;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceMolybdenum(double length, double area, double tempC) {
        double rho = 5.7E-8;
        double alpha = 0.004;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistancePhosphorBronze(double length, double area, double tempC) {
        double rho = 1.1E-7;
        double alpha = 0.0033;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceTin(double length, double area, double tempC) {
        double rho = 1.15E-7;
        double alpha = 0.0042;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceNichrome(double length, double area, double tempC) {
        double rho = 1.0E-6;
        double alpha = 4.0E-4;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistancePalladium(double length, double area, double tempC) {
        double rho = 1.1E-7;
        double alpha = 0.0033;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceTantalum(double length, double area, double tempC) {
        double rho = 1.55E-7;
        double alpha = 0.0031;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceTherlo(double length, double area, double tempC) {
        double rho = 4.7E-7;
        double alpha = 1.0E-5;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceMonelMetal(double length, double area, double tempC) {
        double rho = 4.2E-7;
        double alpha = 0.002;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceManganan(double length, double area, double tempC) {
        double rho = 4.4E-7;
        double alpha = 1.0E-5;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceConstantan(double length, double area, double tempC) {
        double rho = 4.9E-7;
        double alpha = 1.0E-5;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceAntimony(double length, double area, double tempC) {
        double rho = 4.17E-7;
        double alpha = 0.0036;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceCobalt(double length, double area, double tempC) {
        double rho = 9.8E-8;
        double alpha = 0.0033;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceMagnesium(double length, double area, double tempC) {
        double rho = 4.6E-8;
        double alpha = 0.004;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceZinc(double length, double area, double tempC) {
        double rho = 5.8E-8;
        double alpha = 0.0037;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceMercury(double length, double area, double tempC) {
        double rho = 9.5738E-7;
        double alpha = 8.9E-4;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceLead(double length, double area, double tempC) {
        double rho = 2.2E-7;
        double alpha = 0.0039;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistanceGermanSilver(double length, double area, double tempC) {
        double rho = 3.3E-7;
        double alpha = 4.0E-4;
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistivityToResistance(double rho, double alpha, double length, double area, double tempC) {
        double resistance20 = rho * length / area;
        return resistance20 * (1.0 + alpha * (tempC - 20.0));
    }

    public static double resistivityToResistance(double rho, double length, double area) {
        return rho * length / area;
    }

    public static double resistanceToResistivity(double resistance, double length, double area) {
        return resistance * area / length;
    }
}

