/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.SeqChangeFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.IOException;

public class SeqChangeFileTxt
extends SeqChangeFileIterator {
    public SeqChangeFileTxt(String fileName, Genome genome, int positionBase) {
        super(fileName, genome, positionBase);
    }

    @Override
    protected SeqChange readNext() {
        try {
            while (this.ready()) {
                String line = this.readLine();
                if (line == null) {
                    return null;
                }
                if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                String[] fields = line.split("\t");
                if (fields.length >= 4) {
                    String chromosome = fields[0].trim();
                    Chromosome chromo = this.getChromosome(chromosome);
                    this.sanityCheckChromo(chromosome, chromo);
                    int start = this.parsePosition(fields[1]);
                    String reference = fields[2];
                    String change = fields[3];
                    int strand = 1;
                    if (fields.length >= 5) {
                        String strandStr = fields[4];
                        if (strandStr.charAt(0) == '+') {
                            strand = 1;
                        } else if (strandStr.charAt(0) == '-') {
                            strand = -1;
                        }
                    }
                    double quality = -1.0;
                    if (fields.length >= 6) {
                        quality = Gpr.parseDoubleSafe(fields[5]);
                    }
                    int coverage = -1;
                    if (fields.length >= 7) {
                        coverage = Gpr.parseIntSafe(fields[6]);
                    }
                    String id = "";
                    if (fields.length >= 8) {
                        id = fields[7];
                    }
                    return new SeqChange(chromo, start, reference, change, strand, id, quality, coverage);
                }
                throw new RuntimeException("Error reading file '" + this.fileName + "' line " + this.lineNum + " (number of fields is " + fields.length + "):\t" + line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

