/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.commons.lang.WordUtils;

public final class StringUtils {
    public static String wrap(String str, int max_width) throws IOException {
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        StringReader sRdr = new StringReader(str);
        BufferedReader bRdr = new BufferedReader(sRdr);
        String line = bRdr.readLine();
        while (line != null) {
            line = line.trim().startsWith("<NOWRAP>") ? line.substring("<NOWRAP>".length()) : WordUtils.wrap((String)line, (int)max_width);
            pWtr.println(line);
            line = bRdr.readLine();
        }
        sWtr.close();
        String wrappedStr = sWtr.toString();
        if (wrappedStr.length() > 0) {
            wrappedStr = wrappedStr.substring(0, wrappedStr.length() - 1);
        }
        return wrappedStr;
    }

    public static String indent(String str, int numIndents) throws IOException {
        String indent = "";
        for (int i = 0; i < numIndents; ++i) {
            indent = indent + "\t";
        }
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        StringReader sRdr = new StringReader(str);
        BufferedReader bRdr = new BufferedReader(sRdr);
        String line = bRdr.readLine();
        while (line != null) {
            pWtr.print(indent);
            pWtr.println(line);
            line = bRdr.readLine();
        }
        sWtr.close();
        String indentedStr = sWtr.toString();
        if (indentedStr.length() > 0) {
            indentedStr = indentedStr.substring(0, indentedStr.length() - 1);
        }
        return indentedStr;
    }
}

