/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class XMLDistributionWriter {
    BufferedWriter out = null;

    private void writeOND2XML(OrderNDistribution ond, OutputStream os) throws IOException {
        Distribution conditionedDist = null;
        FiniteAlphabet conditionedAlpha = null;
        this.out = new BufferedWriter(new OutputStreamWriter(os));
        this.out.write("<?xml version=\"1.0\" ?>");
        this.out.write("<Distribution type=\"OrderNDistribution\">");
        this.out.write("<alphabet name=\"" + ond.getAlphabet().getName() + "\"/>");
        Iterator<Symbol> i = ((FiniteAlphabet)ond.getConditioningAlphabet()).iterator();
        while (i.hasNext()) {
            Symbol sym = i.next();
            this.out.write("<conditioning_symbol name=\"" + sym.getName() + "\">");
            try {
                conditionedDist = ond.getDistribution(sym);
            }
            catch (IllegalSymbolException ex) {
                throw new BioError("Distribution has been built with Illegal Symbols !?", ex);
            }
            conditionedAlpha = (FiniteAlphabet)conditionedDist.getAlphabet();
            Iterator<Symbol> it = conditionedAlpha.iterator();
            while (it.hasNext()) {
                Symbol condSym = it.next();
                double weight = 0.0;
                try {
                    weight = conditionedDist.getWeight(condSym);
                }
                catch (IllegalSymbolException ex) {
                    throw new BioError("Distribution has been built with Illegal Symbols !?", ex);
                }
                this.out.write("<weight sym=\"" + condSym.getName() + "\" prob=\"" + weight + "\"/>");
            }
            this.out.write("</conditioning_symbol>");
        }
        this.out.write("</Distribution>");
        this.out.flush();
    }

    private void writeDist2XML(Distribution d, OutputStream os) throws IOException {
        this.out = new BufferedWriter(new OutputStreamWriter(os));
        this.out.write("<?xml version=\"1.0\" ?>");
        this.out.write("<Distribution type=\"Distribution\">");
        this.out.write("<alphabet name=\"" + d.getAlphabet().getName() + "\"/>");
        Iterator<Symbol> i = ((FiniteAlphabet)d.getAlphabet()).iterator();
        while (i.hasNext()) {
            Symbol sym = i.next();
            double weight = 0.0;
            try {
                weight = d.getWeight(sym);
            }
            catch (IllegalSymbolException ex) {
                throw new BioError("Distribution has been built with Illegal Symbols !?", ex);
            }
            this.out.write("<weight sym=\"" + sym.getName() + "\" prob=\"" + weight + "\"/>");
        }
        this.out.write("</Distribution>");
        this.out.flush();
    }

    public void writeDistribution(Distribution d, OutputStream os) throws IOException {
        if (d instanceof OrderNDistribution) {
            this.writeOND2XML((OrderNDistribution)d, os);
        } else {
            this.writeDist2XML(d, os);
        }
    }
}

