/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola;

import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fastq.FastqVariant;
import ca.mcgill.mcb.pcingola.fileIterator.FastqFileIterator;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import ca.mcgill.mcb.pcingola.util.Timer;

public class Fastq2Fastq {
    public static final int SHOW_EVERY = 100000;

    public static void main(String[] args) {
        FastqVariant fastqVariantIn = FastqVariant.FASTQ_ILLUMINA;
        FastqVariant fastqVariantOut = FastqVariant.FASTQ_SANGER;
        if (args.length != 1) {
            System.err.println("Usage: Fastq2Fastq inFile.fastq > outFile.fastq");
            System.exit(-1);
        }
        String inFile = args[0];
        Timer.showStdErr("Converting lines from FASTQ (Illumina) to FASTQ (Sanger). Input file '" + inFile + "'");
        try {
            int i = 1;
            FastqFileIterator ffi = new FastqFileIterator(inFile, fastqVariantIn);
            for (Fastq fastq : ffi) {
                System.out.println(fastq.getDescription());
                System.out.println(fastq.getSequence());
                System.out.println("+");
                System.out.println(GprSeq.changeQuality(fastq.getQuality(), fastqVariantIn, fastqVariantOut));
                if (i % 100000 == 0) {
                    Timer.showStdErr(i + " sequences.");
                }
                ++i;
            }
            ffi.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

