/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.plot.PlotGraph;

public class PropInt
extends BlackBox {
    private double kp = 1.0;
    private double ti = Double.POSITIVE_INFINITY;
    private double ki = 0.0;

    public PropInt() {
        super("PropInt");
        super.setSnumer(new ComplexPoly(0.0, 1.0));
        super.setSdenom(new ComplexPoly(0.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setKp(double kp) {
        this.sNumer.resetCoeff(1, new Complex(kp, 0.0));
        super.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setKi(double ki) {
        this.ki = ki;
        this.ti = this.kp / ki;
        this.sNumer.resetCoeff(0, new Complex(ki, 0.0));
        super.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setTi(double ti) {
        this.ti = ti;
        this.ki = this.kp / ti;
        this.sNumer.resetCoeff(0, new Complex(this.ki, 0.0));
        super.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public double getKp() {
        return this.kp;
    }

    public double getKi() {
        return this.ki;
    }

    public double getTi() {
        return this.ti;
    }

    @Override
    public void zTransform() {
        super.deadTimeWarning("zTransform");
        if (this.deltaT == 0.0) {
            System.out.println("z-transform attempted in PropInt with a zero sampling period");
        }
        if (this.ztransMethod == 0) {
            this.mapstozAdHoc();
        } else {
            this.zDenom = new ComplexPoly(1);
            Complex[] coef = Complex.oneDarray(2);
            coef[0].reset(-1.0, 0.0);
            coef[1].reset(1.0, 0.0);
            this.zDenom.resetPoly(coef);
            Complex[] zPoles = Complex.oneDarray(1);
            zPoles[0].reset(1.0, 0.0);
            this.zNumer = new ComplexPoly(1);
            Complex[] zZeros = Complex.oneDarray(1);
            double kit = this.ki * this.deltaT;
            switch (this.integMethod) {
                case 0: {
                    coef[0].reset(kit / 2.0 - this.kp, 0.0);
                    coef[1].reset(kit / 2.0 + this.kp, 0.0);
                    this.zNumer.resetPoly(coef);
                    zZeros[0].reset((this.kp - kit / 2.0) / (this.kp + kit / 2.0), 0.0);
                    break;
                }
                case 1: {
                    coef[0].reset(-this.kp, 0.0);
                    coef[1].reset(kit + this.kp, 0.0);
                    this.zNumer.resetPoly(coef);
                    zZeros[0].reset(this.kp / (this.kp + kit), 0.0);
                    break;
                }
                case 2: {
                    coef[0].reset(this.kp - kit, 0.0);
                    coef[1].reset(this.kp, 0.0);
                    this.zNumer.resetPoly(coef);
                    zZeros[0].reset((this.kp - kit) / this.kp, 0.0);
                    break;
                }
                default: {
                    System.out.println("Integration method option in PropInt must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("z-transform not performed");
                }
            }
        }
    }

    @Override
    public void zTransform(double deltaT) {
        super.setDeltaT(deltaT);
        this.zTransform();
    }

    @Override
    public void stepInput(double stepMag, double finalTime) {
        int n = 50;
        double incrT = finalTime / (double)(n - 1);
        double[][] cdata = new double[2][n];
        double sum = 0.0;
        cdata[0][0] = 0.0;
        for (int i = 1; i < n; ++i) {
            cdata[0][i] = cdata[0][i - 1] + incrT;
        }
        double kpterm = this.kp * stepMag;
        int i = 0;
        while (i < n) {
            cdata[1][i] = kpterm + (sum += this.ki * incrT * stepMag);
            double[] dArray = cdata[0];
            int n2 = i++;
            dArray[n2] = dArray[n2] + this.deadTime;
        }
        PlotGraph pg = new PlotGraph(cdata);
        pg.setGraphTitle("Step Input Transient:   Step magnitude = " + stepMag);
        pg.setGraphTitle2(this.getName());
        pg.setXaxisLegend("Time");
        pg.setXaxisUnitsName("s");
        pg.setYaxisLegend("Output");
        pg.setPoint(0);
        pg.plot();
    }

    @Override
    public void stepInput(double finalTime) {
        this.stepInput(1.0, finalTime);
    }

    @Override
    public void rampInput(double rampGradient, int rampOrder, double finalTime) {
        int i;
        int n = 50;
        double incrT = finalTime / (double)(n - 1);
        double[][] cdata = new double[2][n];
        double sum = 0.0;
        cdata[0][0] = 0.0;
        cdata[1][0] = 0.0;
        for (i = 1; i < n; ++i) {
            cdata[0][i] = cdata[0][i - 1] + incrT;
            cdata[1][i] = this.kp * rampGradient * Math.pow(cdata[0][i], rampOrder) + (sum += rampGradient * (Math.pow(cdata[0][i], rampOrder + 1) - Math.pow(cdata[0][i - 1], rampOrder + 1)) / (double)(rampOrder + 1));
        }
        i = 0;
        while (i < n) {
            double[] dArray = cdata[0];
            int n2 = i++;
            dArray[n2] = dArray[n2] + this.deadTime;
        }
        PlotGraph pg = new PlotGraph(cdata);
        pg.setGraphTitle("Ramp (a.t^n) Input Transient:   ramp gradient (a) = " + rampGradient + " ramp order (n) = " + rampOrder);
        pg.setGraphTitle2(this.getName());
        pg.setXaxisLegend("Time");
        pg.setXaxisUnitsName("s");
        pg.setYaxisLegend("Output");
        pg.setPoint(0);
        pg.plot();
    }

    @Override
    public void rampInput(int rampOrder, double finalTime) {
        double rampGradient = 1.0;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    @Override
    public void rampInput(double rampGradient, double finalTime) {
        int rampOrder = 1;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    @Override
    public void rampInput(double finalTime) {
        double rampGradient = 1.0;
        int rampOrder = 1;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    @Override
    public Complex getOutputS(Complex sValue, Complex iinput) {
        this.sValue = sValue;
        this.inputS = iinput;
        Complex term = this.sValue.times(this.kp);
        term = term.plus(this.ki);
        term = term.over(this.sValue);
        this.outputS = term.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    @Override
    public Complex getOutputS() {
        Complex term = this.sValue.times(this.kp);
        term = term.plus(this.ki);
        term = term.over(this.sValue);
        this.outputS = term.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public void calcOutputT(double ttime, double inp) {
        super.setInputT(ttime, inp);
        this.calcOutputT();
    }

    public void calcOutputT() {
        super.deadTimeWarning("calcOutputT()");
        this.outputT[this.sampLen - 1] = this.kp * this.inputT[this.sampLen - 1];
        if (this.forgetFactor == 1.0) {
            switch (this.integMethod) {
                case 0: {
                    this.integrationSum += (this.inputT[this.sampLen - 1] + this.inputT[this.sampLen - 2]) * this.deltaT / 2.0;
                    break;
                }
                case 1: {
                    this.integrationSum += this.inputT[this.sampLen - 1] * this.deltaT;
                    break;
                }
                case 2: {
                    this.integrationSum += this.inputT[this.sampLen - 2] * this.deltaT;
                    break;
                }
                default: {
                    System.out.println("Integration method option in PropInt must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("getOutput not performed");
                    break;
                }
            }
        } else {
            switch (this.integMethod) {
                case 0: {
                    this.integrationSum = 0.0;
                    for (int i = 1; i < this.sampLen; ++i) {
                        this.integrationSum += Math.pow(this.forgetFactor, this.sampLen - 1 - i) * (this.inputT[i - 1] + this.inputT[i]) * this.deltaT / 2.0;
                    }
                    break;
                }
                case 1: {
                    this.integrationSum = 0.0;
                    for (int i = 1; i < this.sampLen; ++i) {
                        this.integrationSum += Math.pow(this.forgetFactor, this.sampLen - 1 - i) * this.inputT[i] * this.deltaT;
                    }
                    break;
                }
                case 2: {
                    this.integrationSum = 0.0;
                    for (int i = 1; i < this.sampLen; ++i) {
                        this.integrationSum += Math.pow(this.forgetFactor, this.sampLen - 1 - i) * this.inputT[i - 1] * this.deltaT;
                    }
                    break;
                }
                default: {
                    System.out.println("Integration method option in PropInt must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("getOutput not performed");
                }
            }
        }
        int n = this.sampLen - 1;
        this.outputT[n] = this.outputT[n] + this.ki * this.integrationSum;
    }

    @Override
    public PropInt copy() {
        if (this == null) {
            return null;
        }
        PropInt bb = new PropInt();
        this.copyBBvariables(bb);
        bb.kp = this.kp;
        bb.ti = this.ti;
        bb.ki = this.ki;
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

