/*
 * Decompiled with CFR 0.152.
 */
package flanagan.plot;

import flanagan.interpolation.CubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Fmath;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

public class Plot
extends Canvas
implements Serializable {
    protected static final long serialVersionUID = 1L;
    protected double[][] data = null;
    protected double[][] copy = null;
    protected int nCurves = 0;
    protected int[] nPoints = null;
    protected int nmPoints = 0;
    protected int niPoints = 200;
    protected int[] pointOpt = null;
    protected int[] pointSize = null;
    protected int npTypes = 8;
    protected boolean[] errorBar = null;
    protected double[][] errors = null;
    protected double[][] errorsCopy = null;
    protected int[] lineOpt = null;
    protected int[] dashLength = null;
    protected boolean[] minMaxOpt = null;
    protected boolean[] trimOpt = null;
    protected int fontSize = 14;
    protected int xLen = 625;
    protected int yLen = 375;
    protected int xBot = 100;
    protected int xTop = this.xBot + this.xLen;
    protected int yTop = 110;
    protected int yBot = this.yTop + this.yLen;
    protected double xLow = 0.0;
    protected double xHigh = 0.0;
    protected double yLow = 0.0;
    protected double yHigh = 0.0;
    protected int xFac = 0;
    protected int yFac = 0;
    protected int xTicks = 0;
    protected int yTicks = 0;
    protected double xMin = 0.0;
    protected double xMax = 0.0;
    protected double yMin = 0.0;
    protected double yMax = 0.0;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;
    protected boolean noXoffset = false;
    protected boolean noYoffset = false;
    protected double xLowFac = 0.75;
    protected double yLowFac = 0.75;
    protected String graphTitle = "  ";
    protected String graphTitle2 = "  ";
    protected String xAxisLegend = "  ";
    protected String xAxisUnits = "  ";
    protected String yAxisLegend = "  ";
    protected String yAxisUnits = "  ";
    protected boolean xZero = false;
    protected boolean yZero = false;
    protected boolean noXunits = true;
    protected boolean noYunits = true;
    protected double[] xAxisNo = new double[50];
    protected double[] yAxisNo = new double[50];
    protected String[] xAxisChar = new String[50];
    protected String[] yAxisChar = new String[50];
    protected int[] axisTicks = new int[50];
    protected static double dataFill = Double.NaN;

    public Plot(double[][] data) {
        this.initialise(data);
    }

    public Plot(double[] xdata, double[] ydata) {
        int xl = xdata.length;
        int yl = ydata.length;
        if (xl != yl) {
            throw new IllegalArgumentException("x-data length is not equal to the y-data length");
        }
        double[][] data = new double[2][xl];
        for (int i = 0; i < xl; ++i) {
            data[0][i] = xdata[i];
            data[1][i] = ydata[i];
        }
        this.initialise(data);
    }

    private void initialise(double[][] cdata) {
        int i;
        this.nCurves = cdata.length / 2;
        this.nPoints = new int[this.nCurves];
        this.lineOpt = new int[this.nCurves];
        this.dashLength = new int[this.nCurves];
        this.trimOpt = new boolean[this.nCurves];
        this.minMaxOpt = new boolean[this.nCurves];
        this.pointOpt = new int[this.nCurves];
        this.pointSize = new int[this.nCurves];
        this.errorBar = new boolean[this.nCurves];
        this.nmPoints = 0;
        int ll = 0;
        for (int i2 = 0; i2 < 2 * this.nCurves; ++i2) {
            ll = cdata[i2].length;
            if (ll <= this.nmPoints) continue;
            this.nmPoints = ll;
        }
        this.data = new double[2 * this.nCurves][this.nmPoints];
        this.copy = new double[2 * this.nCurves][this.nmPoints];
        this.errors = new double[this.nCurves][this.nmPoints];
        this.errorsCopy = new double[this.nCurves][this.nmPoints];
        int k = 0;
        int l1 = 0;
        int l2 = 0;
        boolean testlen = true;
        for (int i3 = 0; i3 < this.nCurves; ++i3) {
            k = 2 * i3;
            testlen = true;
            l1 = cdata[k].length;
            l2 = cdata[k + 1].length;
            if (l1 != l2) {
                throw new IllegalArgumentException("an x and y array length differ");
            }
            this.nPoints[i3] = l1;
        }
        k = 0;
        boolean testopt = true;
        for (i = 0; i < this.nCurves; ++i) {
            testlen = true;
            l1 = this.nPoints[i];
            while (testlen) {
                if (l1 < 0) {
                    throw new IllegalArgumentException("curve array index  " + k + ": blank array");
                }
                if (cdata[k][l1 - 1] != cdata[k][l1 - 1]) {
                    if (cdata[k + 1][l1 - 1] != cdata[k + 1][l1 - 1]) {
                        --l1;
                        testopt = false;
                        continue;
                    }
                    testlen = false;
                    continue;
                }
                testlen = false;
            }
            this.nPoints[i] = l1;
            k += 2;
        }
        k = 0;
        for (i = 0; i < this.nCurves; ++i) {
            int j;
            double[][] xxx = new double[2][this.nPoints[i]];
            for (j = 0; j < this.nPoints[i]; ++j) {
                xxx[0][j] = cdata[k][j];
                xxx[1][j] = cdata[k + 1][j];
            }
            xxx = Plot.doubleSelectionSort(xxx);
            for (j = 0; j < this.nPoints[i]; ++j) {
                cdata[k][j] = xxx[0][j];
                cdata[k + 1][j] = xxx[1][j];
            }
            k += 2;
        }
        k = 0;
        int kk = 1;
        for (int i4 = 0; i4 < this.nCurves; ++i4) {
            int j;
            int rev = 1;
            for (j = 1; j < this.nPoints[i4]; ++j) {
                if (!(cdata[k][j] < cdata[k][j - 1])) continue;
                ++rev;
            }
            if (rev == this.nPoints[i4]) {
                int j2;
                double[] hold = new double[this.nPoints[i4]];
                for (j2 = 0; j2 < this.nPoints[i4]; ++j2) {
                    hold[j2] = cdata[k][j2];
                }
                for (j2 = 0; j2 < this.nPoints[i4]; ++j2) {
                    cdata[k][j2] = hold[this.nPoints[i4] - j2 - 1];
                }
                for (j2 = 0; j2 < this.nPoints[i4]; ++j2) {
                    hold[j2] = cdata[k + 1][j2];
                }
                for (j2 = 0; j2 < this.nPoints[i4]; ++j2) {
                    cdata[k + 1][j2] = hold[this.nPoints[i4] - j2 - 1];
                }
            }
            for (j = 0; j < this.nPoints[i4]; ++j) {
                this.data[k][j] = cdata[k][j];
                this.data[k + 1][j] = cdata[k + 1][j];
                this.copy[k][j] = cdata[k][j];
                this.copy[k + 1][j] = cdata[k + 1][j];
            }
            this.lineOpt[i4] = 1;
            this.dashLength[i4] = 5;
            this.trimOpt[i4] = false;
            if (this.lineOpt[i4] == 1) {
                this.trimOpt[i4] = true;
            }
            this.minMaxOpt[i4] = true;
            this.pointSize[i4] = 6;
            this.errorBar[i4] = false;
            this.pointOpt[i4] = kk++;
            k += 2;
            if (kk <= this.npTypes) continue;
            kk = 1;
        }
    }

    public static double[][] doubleSelectionSort(double[][] aa) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa[0].length;
        double holdx = 0.0;
        double holdy = 0.0;
        double[][] bb = new double[2][n];
        for (i = 0; i < n; ++i) {
            bb[0][i] = aa[0][i];
            bb[1][i] = aa[1][i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(bb[0][i] < bb[0][index])) continue;
                index = i;
            }
            holdx = bb[0][index];
            bb[0][index] = bb[0][++lastIndex];
            bb[0][lastIndex] = holdx;
            holdy = bb[1][index];
            bb[1][index] = bb[1][lastIndex];
            bb[1][lastIndex] = holdy;
        }
        return bb;
    }

    public static double[][] data(int n, int m) {
        double[][] d = new double[2 * n][m];
        for (int i = 0; i < 2 * n; ++i) {
            for (int j = 0; j < m; ++j) {
                d[i][j] = dataFill;
            }
        }
        return d;
    }

    public static void setDataFillValue(double dataFill) {
        Plot.dataFill = dataFill;
    }

    public static double getDataFillValue() {
        return dataFill;
    }

    public void setGraphTitle(String graphTitle) {
        this.graphTitle = graphTitle;
    }

    public void setGraphTitle2(String graphTitle2) {
        this.graphTitle2 = graphTitle2;
    }

    public void setXaxisLegend(String xAxisLegend) {
        this.xAxisLegend = xAxisLegend;
    }

    public void setYaxisLegend(String yAxisLegend) {
        this.yAxisLegend = yAxisLegend;
    }

    public void setXaxisUnitsName(String xAxisUnits) {
        this.xAxisUnits = xAxisUnits;
        this.noXunits = false;
    }

    public void setYaxisUnitsName(String yAxisUnits) {
        this.yAxisUnits = yAxisUnits;
        this.noYunits = false;
    }

    public int getXaxisLen() {
        return this.xLen;
    }

    public int getYaxisLen() {
        return this.yLen;
    }

    public int getXlow() {
        return this.xBot;
    }

    public int getYhigh() {
        return this.yTop;
    }

    public int[] getPointsize() {
        return this.pointSize;
    }

    public int[] getDashlength() {
        return this.dashLength;
    }

    public double getXlowFac() {
        return 1.0 - this.xLowFac;
    }

    public double getYlowFac() {
        return 1.0 - this.yLowFac;
    }

    public double getXmin() {
        return this.xMin;
    }

    public double getXmax() {
        return this.xMax;
    }

    public double getYmin() {
        return this.yMin;
    }

    public double getYmax() {
        return this.yMax;
    }

    public int[] getLine() {
        return this.lineOpt;
    }

    public int[] getPoint() {
        return this.pointOpt;
    }

    public int getNiPoints() {
        return this.niPoints;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setXaxisLen(int xLen) {
        this.xLen = xLen;
        this.update();
    }

    public void setYaxisLen(int yLen) {
        this.yLen = yLen;
        this.update();
    }

    public void setXlow(int xBot) {
        this.xBot = xBot;
        this.update();
    }

    public void setYhigh(int yTop) {
        this.yTop = yTop;
        this.update();
    }

    public void setXlowFac(double xLowFac) {
        this.xLowFac = 1.0 - xLowFac;
    }

    public void setYlowFac(double yLowFac) {
        this.yLowFac = 1.0 - yLowFac;
    }

    public void setNoXoffset(boolean noXoffset) {
        this.noXoffset = noXoffset;
    }

    public void setNoYoffset(boolean noYoffset) {
        this.noYoffset = noYoffset;
    }

    public void setNoOffset(boolean nooffset) {
        this.noXoffset = nooffset;
        this.noYoffset = nooffset;
    }

    public boolean getNoXoffset() {
        return this.noXoffset;
    }

    public boolean getNoYoffset() {
        return this.noYoffset;
    }

    protected void update() {
        this.xTop = this.xBot + this.xLen;
        this.yBot = this.yTop + this.yLen;
    }

    public void setLine(int[] lineOpt) {
        int i;
        int n = lineOpt.length;
        if (n != this.nCurves) {
            throw new IllegalArgumentException("input array of wrong length");
        }
        for (i = 0; i < n; ++i) {
            if (lineOpt[i] >= 0 && lineOpt[i] <= 4) continue;
            throw new IllegalArgumentException("lineOpt must be 0, 1, 2, 3 or 4");
        }
        this.lineOpt = lineOpt;
        for (i = 0; i < this.lineOpt.length; ++i) {
            int j;
            if (this.lineOpt[i] != 1 && this.lineOpt[i] != 2) continue;
            boolean test0 = false;
            for (int j2 = 1; j2 < this.nPoints[i]; ++j2) {
                if (!(this.data[i][j2] < this.data[i][j2 - 1])) continue;
                test0 = true;
            }
            if (!test0) continue;
            int rev = 1;
            for (j = 1; j < this.nPoints[i]; ++j) {
                if (!(this.data[2 * i][j] > this.data[2 * i][j - 1])) continue;
                ++rev;
            }
            if (rev == this.nPoints[i]) {
                lineOpt[i] = -lineOpt[i];
                continue;
            }
            rev = 1;
            for (j = 1; j < this.nPoints[i]; ++j) {
                if (!(this.data[2 * i][j] < this.data[2 * i][j - 1])) continue;
                ++rev;
            }
            if (rev == this.nPoints[i]) {
                int j3;
                double[] hold = new double[this.nPoints[i]];
                for (j3 = 0; j3 < this.nPoints[i]; ++j3) {
                    hold[j3] = this.data[i][j3];
                }
                for (j3 = 0; j3 < this.nPoints[i]; ++j3) {
                    this.data[i][j3] = hold[this.nPoints[i] - j3 - 1];
                }
                for (j3 = 0; j3 < this.nPoints[i]; ++j3) {
                    hold[j3] = this.data[2 * i][j3];
                }
                for (j3 = 0; j3 < this.nPoints[i]; ++j3) {
                    this.data[2 * i][j3] = hold[this.nPoints[i] - j3 - 1];
                }
                this.lineOpt[i] = -lineOpt[i];
                continue;
            }
            System.out.println("Curve " + i + " will not support interpolation");
            System.out.println("Straight connecting line option used");
            if (this.lineOpt[i] == 1) {
                this.lineOpt[i] = 3;
            }
            if (this.lineOpt[i] != 2) continue;
            this.lineOpt[i] = 4;
        }
    }

    public void setLine(int slineOpt) {
        if (slineOpt < 0 || slineOpt > 3) {
            throw new IllegalArgumentException("lineOpt must be 0, 1, 2 or 3");
        }
        for (int i = 0; i < this.nCurves; ++i) {
            this.lineOpt[i] = slineOpt;
        }
    }

    public void setDashLength(int[] dashLength) {
        if (dashLength.length != this.nCurves) {
            throw new IllegalArgumentException("input array of wrong length");
        }
        this.dashLength = dashLength;
    }

    public void setDashLength(int sdashLength) {
        for (int i = 0; i < this.nCurves; ++i) {
            this.dashLength[i] = sdashLength;
        }
    }

    public void setPoint(int[] pointOpt) {
        int n = pointOpt.length;
        if (n != this.nCurves) {
            throw new IllegalArgumentException("input array of wrong length");
        }
        for (int i = 0; i < n; ++i) {
            if (pointOpt[i] >= 0 && pointOpt[i] <= 8) continue;
            throw new IllegalArgumentException("pointOpt must be 0, 1, 2, 3, 4, 5, 6, 7, or 8");
        }
        this.pointOpt = pointOpt;
    }

    public void setPoint(int spointOpt) {
        if (spointOpt < 0 || spointOpt > 8) {
            throw new IllegalArgumentException("pointOpt must be 0, 1, 2, 3, 4, 5, 6, 7, or 8");
        }
        for (int i = 0; i < this.nCurves; ++i) {
            this.pointOpt[i] = spointOpt;
        }
    }

    public void setPointSize(int[] mpointSize) {
        if (mpointSize.length != this.nCurves) {
            throw new IllegalArgumentException("input array of wrong length");
        }
        for (int i = 0; i < this.nCurves; ++i) {
            if (mpointSize[i] != mpointSize[i] / 2 * 2) {
                int n = i;
                mpointSize[n] = mpointSize[n] + 1;
            }
            this.pointSize[i] = mpointSize[i];
        }
    }

    public void setPointSize(int spointSize) {
        if (spointSize % 2 != 0) {
            ++spointSize;
        }
        for (int i = 0; i < this.nCurves; ++i) {
            this.pointSize[i] = spointSize;
        }
    }

    public void setErrorBars(int nc, double[] err) {
        if (err.length != this.nPoints[nc]) {
            throw new IllegalArgumentException("input array of wrong length");
        }
        this.errorBar[nc] = true;
        for (int i = 0; i < this.nPoints[nc]; ++i) {
            this.errors[nc][i] = err[i];
            this.errorsCopy[nc][i] = err[i];
        }
    }

    public void setNiPoints(int niPoints) {
        this.niPoints = niPoints;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setTrimOpt(boolean[] trim) {
        this.trimOpt = trim;
    }

    public void setMinMaxOpt(boolean[] minmax) {
        this.minMaxOpt = minmax;
    }

    public static int scale(double mmin, double mmax) {
        int fac = 0;
        double big = 0.0;
        boolean test = false;
        if (mmin >= 0.0 && mmax > 0.0) {
            big = mmax;
            test = true;
        } else if (mmin < 0.0 && mmax <= 0.0) {
            big = -mmin;
            test = true;
        } else if (mmax > 0.0 && mmin < 0.0) {
            big = Math.max(mmax, -mmin);
            test = true;
        }
        if (test) {
            if (big > 100.0) {
                while (big > 1.0) {
                    big /= 10.0;
                    --fac;
                }
            }
            if (big <= 0.01) {
                while (big <= 0.1) {
                    big *= 10.0;
                    ++fac;
                }
            }
        }
        return fac;
    }

    public static void limits(double low, double high, double lowfac, double[] limits) {
        double facl = 1.0;
        double fach = 1.0;
        if (Math.abs(low) < 1.0) {
            facl = 10.0;
        }
        if (Math.abs(low) < 0.1) {
            facl = 100.0;
        }
        if (Math.abs(high) < 1.0) {
            fach = 10.0;
        }
        if (Math.abs(high) < 0.1) {
            fach = 100.0;
        }
        double ld = Math.floor(10.0 * low * facl) / facl;
        double hd = Math.ceil(10.0 * high * fach) / fach;
        if (ld >= 0.0 && hd > 0.0 && ld < lowfac * hd) {
            ld = 0.0;
        }
        if (ld < 0.0 && hd <= 0.0 && -hd <= -lowfac * ld) {
            hd = 0.0;
        }
        limits[0] = ld / 10.0;
        limits[1] = hd / 10.0;
    }

    public static double offset(double low, double high) {
        double diff = high - low;
        double sh = Fmath.sign(high);
        double sl = Fmath.sign(low);
        double offset = 0.0;
        int eh = 0;
        int ed = 0;
        if (sh == sl) {
            ed = (int)Math.floor(Fmath.log10(diff));
            if (sh == 1.0) {
                eh = (int)Math.floor(Fmath.log10(high));
                if (eh - ed > 1) {
                    offset = Math.floor(low * Math.pow(10.0, -ed)) * Math.pow(10.0, ed);
                }
            } else {
                eh = (int)Math.floor(Fmath.log10(Math.abs(low)));
                if (eh - ed > 1) {
                    offset = Math.floor(high * Math.pow(10.0, -ed)) * Math.pow(10.0, ed);
                }
            }
        }
        return offset;
    }

    public void axesScaleOffset() {
        int j;
        int i;
        double[] limit = new double[2];
        int k = 0;
        for (i = 0; i < this.nCurves; ++i) {
            for (j = 0; j < this.nPoints[i]; ++j) {
                this.data[k][j] = this.copy[k][j];
                this.data[k + 1][j] = this.copy[k + 1][j];
                this.errors[i][j] = this.errorsCopy[i][j];
                if (!this.errorBar[i]) continue;
                double[] dArray = this.errors[i];
                int n = j;
                dArray[n] = dArray[n] + this.data[k + 1][j];
            }
            k += 2;
        }
        this.minMax();
        if (!this.noXoffset) {
            this.xOffset = Plot.offset(this.xMin, this.xMax);
        }
        if (this.xOffset != 0.0) {
            k = 0;
            for (i = 0; i < this.nCurves; ++i) {
                j = 0;
                while (j < this.nPoints[i]) {
                    double[] dArray = this.data[k];
                    int n = j++;
                    dArray[n] = dArray[n] - this.xOffset;
                }
                k += 2;
            }
            this.xMin -= this.xOffset;
            this.xMax -= this.xOffset;
        }
        if (!this.noYoffset) {
            this.yOffset = Plot.offset(this.yMin, this.yMax);
        }
        if (this.yOffset != 0.0) {
            k = 1;
            for (i = 0; i < this.nCurves; ++i) {
                for (j = 0; j < this.nPoints[i]; ++j) {
                    double[] dArray = this.data[k];
                    int n = j;
                    dArray[n] = dArray[n] - this.yOffset;
                    if (!this.errorBar[i]) continue;
                    double[] dArray2 = this.errors[i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] - this.yOffset;
                }
                k += 2;
            }
            this.yMin -= this.yOffset;
            this.yMax -= this.yOffset;
        }
        this.xFac = Plot.scale(this.xMin, this.xMax);
        if (this.xFac != 0) {
            k = 0;
            for (i = 0; i < this.nCurves; ++i) {
                j = 0;
                while (j < this.nPoints[i]) {
                    double[] dArray = this.data[k];
                    int n = j++;
                    dArray[n] = dArray[n] * Math.pow(10.0, this.xFac + 1);
                }
                k += 2;
            }
            this.xMin *= Math.pow(10.0, this.xFac + 1);
            this.xMax *= Math.pow(10.0, this.xFac + 1);
        }
        this.yFac = Plot.scale(this.yMin, this.yMax);
        if (this.yFac != 0) {
            k = 1;
            for (i = 0; i < this.nCurves; ++i) {
                for (j = 0; j < this.nPoints[i]; ++j) {
                    double[] dArray = this.data[k];
                    int n = j;
                    dArray[n] = dArray[n] * Math.pow(10.0, this.yFac + 1);
                    if (!this.errorBar[i]) continue;
                    double[] dArray3 = this.errors[i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] * Math.pow(10.0, this.yFac + 1);
                }
                k += 2;
            }
            this.yMin *= Math.pow(10.0, this.yFac + 1);
            this.yMax *= Math.pow(10.0, this.yFac + 1);
        }
        Plot.limits(this.xMin, this.xMax, this.xLowFac, limit);
        this.xLow = limit[0];
        this.xHigh = limit[1];
        if (this.xLow < 0.0 && this.xHigh > 0.0) {
            this.xZero = true;
        }
        Plot.limits(this.yMin, this.yMax, this.yLowFac, limit);
        this.yLow = limit[0];
        this.yHigh = limit[1];
        if (this.yLow < 0.0 && this.yHigh > 0.0) {
            this.yZero = true;
        }
        this.xTicks = Plot.ticks(this.xLow, this.xHigh, this.xAxisNo, this.xAxisChar);
        this.xHigh = this.xAxisNo[this.xTicks - 1];
        if (this.xLow != this.xAxisNo[0]) {
            if (this.xOffset != 0.0) {
                this.xOffset = this.xOffset - this.xLow + this.xAxisNo[0];
            }
            this.xLow = this.xAxisNo[0];
        }
        this.yTicks = Plot.ticks(this.yLow, this.yHigh, this.yAxisNo, this.yAxisChar);
        this.yHigh = this.yAxisNo[this.yTicks - 1];
        if (this.yLow != this.yAxisNo[0]) {
            if (this.yOffset != 0.0) {
                this.yOffset = this.yOffset - this.yLow + this.yAxisNo[0];
            }
            this.yLow = this.yAxisNo[0];
        }
    }

    public static int ticks(double low, double high, double[] tickval, String[] tickchar) {
        int[] trunc = new int[]{1, 1, 1, 2, 3};
        double[] scfac1 = new double[]{1.0, 10.0, 1.0, 0.1, 0.01};
        double[] scfac2 = new double[]{1.0, 1.0, 0.1, 0.01, 0.001};
        double rmax = Math.abs(high);
        double temp = Math.abs(low);
        if (temp > rmax) {
            rmax = temp;
        }
        int range = 0;
        if (rmax <= 100.0) {
            range = 1;
        }
        if (rmax <= 10.0) {
            range = 2;
        }
        if (rmax <= 1.0) {
            range = 3;
        }
        if (rmax <= 0.1) {
            range = 4;
        }
        if (rmax > 100.0 || rmax < 0.01) {
            range = 0;
        }
        double inc = 0.0;
        double bot = 0.0;
        double top = 0.0;
        int sgn = 0;
        int dirn = 0;
        if (high > 0.0 && low >= 0.0) {
            inc = Math.ceil((high - low) / scfac1[range]) * scfac2[range];
            dirn = 1;
            bot = low;
            top = high;
            sgn = 1;
        } else if (high <= 0.0 && low < 0.0) {
            inc = Math.ceil((high - low) / scfac1[range]) * scfac2[range];
            dirn = -1;
            bot = high;
            top = low;
            sgn = -1;
        } else {
            double up = Math.abs(Math.ceil(high));
            double down = Math.abs(Math.floor(low));
            int np = 0;
            if (up >= down) {
                dirn = 2;
                np = (int)Math.rint(10.0 * up / (up + down));
                inc = Math.ceil(high * 10.0 / (double)np / scfac1[range]) * scfac2[range];
                bot = 0.0;
                top = high;
                sgn = 1;
            } else {
                dirn = -2;
                np = (int)Math.rint(10.0 * down / (up + down));
                inc = Math.ceil(Math.abs(low * 10.0 / (double)np) / scfac1[range]) * scfac2[range];
                bot = 0.0;
                top = low;
                sgn = -1;
            }
        }
        int nticks = 1;
        double sum = bot;
        boolean test = true;
        while (test) {
            sum += (double)sgn * inc;
            ++nticks;
            if (!(Math.abs(sum) >= Math.abs(top))) continue;
            test = false;
        }
        int npExtra = 0;
        double[] ttickval = null;
        switch (dirn) {
            case 1: {
                int i;
                ttickval = new double[nticks];
                tickval[0] = Fmath.truncate(low, trunc[range]);
                for (i = 1; i < nticks; ++i) {
                    tickval[i] = Fmath.truncate(tickval[i - 1] + inc, trunc[range]);
                }
                break;
            }
            case -1: {
                int i;
                ttickval = new double[nticks];
                ttickval[0] = Fmath.truncate(high, trunc[range]);
                for (i = 1; i < nticks; ++i) {
                    ttickval[i] = Fmath.truncate(ttickval[i - 1] - inc, trunc[range]);
                }
                ttickval = Fmath.reverseArray(ttickval);
                for (i = 0; i < nticks; ++i) {
                    tickval[i] = ttickval[i];
                }
                break;
            }
            case 2: {
                int i;
                npExtra = (int)Math.ceil(-low / inc);
                ttickval = new double[nticks += npExtra];
                tickval[0] = Fmath.truncate((double)(-npExtra) * inc, trunc[range]);
                for (i = 1; i < nticks; ++i) {
                    tickval[i] = Fmath.truncate(tickval[i - 1] + inc, trunc[range]);
                }
                break;
            }
            case -2: {
                int i;
                npExtra = (int)Math.ceil(high / inc);
                ttickval = new double[nticks += npExtra];
                ttickval[0] = Fmath.truncate((double)npExtra * inc, trunc[range]);
                for (i = 1; i < nticks; ++i) {
                    ttickval[i] = Fmath.truncate(ttickval[i - 1] - inc, trunc[range]);
                }
                ttickval = Fmath.reverseArray(ttickval);
                for (i = 0; i < nticks; ++i) {
                    tickval[i] = ttickval[i];
                }
                break;
            }
        }
        ArrayMaths am = new ArrayMaths(tickval);
        double max = am.maximum();
        double min = Math.abs(am.minimum());
        boolean testZero = true;
        int counter = 0;
        while (testZero) {
            if (Math.abs(tickval[counter]) < max * 1.0E-4 || Math.abs(tickval[counter]) < min * 1.0E-4) {
                tickval[counter] = 0.0;
                testZero = false;
                continue;
            }
            if (++counter < nticks) continue;
            testZero = false;
        }
        for (int i = 0; i < nticks; ++i) {
            tickchar[i] = String.valueOf(tickval[i]);
            tickchar[i] = tickchar[i].trim();
        }
        return nticks;
    }

    public void minMax() {
        boolean test = true;
        int ii = 0;
        while (test) {
            if (this.minMaxOpt[ii]) {
                test = false;
                this.xMin = this.data[2 * ii][0];
                this.xMax = this.data[2 * ii][0];
                this.yMin = this.data[2 * ii + 1][0];
                if (this.errorBar[ii]) {
                    this.yMin = 2.0 * this.yMin - this.errors[ii][0];
                }
                this.yMax = this.data[2 * ii + 1][0];
                if (!this.errorBar[ii]) continue;
                this.yMax = this.errors[ii][0];
                continue;
            }
            if (++ii <= this.nCurves) continue;
            throw new IllegalArgumentException("At least one curve must be included in the maximum/minimum calculation");
        }
        int k = 0;
        double yMint = 0.0;
        double yMaxt = 0.0;
        for (int i = 0; i < this.nCurves; ++i) {
            if (this.minMaxOpt[i]) {
                for (int j = 0; j < this.nPoints[i]; ++j) {
                    if (this.xMin > this.data[k][j]) {
                        this.xMin = this.data[k][j];
                    }
                    if (this.xMax < this.data[k][j]) {
                        this.xMax = this.data[k][j];
                    }
                    yMint = this.data[k + 1][j];
                    if (this.errorBar[i]) {
                        yMint = 2.0 * yMint - this.errors[i][j];
                    }
                    if (this.yMin > yMint) {
                        this.yMin = yMint;
                    }
                    yMaxt = this.data[k + 1][j];
                    if (this.errorBar[i]) {
                        yMaxt = this.errors[i][j];
                    }
                    if (!(this.yMax < yMaxt)) continue;
                    this.yMax = yMaxt;
                }
            }
            k += 2;
        }
        if (this.xMin == this.xMax) {
            if (this.xMin == 0.0) {
                this.xMin = 0.1;
                this.xMax = 0.1;
            } else if (this.xMin < 0.0) {
                this.xMin *= 1.1;
            } else {
                this.xMax *= 1.1;
            }
        }
        if (this.yMin == this.yMax) {
            if (this.yMin == 0.0) {
                this.yMin = 0.1;
                this.yMax = 0.1;
            } else if (this.yMin < 0.0) {
                this.yMin *= 1.1;
            } else {
                this.yMax *= 1.1;
            }
        }
    }

    protected static String offsetString(double offset) {
        String stroffset = String.valueOf(offset);
        String substr1 = "";
        String substr2 = "";
        String substr3 = "";
        String zero = "0";
        int posdot = stroffset.indexOf(46);
        int posexp = stroffset.indexOf(69);
        if (posexp == -1) {
            return stroffset;
        }
        substr1 = stroffset.substring(posexp + 1);
        int n = Integer.parseInt(substr1);
        substr1 = stroffset.substring(0, posexp);
        if (n >= 0) {
            for (int i = 0; i < n; ++i) {
                substr1 = substr1 + zero;
            }
            return substr1;
        }
        substr2 = substr1.substring(0, posdot + 1);
        substr3 = substr1.substring(posdot + 1);
        for (int i = 0; i < -n; ++i) {
            substr2 = substr1 + zero;
        }
        substr2 = substr2 + substr3;
        return substr2;
    }

    public boolean printCheck(boolean trim, int xoldpoint, int xnewpoint, int yoldpoint, int ynewpoint) {
        boolean btest2 = true;
        if (trim) {
            if (xoldpoint < this.xBot) {
                btest2 = false;
            }
            if (xoldpoint > this.xTop) {
                btest2 = false;
            }
            if (xnewpoint < this.xBot) {
                btest2 = false;
            }
            if (xnewpoint > this.xTop) {
                btest2 = false;
            }
            if (yoldpoint > this.yBot) {
                btest2 = false;
            }
            if (yoldpoint < this.yTop) {
                btest2 = false;
            }
            if (ynewpoint > this.yBot) {
                btest2 = false;
            }
            if (ynewpoint < this.yTop) {
                btest2 = false;
            }
        }
        return btest2;
    }

    public void graph(Graphics g) {
        String sn;
        g.setFont(new Font("serif", 0, this.fontSize));
        FontMetrics fm = g.getFontMetrics();
        this.axesScaleOffset();
        String xoffstr = Plot.offsetString(this.xOffset);
        String yoffstr = Plot.offsetString(this.yOffset);
        String bunit1 = "  /( ";
        String bunit2 = " )";
        String bunit3 = "  / ";
        String bunit4 = " ";
        String bunit5 = " x 10";
        String bunit6 = "10";
        String nounit = " ";
        String xbrack1 = bunit1;
        String xbrack2 = bunit2;
        String xbrack3 = bunit5;
        if (this.xFac == 0) {
            xbrack1 = bunit3;
            xbrack2 = "";
            xbrack3 = "";
        }
        String ybrack1 = bunit1;
        String ybrack2 = bunit2;
        String ybrack3 = bunit5;
        if (this.yFac == 0) {
            ybrack1 = bunit3;
            ybrack2 = "";
            ybrack3 = "";
        }
        if (this.noXunits) {
            if (this.xFac == 0) {
                xbrack1 = nounit;
                xbrack2 = nounit;
                xbrack3 = nounit;
            } else {
                xbrack1 = bunit3;
                xbrack2 = bunit4;
                xbrack3 = bunit6;
            }
        }
        if (this.noYunits) {
            if (this.yFac == 0) {
                ybrack1 = nounit;
                ybrack2 = nounit;
                ybrack3 = nounit;
            } else {
                ybrack1 = bunit3;
                ybrack2 = bunit4;
                ybrack3 = bunit6;
            }
        }
        double xLen = this.xTop - this.xBot;
        double yLen = this.yBot - this.yTop;
        String sp = " + ";
        String ss = sn = " - ";
        g.drawString(this.graphTitle + " ", 15, 15);
        g.drawString(this.graphTitle2 + " ", 15, 35);
        if (this.xOffset < 0.0) {
            ss = sp;
            this.xOffset = -this.xOffset;
        }
        int sw = 0;
        String ssx = "";
        String ssy = "";
        String sws1 = "";
        String sws2 = "";
        if (this.xFac == 0 && this.xOffset == 0.0) {
            g.drawString(this.xAxisLegend + xbrack1 + this.xAxisUnits + xbrack2, this.xBot - 4, this.yBot + 32);
        } else if (this.xOffset == 0.0) {
            ssx = this.xAxisLegend + xbrack1 + this.xAxisUnits + xbrack3;
            sw = fm.stringWidth(ssx);
            g.drawString(ssx, this.xBot - 4, this.yBot + 42);
            sws1 = String.valueOf(-this.xFac - 1);
            g.drawString(sws1, this.xBot - 4 + sw + 1, this.yBot + 32);
            g.drawString(xbrack2, this.xBot - 4 + (sw += fm.stringWidth(sws1)) + 1, this.yBot + 42);
        } else if (this.xFac == 0) {
            g.drawString(this.xAxisLegend + ss + xoffstr + xbrack1 + this.xAxisUnits + xbrack2, this.xBot - 4, this.yBot + 30);
        } else {
            ssx = this.xAxisLegend + ss + xoffstr + xbrack1 + this.xAxisUnits + xbrack3;
            sw = fm.stringWidth(ssx);
            g.drawString(ssx, this.xBot - 4, this.yBot + 37);
            sws1 = String.valueOf(-this.xFac - 1);
            g.drawString(sws1, this.xBot - 4 + sw + 1, this.yBot + 32);
            g.drawString(xbrack2, this.xBot - 4 + (sw += fm.stringWidth(sws1)) + 1, this.yBot + 37);
        }
        ss = sn;
        if (this.yOffset < 0.0) {
            ss = sp;
            this.yOffset = -this.yOffset;
        }
        if (this.yFac == 0 && this.yOffset == 0.0) {
            g.drawString(this.yAxisLegend + " ", 15, this.yTop - 25);
            g.drawString(ybrack1 + this.yAxisUnits + ybrack2, 15, this.yTop - 10);
        } else if (this.yOffset == 0.0) {
            g.drawString(this.yAxisLegend, 15, this.yTop - 35);
            sws1 = ybrack1 + this.yAxisUnits + ybrack3;
            g.drawString(sws1, 15, this.yTop - 15);
            sw = fm.stringWidth(sws1);
            sws2 = String.valueOf(-this.yFac - 1);
            g.drawString(sws2, 15 + sw + 1, this.yTop - 20);
            g.drawString(ybrack2, 15 + (sw += fm.stringWidth(sws2)) + 1, this.yTop - 15);
        } else if (this.yFac == 0) {
            g.drawString(this.yAxisLegend + ss + yoffstr, 15, this.yTop - 25);
            g.drawString(ybrack1 + this.yAxisUnits + ybrack2, 15, this.yTop - 10);
        } else {
            ssy = this.yAxisLegend + ss + yoffstr;
            g.drawString(ssy, 15, this.yTop - 35);
            sws1 = ybrack1 + this.yAxisUnits + ybrack3;
            g.drawString(sws1, 15, this.yTop - 15);
            sw = fm.stringWidth(sws1);
            sws2 = String.valueOf(-this.yFac - 1);
            g.drawString(sws2, 15 + sw + 1, this.yTop - 20);
            g.drawString(ybrack2, 15 + (sw += fm.stringWidth(sws2)) + 1, this.yTop - 15);
        }
        int zdif = 0;
        int zold = 0;
        int znew = 0;
        int zzer = 0;
        double csstep = 0.0;
        double xdenom = this.xHigh - this.xLow;
        double ydenom = this.yHigh - this.yLow;
        g.drawLine(this.xBot, this.yBot, this.xTop, this.yBot);
        g.drawLine(this.xBot, this.yTop, this.xTop, this.yTop);
        g.drawLine(this.xBot, this.yBot, this.xBot, this.yTop);
        g.drawLine(this.xTop, this.yBot, this.xTop, this.yTop);
        if (this.xZero) {
            zdif = 8;
            zzer = this.xBot + (int)((0.0 - this.xLow) / xdenom * xLen);
            g.drawLine(zzer, this.yTop, zzer, this.yTop + 8);
            g.drawLine(zzer, this.yBot, zzer, this.yBot - 8);
            zold = this.yTop;
            while (zold + zdif < this.yBot) {
                znew = zold + zdif;
                g.drawLine(zzer, zold, zzer, znew);
                zold = znew + zdif;
            }
        }
        if (this.yZero) {
            zdif = 8;
            zzer = this.yBot - (int)((0.0 - this.yLow) / ydenom * yLen);
            g.drawLine(this.xBot, zzer, this.xBot + 8, zzer);
            g.drawLine(this.xTop, zzer, this.xTop - 8, zzer);
            zold = this.xBot;
            while (zold + zdif < this.xTop) {
                znew = zold + zdif;
                g.drawLine(zold, zzer, znew, zzer);
                zold = znew + zdif;
            }
        }
        int xt = 0;
        for (int ii = 0; ii < this.xTicks; ++ii) {
            xt = this.xBot + (int)((this.xAxisNo[ii] - this.xLow) / xdenom * xLen);
            g.drawLine(xt, this.yBot, xt, this.yBot - 8);
            g.drawLine(xt, this.yTop, xt, this.yTop + 8);
            g.drawString(this.xAxisChar[ii] + " ", xt - 4, this.yBot + 18);
        }
        int yt = 0;
        int yCharLenMax = this.yAxisChar[0].length();
        for (int ii = 1; ii < this.yTicks; ++ii) {
            if (this.yAxisChar[ii].length() <= yCharLenMax) continue;
            yCharLenMax = this.yAxisChar[ii].length();
        }
        int shift = (yCharLenMax - 3) * 5;
        double ytep = (double)(-this.yTop + this.yBot) / (double)(this.yTicks - 1);
        for (int ii = 0; ii < this.yTicks; ++ii) {
            yt = this.yBot - (int)Math.round((double)ii * ytep);
            yt = this.yBot - (int)((this.yAxisNo[ii] - this.yLow) / ydenom * yLen);
            g.drawLine(this.xBot, yt, this.xBot + 8, yt);
            g.drawLine(this.xTop, yt, this.xTop - 8, yt);
            g.drawString(this.yAxisChar[ii] + " ", this.xBot - 30 - shift, yt + 4);
        }
        int dsum = 0;
        boolean dcheck = true;
        int kk = 0;
        int xxp = 0;
        int yyp = 0;
        int yype = 0;
        int xoldpoint = 0;
        int xnewpoint = 0;
        int yoldpoint = 0;
        int ynewpoint = 0;
        int ps = 0;
        int psh = 0;
        int nxpoints = 0;
        double[] ics = new double[this.niPoints];
        boolean btest2 = true;
        for (int i = 0; i < this.nCurves; ++i) {
            int ii;
            CubicSpline cs;
            nxpoints = this.nPoints[i];
            double[] xcs = new double[nxpoints];
            double[] ycs = new double[nxpoints];
            if (this.lineOpt[i] == 1 || this.lineOpt[i] == 2) {
                cs = new CubicSpline(this.nPoints[i]);
                for (ii = 0; ii < nxpoints; ++ii) {
                    xcs[ii] = this.data[kk][ii];
                }
                csstep = (xcs[nxpoints - 1] - xcs[0]) / (double)(this.niPoints - 1);
                ics[0] = xcs[0];
                for (ii = 1; ii < this.niPoints; ++ii) {
                    ics[ii] = ics[ii - 1] + csstep;
                }
                ics[this.niPoints - 1] = xcs[nxpoints - 1];
                for (ii = 0; ii < nxpoints; ++ii) {
                    ycs[ii] = this.data[kk + 1][ii];
                }
                cs.resetData(xcs, ycs);
                cs.calcDeriv();
                xoldpoint = this.xBot + (int)((xcs[0] - this.xLow) / xdenom * xLen);
                yoldpoint = this.yBot - (int)((ycs[0] - this.yLow) / ydenom * yLen);
                for (ii = 1; ii < this.niPoints; ++ii) {
                    xnewpoint = this.xBot + (int)((ics[ii] - this.xLow) / xdenom * xLen);
                    ynewpoint = this.yBot - (int)((cs.interpolate(ics[ii]) - this.yLow) / ydenom * yLen);
                    btest2 = this.printCheck(this.trimOpt[i], xoldpoint, xnewpoint, yoldpoint, ynewpoint);
                    if (btest2) {
                        if (this.lineOpt[i] == 2 && ++dsum > this.dashLength[i]) {
                            dsum = 0;
                            dcheck = !dcheck;
                        }
                        if (dcheck) {
                            g.drawLine(xoldpoint, yoldpoint, xnewpoint, ynewpoint);
                        }
                    }
                    xoldpoint = xnewpoint;
                    yoldpoint = ynewpoint;
                }
            }
            if (this.lineOpt[i] == -1 || this.lineOpt[i] == -2) {
                cs = new CubicSpline(this.nPoints[i]);
                for (ii = 0; ii < nxpoints; ++ii) {
                    xcs[ii] = this.data[kk][ii];
                }
                for (ii = 0; ii < nxpoints; ++ii) {
                    ycs[ii] = this.data[kk + 1][ii];
                }
                csstep = (ycs[nxpoints - 1] - ycs[0]) / (double)(this.niPoints - 1);
                ics[0] = ycs[0];
                for (ii = 1; ii < this.niPoints; ++ii) {
                    ics[ii] = ics[ii - 1] + csstep;
                }
                ics[this.niPoints - 1] = ycs[nxpoints - 1];
                cs.resetData(ycs, xcs);
                cs.calcDeriv();
                xoldpoint = this.xBot + (int)((xcs[0] - this.xLow) / xdenom * xLen);
                yoldpoint = this.yBot - (int)((ycs[0] - this.yLow) / ydenom * yLen);
                for (ii = 1; ii < this.niPoints; ++ii) {
                    ynewpoint = this.yBot + (int)((ics[ii] - this.yLow) / ydenom * yLen);
                    xnewpoint = this.xBot - (int)((cs.interpolate(ics[ii]) - this.xLow) / xdenom * xLen);
                    btest2 = this.printCheck(this.trimOpt[i], xoldpoint, xnewpoint, yoldpoint, ynewpoint);
                    if (btest2) {
                        if (this.lineOpt[i] == 2 && ++dsum > this.dashLength[i]) {
                            dsum = 0;
                            dcheck = !dcheck;
                        }
                        if (dcheck) {
                            g.drawLine(xoldpoint, yoldpoint, xnewpoint, ynewpoint);
                        }
                    }
                    xoldpoint = xnewpoint;
                    yoldpoint = ynewpoint;
                }
            }
            if (this.lineOpt[i] == 3) {
                dsum = 0;
                dcheck = true;
                xoldpoint = this.xBot + (int)((this.data[kk][0] - this.xLow) / xdenom * xLen);
                yoldpoint = this.yBot - (int)((this.data[kk + 1][0] - this.yLow) / ydenom * yLen);
                for (int ii2 = 1; ii2 < nxpoints; ++ii2) {
                    xnewpoint = this.xBot + (int)((this.data[kk][ii2] - this.xLow) / xdenom * xLen);
                    ynewpoint = this.yBot - (int)((this.data[kk + 1][ii2] - this.yLow) / ydenom * yLen);
                    btest2 = this.printCheck(this.trimOpt[i], xoldpoint, xnewpoint, yoldpoint, ynewpoint);
                    if (btest2) {
                        g.drawLine(xoldpoint, yoldpoint, xnewpoint, ynewpoint);
                    }
                    xoldpoint = xnewpoint;
                    yoldpoint = ynewpoint;
                }
            }
            if (this.lineOpt[i] == 4) {
                dsum = 0;
                dcheck = true;
                xoldpoint = this.xBot + (int)((this.data[kk][0] - this.xLow) / xdenom * xLen);
                yoldpoint = this.yBot - (int)((this.data[kk + 1][0] - this.yLow) / ydenom * yLen);
                for (int ii3 = 1; ii3 < nxpoints; ++ii3) {
                    if (++dsum > this.dashLength[i]) {
                        dsum = 0;
                        dcheck = !dcheck;
                    }
                    xnewpoint = this.xBot + (int)((this.data[kk][ii3] - this.xLow) / xdenom * xLen);
                    ynewpoint = this.yBot - (int)((this.data[kk + 1][ii3] - this.yLow) / ydenom * yLen);
                    btest2 = this.printCheck(this.trimOpt[i], xoldpoint, xnewpoint, yoldpoint, ynewpoint);
                    if (dcheck) {
                        g.drawLine(xoldpoint, yoldpoint, xnewpoint, ynewpoint);
                    }
                    xoldpoint = xnewpoint;
                    yoldpoint = ynewpoint;
                }
            }
            if (this.pointOpt[i] > 0) {
                for (int ii4 = 0; ii4 < nxpoints; ++ii4) {
                    ps = this.pointSize[i];
                    psh = ps / 2;
                    xxp = this.xBot + (int)((this.data[kk][ii4] - this.xLow) / xdenom * xLen);
                    yyp = this.yBot - (int)((this.data[kk + 1][ii4] - this.yLow) / ydenom * yLen);
                    switch (this.pointOpt[i]) {
                        case 1: {
                            g.drawOval(xxp - psh, yyp - psh, ps, ps);
                            break;
                        }
                        case 2: {
                            g.drawRect(xxp - psh, yyp - psh, ps, ps);
                            break;
                        }
                        case 3: {
                            g.drawLine(xxp - psh, yyp, xxp, yyp + psh);
                            g.drawLine(xxp, yyp + psh, xxp + psh, yyp);
                            g.drawLine(xxp + psh, yyp, xxp, yyp - psh);
                            g.drawLine(xxp, yyp - psh, xxp - psh, yyp);
                            break;
                        }
                        case 4: {
                            g.fillOval(xxp - psh, yyp - psh, ps, ps);
                            break;
                        }
                        case 5: {
                            g.fillRect(xxp - psh, yyp - psh, ps, ps);
                            break;
                        }
                        case 6: {
                            int jj;
                            for (jj = 0; jj < psh; ++jj) {
                                g.drawLine(xxp - jj, yyp - psh + jj, xxp + jj, yyp - psh + jj);
                            }
                            for (jj = 0; jj <= psh; ++jj) {
                                g.drawLine(xxp - psh + jj, yyp + jj, xxp + psh - jj, yyp + jj);
                            }
                            break;
                        }
                        case 7: {
                            g.drawLine(xxp - psh, yyp - psh, xxp + psh, yyp + psh);
                            g.drawLine(xxp - psh, yyp + psh, xxp + psh, yyp - psh);
                            break;
                        }
                        case 8: {
                            g.drawLine(xxp - psh, yyp, xxp + psh, yyp);
                            g.drawLine(xxp, yyp + psh, xxp, yyp - psh);
                            break;
                        }
                        default: {
                            g.drawLine(xxp - psh, yyp - psh, xxp + psh, yyp + psh);
                            g.drawLine(xxp - psh, yyp + psh, xxp + psh, yyp - psh);
                        }
                    }
                    if (!this.errorBar[i]) continue;
                    yype = this.yBot - (int)((this.errors[i][ii4] - this.yLow) / ydenom * yLen);
                    g.drawLine(xxp, yyp, xxp, yype);
                    g.drawLine(xxp - 4, yype, xxp + 4, yype);
                    yype = 2 * yyp - yype;
                    g.drawLine(xxp, yyp, xxp, yype);
                    g.drawLine(xxp - 4, yype, xxp + 4, yype);
                }
            }
            kk += 2;
        }
    }

    public static long getSerialVersionUID() {
        return 1L;
    }
}

