/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.math.Fmath;

public class ErrorProp {
    private double value = 0.0;
    private double error = 0.0;

    public ErrorProp() {
        this.value = 0.0;
        this.error = 0.0;
    }

    public ErrorProp(double value, double error) {
        this.value = value;
        this.error = error;
    }

    public ErrorProp(double value) {
        this.value = value;
        this.error = 0.0;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setError(double error) {
        this.error = error;
    }

    public void reset(double value, double error) {
        this.value = value;
        this.error = error;
    }

    public double getValue() {
        return this.value;
    }

    public double getError() {
        return this.error;
    }

    public void println(String message) {
        System.out.println(message + " " + this.toString());
    }

    public void println() {
        System.out.println(" " + this.toString());
    }

    public void print(String message) {
        System.out.print(message + " " + this.toString());
    }

    public void print() {
        System.out.print(" " + this.toString());
    }

    public static ErrorProp truncate(ErrorProp x, int prec) {
        if (prec < 0) {
            return x;
        }
        double xV = x.getValue();
        double xS = x.getError();
        ErrorProp y = new ErrorProp();
        xV = Fmath.truncate(xV, prec);
        xS = Fmath.truncate(xS, prec);
        y.reset(xV, xS);
        return y;
    }

    public ErrorProp truncate(int prec) {
        if (prec < 0) {
            return this;
        }
        double xV = this.getValue();
        double xS = this.getError();
        ErrorProp y = new ErrorProp();
        xV = Fmath.truncate(xV, prec);
        xS = Fmath.truncate(xS, prec);
        y.reset(xV, xS);
        return y;
    }

    public String toString() {
        return this.value + ", error = " + this.error;
    }

    public static String toString(ErrorProp aa) {
        return aa.value + ", error = " + aa.error;
    }

    public int hashCode() {
        long lvalue = Double.doubleToLongBits(this.value);
        long lerror = Double.doubleToLongBits(this.error);
        int hvalue = (int)(lvalue ^ lvalue >>> 32);
        int herror = (int)(lerror ^ lerror >>> 32);
        return 7 * (hvalue / 10) + 3 * (herror / 10);
    }

    public static ErrorProp[] oneDarray(int n) {
        ErrorProp[] a = new ErrorProp[n];
        for (int i = 0; i < n; ++i) {
            a[i] = ErrorProp.zero();
        }
        return a;
    }

    public static ErrorProp[] oneDarray(int n, double a, double b) {
        ErrorProp[] c = new ErrorProp[n];
        for (int i = 0; i < n; ++i) {
            c[i] = ErrorProp.zero();
            c[i].reset(a, b);
        }
        return c;
    }

    public static ErrorProp[] oneDarray(int n, ErrorProp constant) {
        ErrorProp[] c = new ErrorProp[n];
        for (int i = 0; i < n; ++i) {
            c[i] = ErrorProp.copy(constant);
        }
        return c;
    }

    public static ErrorProp[][] twoDarray(int n, int m) {
        ErrorProp[][] a = new ErrorProp[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                a[i][j] = ErrorProp.zero();
            }
        }
        return a;
    }

    public static ErrorProp[][] twoDarray(int n, int m, double a, double b) {
        ErrorProp[][] c = new ErrorProp[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                c[i][j] = ErrorProp.zero();
                c[i][j].reset(a, b);
            }
        }
        return c;
    }

    public static ErrorProp[][] twoDarray(int n, int m, ErrorProp constant) {
        ErrorProp[][] c = new ErrorProp[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                c[i][j] = ErrorProp.copy(constant);
            }
        }
        return c;
    }

    public static ErrorProp copy(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = a.value;
        b.error = a.error;
        return b;
    }

    public ErrorProp copy() {
        ErrorProp b = new ErrorProp();
        b.value = this.value;
        b.error = this.error;
        return b;
    }

    public Object clone() {
        ErrorProp b = new ErrorProp();
        b.value = this.value;
        b.error = this.error;
        return b;
    }

    public static ErrorProp[] copy(ErrorProp[] a) {
        int n = a.length;
        ErrorProp[] b = ErrorProp.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            b[i] = ErrorProp.copy(a[i]);
        }
        return b;
    }

    public static ErrorProp[][] copy(ErrorProp[][] a) {
        int n = a.length;
        int m = a[0].length;
        ErrorProp[][] b = ErrorProp.twoDarray(n, m);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                b[i][j] = ErrorProp.copy(a[i][j]);
            }
        }
        return b;
    }

    public ErrorProp plus(ErrorProp a, double corrCoeff) {
        ErrorProp c = new ErrorProp();
        c.value = a.value + this.value;
        c.error = ErrorProp.hypotWithCov(a.error, this.error, corrCoeff);
        return c;
    }

    public static ErrorProp plus(ErrorProp a, ErrorProp b, double corrCoeff) {
        ErrorProp c = new ErrorProp();
        c.value = a.value + b.value;
        c.error = ErrorProp.hypotWithCov(a.error, b.error, corrCoeff);
        return c;
    }

    public ErrorProp plus(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = this.value + a.value;
        b.error = ErrorProp.hypotWithCov(a.error, this.error, 0.0);
        return b;
    }

    public static ErrorProp plus(ErrorProp a, ErrorProp b) {
        ErrorProp c = new ErrorProp();
        c.value = a.value + b.value;
        c.error = ErrorProp.hypotWithCov(a.error, b.error, 0.0);
        return c;
    }

    public ErrorProp plus(double a) {
        ErrorProp b = new ErrorProp();
        b.value = this.value + a;
        b.error = Math.abs(this.error);
        return b;
    }

    public static ErrorProp plus(double a, ErrorProp b) {
        ErrorProp c = new ErrorProp();
        c.value = a + b.value;
        c.error = Math.abs(b.error);
        return c;
    }

    public static ErrorProp plus(double a, double b) {
        ErrorProp c = new ErrorProp();
        c.value = a + b;
        c.error = 0.0;
        return c;
    }

    public void plusEquals(ErrorProp a, double corrCoeff) {
        this.value += a.value;
        this.error = ErrorProp.hypotWithCov(a.error, this.error, corrCoeff);
    }

    public void plusEquals(ErrorProp a) {
        this.value += a.value;
        this.error = Math.sqrt(a.error * a.error + this.error * this.error);
        this.error = ErrorProp.hypotWithCov(a.error, this.error, 0.0);
    }

    public void plusEquals(double a) {
        this.value += a;
        this.error = Math.abs(this.error);
    }

    public ErrorProp minus(ErrorProp a, double corrCoeff) {
        ErrorProp c = new ErrorProp();
        c.value = this.value - a.value;
        c.error = ErrorProp.hypotWithCov(this.error, a.error, -corrCoeff);
        return c;
    }

    public static ErrorProp minus(ErrorProp a, ErrorProp b, double corrCoeff) {
        ErrorProp c = new ErrorProp();
        c.value = a.value - b.value;
        c.error = ErrorProp.hypotWithCov(a.error, b.error, -corrCoeff);
        return c;
    }

    public ErrorProp minus(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = this.value - a.value;
        b.error = ErrorProp.hypotWithCov(a.error, this.error, 0.0);
        return b;
    }

    public static ErrorProp minus(ErrorProp a, ErrorProp b) {
        ErrorProp c = new ErrorProp();
        c.value = a.value - b.value;
        c.error = ErrorProp.hypotWithCov(a.error, b.error, 0.0);
        return c;
    }

    public ErrorProp minus(double a) {
        ErrorProp b = new ErrorProp();
        b.value = this.value - a;
        b.error = Math.abs(this.error);
        return b;
    }

    public static ErrorProp minus(double a, ErrorProp b) {
        ErrorProp c = new ErrorProp();
        c.value = a - b.value;
        c.error = Math.abs(b.error);
        return c;
    }

    public static ErrorProp minus(double a, double b) {
        ErrorProp c = new ErrorProp();
        c.value = a - b;
        c.error = 0.0;
        return c;
    }

    public void minusEquals(ErrorProp a, double corrCoeff) {
        this.value -= a.value;
        this.error = ErrorProp.hypotWithCov(a.error, this.error, -corrCoeff);
    }

    public void minusEquals(ErrorProp a) {
        this.value -= a.value;
        this.error = ErrorProp.hypotWithCov(a.error, this.error, 0.0);
    }

    public void minusEquals(double a) {
        this.value -= a;
        this.error = Math.abs(this.error);
    }

    public ErrorProp times(ErrorProp a, double corrCoeff) {
        ErrorProp c = new ErrorProp();
        double cov = corrCoeff * a.error * this.error;
        c.value = a.value * this.value;
        c.error = a.value == 0.0 ? a.error * this.value : (this.value == 0.0 ? this.error * a.value : Math.abs(c.value) * ErrorProp.hypotWithCov(a.error / a.value, this.error / this.value, corrCoeff));
        return c;
    }

    public ErrorProp times(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = this.value * a.value;
        b.error = a.value == 0.0 ? a.error * this.value : (this.value == 0.0 ? this.error * a.value : Math.abs(b.value) * ErrorProp.hypotWithCov(a.error / a.value, this.error / this.value, 0.0));
        return b;
    }

    public ErrorProp times(double a) {
        ErrorProp b = new ErrorProp();
        b.value = this.value * a;
        b.error = Math.abs(this.error * a);
        return b;
    }

    public static ErrorProp times(ErrorProp a, ErrorProp b, double corrCoeff) {
        ErrorProp c = new ErrorProp();
        double cov = corrCoeff * a.error * b.error;
        c.value = a.value * b.value;
        c.error = a.value == 0.0 ? a.error * b.value : (b.value == 0.0 ? b.error * a.value : Math.abs(c.value) * ErrorProp.hypotWithCov(a.error / a.value, b.error / b.value, corrCoeff));
        return c;
    }

    public static ErrorProp times(ErrorProp a, ErrorProp b) {
        ErrorProp c = new ErrorProp();
        c.value = a.value * b.value;
        c.error = a.value == 0.0 ? a.error * b.value : (b.value == 0.0 ? b.error * a.value : Math.abs(c.value) * ErrorProp.hypotWithCov(a.error / a.value, b.error / b.value, 0.0));
        return c;
    }

    public static ErrorProp times(double a, ErrorProp b) {
        ErrorProp c = new ErrorProp();
        c.value = a * b.value;
        c.error = Math.abs(a * b.error);
        return c;
    }

    public static ErrorProp times(double a, double b) {
        ErrorProp c = new ErrorProp();
        c.value = a * b;
        c.error = 0.0;
        return c;
    }

    public void timesEquals(ErrorProp a, double corrCoeff) {
        ErrorProp b = new ErrorProp();
        double cov = corrCoeff * this.error * a.error;
        b.value = this.value * a.value;
        b.error = a.value == 0.0 ? a.error * this.value : (this.value == 0.0 ? this.error * a.value : Math.abs(b.value) * ErrorProp.hypotWithCov(a.error / a.value, this.error / this.value, corrCoeff));
        this.value = b.value;
        this.error = b.error;
    }

    public void timesEquals(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = this.value * a.value;
        b.error = a.value == 0.0 ? a.error * this.value : (this.value == 0.0 ? this.error * a.value : Math.abs(b.value) * ErrorProp.hypotWithCov(a.error / a.value, this.error / this.value, 0.0));
        this.value = b.value;
        this.error = b.error;
    }

    public void timesEquals(double a) {
        this.value *= a;
        this.error = Math.abs(this.error * a);
    }

    public ErrorProp over(ErrorProp a, double corrCoeff) {
        ErrorProp c = new ErrorProp();
        c.value = this.value / a.value;
        c.error = this.value == 0.0 ? this.error * a.value : Math.abs(c.value) * ErrorProp.hypotWithCov(this.error / this.value, a.error / a.value, -corrCoeff);
        return c;
    }

    public static ErrorProp over(ErrorProp a, ErrorProp b, double corrCoeff) {
        ErrorProp c = new ErrorProp();
        c.value = a.value / b.value;
        c.error = a.value == 0.0 ? a.error * b.value : Math.abs(c.value) * ErrorProp.hypotWithCov(a.error / a.value, b.error / b.value, -corrCoeff);
        return c;
    }

    public ErrorProp over(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = this.value / a.value;
        b.error = Math.abs(b.value) * ErrorProp.hypotWithCov(a.error / a.value, this.error / this.value, 0.0);
        b.error = this.value == 0.0 ? this.error * b.value : Math.abs(b.value) * ErrorProp.hypotWithCov(a.error / a.value, this.error / this.value, 0.0);
        return b;
    }

    public static ErrorProp over(ErrorProp a, ErrorProp b) {
        ErrorProp c = new ErrorProp();
        c.value = a.value / b.value;
        c.error = a.value == 0.0 ? a.error * b.value : Math.abs(c.value) * ErrorProp.hypotWithCov(a.error / a.value, b.error / b.value, 0.0);
        return c;
    }

    public ErrorProp over(double a) {
        ErrorProp b = new ErrorProp();
        b.value = this.value / a;
        b.error = Math.abs(this.error / a);
        return b;
    }

    public static ErrorProp over(double a, ErrorProp b) {
        ErrorProp c = new ErrorProp();
        c.value = a / b.value;
        c.error = Math.abs(a * b.error / (b.value * b.value));
        return c;
    }

    public static ErrorProp over(double a, double b) {
        ErrorProp c = new ErrorProp();
        c.value = a / b;
        c.error = 0.0;
        return c;
    }

    public void overEquals(ErrorProp b) {
        ErrorProp c = new ErrorProp();
        c.value = this.value / b.value;
        c.error = this.value == 0.0 ? this.error * b.value : Math.abs(c.value) * ErrorProp.hypotWithCov(this.error / this.value, b.error / b.value, 0.0);
        this.value = c.value;
        this.error = c.error;
    }

    public void overEquals(ErrorProp b, double corrCoeff) {
        ErrorProp c = new ErrorProp();
        c.value = this.value / b.value;
        c.error = this.value == 0.0 ? this.error * b.value : Math.abs(c.value) * ErrorProp.hypotWithCov(this.error / this.value, b.error / b.value, -corrCoeff);
        this.value = c.value;
        this.error = c.error;
    }

    public void overEquals(double a) {
        this.value /= a;
        this.error = Math.abs(this.error / a);
    }

    public ErrorProp inverse() {
        ErrorProp b = ErrorProp.over(1.0, this);
        return b;
    }

    public static ErrorProp inverse(ErrorProp a) {
        ErrorProp b = ErrorProp.over(1.0, a);
        return b;
    }

    public static ErrorProp hypot(ErrorProp a, ErrorProp b, double corrCoeff) {
        ErrorProp c = new ErrorProp();
        c.value = Fmath.hypot(a.value, b.value);
        c.error = Math.abs(ErrorProp.hypotWithCov(a.error * a.value, b.error * b.value, corrCoeff) / c.value);
        return c;
    }

    public static ErrorProp hypot(ErrorProp a, ErrorProp b) {
        ErrorProp c = new ErrorProp();
        c.value = Fmath.hypot(a.value, b.value);
        c.error = Math.abs(ErrorProp.hypotWithCov(a.error * a.value, b.error * b.value, 0.0) / c.value);
        return c;
    }

    public static ErrorProp abs(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Math.abs(a.value);
        b.error = Math.abs(a.error);
        return b;
    }

    public ErrorProp abs() {
        ErrorProp b = new ErrorProp();
        b.value = Math.abs(this.value);
        b.error = Math.abs(this.error);
        return b;
    }

    public static ErrorProp exp(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Math.exp(a.value);
        b.error = Math.abs(b.value * a.error);
        return b;
    }

    public static ErrorProp log(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Math.log(a.value);
        b.error = Math.abs(a.error / a.value);
        return b;
    }

    public static ErrorProp log10(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Fmath.log10(a.value);
        b.error = Math.abs(a.error / (a.value * Math.log(10.0)));
        return b;
    }

    public static ErrorProp sqrt(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Math.sqrt(a.value);
        b.error = Math.abs(a.error / (2.0 * a.value));
        return b;
    }

    public static ErrorProp nthRoot(ErrorProp a, int n) {
        if (n == 0) {
            throw new ArithmeticException("Division by zero (n = 0 - infinite root) attempted in ErrorProp.nthRoot");
        }
        ErrorProp b = new ErrorProp();
        b.value = Math.pow(a.value, 1 / n);
        b.error = Math.abs(a.error * Math.pow(a.value, 1 / n - 1) / (double)n);
        return b;
    }

    public ErrorProp square() {
        ErrorProp a = new ErrorProp(this.value, this.error);
        return a.times(a, 1.0);
    }

    public static ErrorProp square(ErrorProp a) {
        return a.times(a, 1.0);
    }

    public static ErrorProp pow(ErrorProp a, double b) {
        ErrorProp c = new ErrorProp();
        c.value = Math.pow(a.value, b);
        c.error = Math.abs(b * Math.pow(a.value, b - 1.0));
        return c;
    }

    public static ErrorProp pow(double a, ErrorProp b) {
        ErrorProp c = new ErrorProp();
        c.value = Math.pow(a, b.value);
        c.error = Math.abs(c.value * Math.log(a) * b.error);
        return c;
    }

    public static ErrorProp pow(ErrorProp a, ErrorProp b, double corrCoeff) {
        ErrorProp c = new ErrorProp();
        c.value = Math.pow(a.value, b.value);
        c.error = ErrorProp.hypotWithCov(a.error * b.value * Math.pow(a.value, b.value - 1.0), b.error * Math.log(a.value) * Math.pow(a.value, b.value), corrCoeff);
        return c;
    }

    public static ErrorProp pow(ErrorProp a, ErrorProp b) {
        ErrorProp c = new ErrorProp();
        c.value = Math.pow(a.value, b.value);
        c.error = ErrorProp.hypotWithCov(a.error * b.value * Math.pow(a.value, b.value - 1.0), b.error * Math.log(a.value) * Math.pow(a.value, b.value), 0.0);
        return c;
    }

    public static ErrorProp sin(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Math.sin(a.value);
        b.error = Math.abs(a.error * Math.cos(a.value));
        return b;
    }

    public static ErrorProp cos(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Math.cos(a.value);
        b.error = Math.abs(a.error * Math.sin(a.value));
        return b;
    }

    public static ErrorProp tan(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Math.tan(a.value);
        b.error = Math.abs(a.error * Fmath.square(Fmath.sec(a.value)));
        return b;
    }

    public static ErrorProp sinh(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Fmath.sinh(a.value);
        b.error = Math.abs(a.error * Fmath.cosh(a.value));
        return b;
    }

    public static ErrorProp cosh(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Fmath.cosh(a.value);
        b.error = Math.abs(a.error * Fmath.sinh(a.value));
        return b;
    }

    public static ErrorProp tanh(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Fmath.tanh(a.value);
        b.error = Math.abs(a.error * Fmath.square(Fmath.sech(a.value)));
        return b;
    }

    public static ErrorProp asin(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Math.asin(a.value);
        b.error = Math.abs(a.error / Math.sqrt(1.0 - a.value * a.value));
        return b;
    }

    public static ErrorProp acos(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Math.acos(a.value);
        b.error = Math.abs(a.error / Math.sqrt(1.0 - a.value * a.value));
        return b;
    }

    public static ErrorProp atan(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Math.atan(a.value);
        b.error = Math.abs(a.error / (1.0 + a.value * a.value));
        return b;
    }

    public static ErrorProp atan2(ErrorProp a, ErrorProp b) {
        ErrorProp c = new ErrorProp();
        ErrorProp d = a.over(b);
        c.value = Math.atan2(a.value, b.value);
        c.error = Math.abs(d.error / (1.0 + d.value * d.value));
        return c;
    }

    public static ErrorProp atan2(ErrorProp a, ErrorProp b, double rho) {
        ErrorProp c = new ErrorProp();
        ErrorProp d = a.over(b, rho);
        c.value = Math.atan2(a.value, b.value);
        c.error = Math.abs(d.error / (1.0 + d.value * d.value));
        return c;
    }

    public static ErrorProp asinh(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Fmath.asinh(a.value);
        b.error = Math.abs(a.error / Math.sqrt(a.value * a.value + 1.0));
        return b;
    }

    public static ErrorProp acosh(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Fmath.acosh(a.value);
        b.error = Math.abs(a.error / Math.sqrt(a.value * a.value - 1.0));
        return b;
    }

    public static ErrorProp atanh(ErrorProp a) {
        ErrorProp b = new ErrorProp();
        b.value = Fmath.atanh(a.value);
        b.error = Math.abs(a.error / (1.0 - a.value * a.value));
        return b;
    }

    public static ErrorProp zero() {
        ErrorProp c = new ErrorProp();
        c.value = 0.0;
        c.error = 0.0;
        return c;
    }

    public static ErrorProp plusOne() {
        ErrorProp c = new ErrorProp();
        c.value = 1.0;
        c.error = 0.0;
        return c;
    }

    public static ErrorProp minusOne() {
        ErrorProp c = new ErrorProp();
        c.value = -1.0;
        c.error = 0.0;
        return c;
    }

    private static double hypotWithCov(double a, double b, double r) {
        double pre = 0.0;
        double ratio = 0.0;
        double sgn = 0.0;
        if (a == 0.0 && b == 0.0) {
            return 0.0;
        }
        if (Math.abs(a) > Math.abs(b)) {
            pre = Math.abs(a);
            ratio = b / a;
            sgn = Fmath.sign(a);
        } else {
            pre = Math.abs(b);
            ratio = a / b;
            sgn = Fmath.sign(b);
        }
        return pre * Math.sqrt(1.0 + ratio * (ratio + 2.0 * r * sgn));
    }
}

