/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.codons.CodonTables;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.HashMap;

public class PurityChange {
    public static final int CODONS_AROUND = 5;
    public static final int CODONS_SIZE = 3;
    public static final int MIN_COUNT_CODON = 2;
    public static final String KEY_SEPARATOR = "\t";
    public static final boolean debug = false;
    CodonTable codonTable;

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.err.println("Usage: PurityChange snpEff_results_file");
            System.exit(-1);
        }
        CodonTable codonTable = CodonTables.getInstance().getTable("Standard");
        PurityChange purityChange = new PurityChange(codonTable);
        purityChange.load(args[0]);
    }

    public PurityChange(CodonTable codonTable) {
        this.codonTable = codonTable;
    }

    void add(HashMap<String, Integer> count, String key, int add) {
        Integer c = count.get(key);
        c = c == null ? Integer.valueOf(1) : Integer.valueOf(c + add);
        count.put(key, c);
    }

    void addAa(HashMap<String, Integer> count, String codon, int add) {
        String aa = this.codonTable.aa(codon);
        String key = aa + KEY_SEPARATOR + codon.toUpperCase();
        this.add(count, key, add);
    }

    String getCodon(String str, int codonNum) {
        int pos = codonNum * 3;
        return str.substring(pos, pos + 3);
    }

    void load(String resFileName) {
        StringBuffer out = new StringBuffer();
        Gpr.debug("Reading file: " + resFileName);
        String resFile = Gpr.readFile(resFileName);
        String[] resLines = resFile.split("\n");
        int countIgnored = 0;
        int countOk = 0;
        for (String resLine : resLines) {
            String[] recs = resLine.split(KEY_SEPARATOR);
            if (recs.length > 21) {
                String chr = recs[0];
                String pos = recs[1];
                String ref = recs[2];
                String change = recs[3];
                if (change.length() / 3 == 1) {
                    String[] codonsAround = recs[20].split("/");
                    if (codonsAround.length > 1) {
                        String codonsAroundOld = codonsAround[0].trim();
                        String codonsAroundNew = codonsAround[1].trim();
                        String[] codonsChange = recs[17].split("/");
                        String codonsOld = codonsChange[0].trim();
                        String codonsNew = codonsChange[1].trim();
                        double purityChange = this.purityChange(codonsOld, codonsAroundOld, codonsNew, codonsAroundNew);
                        String[] aastr = recs[21].split("/");
                        String aaAroundOld = aastr[0];
                        String aaAroundNew = aastr[1];
                        ++countOk;
                        String lineOut = chr + KEY_SEPARATOR + pos + KEY_SEPARATOR + ref + KEY_SEPARATOR + change + KEY_SEPARATOR + codonsAroundOld + "/" + codonsAroundNew + KEY_SEPARATOR + aaAroundOld + "/" + aaAroundNew + KEY_SEPARATOR + String.format("%.2f", purityChange);
                        System.out.println(lineOut);
                        out.append(lineOut + "\n");
                        continue;
                    }
                    ++countIgnored;
                    continue;
                }
                ++countIgnored;
                continue;
            }
            ++countIgnored;
        }
        System.out.println("OK:" + countOk + "\tIgnored:" + countIgnored + "\tTotal:" + (countOk + countIgnored));
        Gpr.toFile("/tmp/purity.txt", out);
    }

    double maxPurity(HashMap<String, Integer> count) {
        HashMap<String, Integer> countAa = new HashMap<String, Integer>();
        for (String key : count.keySet()) {
            int cnt = count.get(key);
            String aa = key.split(KEY_SEPARATOR)[0];
            this.add(countAa, aa, cnt);
        }
        int maxCountAa = 0;
        String maxAa = "";
        for (String aa : countAa.keySet()) {
            int cntAa = (Integer)countAa.get(aa);
            if (maxCountAa >= cntAa) continue;
            maxCountAa = cntAa;
            maxAa = aa;
        }
        int totalMaxAa = 0;
        int maxCountCodon = 0;
        String maxCodon = "";
        for (String key : count.keySet()) {
            String aa = key.split(KEY_SEPARATOR)[0];
            if (!aa.equals(maxAa)) continue;
            int cnt = count.get(key);
            totalMaxAa += cnt;
            if (maxCountCodon >= cnt) continue;
            maxCountCodon = cnt;
            maxCodon = key.split(KEY_SEPARATOR)[1];
        }
        double purity = 0.0;
        if (maxCountCodon >= 2) {
            purity = (double)maxCountCodon / (double)totalMaxAa;
        }
        return purity;
    }

    double purity(String codon, String around) {
        int i;
        String pre = around.substring(0, 15);
        String post = around.substring(around.length() - 15);
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        int maxSyms = codon.length() / 3;
        for (i = 0; i < maxSyms; ++i) {
            String sym = this.getCodon(codon, i);
            this.addAa(count, sym, 1);
        }
        for (i = 0; i < 5; ++i) {
            String cod = this.getCodon(pre, i);
            this.addAa(count, cod, 1);
            cod = this.getCodon(post, i);
            this.addAa(count, cod, 1);
        }
        return this.maxPurity(count);
    }

    double purityChange(String oldcodon, String aroundOld, String newcodon, String aroundNew) {
        double purityOld = this.purity(oldcodon, aroundOld);
        double purityNew = this.purity(newcodon, aroundNew);
        double purityChange = purityNew - purityOld;
        return purityChange;
    }
}

