/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.motif;

import ca.mcgill.mcb.pcingola.util.Gpr;

public class Pwm {
    public static final int SCALE = 100;
    static final double LOG2 = Math.log(2.0);
    public static final char[] BASES = new char[]{'A', 'C', 'G', 'T'};
    int[][] countMatrix;
    int[] count;
    double[][] logOdds;
    int length;
    int totalCount;

    public Pwm(int length) {
        this.length = length;
        this.countMatrix = new int[BASES.length][length];
        this.count = new int[BASES.length];
        this.logOdds = null;
    }

    public Pwm(String file) {
        String data = Gpr.readFile(file);
        String[] lines = data.split("\n");
        this.length = lines.length;
        this.countMatrix = new int[BASES.length][this.length];
        this.count = new int[BASES.length];
        this.logOdds = new double[BASES.length][this.length];
        for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
            String[] val = lines[lineNum].trim().split("\\s+");
            for (int baseNum = 0; baseNum < BASES.length; ++baseNum) {
                this.logOdds[baseNum][lineNum] = Gpr.parseDoubleSafe(val[baseNum]);
            }
        }
    }

    int base2int(char base) {
        switch (base) {
            case 'A': 
            case 'a': {
                return 0;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'G': 
            case 'g': {
                return 2;
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                return 3;
            }
        }
        return -1;
    }

    public void calcLogOddsWeight() {
        int baseNum;
        this.logOdds = new double[BASES.length][this.length];
        double[] b = new double[BASES.length];
        int total = 0;
        for (baseNum = 0; baseNum < BASES.length; ++baseNum) {
            total += this.count[baseNum] + 1;
        }
        for (baseNum = 0; baseNum < BASES.length; ++baseNum) {
            b[baseNum] = (double)(this.count[baseNum] + 1) / (double)total;
        }
        for (int i = 0; i < this.countMatrix.length; ++i) {
            for (int baseNum2 = 0; baseNum2 < BASES.length; ++baseNum2) {
                double p = (double)(this.countMatrix[baseNum2][i] + 1) / (double)total;
                this.logOdds[baseNum2][i] = Math.log(p / b[baseNum2]) / LOG2;
            }
        }
    }

    public int getCount(char base, int position) {
        return this.countMatrix[this.base2int(base)][position];
    }

    public double getLogOdds(char base, int position) {
        int baseIdx = this.base2int(base);
        if (baseIdx < 0) {
            return 0.0;
        }
        return this.logOdds[baseIdx][position];
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int length() {
        return this.length;
    }

    public double score(String dna) {
        if (this.logOdds == null) {
            this.calcLogOddsWeight();
        }
        char[] bases = dna.toCharArray();
        int score = 0;
        for (int i = 0; i < bases.length; ++i) {
            score = (int)((double)score + this.getLogOdds(bases[i], i));
        }
        return (double)score / (double)(this.length * 100);
    }

    public void set(String dna) {
        char[] bases = dna.toCharArray();
        for (int i = 0; i < bases.length; ++i) {
            for (int j = 0; j < BASES.length; ++j) {
                this.countMatrix[j][i] = 1;
            }
            this.countMatrix[this.base2int((char)bases[i])][i] = 100;
        }
    }

    int size() {
        return this.countMatrix[0].length;
    }

    public String toString() {
        int i;
        int i2;
        int b;
        StringBuffer sb = new StringBuffer();
        sb.append("Counts:\n");
        for (b = 0; b < BASES.length; ++b) {
            sb.append(BASES[b] + "\t");
            for (i2 = 0; i2 < this.countMatrix[b].length; ++i2) {
                sb.append(String.format("%10d  ", this.countMatrix[b][i2]));
            }
            sb.append("\n");
        }
        sb.append("Max:\t");
        for (i = 0; i < this.countMatrix[0].length; ++i) {
            int max = 0;
            int maxb = 0;
            for (int b2 = 0; b2 < BASES.length; ++b2) {
                if (max >= this.countMatrix[b2][i]) continue;
                max = this.countMatrix[b2][i];
                maxb = b2;
            }
            sb.append(String.format("%10s  ", Character.valueOf(BASES[maxb])));
        }
        sb.append("\n");
        sb.append("\nWeights:\n");
        for (b = 0; b < BASES.length; ++b) {
            sb.append(BASES[b] + "\t");
            for (i2 = 0; i2 < this.logOdds[b].length; ++i2) {
                sb.append(String.format("%10.2f  ", this.logOdds[b][i2]));
            }
            sb.append("\n");
        }
        sb.append("Max:\t");
        for (i = 0; i < this.countMatrix[0].length; ++i) {
            int maxb = 0;
            double max = Double.NEGATIVE_INFINITY;
            for (int b3 = 0; b3 < BASES.length; ++b3) {
                if (!(max < this.logOdds[b3][i])) continue;
                max = this.logOdds[b3][i];
                maxb = b3;
            }
            sb.append(String.format("%10s  ", Character.valueOf(BASES[maxb])));
        }
        sb.append("\n");
        return sb.toString();
    }

    public void updateCounts(String dna) {
        this.updateCounts(dna, 1);
    }

    public void updateCounts(String dna, int inc) {
        this.totalCount += inc;
        char[] bases = dna.toCharArray();
        for (int i = 0; i < bases.length; ++i) {
            int code = this.base2int(bases[i]);
            if (code < 0) continue;
            int[] nArray = this.countMatrix[code];
            int n = i;
            nArray[n] = nArray[n] + inc;
            int n2 = code;
            this.count[n2] = this.count[n2] + inc;
        }
    }
}

