/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.Index;
import org.biojava.bio.seq.db.IndexStore;
import org.biojava.bio.seq.db.SimpleIndex;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolTokenization;

public class BioIndex
implements IndexStore {
    private static Comparator STRING_CASE_SENSITIVE_ORDER = new Comparator(){

        public int compare(Object a, Object b) {
            return ((Comparable)a).compareTo(b);
        }
    };
    private File indexDirectory;
    private int fileCount = 0;
    private File[] fileIDToFile;
    private FileAsList indxList;
    private Set idSet = new ListAsSet();
    private String name;
    private SequenceFormat format;
    private SequenceBuilderFactory sbFactory;
    private SymbolTokenization symbolTokenization;

    public BioIndex(File indexDirectory, String namespace, int idLength) throws IOException, BioException {
        this.fileIDToFile = new File[4];
        if (indexDirectory.exists()) {
            throw new BioException("Can't create new index as directory already exists: " + indexDirectory);
        }
        indexDirectory.mkdirs();
        File bioindex = new File(indexDirectory, "BIOINDEX.dat");
        bioindex.createNewFile();
        PrintWriter pw = new PrintWriter(new FileWriter(bioindex));
        pw.println("index\tflat/1");
        pw.close();
        File fileids = new File(indexDirectory, "fileids.dat");
        fileids.createNewFile();
        PrintWriter fileidsWriter = new PrintWriter(new FileWriter(fileids));
        File config = new File(indexDirectory, "config.dat");
        config.createNewFile();
        PrintWriter configWriter = new PrintWriter(new FileWriter(config));
        configWriter.println("namespace\t" + namespace);
        String uniqueName = "key_" + namespace + ".key";
        File unique = new File(indexDirectory, uniqueName);
        unique.createNewFile();
        int recordLen = idLength + 1 + 4 + 1 + String.valueOf(Long.MAX_VALUE).length() + 1 + String.valueOf(Integer.MAX_VALUE).length() + "\n".length();
        this.indxList = new IndexFileAsList(new RandomAccessFile(unique, "rw"), recordLen);
        fileidsWriter.println(uniqueName + "\t" + recordLen);
        this.fileCount = 0;
        this.fileIDToFile = new File[4];
        configWriter.close();
        fileidsWriter.close();
    }

    public BioIndex(File indexDirectory) throws IOException, BioException {
        this.fileIDToFile = new File[4];
        this.indexDirectory = indexDirectory;
        if (!indexDirectory.exists()) {
            throw new BioException("Tried to load non-existant index: " + indexDirectory);
        }
        System.out.println("Global");
        HashMap<String, String> config = new HashMap<String, String>();
        BufferedReader fi = new BufferedReader(new FileReader(new File(indexDirectory, "config.dat")));
        String line = fi.readLine();
        while (line != null) {
            int tab = line.indexOf("\t");
            config.put(line.substring(0, tab), line.substring(tab + 1));
            line = fi.readLine();
        }
        String namespace = (String)config.get("namespace");
        RandomAccessFile indxFile = new RandomAccessFile("key_" + namespace + ".key", "rw");
        int recLen = this.guessRecLen(indxFile);
        this.indxList = new IndexFileAsList(indxFile, recLen);
        System.out.println("Files");
        this.fileCount = 0;
        this.fileIDToFile = new File[4];
        BufferedReader fi2 = new BufferedReader(new FileReader(new File(indexDirectory, "fileids.dat")));
        String line2 = fi2.readLine();
        while (line2 != null) {
            StringTokenizer sTok = new StringTokenizer("\t");
            int id = Integer.parseInt(sTok.nextToken());
            File file = new File(sTok.nextToken());
            long fileLength = Long.parseLong(sTok.nextToken());
            if (file.length() != fileLength) {
                throw new BioException("File length changed: " + file + " " + file.length() + " vs " + fileLength);
            }
            this.fileIDToFile[id] = file;
            line2 = fi2.readLine();
        }
    }

    private File getFileForID(int fileId) {
        return this.fileIDToFile[fileId];
    }

    private int getIDForFile(File file) {
        for (int i = 0; i < this.fileCount; ++i) {
            if (!file.equals(this.fileIDToFile[i])) continue;
            return i;
        }
        if (this.fileCount >= this.fileIDToFile.length) {
            File[] tmp = new File[this.fileIDToFile.length + 4];
            System.arraycopy(this.fileIDToFile, 0, tmp, 0, this.fileCount);
            this.fileIDToFile = tmp;
        }
        this.fileIDToFile[this.fileCount] = file;
        return this.fileCount++;
    }

    public String getName() {
        return this.name;
    }

    public int guessRecLen(RandomAccessFile file) throws IOException {
        file.seek(0L);
        int b = 0;
        while (b != 10 && b != 13) {
            b = file.read();
        }
        int offset = (int)file.getFilePointer();
        if (b == 10) {
            return offset + 1;
        }
        b = file.read();
        if (b == 10) {
            return offset + 2;
        }
        return offset + 1;
    }

    public Index fetch(String id) throws IllegalIDException, BioException {
        int indx = Collections.binarySearch(this.indxList, id, this.indxList.getComparator());
        if (indx < 0) {
            throw new IllegalIDException("Can't find sequence for " + id);
        }
        return (Index)this.indxList.get(indx);
    }

    public void store(Index indx) {
        this.indxList.add(indx);
    }

    public void commit() throws BioException {
        this.indxList.commit();
        try {
            PrintStream fo = new PrintStream(new FileOutputStream(new File(this.indexDirectory, "fileids.dat")));
            for (int i = 0; i < this.fileCount; ++i) {
                fo.print(i);
                fo.print('\t');
                fo.print(this.fileIDToFile[i]);
                fo.print('\t');
                fo.print(this.fileIDToFile[i].length());
                fo.println();
            }
            fo.close();
        }
        catch (Exception e) {
            this.rollback();
            throw new BioException("Unable to commit. Rolled back to be safe", e);
        }
    }

    public void rollback() {
        this.indxList.rollback();
    }

    public Set getIDs() {
        return this.idSet;
    }

    public Set getFiles() {
        return new HashSet<File>(Arrays.asList(this.fileIDToFile));
    }

    public SequenceFormat getFormat() {
        return this.format;
    }

    public SequenceBuilderFactory getSBFactory() {
        return this.sbFactory;
    }

    public SymbolTokenization getSymbolParser() {
        return this.symbolTokenization;
    }

    private class ListAsSet
    extends AbstractSet {
        private ListAsSet() {
        }

        public Iterator iterator() {
            return BioIndex.this.indxList.iterator();
        }

        public int size() {
            return BioIndex.this.indxList.size();
        }
    }

    private class IndexFileAsList
    extends FileAsList {
        private Comparator INDEX_COMPARATOR;

        public IndexFileAsList(RandomAccessFile file, int recordLength) {
            super(file, recordLength);
            this.INDEX_COMPARATOR = new Comparator(){

                public int compare(Object a, Object b) {
                    String as = a instanceof Index ? ((Index)a).getID() : (String)a;
                    String bs = b instanceof Index ? ((Index)b).getID() : (String)b;
                    return STRING_CASE_SENSITIVE_ORDER.compare(as, bs);
                }
            };
        }

        protected Object parseRecord(byte[] buffer) {
            int lastI = 0;
            int newI = 0;
            while (buffer[newI] != 9) {
                ++newI;
            }
            String id = new String(buffer, lastI, newI);
            while (buffer[newI] != 9) {
                ++newI;
            }
            File file = BioIndex.this.getFileForID(Integer.parseInt(new String(buffer, lastI, newI).trim()));
            while (buffer[newI] != 9) {
                ++newI;
            }
            long start = Long.parseLong(new String(buffer, lastI, newI));
            int length = Integer.parseInt(new String(buffer, newI + 1, buffer.length));
            return new SimpleIndex(file, start, length, id);
        }

        protected void generateRecord(byte[] buffer, Object item) {
            int j;
            Index indx = (Index)item;
            String id = indx.getID();
            int fileID = BioIndex.this.getIDForFile(indx.getFile());
            String start = String.valueOf(indx.getStart());
            String length = String.valueOf(indx.getLength());
            int i = 0;
            byte[] str = id.getBytes();
            for (j = 0; j < str.length; ++j) {
                buffer[i++] = str[j];
            }
            buffer[i++] = 9;
            str = String.valueOf(fileID).getBytes();
            for (j = 0; j < str.length; ++j) {
                buffer[i++] = str[j];
            }
            buffer[i++] = 9;
            str = start.getBytes();
            for (j = 0; j < str.length; ++j) {
                buffer[i++] = str[j];
            }
            buffer[i++] = 9;
            str = length.getBytes();
            for (j = 0; j < str.length; ++j) {
                buffer[i++] = str[j];
            }
            while (i < buffer.length - 1) {
                buffer[i++] = 32;
            }
            buffer[i] = 10;
        }

        public Comparator getComparator() {
            return this.INDEX_COMPARATOR;
        }
    }

    private abstract class FileAsList
    extends AbstractList
    implements Commitable {
        private RandomAccessFile mappedFile;
        private int commitedRecords;
        private int lastIndx;
        private Object lastRec;
        private byte[] buffer;

        public FileAsList(RandomAccessFile mappedFile, int recordLength) {
            this.mappedFile = mappedFile;
            this.buffer = new byte[recordLength];
        }

        public Object get(int indx) {
            if (indx < 0 || indx >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (indx == this.lastIndx) {
                return this.lastRec;
            }
            long offset = indx * this.buffer.length;
            try {
                this.mappedFile.seek(offset);
                this.mappedFile.readFully(this.buffer);
            }
            catch (IOException ioe) {
                throw new BioError("Failed to seek for record", ioe);
            }
            this.lastRec = this.parseRecord(this.buffer);
            this.lastIndx = indx;
            return this.lastRec;
        }

        public int size() {
            try {
                return (int)(this.mappedFile.length() / (long)this.buffer.length);
            }
            catch (IOException ioe) {
                throw new BioError("Can't read file length", ioe);
            }
        }

        public boolean add(Object o) {
            this.generateRecord(this.buffer, o);
            try {
                this.mappedFile.seek(this.mappedFile.length());
                this.mappedFile.write(this.buffer);
            }
            catch (IOException ioe) {
                throw new BioError("Failed to write index", ioe);
            }
            return true;
        }

        public void commit() {
            Collections.sort(BioIndex.this.indxList, BioIndex.this.indxList.getComparator());
            this.commitedRecords = BioIndex.this.indxList.size();
        }

        public void rollback() {
            try {
                this.mappedFile.setLength((long)this.commitedRecords * (long)this.buffer.length);
            }
            catch (Throwable t) {
                throw new BioError("Could not roll back. The index store will be in an inconsistent state and should be discarded. File: " + this.mappedFile, t);
            }
        }

        protected abstract Object parseRecord(byte[] var1);

        protected abstract void generateRecord(byte[] var1, Object var2);

        protected abstract Comparator getComparator();
    }

    private static interface Commitable {
        public void commit() throws BioException;

        public void rollback();
    }
}

