/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.Impedance;
import flanagan.circuits.TransmissionLine;

public class TwoWireLine
extends TransmissionLine {
    private double wireRadius = -1.0;
    private double wireSeparation = -1.0;
    private boolean distancesSet = false;
    private double relativePermittivity = 1.0;
    private double relativePermeability = 1.0;

    public void setWireRadius(double radius) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("The wire radius, " + radius + ", must be greater than zero");
        }
        if (this.wireSeparation != -1.0 && this.wireSeparation <= 2.0 * radius) {
            throw new IllegalArgumentException("The wire separation distance, " + this.wireSeparation + ", must be greater than the sum of the two wire radii, " + 2.0 * radius);
        }
        this.wireRadius = radius;
        if (this.wireSeparation != -1.0) {
            this.distancesSet = true;
        }
        if (this.distancesSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setWireSeparation(double separation) {
        if (separation <= 0.0) {
            throw new IllegalArgumentException("The wire separation, " + separation + ", must be greater than zero");
        }
        if (this.wireRadius != -1.0 && separation <= 2.0 * this.wireRadius) {
            throw new IllegalArgumentException("The wire separation distance, " + separation + ", must be greater than the sum of the two wire radii, " + 2.0 * this.wireRadius);
        }
        this.wireSeparation = separation;
        if (this.wireRadius != -1.0) {
            this.distancesSet = true;
        }
        if (this.distancesSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setRelativePermittivity(double epsilonR) {
        this.relativePermittivity = epsilonR;
        if (this.distancesSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setRelativePermeability(double muR) {
        this.relativePermeability = muR;
        if (this.distancesSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    private void calculateDistributedCapacitanceAndInductance() {
        this.distributedCapacitance = Impedance.parallelWiresCapacitance(1.0, this.wireRadius, this.wireSeparation, this.relativePermittivity);
        this.distributedInductance = Impedance.parallelWiresInductance(1.0, this.wireRadius, this.wireSeparation, this.relativePermeability);
    }

    @Override
    public TwoWireLine copy() {
        if (this == null) {
            return null;
        }
        TwoWireLine tl = new TwoWireLine();
        tl.wireRadius = this.wireRadius;
        tl.wireSeparation = this.wireSeparation;
        tl.distancesSet = this.distancesSet;
        tl.relativePermittivity = this.relativePermittivity;
        tl.relativePermeability = this.relativePermeability;
        tl.title = this.title;
        tl.distributedResistance = this.distributedResistance;
        tl.distributedConductance = this.distributedConductance;
        tl.distributedCapacitance = this.distributedCapacitance;
        tl.distributedInductance = this.distributedInductance;
        tl.distributedImpedance = this.distributedImpedance.copy();
        tl.distributedAdmittance = this.distributedAdmittance.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.lineLength = this.lineLength;
        tl.segmentLength = this.segmentLength;
        tl.frequency = this.frequency;
        tl.segmentLength = this.segmentLength;
        tl.omega = this.omega;
        tl.inputVoltage = this.inputVoltage.copy();
        tl.inputCurrent = this.inputCurrent.copy();
        tl.outputVoltage = this.outputVoltage.copy();
        tl.outputCurrent = this.outputCurrent.copy();
        tl.idealWavelength = this.idealWavelength;
        tl.generalWavelength = this.generalWavelength;
        tl.lowLossWavelength = this.lowLossWavelength;
        tl.idealPhaseVelocity = this.idealPhaseVelocity;
        tl.generalPhaseVelocity = this.generalPhaseVelocity;
        tl.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
        tl.idealGroupVelocity = this.idealGroupVelocity;
        tl.generalGroupVelocity = this.generalGroupVelocity;
        tl.lowLossGroupVelocity = this.lowLossGroupVelocity;
        tl.delta = this.delta;
        tl.idealAttenuationConstant = this.idealAttenuationConstant;
        tl.generalAttenuationConstant = this.generalAttenuationConstant;
        tl.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
        tl.idealPhaseConstant = this.idealPhaseConstant;
        tl.generalPhaseConstant = this.generalPhaseConstant;
        tl.lowLossPhaseConstant = this.lowLossPhaseConstant;
        tl.idealPropagationConstant = this.idealPropagationConstant.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.generalPropagationConstant = this.generalPropagationConstant.copy();
        tl.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
        tl.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
        tl.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
        tl.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
        tl.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
        tl.idealInputImpedance = this.idealInputImpedance.copy();
        tl.generalInputImpedance = this.generalInputImpedance.copy();
        tl.lowLossInputImpedance = this.lowLossInputImpedance.copy();
        tl.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
        tl.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
        tl.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
        tl.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
        tl.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
        tl.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
        tl.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
        tl.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
        tl.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
        tl.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
        tl.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
        tl.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
        tl.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
        tl.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
        tl.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
        tl.idealStandingWaveRatio = this.idealStandingWaveRatio;
        tl.generalStandingWaveRatio = this.generalStandingWaveRatio;
        tl.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
        tl.idealABCDmatrix = this.idealABCDmatrix.copy();
        tl.generalABCDmatrix = this.generalABCDmatrix.copy();
        tl.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
        tl.numberOfPoints = this.numberOfPoints;
        return tl;
    }

    @Override
    public Object clone() {
        TwoWireLine ret = null;
        if (this != null) {
            TwoWireLine tl = new TwoWireLine();
            tl.wireRadius = this.wireRadius;
            tl.wireSeparation = this.wireSeparation;
            tl.distancesSet = this.distancesSet;
            tl.relativePermittivity = this.relativePermittivity;
            tl.relativePermeability = this.relativePermeability;
            tl.title = this.title;
            tl.distributedResistance = this.distributedResistance;
            tl.distributedConductance = this.distributedConductance;
            tl.distributedCapacitance = this.distributedCapacitance;
            tl.distributedInductance = this.distributedInductance;
            tl.distributedImpedance = this.distributedImpedance.copy();
            tl.distributedAdmittance = this.distributedAdmittance.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.lineLength = this.lineLength;
            tl.segmentLength = this.segmentLength;
            tl.frequency = this.frequency;
            tl.segmentLength = this.segmentLength;
            tl.omega = this.omega;
            tl.inputVoltage = this.inputVoltage.copy();
            tl.inputCurrent = this.inputCurrent.copy();
            tl.outputVoltage = this.outputVoltage.copy();
            tl.outputCurrent = this.outputCurrent.copy();
            tl.idealWavelength = this.idealWavelength;
            tl.generalWavelength = this.generalWavelength;
            tl.lowLossWavelength = this.lowLossWavelength;
            tl.idealPhaseVelocity = this.idealPhaseVelocity;
            tl.generalPhaseVelocity = this.generalPhaseVelocity;
            tl.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
            tl.idealGroupVelocity = this.idealGroupVelocity;
            tl.generalGroupVelocity = this.generalGroupVelocity;
            tl.lowLossGroupVelocity = this.lowLossGroupVelocity;
            tl.delta = this.delta;
            tl.idealAttenuationConstant = this.idealAttenuationConstant;
            tl.generalAttenuationConstant = this.generalAttenuationConstant;
            tl.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
            tl.idealPhaseConstant = this.idealPhaseConstant;
            tl.generalPhaseConstant = this.generalPhaseConstant;
            tl.lowLossPhaseConstant = this.lowLossPhaseConstant;
            tl.idealPropagationConstant = this.idealPropagationConstant.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.generalPropagationConstant = this.generalPropagationConstant.copy();
            tl.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
            tl.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
            tl.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
            tl.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
            tl.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
            tl.idealInputImpedance = this.idealInputImpedance.copy();
            tl.generalInputImpedance = this.generalInputImpedance.copy();
            tl.lowLossInputImpedance = this.lowLossInputImpedance.copy();
            tl.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
            tl.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
            tl.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
            tl.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
            tl.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
            tl.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
            tl.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
            tl.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
            tl.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
            tl.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
            tl.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
            tl.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
            tl.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
            tl.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
            tl.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
            tl.idealStandingWaveRatio = this.idealStandingWaveRatio;
            tl.generalStandingWaveRatio = this.generalStandingWaveRatio;
            tl.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
            tl.idealABCDmatrix = this.idealABCDmatrix.copy();
            tl.generalABCDmatrix = this.generalABCDmatrix.copy();
            tl.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
            tl.numberOfPoints = this.numberOfPoints;
            ret = tl;
        }
        return ret;
    }
}

