/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRand;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesIns
extends TestCase {
    boolean debug = false;
    Random rand;
    Config config;
    Genome genome;
    Chromosome chromosome;
    Gene gene;
    Transcript transcript;
    SnpEffectPredictor snpEffectPredictor;
    String chromoSequence = "";
    char[] chromoBases;

    public TestCasesIns() {
        this.init();
    }

    void init() {
        this.initRand();
        this.initSnpEffPredictor();
    }

    void initRand() {
        this.rand = new Random(20100629L);
    }

    void initSnpEffPredictor() {
        this.config = new Config("testCase", "snpEff.config");
        int maxGeneLen = 1000;
        int maxTranscripts = 1;
        int maxExons = 5;
        SnpEffPredictorFactoryRand sepf = new SnpEffPredictorFactoryRand(this.config, 1, this.rand, maxGeneLen, maxTranscripts, maxExons);
        this.chromoSequence = sepf.getChromoSequence();
        this.chromoBases = this.chromoSequence.toCharArray();
        this.snpEffectPredictor = sepf.create();
        this.config.setSnpEffectPredictor(this.snpEffectPredictor);
        this.config.getSnpEffectPredictor().setUpDownStreamLength(0);
        this.config.getSnpEffectPredictor().buildForest();
        this.chromosome = sepf.getChromo();
        this.genome = this.config.getGenome();
        this.gene = this.genome.getGenes().iterator().next();
        this.transcript = (Transcript)this.gene.iterator().next();
    }

    public void test_01() {
        int N = 1000;
        CodonTable codonTable = this.genome.codonTable();
        for (int i = 0; i < N; ++i) {
            this.initSnpEffPredictor();
            if (this.debug) {
                System.out.println("INS Test iteration: " + i + "\n" + this.transcript);
            } else {
                System.out.println("INS Test iteration: " + i + "\t" + this.transcript.cds());
            }
            int cdsBaseNum = 0;
            for (Exon exon : this.transcript.sortedStrand()) {
                int beg;
                int step = exon.getStrand() >= 0 ? 1 : -1;
                int pos = beg = exon.getStrand() >= 0 ? exon.getStart() : exon.getEnd();
                while (pos >= exon.getStart() && pos <= exon.getEnd()) {
                    String insPlus;
                    int insLen = this.rand.nextInt(10) + 1;
                    String ins = insPlus = GprSeq.randSequence(this.rand, insLen);
                    int cdsCodonNum = cdsBaseNum / 3;
                    int cdsCodonPos = cdsBaseNum % 3;
                    int minCodonPos = cdsCodonNum * 3;
                    int maxCodonPos = minCodonPos + 3;
                    if (maxCodonPos < this.transcript.cds().length()) {
                        int seqChangeStrand;
                        String codonOld = this.transcript.cds().substring(minCodonPos, maxCodonPos);
                        codonOld = codonOld.toUpperCase();
                        String aaOld = codonTable.aa(codonOld);
                        String codonNew = "";
                        String aaNew = "";
                        int n = seqChangeStrand = this.rand.nextBoolean() ? 1 : -1;
                        if (seqChangeStrand == -exon.getStrand()) {
                            ins = GprSeq.reverseWc(insPlus);
                        }
                        SeqChange seqChange = new SeqChange(this.chromosome, pos, "", "+" + ins, seqChangeStrand, "", 1.0, 1);
                        Assert.assertEquals((boolean)true, (boolean)seqChange.isIns());
                        String effectExpected = "";
                        if (insLen % 3 != 0) {
                            aaOld = "-";
                            codonNew = insPlus;
                            aaNew = codonTable.aa(codonNew);
                            effectExpected = "FRAME_SHIFT(" + aaOld + "/" + aaNew + ")";
                        } else {
                            if (cdsCodonPos == 0) {
                                aaOld = "-";
                                codonOld = "-";
                                codonNew = insPlus;
                                aaNew = codonTable.aa(codonNew);
                                effectExpected = "CODON_INSERTION(" + aaOld + "/" + aaNew + ")";
                            } else {
                                codonNew = codonOld.substring(0, cdsCodonPos) + insPlus + codonOld.substring(cdsCodonPos);
                                aaNew = codonTable.aa(codonNew);
                                effectExpected = codonNew.startsWith(codonOld) ? "CODON_INSERTION(" + aaOld + "/" + aaNew + ")" : "CODON_CHANGE_PLUS_CODON_INSERTION(" + aaOld + "/" + aaNew + ")";
                            }
                            if (cdsCodonNum == 0 && codonTable.isStartFirst(codonOld) && !codonTable.isStartFirst(codonNew)) {
                                effectExpected = "START_LOST(" + aaOld + "/" + aaNew + ")";
                            } else if (aaOld.indexOf(42) >= 0 && aaNew.indexOf(42) < 0) {
                                effectExpected = "STOP_LOST(" + aaOld + "/" + aaNew + ")";
                            } else if (aaNew.indexOf(42) >= 0 && aaOld.indexOf(42) < 0) {
                                effectExpected = "STOP_GAINED(" + aaOld + "/" + aaNew + ")";
                            }
                        }
                        List<ChangeEffect> effects = this.snpEffectPredictor.seqChangeEffect(seqChange);
                        Assert.assertEquals((int)1, (int)effects.size());
                        ChangeEffect effect = effects.get(0);
                        String effStr = effect.effect(true, true, true);
                        if (this.debug) {
                            System.out.println("\tPos: " + pos + "\tCDS base num: " + cdsBaseNum + " [" + cdsCodonNum + ":" + cdsCodonPos + "]" + "\t" + seqChange + "\tstrand" + (seqChange.getStrand() >= 0 ? "+" : "-") + "\tCodon: " + codonOld + " -> " + codonNew + "\tAA: " + aaOld + " -> " + aaNew + "\tEffect: " + effStr + "\tEffect expected: " + effectExpected);
                        }
                        Assert.assertEquals((String)effectExpected, (String)effStr);
                    }
                    pos += step;
                    ++cdsBaseNum;
                }
            }
        }
    }
}

