/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.SeqChangeFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.IOException;

public class SeqChangeFilePileUp
extends SeqChangeFileIterator {
    public SeqChangeFilePileUp(String fileName, Genome genome, int positionBase) {
        super(fileName, genome, positionBase);
    }

    @Override
    protected SeqChange readNext() {
        try {
            while (this.ready()) {
                String[] fields;
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (this.line.length() <= 0 || this.line.startsWith("#") || (fields = this.line.split("\\s")).length < 4) continue;
                String chromosome = fields[0].trim();
                Chromosome chromo = this.getChromosome(chromosome);
                this.sanityCheckChromo(chromosome, chromo);
                int start = this.parsePosition(fields[1]);
                String reference = fields[2];
                String change = fields[3];
                int strand = 1;
                double quality = Gpr.parseDoubleSafe(fields[5]);
                int coverage = Gpr.parseIntSafe(fields[7]);
                return new SeqChange(chromo, start, reference, change, strand, "", quality, coverage);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

