/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fastq.FastqBuilder;
import ca.mcgill.mcb.pcingola.fastq.FastqVariant;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class FastqFileIterator
implements Iterable<Fastq>,
Iterator<Fastq> {
    public static boolean debug = false;
    FastqBuilder fastqBuilder = new FastqBuilder();
    BufferedReader reader;
    boolean seqReady = false;
    String line;
    int lineNum;

    public FastqFileIterator(InputStream inStream, FastqVariant variant) {
        this.fastqBuilder.withVariant(variant);
        this.line = null;
        this.lineNum = 0;
        this.reader = null;
        this.reader = new BufferedReader(new InputStreamReader(inStream));
    }

    public FastqFileIterator(String fastqFileName) {
        this.fastqBuilder.withVariant(FastqVariant.FASTQ_SANGER);
        this.line = null;
        this.lineNum = 0;
        this.reader = null;
        try {
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(fastqFileName))));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public FastqFileIterator(String fastqFileName, FastqVariant variant) {
        this.fastqBuilder.withVariant(variant);
        this.line = null;
        this.lineNum = 0;
        this.reader = null;
        try {
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(fastqFileName))));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reader = null;
        this.line = null;
        this.lineNum = 0;
        this.seqReady = false;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    @Override
    public boolean hasNext() {
        if (this.reader == null) {
            return false;
        }
        if (!this.seqReady) {
            this.seqReady = this.readSeq();
            if (!this.seqReady) {
                this.close();
            }
        }
        return this.seqReady;
    }

    @Override
    public Iterator<Fastq> iterator() {
        return this;
    }

    @Override
    public Fastq next() {
        if (this.hasNext()) {
            this.seqReady = false;
            Fastq fastq = this.fastqBuilder.build();
            return fastq;
        }
        return null;
    }

    boolean readSeq() {
        try {
            State state = State.DESCRIPTION;
            while (this.reader.ready()) {
                if (this.line == null) {
                    this.line = this.reader.readLine();
                    ++this.lineNum;
                }
                if (debug) {
                    Gpr.debug("State:" + (Object)((Object)state) + "\tLine " + this.lineNum + ": " + this.line);
                }
                switch (state) {
                    case DESCRIPTION: {
                        if (!this.line.startsWith("@")) break;
                        this.fastqBuilder.withDescription(this.line.trim());
                        state = State.SEQUENCE;
                        break;
                    }
                    case SEQUENCE: {
                        this.fastqBuilder.withSequence(this.line.trim());
                        state = State.REPEAT_DESCRIPTION;
                        break;
                    }
                    case REPEAT_DESCRIPTION: {
                        if (this.line.startsWith("+")) {
                            state = State.QUALITY;
                            break;
                        }
                        this.fastqBuilder.appendSequence(this.line.trim());
                        break;
                    }
                    case QUALITY: {
                        this.fastqBuilder.withQuality(this.line.trim());
                        state = State.COMPLETE;
                        break;
                    }
                    case COMPLETE: {
                        if (this.line.startsWith("@")) {
                            state = State.COMPLETE;
                            return true;
                        }
                        this.fastqBuilder.appendQuality(this.line.trim());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unkown state '" + (Object)((Object)state) + "'");
                    }
                }
                this.line = null;
            }
            if (state == State.COMPLETE) {
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unimplemented");
    }

    private static enum State {
        DESCRIPTION,
        SEQUENCE,
        REPEAT_DESCRIPTION,
        QUALITY,
        COMPLETE;

    }
}

