/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.cli.InvalidDataException;
import edu.mayo.pipes.InputStreamPipe;
import edu.mayo.pipes.LineCounterPipe;
import edu.mayo.pipes.PrintPipe;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class UnixStreamPipeline {
    private Status mStatus = new Status();
    private static Logger sLogger = Logger.getLogger(UnixStreamPipeline.class);

    public Status getStatus() {
        return this.mStatus;
    }

    public void execute(Pipe<History, History> logic) throws InvalidDataException {
        HistoryInPipe historyIn = new HistoryInPipe();
        HistoryOutPipe historyOut = new HistoryOutPipe();
        this.execute((Pipe)historyIn, logic, (Pipe)historyOut);
    }

    public void execute(Pipe preLogic, Pipe logic, Pipe postLogic) throws InvalidDataException {
        InputStreamPipe in = new InputStreamPipe();
        PrintPipe print = new PrintPipe();
        LineCounterPipe counterPipeIn = new LineCounterPipe();
        LineCounterPipe counterPipeOut = new LineCounterPipe();
        Pipeline pipeline = new Pipeline(new Pipe[]{in, preLogic, counterPipeIn, logic, counterPipeOut, postLogic, print});
        pipeline.setStarts(Arrays.asList(System.in));
        boolean hasNext = true;
        while (hasNext) {
            try {
                pipeline.next();
            }
            catch (NoSuchElementException e) {
                hasNext = false;
            }
            catch (InvalidPipeInputException e) {
                ++this.mStatus.numLinesBadData;
                sLogger.error((Object)e.getMessage());
            }
        }
        this.mStatus.numLinesIn = counterPipeIn.getLineCount();
        this.mStatus.numLinesOut = counterPipeOut.getLineCount();
        this.mStatus.isSuccessful = true;
        if (this.mStatus.numLinesBadData > 0L) {
            String msg = String.format("WARNING: Found %s data error(s).  Not all input data rows could be successfully processed.", String.valueOf(this.mStatus.numLinesBadData));
            System.err.println(msg);
        }
    }

    public class Status {
        public long numLinesIn = 0L;
        public long numLinesOut = 0L;
        public long numLinesBadData = 0L;
        public boolean isSuccessful = false;

        public String toString() {
            String out = "numLinesIn=" + this.numLinesIn + "\n" + "numLinesOut=" + this.numLinesOut + "\n" + "numLinesBadData=" + this.numLinesBadData + "\n" + "isSuccessful=" + this.isSuccessful + "\n";
            return out;
        }
    }
}

