/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Downstream;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.IntervalAndSubIntervals;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSerializer;
import ca.mcgill.mcb.pcingola.interval.MarkerUtil;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteBranch;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteBranchU12;
import ca.mcgill.mcb.pcingola.interval.Upstream;
import ca.mcgill.mcb.pcingola.interval.Utr;
import ca.mcgill.mcb.pcingola.interval.Utr3prime;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.stats.ObservedOverExpectedCpG;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Transcript
extends IntervalAndSubIntervals<Exon> {
    private static final long serialVersionUID = -2665025617916107311L;
    boolean proteinCoding = false;
    int cdsStart = -1;
    int cdsEnd = -1;
    String bioType = "";
    String cds = null;
    ArrayList<SpliceSiteBranch> spliceBranchSites = new ArrayList();
    ArrayList<Utr> utrs = new ArrayList();
    ArrayList<Cds> cdss = new ArrayList();
    ArrayList<Intron> introns;
    Upstream upstream;
    Downstream downstream;
    Exon firstCodingExon;
    int[] cds2pos;

    protected Transcript() {
        this.type = ChangeEffect.EffectType.TRANSCRIPT;
    }

    public Transcript(Gene gene, int start, int end, int strand, String id) {
        super(gene, start, end, strand, id);
        this.type = ChangeEffect.EffectType.TRANSCRIPT;
    }

    @Override
    public void add(Cds cdsInt) {
        this.cdss.add(cdsInt);
        this.cds = null;
    }

    @Override
    public void add(SpliceSiteBranchU12 branchU12) {
        this.spliceBranchSites.add(branchU12);
    }

    @Override
    public void add(Utr utr) {
        this.utrs.add(utr);
        this.cds = null;
    }

    boolean addMissingUtrs(Markers missingUtrs, boolean verbose) {
        missingUtrs.sort(false, this.strand < 0);
        int minCds = Integer.MAX_VALUE;
        int maxCds = 0;
        for (Cds c : this.cdss) {
            minCds = Math.min(minCds, c.getStart());
            maxCds = Math.max(maxCds, c.getEnd());
        }
        if (verbose) {
            System.out.println("Transcript '" + this.id + "' has missing UTRs. Strand: " + this.strand + " (minCds: " + minCds + " , maxCds: " + maxCds + "):");
        }
        boolean retVal = false;
        for (Marker mu : missingUtrs) {
            Exon exon = this.intersectingExon(mu);
            if (exon == null) {
                throw new RuntimeException("Cannot find exon for UTR: " + mu);
            }
            Utr toAdd = null;
            if (this.isStrandPlus()) {
                if (mu.getEnd() <= minCds) {
                    toAdd = new Utr5prime(exon, mu.getStart(), mu.getEnd(), (int)this.strand, mu.getId());
                } else if (mu.getStart() >= maxCds) {
                    toAdd = new Utr3prime(exon, mu.getStart(), mu.getEnd(), (int)this.strand, mu.getId());
                }
            } else if (mu.getStart() >= maxCds) {
                toAdd = new Utr5prime(exon, mu.getStart(), mu.getEnd(), (int)this.strand, mu.getId());
            } else if (mu.getEnd() <= minCds) {
                toAdd = new Utr3prime(exon, mu.getStart(), mu.getEnd(), (int)this.strand, mu.getId());
            }
            if (toAdd == null) continue;
            this.add(toAdd);
            if (verbose) {
                System.out.println("\tAdding " + toAdd);
            }
            retVal = true;
        }
        return retVal;
    }

    public boolean adjust() {
        byte newStrand;
        boolean changed = false;
        int strandSumTr = 0;
        int newStart = this.start;
        int newEnd = this.end;
        if (newStart == 0 && newEnd == 0) {
            newStart = Integer.MAX_VALUE;
            newEnd = Integer.MIN_VALUE;
        }
        int countStrandPlus = 0;
        int countStrandMinus = 0;
        for (Exon exon : this.sortedStrand()) {
            newStart = Math.min(newStart, exon.getStart());
            newEnd = Math.max(newEnd, exon.getEnd());
            if (exon.getStrand() > 0) {
                ++countStrandPlus;
                continue;
            }
            if (exon.getStrand() >= 0) continue;
            ++countStrandMinus;
        }
        for (Utr utr : this.getUtrs()) {
            newStart = Math.min(newStart, utr.getStart());
            newEnd = Math.max(newEnd, utr.getEnd());
        }
        strandSumTr = countStrandPlus - countStrandMinus;
        byte by = newStrand = strandSumTr >= 0 ? (byte)1 : -1;
        if (countStrandPlus > 0 && countStrandMinus > 0) {
            Gpr.debug("Transcript '" + this.id + "' has " + countStrandPlus + " exons on the plus and " + countStrandMinus + " exons on the minus strand! This should never happen!");
        }
        if (this.strand != newStrand) {
            changed = true;
            this.setStart(newStrand);
        }
        if (this.start != newStart) {
            this.start = newStart;
            changed = true;
        }
        if (this.end != newEnd) {
            this.end = newEnd;
            changed = true;
        }
        return changed;
    }

    synchronized void calcCdsStartEnd() {
        if (this.cdsStart < 0) {
            if (this.utrs.isEmpty()) {
                this.cdsStart = this.isStrandPlus() ? this.end : this.start;
                this.cdsEnd = this.isStrandPlus() ? this.start : this.end;
                for (Exon ex : this) {
                    if (this.isStrandPlus()) {
                        this.cdsStart = Math.min(this.cdsStart, ex.getStart());
                        this.cdsEnd = Math.max(this.cdsEnd, ex.getEnd());
                        continue;
                    }
                    this.cdsStart = Math.max(this.cdsStart, ex.getEnd());
                    this.cdsEnd = Math.min(this.cdsEnd, ex.getStart());
                }
            } else {
                this.cdsStart = this.isStrandPlus() ? this.start : this.end;
                this.cdsEnd = this.isStrandPlus() ? this.end : this.start;
                int cdsStartNotExon = this.cdsStart;
                for (Utr utr : this.utrs) {
                    if (utr instanceof Utr5prime) {
                        if (this.isStrandPlus()) {
                            this.cdsStart = Math.max(this.cdsStart, utr.getEnd() + 1);
                            continue;
                        }
                        this.cdsStart = Math.min(this.cdsStart, utr.getStart() - 1);
                        continue;
                    }
                    if (!(utr instanceof Utr3prime)) continue;
                    if (this.isStrandPlus()) {
                        this.cdsEnd = Math.min(this.cdsEnd, utr.getStart() - 1);
                        continue;
                    }
                    this.cdsEnd = Math.max(this.cdsEnd, utr.getEnd() + 1);
                }
                if (this.isStrandPlus()) {
                    this.cdsStart = this.firstExonPositionAfter(this.cdsStart);
                    this.cdsEnd = this.lastExonPositionBefore(this.cdsEnd);
                } else {
                    this.cdsStart = this.lastExonPositionBefore(this.cdsStart);
                    this.cdsEnd = this.firstExonPositionAfter(this.cdsEnd);
                }
                if (this.cdsStart < 0 || this.cdsEnd < 0) {
                    this.cdsStart = this.cdsEnd = cdsStartNotExon;
                }
            }
        }
    }

    public synchronized String cds() {
        if (this.cds != null) {
            return this.cds;
        }
        List exons = this.sortedStrand();
        StringBuilder sequence = new StringBuilder();
        int utr5len = 0;
        int utr3len = 0;
        for (Utr utr : this.get5primeUtrs()) {
            utr5len += utr.size();
        }
        boolean missingSequence = false;
        for (Exon exon : exons) {
            missingSequence |= !exon.hasSequence();
            sequence.append(exon.getSequence());
        }
        if (missingSequence) {
            this.cds = "";
        } else {
            for (Utr utr : this.get3primeUtrs()) {
                utr3len += utr.size();
            }
            int n = sequence.length() - utr3len;
            this.cds = utr5len > n ? "" : sequence.substring(utr5len, n);
        }
        return this.cds;
    }

    public synchronized int cdsBaseNumber(int pos, boolean usePrevBaseIntron) {
        if (!this.intersects(pos)) {
            return -1;
        }
        if (this.isUtr(pos)) {
            return -1;
        }
        this.calcCdsStartEnd();
        int firstCdsBaseInExon = 0;
        for (Exon eint : this.sortedStrand()) {
            if (eint.intersects(pos)) {
                int cdsBaseInExon = this.strand >= 0 ? pos - Math.max(eint.getStart(), this.cdsStart) : Math.min(eint.getEnd(), this.cdsStart) - pos;
                cdsBaseInExon = Math.max(0, cdsBaseInExon);
                return firstCdsBaseInExon + cdsBaseInExon;
            }
            if (this.isStrandPlus() && pos < eint.getStart() || this.isStrandMinus() && pos > eint.getEnd()) {
                return firstCdsBaseInExon - (usePrevBaseIntron ? 1 : 0);
            }
            if (this.isStrandPlus()) {
                firstCdsBaseInExon += Math.max(0, eint.getEnd() - Math.max(eint.getStart(), this.cdsStart) + 1);
                continue;
            }
            firstCdsBaseInExon += Math.max(0, Math.min(this.cdsStart, eint.getEnd()) - eint.getStart() + 1);
        }
        return firstCdsBaseInExon - 1;
    }

    public synchronized int[] cdsBaseNumber2ChrPos() {
        if (this.cds2pos != null) {
            return this.cds2pos;
        }
        this.calcCdsStartEnd();
        this.cds2pos = new int[this.cds().length()];
        for (int i = 0; i < this.cds2pos.length; ++i) {
            this.cds2pos[i] = -1;
        }
        int cdsMin = Math.min(this.cdsStart, this.cdsEnd);
        int cdsMax = Math.max(this.cdsStart, this.cdsEnd);
        int cdsBaseNum = 0;
        for (Exon exon : this.sortedStrand()) {
            int min = this.isStrandPlus() ? exon.getStart() : exon.getEnd();
            int step = this.isStrandPlus() ? 1 : -1;
            int pos = min;
            while (exon.intersects(pos)) {
                if (cdsMin <= pos && pos <= cdsMax) {
                    this.cds2pos[cdsBaseNum++] = pos;
                }
                pos += step;
            }
        }
        return this.cds2pos;
    }

    public String codonByCdsBaseNumber(int cdsBaseNumber) {
        int codonNum = cdsBaseNumber / 3;
        int min = codonNum * 3;
        int max = codonNum * 3 + 3;
        if (min >= 0 && max <= this.cds().length()) {
            return this.cds().substring(min, max).toUpperCase();
        }
        return null;
    }

    public boolean collapseZeroGap() {
        boolean ret = false;
        this.introns = null;
        Map<Marker, Marker> collapse = MarkerUtil.collapseZeroGap(new Markers().addAll(this.subintervals()));
        for (Marker exon : collapse.keySet()) {
            Exon collapsedExon;
            if (exon == (collapsedExon = (Exon)collapse.get(exon))) continue;
            ret = true;
            this.remove((Exon)exon);
            if (!this.containsId(collapsedExon.getId())) {
                this.add(collapsedExon);
            }
            for (Marker marker : this.getUtrs()) {
                Utr utr = (Utr)marker;
                if (utr.getParent() != exon) continue;
                utr.setParent(collapsedExon);
            }
        }
        collapse = MarkerUtil.collapseZeroGap(new Markers(this.cdss));
        this.cdss = new ArrayList();
        Markers uniqCollapsedCds = new Markers(collapse.values()).unique();
        for (Marker cds : uniqCollapsedCds) {
            this.cdss.add((Cds)cds);
        }
        collapse = MarkerUtil.collapseZeroGap(new Markers(this.utrs));
        Markers uniqCollapsedUtrs = new Markers(collapse.values()).unique();
        this.utrs = new ArrayList();
        for (Marker utr : uniqCollapsedUtrs) {
            this.utrs.add((Utr)utr);
        }
        return ret;
    }

    public double cpgExonBias() {
        ObservedOverExpectedCpG oe = new ObservedOverExpectedCpG();
        return oe.oe(this);
    }

    public int cpgExons() {
        ObservedOverExpectedCpG oe = new ObservedOverExpectedCpG();
        return oe.observed(this);
    }

    public void createUpDownStream(int upDownLength) {
        Chromosome chr = this.getChromosome();
        int min = chr.getStart();
        int max = chr.getEnd();
        if (this.isStrandPlus()) {
            this.upstream = new Upstream(this, Math.max(this.start - upDownLength, min), Math.max(this.start - 1, min), 1, this.id);
            this.downstream = new Downstream(this, Math.min(this.end + 1, max), Math.min(this.end + upDownLength, max), 1, this.id);
        } else {
            this.upstream = new Upstream(this, Math.min(this.end + 1, max), Math.min(this.end + upDownLength, max), 1, this.id);
            this.downstream = new Downstream(this, Math.max(this.start - upDownLength, min), Math.max(this.start - 1, min), 1, this.id);
        }
    }

    public boolean deleteRedundant() {
        boolean ret = false;
        this.introns = null;
        Map<Marker, Marker> includedIn = MarkerUtil.redundant(this.subintervals());
        for (Marker exon : includedIn.keySet()) {
            ret = true;
            this.remove((Exon)exon);
            for (Marker marker : this.getUtrs()) {
                Utr utr = (Utr)marker;
                if (utr.getParent() != exon) continue;
                utr.setParent(includedIn.get(exon));
            }
        }
        includedIn = MarkerUtil.redundant(this.cdss);
        for (Marker cds : includedIn.keySet()) {
            this.cdss.remove(cds);
        }
        includedIn = MarkerUtil.redundant(this.utrs);
        for (Marker utr : includedIn.keySet()) {
            this.utrs.remove(utr);
        }
        return ret;
    }

    public Exon findExon(int pos) {
        for (Exon exon : this) {
            if (!exon.intersects(pos)) continue;
            return exon;
        }
        return null;
    }

    public List<SpliceSite> findSpliceSites(boolean createIfMissing) {
        LinkedList<SpliceSite> list = new LinkedList<SpliceSite>();
        ArrayList exons = (ArrayList)this.sortedStrand();
        if (exons.size() > 0) {
            for (int i = 0; i < exons.size(); ++i) {
                SpliceSite ss;
                int dist;
                Exon next;
                Exon exon = (Exon)exons.get(i);
                Exon prev = i >= 1 ? (Exon)exons.get(i - 1) : null;
                Exon exon2 = next = i < exons.size() - 1 ? (Exon)exons.get(i + 1) : null;
                if (prev != null) {
                    dist = 0;
                    dist = this.strand >= 0 ? exon.getStart() - prev.getEnd() - 1 : prev.getStart() - exon.getEnd() - 1;
                    ss = exon.getSpliceSiteAcceptor();
                    if (ss == null && createIfMissing) {
                        ss = exon.createSpliceSiteAcceptor(Math.min(2, dist));
                    }
                    if (ss != null) {
                        list.add(ss);
                    }
                }
                if (next != null) {
                    dist = 0;
                    dist = this.strand >= 0 ? next.getStart() - exon.getEnd() - 1 : exon.getStart() - next.getEnd() - 1;
                    ss = exon.getSpliceSiteDonor();
                    if (ss == null && createIfMissing) {
                        ss = exon.createSpliceSiteDonor(Math.min(2, dist));
                    }
                    if (ss != null) {
                        list.add(ss);
                    }
                }
                int rank = i + 1;
                if (exon.getRank() == rank) continue;
                String msg = "Rank numbers do not march: " + rank + " != " + exon.getRank() + "\n\tTranscript: " + this;
                throw new RuntimeException(msg);
            }
        }
        return list;
    }

    public Utr findUtr(int pos) {
        for (Utr utr : this.utrs) {
            if (!utr.intersects(pos)) continue;
            return utr;
        }
        return null;
    }

    int firstExonPositionAfter(int pos) {
        for (Exon ex : this.sorted()) {
            if (pos <= ex.getStart()) {
                return ex.getStart();
            }
            if (pos > ex.getEnd()) continue;
            return pos;
        }
        System.err.println("WARNING: Cannot find first exonic position after " + pos + " for transcript '" + this.id + "'");
        return -1;
    }

    public List<Utr3prime> get3primeUtrs() {
        ArrayList<Utr3prime> list = new ArrayList<Utr3prime>();
        for (Utr utr : this.utrs) {
            if (!(utr instanceof Utr3prime)) continue;
            list.add((Utr3prime)utr);
        }
        return list;
    }

    public List<Utr5prime> get5primeUtrs() {
        ArrayList<Utr5prime> list = new ArrayList<Utr5prime>();
        for (Utr utr : this.utrs) {
            if (!(utr instanceof Utr5prime)) continue;
            list.add((Utr5prime)utr);
        }
        return list;
    }

    public String getBioType() {
        return this.bioType;
    }

    public List<Cds> getCds() {
        return this.cdss;
    }

    public int getCdsEnd() {
        this.calcCdsStartEnd();
        return this.cdsEnd;
    }

    public int getCdsStart() {
        this.calcCdsStartEnd();
        return this.cdsStart;
    }

    public Downstream getDownstream() {
        return this.downstream;
    }

    public synchronized Exon getFirstCodingExon() {
        if (this.firstCodingExon == null) {
            long cstart = this.getCdsStart();
            for (Exon exon : this.sortedStrand()) {
                if (!exon.intersects(cstart)) continue;
                this.firstCodingExon = exon;
            }
            if (this.firstCodingExon == null) {
                throw new RuntimeException("Error: Cannot find first coding exon for transcript:\n" + this);
            }
        }
        return this.firstCodingExon;
    }

    public ArrayList<SpliceSiteBranch> getSpliceBranchSites() {
        return this.spliceBranchSites;
    }

    public Upstream getUpstream() {
        return this.upstream;
    }

    public List<Utr> getUtrs() {
        return this.utrs;
    }

    public Exon intersectingExon(Marker interval) {
        for (Exon ei : this) {
            if (!ei.intersects(interval)) continue;
            return ei;
        }
        return null;
    }

    public synchronized ArrayList<Intron> introns() {
        if (this.introns == null) {
            this.introns = new ArrayList();
            Exon exBefore = null;
            for (Exon ex : this.sortedStrand()) {
                if (exBefore != null) {
                    int end;
                    int start;
                    int rank = this.introns.size() + 1;
                    if (this.isStrandPlus()) {
                        start = exBefore.getEnd() + 1;
                        end = ex.getStart() - 1;
                    } else {
                        start = ex.getEnd() + 1;
                        end = exBefore.getStart() - 1;
                    }
                    int size = end - start + 1;
                    if (size > 0) {
                        Intron intron = new Intron(this, start, end, (int)this.strand, this.id + "_intron_" + rank);
                        intron.setRank(rank);
                        this.introns.add(intron);
                    }
                }
                exBefore = ex;
            }
        }
        return this.introns;
    }

    public int intronSize(int intronNum) {
        if (intronNum >= this.numChilds() - 1) {
            return -1;
        }
        ArrayList exons = (ArrayList)this.sortedStrand();
        Exon exon = (Exon)exons.get(intronNum);
        Exon next = (Exon)exons.get(intronNum + 1);
        return (this.isStrandPlus() ? next.getStart() - exon.getEnd() : exon.getStart() - next.getEnd()) - 1;
    }

    @Override
    protected boolean isAdjustIfParentDoesNotInclude(Marker parent) {
        return true;
    }

    boolean isCds(SeqChange seqChange) {
        this.calcCdsStartEnd();
        int cs = this.cdsStart;
        int ce = this.cdsEnd;
        if (this.isStrandMinus()) {
            cs = this.cdsEnd;
            ce = this.cdsStart;
        }
        return seqChange.getEnd() >= cs && seqChange.getStart() <= ce;
    }

    public boolean isProteinCoding() {
        return this.proteinCoding;
    }

    public boolean isUtr(int pos) {
        return this.findUtr(pos) != null;
    }

    int lastExonPositionBefore(int pos) {
        int last = -1;
        for (Exon ex : this.sorted()) {
            if (pos < ex.getStart()) {
                if (last < 0) {
                    System.err.println("WARNING: Cannot find last exonic position before " + pos + " for transcript '" + this.id + "'");
                    return -1;
                }
                return last;
            }
            if (pos <= ex.getEnd()) {
                return pos;
            }
            last = ex.getEnd();
        }
        System.err.println("WARNING: Cannot find last exonic position before " + pos + " for transcript '" + this.id + "'");
        return -1;
    }

    public String mRna() {
        List exons = this.sortedStrand();
        StringBuilder sequence = new StringBuilder();
        for (Exon eint : exons) {
            sequence.append(eint.getSequence());
        }
        return sequence.toString();
    }

    public String protein() {
        if (!Config.get().isTreatAllAsProteinCoding() && !this.isProteinCoding()) {
            return "";
        }
        return this.codonTable().aa(this.cds());
    }

    public boolean rankExons() {
        boolean changed = false;
        int rank = 1;
        for (Exon exon : this.sortedStrand()) {
            if (rank != exon.getRank()) {
                exon.setRank(rank);
                changed = true;
            }
            ++rank;
        }
        return changed;
    }

    @Override
    public List<ChangeEffect> seqChangeEffect(SeqChange seqChange, ChangeEffect changeEffect) {
        ChangeEffect cheff;
        List<ChangeEffect> chEffList;
        if (!this.intersects(seqChange)) {
            return ChangeEffect.emptyResults();
        }
        ArrayList<ChangeEffect> changeEffectList = new ArrayList<ChangeEffect>();
        boolean included = false;
        for (Utr utr : this.utrs) {
            if (!utr.intersects(seqChange)) continue;
            chEffList = utr.seqChangeEffect(seqChange, changeEffect.clone());
            if (!chEffList.isEmpty()) {
                changeEffectList.addAll(chEffList);
            }
            included |= utr.includes(seqChange);
        }
        if (included) {
            return changeEffectList;
        }
        included = false;
        for (SpliceSiteBranch ssbranch : this.spliceBranchSites) {
            if (!ssbranch.intersects(seqChange)) continue;
            chEffList = ssbranch.seqChangeEffect(seqChange, changeEffect.clone());
            if (!chEffList.isEmpty()) {
                changeEffectList.addAll(chEffList);
            }
            included |= ssbranch.includes(seqChange);
        }
        if (included) {
            return changeEffectList;
        }
        for (Intron intron : this.introns()) {
            if (!intron.intersects(seqChange)) continue;
            cheff = changeEffect.clone();
            cheff.set(intron, ChangeEffect.EffectType.INTRON, "");
            changeEffectList.add(cheff);
        }
        if (!Config.get().isTreatAllAsProteinCoding() && !this.isProteinCoding() || seqChange.isInterval()) {
            if (!this.subintervals().isEmpty()) {
                for (Exon exon : this) {
                    if (!exon.intersects(seqChange)) continue;
                    cheff = changeEffect.clone();
                    cheff.set(exon, ChangeEffect.EffectType.EXON, "");
                    changeEffectList.add(cheff);
                }
            } else {
                ChangeEffect cheff2 = changeEffect.clone();
                cheff2.set(this, ChangeEffect.EffectType.TRANSCRIPT, "");
                changeEffectList.add(cheff2);
            }
            return changeEffectList;
        }
        if (this.isCds(seqChange)) {
            CodonChange codonChange = new CodonChange(seqChange, this, changeEffect);
            changeEffectList.addAll(codonChange.calculate());
        }
        return changeEffectList;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.bioType = markerSerializer.getNextField();
        this.proteinCoding = markerSerializer.getNextFieldBoolean();
        this.upstream = (Upstream)markerSerializer.getNextFieldMarker();
        this.downstream = (Downstream)markerSerializer.getNextFieldMarker();
        for (Marker m : markerSerializer.getNextFieldMarkers()) {
            this.utrs.add((Utr)m);
        }
        for (Marker m : markerSerializer.getNextFieldMarkers()) {
            this.cdss.add((Cds)m);
        }
        for (Marker m : markerSerializer.getNextFieldMarkers()) {
            this.spliceBranchSites.add((SpliceSiteBranchU12)m);
        }
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.bioType + "\t" + this.proteinCoding + "\t" + markerSerializer.save(this.upstream) + "\t" + markerSerializer.save(this.downstream) + "\t" + markerSerializer.save(this.utrs) + "\t" + markerSerializer.save(this.cdss) + "\t" + markerSerializer.save(this.spliceBranchSites);
    }

    public void setBioType(String bioType) {
        this.bioType = bioType;
    }

    public void setProteinCoding(boolean proteinCoding) {
        this.proteinCoding = proteinCoding;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChromosomeName() + ":" + this.start + "-" + this.end);
        sb.append(", strand: " + (this.strand >= 0 ? "+" : "-"));
        if (this.id != null && this.id.length() > 0) {
            sb.append(", id:" + this.id);
        }
        if (this.bioType != null && this.bioType.length() > 0) {
            sb.append(", bioType:" + this.bioType);
        }
        if (this.isProteinCoding()) {
            sb.append(", Protein");
        }
        if (this.numChilds() > 0) {
            sb.append("\n");
            for (Utr utr : this.get5primeUtrs()) {
                sb.append("\t\t5'UTR   :\t" + utr + "\n");
            }
            sb.append("\t\tExons:\n");
            for (Exon exon : this.sorted()) {
                sb.append("\t\t" + exon + "\n");
            }
            for (Utr utr : this.get3primeUtrs()) {
                sb.append("\t\t3'UTR   :\t" + utr + "\n");
            }
            if (this.isProteinCoding()) {
                sb.append("\t\tCDS     :\t" + this.cds() + "\n");
                sb.append("\t\tProtein :\t" + this.protein() + "\n");
            }
        }
        return sb.toString();
    }

    public String toStringAsciiArt() {
        char[] art = new char[this.size()];
        int i = this.start;
        int j = 0;
        while (i <= this.end) {
            Exon exon;
            Utr utr = this.findUtr(i);
            art[j] = utr != null ? (utr.isUtr5prime() ? 53 : 51) : ((exon = this.findExon(i)) != null ? (exon.isStrandPlus() ? 62 : 60) : 45);
            ++i;
            ++j;
        }
        return new String(art);
    }

    public boolean utrFromCds(boolean verbose) {
        if (this.cdss.size() <= 0) {
            return false;
        }
        Markers exons = new Markers();
        Markers minus = new Markers();
        for (Exon e : this) {
            exons.add(e);
        }
        for (Utr uint : this.getUtrs()) {
            minus.add(uint);
        }
        for (Cds cint : this.cdss) {
            minus.add(cint);
        }
        Markers missingUtrs = exons.minus(minus);
        if (missingUtrs.size() > 0) {
            return this.addMissingUtrs(missingUtrs, verbose);
        }
        return false;
    }
}

