/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.Instruction;

class MethodInstruction
implements Instruction {
    private final CodeMethod meth;
    private final byte opcode;

    MethodInstruction(byte op, CodeMethod m) {
        if (m == null) {
            throw new NullPointerException("CodeMethod can not be null");
        }
        this.opcode = op;
        this.meth = m;
    }

    public void writeCode(CodeContext ctx) throws CodeException {
        ctx.writeByte(this.opcode);
        if (this.opcode == -71) {
            ctx.writeShort(ctx.getConstants().resolveInterfaceMethod(this.meth));
            int count = 1;
            for (int i = 0; i < this.meth.numParameters(); ++i) {
                CodeClass ptype = this.meth.getParameterType(i);
                count += CodeUtils.wordsForType(ptype);
            }
            ctx.writeByte((byte)count);
            ctx.writeByte((byte)0);
        } else {
            ctx.writeShort(ctx.getConstants().resolveMethod(this.meth));
        }
    }

    public int stackDepth() {
        return 0;
    }

    public int stackDelta() {
        int popped = 0;
        if ((this.meth.getModifiers() & 8) == 0) {
            ++popped;
        }
        int pushed = this.meth.getReturnType() == CodeUtils.TYPE_VOID ? 0 : 1;
        return pushed - (popped += this.meth.numParameters());
    }
}

