/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolPropertyTable;

public class MassCalc {
    public static final double Cmono = 12.0;
    public static final double Hmono = 1.007825;
    public static final double Nmono = 14.003074;
    public static final double Omono = 15.9949146;
    public static final double Cavg = 12.011;
    public static final double Havg = 1.00794;
    public static final double Navg = 14.00674;
    public static final double Oavg = 15.9994;
    private HashMap mSymbolPropertyHash;
    private HashMap mVariableModPropertyHash;
    private double termMass;

    public MassCalc(String isotopicType, boolean MH_PLUS) {
        this.termMass = MassCalc.calcTermMass(isotopicType, MH_PLUS);
        this.mSymbolPropertyHash = new HashMap();
        SymbolPropertyTable symbolPropertyTable = ProteinTools.getSymbolPropertyTable(isotopicType);
        this.mVariableModPropertyHash = new HashMap();
        Iterator<Symbol> symbolList = ProteinTools.getAlphabet().iterator();
        while (symbolList.hasNext()) {
            Symbol sym = symbolList.next();
            if (sym == ProteinTools.o() || sym == ProteinTools.u()) continue;
            try {
                try {
                    Double value = new Double(symbolPropertyTable.getDoubleValue(sym));
                    this.mSymbolPropertyHash.put(sym, value);
                }
                catch (NullPointerException npe) {}
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Error setting properties for Symbol " + sym, ise);
            }
        }
    }

    public void setSymbolModification(char symbolToken, double mass) throws IllegalSymbolException {
        SymbolTokenization toke;
        try {
            toke = ProteinTools.getAlphabet().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError("Expected a tokenization", ex);
        }
        Symbol sym = toke.parseToken("" + symbolToken);
        this.mSymbolPropertyHash.put(sym, new Double(mass));
    }

    public void addVariableModification(char residue, double[] masses) throws IllegalSymbolException {
        Symbol sym = this.getSymbolForChar(residue);
        this.addVariableModification(sym, masses);
    }

    public void addVariableModification(Symbol residue, double[] masses) throws IllegalSymbolException {
        LinkedList<Double> massList = new LinkedList<Double>();
        for (int i = 0; i < masses.length; ++i) {
            massList.add(new Double(masses[i]));
        }
        this.getVariableModMap().put(residue, massList);
    }

    public boolean removeVariableModifications(char residue) throws IllegalSymbolException {
        Symbol sym = this.getSymbolForChar(residue);
        return this.removeVariableModifications(sym);
    }

    public boolean removeVariableModifications(Symbol residue) {
        return this.getVariableModMap().remove(residue) != null;
    }

    public static final double getMolecularWeight(SymbolList proteinSeq) throws IllegalSymbolException {
        double pepMass = 0.0;
        Symbol gap = AlphabetManager.alphabetForName("PROTEIN").getGapSymbol();
        SymbolPropertyTable sPT = ProteinTools.getSymbolPropertyTable("avgMass");
        Iterator<Symbol> it = proteinSeq.iterator();
        while (it.hasNext()) {
            Symbol s = it.next();
            if (s instanceof AtomicSymbol) {
                pepMass += sPT.getDoubleValue(s);
                continue;
            }
            FiniteAlphabet matches = (FiniteAlphabet)s.getMatches();
            if (matches.size() == 0) {
                if (s.equals(gap)) continue;
                throw new IllegalSymbolException("Symbol " + s.getName() + " has no mass associated");
            }
            int count = 0;
            double mass = 0.0;
            Iterator<Symbol> i = matches.iterator();
            while (i.hasNext()) {
                AtomicSymbol as = (AtomicSymbol)i.next();
                if (as == ProteinTools.o() || as == ProteinTools.u()) continue;
                mass += sPT.getDoubleValue(as);
                ++count;
            }
            pepMass += mass / (double)count;
        }
        double termMass = MassCalc.calcTermMass("avgMass", false);
        if (pepMass != 0.0) {
            pepMass += termMass;
        }
        return pepMass;
    }

    public static final double getMass(SymbolList proteinSeq, String isotopicType, boolean MH_PLUS) throws IllegalSymbolException {
        double pepMass = 0.0;
        SymbolPropertyTable sPT = ProteinTools.getSymbolPropertyTable(isotopicType);
        Iterator<Symbol> it = proteinSeq.iterator();
        while (it.hasNext()) {
            Symbol s = it.next();
            if (!(s instanceof AtomicSymbol)) {
                throw new IllegalSymbolException("Symbol " + s.getName() + " is not atomic");
            }
            pepMass += sPT.getDoubleValue(s);
        }
        double termMass = MassCalc.calcTermMass(isotopicType, MH_PLUS);
        if (pepMass != 0.0) {
            pepMass += termMass;
        }
        return pepMass;
    }

    public double getMass(SymbolList proteinSeq) throws IllegalSymbolException {
        double pepMass = 0.0;
        HashMap symbolPropertyMap = this.getSymbolPropertyMap();
        Iterator<Symbol> it = proteinSeq.iterator();
        while (it.hasNext()) {
            Symbol s = it.next();
            if (!symbolPropertyMap.containsKey(s)) {
                throw new IllegalSymbolException(s, "The mass of the symbol " + s.getName() + " is unknown");
            }
            Double mass = (Double)symbolPropertyMap.get(s);
            pepMass += mass.doubleValue();
        }
        return pepMass += this.getTermMass();
    }

    public double[] getVariableMasses(SymbolList peptide) throws IllegalSymbolException {
        double[] vMasses = this.getVMasses(peptide);
        int i = 0;
        while (i < vMasses.length) {
            int n = i++;
            vMasses[n] = vMasses[n] + this.getTermMass();
        }
        return vMasses;
    }

    private HashMap getVariableModMap() {
        return this.mVariableModPropertyHash;
    }

    private HashMap getSymbolPropertyMap() {
        return this.mSymbolPropertyHash;
    }

    public double getTermMass() {
        return this.termMass;
    }

    private double[] getVMasses(SymbolList peptide) throws IllegalSymbolException {
        HashSet<Double> allMassList = new HashSet<Double>();
        Symbol sym = peptide.symbolAt(1);
        if (!this.getSymbolPropertyMap().containsKey(sym)) {
            String msg = "No mass Set for Symbol " + sym.getName();
            throw new IllegalSymbolException(msg);
        }
        LinkedList<Object> curResMasses = null;
        curResMasses = this.getVariableModMap().containsKey(sym) ? new LinkedList((List)this.getVariableModMap().get(sym)) : new LinkedList();
        curResMasses.add(this.getSymbolPropertyMap().get(sym));
        Iterator it = curResMasses.iterator();
        while (it.hasNext()) {
            double resMass = (Double)it.next();
            if (peptide.length() == 1) {
                allMassList.add(new Double(resMass));
                continue;
            }
            double[] subMasses = this.getVMasses(peptide.subList(2, peptide.length()));
            for (int i = 0; i < subMasses.length; ++i) {
                double pepMass = resMass + subMasses[i];
                allMassList.add(new Double(pepMass));
            }
        }
        double[] masses = new double[allMassList.size()];
        int i = 0;
        Iterator mit = allMassList.iterator();
        while (mit.hasNext()) {
            masses[i] = (Double)mit.next();
            ++i;
        }
        return masses;
    }

    private static double calcTermMass(String isotopicType, boolean MH_PLUS) {
        double termMass = 0.0;
        if (isotopicType.equals("avgMass")) {
            termMass += 18.01528;
            if (MH_PLUS) {
                termMass += 1.00794;
            }
        } else if (isotopicType.equals("monoMass")) {
            termMass += 18.0105646;
            if (MH_PLUS) {
                termMass += 1.007825;
            }
        }
        return termMass;
    }

    private Symbol getSymbolForChar(char symbolToken) throws IllegalSymbolException {
        SymbolTokenization toke;
        try {
            toke = ProteinTools.getAlphabet().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError("Expected a tokenization", ex);
        }
        Symbol sym = toke.parseToken("" + symbolToken);
        return sym;
    }
}

