/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.AbstractAnnotation;
import org.biojava.bio.Annotation;
import org.biojava.bio.program.tagvalue.PropertyChanger;

public class AnnotationRenamer
extends AbstractAnnotation {
    private final Annotation wrapped;
    private final PropertyChanger mapper;
    private final Map properties;

    public AnnotationRenamer(Annotation wrapped, PropertyChanger mapper) {
        this.wrapped = wrapped;
        this.mapper = mapper;
        this.properties = new MappedHash();
    }

    public Annotation getWrapped() {
        return this.wrapped;
    }

    public PropertyChanger getMapper() {
        return this.mapper;
    }

    public Map getProperties() {
        return this.properties;
    }

    public boolean propertiesAllocated() {
        return true;
    }

    private class WrappedSet
    extends AbstractSet {
        private Set entrySet;

        public WrappedSet(Set entrySet) {
            this.entrySet = entrySet;
        }

        public int size() {
            return this.entrySet.size();
        }

        public Iterator iterator() {
            return new Iterator(){
                Iterator i;
                {
                    this.i = WrappedSet.this.entrySet.iterator();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    final Map.Entry entry = (Map.Entry)this.i.next();
                    return new Map.Entry(){

                        public Object getKey() {
                            return AnnotationRenamer.this.mapper.getNewTag(entry.getKey());
                        }

                        public Object getValue() {
                            return entry.getValue();
                        }

                        public Object setValue(Object value) {
                            return entry.setValue(value);
                        }
                    };
                }

                public void remove() {
                    this.i.remove();
                }
            };
        }
    }

    private class MappedHash
    extends AbstractMap {
        private MappedHash() {
        }

        public int size() {
            return AnnotationRenamer.this.wrapped.asMap().size();
        }

        public Set entrySet() {
            return new WrappedSet(AnnotationRenamer.this.wrapped.asMap().entrySet());
        }
    }
}

