/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import com.google.gson.Gson;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import edu.mayo.pipes.bioinformatics.vocab.ComparableObjectInterface;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import java.util.ArrayList;
import net.minidev.json.JSONArray;

public class SameVariantLogic
implements ComparableObjectInterface {
    private boolean isRsidCheckOnly = false;
    private boolean isAlleleCheckOnly = false;
    private JsonPath chrJsonPath = null;
    private JsonPath minBpJsonPath = null;
    private JsonPath rsIdJsonPath = null;
    private JsonPath refJsonPath = null;
    private JsonPath altJsonPath = null;
    private Gson gson = new Gson();

    public SameVariantLogic() {
        this.init();
    }

    public SameVariantLogic(boolean rsidCheckOnly, boolean alleleCheckOnly) {
        this.isRsidCheckOnly = rsidCheckOnly;
        this.isAlleleCheckOnly = alleleCheckOnly;
        this.init();
    }

    public void init() {
        this.chrJsonPath = JsonPath.compile((String)CoreAttributes._landmark.toString(), (Filter[])new Filter[0]);
        this.minBpJsonPath = JsonPath.compile((String)CoreAttributes._minBP.toString(), (Filter[])new Filter[0]);
        this.rsIdJsonPath = JsonPath.compile((String)CoreAttributes._id.toString(), (Filter[])new Filter[0]);
        this.refJsonPath = JsonPath.compile((String)CoreAttributes._refAllele.toString(), (Filter[])new Filter[0]);
        this.altJsonPath = JsonPath.compile((String)CoreAttributes._altAlleles.toString(), (Filter[])new Filter[0]);
    }

    @Override
    public boolean same(String jsonIn, String jsonCatalog) {
        boolean isAltAlleleMatch;
        String chrIn = (String)this.chrJsonPath.read(jsonIn);
        String chrOut = (String)this.chrJsonPath.read(jsonCatalog);
        if (chrIn == null || chrIn.length() == 0 || !chrIn.equalsIgnoreCase(chrOut)) {
            return false;
        }
        Integer minBpIn = (Integer)this.minBpJsonPath.read(jsonIn);
        Integer minBpOut = (Integer)this.minBpJsonPath.read(jsonCatalog);
        if (minBpIn == null || minBpIn.compareTo(minBpOut) != 0) {
            return false;
        }
        String rsIdIn = (String)this.rsIdJsonPath.read(jsonIn);
        String rsIdOut = (String)this.rsIdJsonPath.read(jsonCatalog);
        String refIn = (String)this.refJsonPath.read(jsonIn);
        String refOut = (String)this.refJsonPath.read(jsonCatalog);
        ArrayList<String> altsIn = this.toList((JSONArray)this.altJsonPath.read(jsonIn));
        ArrayList<String> altsOut = this.toList((JSONArray)this.altJsonPath.read(jsonCatalog));
        boolean isRsIdMatch = rsIdIn != null && rsIdIn.length() > 0 && rsIdIn.equalsIgnoreCase(rsIdOut);
        boolean isRefAlleleMatch = refIn != null && refIn.length() > 0 && refIn.equalsIgnoreCase(refOut);
        boolean bl = isAltAlleleMatch = altsIn != null && altsIn.size() > 0 && this.isSubset(altsIn, altsOut);
        if (this.isRsidCheckOnly) {
            return isRsIdMatch;
        }
        if (this.isAlleleCheckOnly) {
            return isRefAlleleMatch && isAltAlleleMatch;
        }
        return isRsIdMatch || isRefAlleleMatch && isAltAlleleMatch;
    }

    public boolean isSubset(ArrayList<String> subset, ArrayList<String> allItems) {
        for (String item : subset) {
            if (allItems.contains(item)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<String> toList(JSONArray jsonArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            list.add((String)jsonArray.get(i));
        }
        return list;
    }
}

