/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRand;
import ca.mcgill.mcb.pcingola.snpEffect.testCases.Save;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesMnp
extends TestCase {
    static boolean debug = false;
    static int MAX_MNP_LEN = 10;
    int maxGeneLen = 1000;
    int maxTranscripts = 1;
    int maxExons = 5;
    Random rand;
    Config config;
    Genome genome;
    CodonTable codonTable;
    Chromosome chromosome;
    Gene gene;
    Transcript transcript;
    Transcript transcriptNew;
    SnpEffectPredictor snpEffectPredictor;
    String chromoSequence = "";
    String chromoNewSequence = "";
    char[] chromoBases;
    String codonsOld = "";
    String codonsNew = "";

    public TestCasesMnp() {
        this.init();
    }

    void addIfDiff(char[] codonOld, char[] codonNew) {
        String cold = new String(codonOld);
        String cnew = new String(codonNew);
        if (!cold.equals(cnew)) {
            this.codonsOld = this.codonsOld + (this.transcript.isStrandPlus() ? cold : GprSeq.wc(cold));
            this.codonsNew = this.codonsNew + (this.transcript.isStrandPlus() ? cnew : GprSeq.wc(cnew));
        }
    }

    void analyze(int i, int pos, String ref, String mnp) {
        String codons = this.codons();
        int seqChangeStrand = 1;
        SeqChange seqChange = new SeqChange(this.chromosome, pos, ref + "", mnp + "", seqChangeStrand, "", 1.0, 1);
        List<ChangeEffect> effects = this.snpEffectPredictor.seqChangeEffect(seqChange);
        ChangeEffect effect = null;
        if (effects.size() > 1) {
            for (ChangeEffect ce : effects) {
                if (ce.getEffectType() == ChangeEffect.EffectType.SPLICE_SITE_ACCEPTOR || ce.getEffectType() == ChangeEffect.EffectType.SPLICE_SITE_DONOR || ce.getEffectType() == ChangeEffect.EffectType.INTRON || ce.getEffectType() == ChangeEffect.EffectType.INTERGENIC) continue;
                effect = ce;
            }
        } else {
            effect = effects.get(0);
        }
        if (effect != null) {
            String effStr = effect.effect(true, true, true);
            if (codons.length() > 1) {
                boolean error;
                String[] codonsExp = codons.split("/");
                boolean bl = error = !codonsExp[0].toUpperCase().equals(effect.getCodonsOld().toUpperCase()) || !codonsExp[1].toUpperCase().equals(effect.getCodonsNew().toUpperCase());
                if (error || debug) {
                    Gpr.debug("Fatal error:\n\tPos           : " + pos + "\n\tSeqChange     : " + seqChange + (seqChange.getStrand() >= 0 ? "+" : "-") + "\n\tCodon (exp)   : " + codons + "\n\tCodon (pred)  : " + effect.getCodonsOld().toUpperCase() + "/" + effect.getCodonsNew().toUpperCase() + "\n\tEffect (pred) : " + effStr + "\n\tEffect (pred) : " + effect + "\n\tGene          : " + this.gene + "\n\tChromo        : " + this.chromoSequence);
                }
                if (error) {
                    System.err.println("Error. Dumping data");
                    Save save = new Save();
                    save.snpEffectPredictor = this.snpEffectPredictor;
                    save.chromoSequence = this.chromoSequence;
                    save.chromoNewSequence = this.chromoNewSequence;
                    save.ref = ref;
                    save.pos = pos;
                    save.mnp = mnp;
                    String outFile = "/tmp/sep_" + i + "_" + pos + ".bin";
                    Gpr.toFileSerialize(outFile, save);
                    throw new RuntimeException("Codons do not match!\n\tData dumped: '" + outFile + "'");
                }
                if (!effect.getWarning().isEmpty()) {
                    Gpr.debug("WARN:" + effect.getWarning() + "\t" + seqChange + "\t" + seqChangeStrand);
                }
                Assert.assertEquals((boolean)true, (boolean)effect.getWarning().isEmpty());
            }
        }
    }

    String codons() {
        char[] seq = this.chromoSequence.toCharArray();
        char[] seqNew = this.chromoNewSequence.toCharArray();
        this.codonsOld = "";
        this.codonsNew = "";
        int codonIdx = 0;
        int i = 0;
        int step = this.transcript.isStrandPlus() ? 1 : -1;
        char[] codonOld = new char[3];
        char[] codonNew = new char[3];
        for (Exon ex : this.transcript.sortedStrand()) {
            int start;
            i = start = ex.isStrandPlus() ? ex.getStart() : ex.getEnd();
            while (ex.intersects(i)) {
                codonOld[codonIdx] = seq[i];
                codonNew[codonIdx] = seqNew[i];
                if (codonIdx == 2) {
                    this.addIfDiff(codonOld, codonNew);
                }
                i += step;
                codonIdx = (codonIdx + 1) % 3;
            }
        }
        while (codonIdx != 0) {
            codonOld[codonIdx] = 78;
            codonNew[codonIdx] = 78;
            if (codonIdx == 2) {
                this.addIfDiff(codonOld, codonNew);
            }
            i += step;
            codonIdx = (codonIdx + 1) % 3;
        }
        return this.codonsOld + "/" + this.codonsNew;
    }

    String createMnp(int pos, int mnpLen) {
        char[] chSeq = this.chromoSequence.toCharArray();
        char[] chSeqNew = this.chromoSequence.toCharArray();
        String mnp = "";
        for (int i = pos; i < pos + mnpLen; ++i) {
            chSeqNew[i] = this.snp(chSeq[i]);
            mnp = mnp + chSeqNew[i];
        }
        this.chromoNewSequence = new String(chSeqNew);
        return mnp;
    }

    void init() {
        this.initRand();
        this.initSnpEffPredictor();
    }

    void initRand() {
        this.rand = new Random(20111113L);
        this.rand = new Random(20111222L);
    }

    void initSnpEffPredictor() {
        this.config = new Config("testCase", "snpEff.config");
        SnpEffPredictorFactoryRand sepf = new SnpEffPredictorFactoryRand(this.config, 1, this.rand, this.maxGeneLen, this.maxTranscripts, this.maxExons);
        this.snpEffectPredictor = sepf.create();
        this.config.setSnpEffectPredictor(this.snpEffectPredictor);
        this.chromoSequence = sepf.getChromoSequence();
        this.chromoBases = this.chromoSequence.toCharArray();
        this.config.getSnpEffectPredictor().setUpDownStreamLength(0);
        this.config.getSnpEffectPredictor().buildForest();
        this.chromosome = sepf.getChromo();
        this.genome = this.config.getGenome();
        this.codonTable = this.genome.codonTable();
        this.gene = this.genome.getGenes().iterator().next();
        this.transcript = (Transcript)this.gene.iterator().next();
    }

    char snp(char ref) {
        char snp = ref;
        while (snp == ref) {
            snp = Character.toUpperCase(GprSeq.randBase(this.rand));
        }
        return snp;
    }

    public void test() {
        int N = 1000;
        for (int i = 0; i < N; ++i) {
            this.initSnpEffPredictor();
            if (debug) {
                System.out.println("MNP Test iteration: " + i + "\nChromo:\t" + this.chromoSequence + "\n" + this.transcript);
            } else {
                System.out.println("MNP Test iteration: " + i + "\t" + (this.transcript.getStrand() >= 0 ? "+" : "-") + "\t" + this.transcript.cds());
            }
            if (debug) {
                for (Exon exon : this.transcript.sortedStrand()) {
                    System.out.println("\tExon: " + exon + "\tSEQ:\t" + (exon.isStrandMinus() ? GprSeq.reverseWc(exon.getSequence()) : exon.getSequence()).toUpperCase());
                }
            }
            for (int pos = 0; pos < this.chromoSequence.length() - 2; ++pos) {
                int mnpLen = this.rand.nextInt(MAX_MNP_LEN) + 2;
                int maxMnpLen = this.chromoSequence.length() - pos;
                mnpLen = Math.min(mnpLen, maxMnpLen);
                String ref = this.chromoSequence.substring(pos, pos + mnpLen);
                String mnp = this.createMnp(pos, mnpLen);
                this.analyze(i, pos, ref, mnp);
            }
        }
    }
}

