/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.binseq;

public class DnaSequenceByte {
    public static final int BASES_PER_BYTE = 4;
    public static final int BITS_PER_BASE = 2;
    public static final byte[] MASK = new byte[]{-64, 48, 12, 3};
    public static final char[] BASES = new char[]{'A', 'C', 'G', 'T'};
    public static final byte[] BASE2CODE = new byte[256];
    int length;
    byte[] codes;

    public DnaSequenceByte(int length, byte[] codes) {
        DnaSequenceByte.BASE2CODE[97] = 0;
        DnaSequenceByte.BASE2CODE[65] = 0;
        DnaSequenceByte.BASE2CODE[99] = 1;
        DnaSequenceByte.BASE2CODE[67] = 1;
        DnaSequenceByte.BASE2CODE[103] = 2;
        DnaSequenceByte.BASE2CODE[71] = 2;
        DnaSequenceByte.BASE2CODE[116] = 3;
        DnaSequenceByte.BASE2CODE[84] = 3;
        this.length = length;
        this.codes = codes;
    }

    public DnaSequenceByte(String seqStr) {
        DnaSequenceByte.BASE2CODE[97] = 0;
        DnaSequenceByte.BASE2CODE[65] = 0;
        DnaSequenceByte.BASE2CODE[99] = 1;
        DnaSequenceByte.BASE2CODE[67] = 1;
        DnaSequenceByte.BASE2CODE[103] = 2;
        DnaSequenceByte.BASE2CODE[71] = 2;
        DnaSequenceByte.BASE2CODE[116] = 3;
        DnaSequenceByte.BASE2CODE[84] = 3;
        if (seqStr != null) {
            this.set(seqStr);
        }
    }

    public char getBase(int index) {
        int idx = index / 4;
        int pos = index % 4;
        int code = 0xFF & (this.codes[idx] & MASK[pos]);
        int rot = (3 - pos) * 2;
        return BASES[code >>>= rot];
    }

    public byte[] getCodes() {
        return this.codes;
    }

    public int getLength() {
        return this.length;
    }

    public int hashCode() {
        long hash = 0L;
        for (int i = 0; i < this.codes.length; ++i) {
            hash = hash * 33L + (long)this.codes[i];
        }
        return (int)hash;
    }

    public int length() {
        return this.length;
    }

    public void set(String seqStr) {
        if (seqStr == null) {
            this.length = 0;
            this.codes = null;
        } else {
            this.length = seqStr.length();
            int ilen = this.length / 4 + (this.length % 4 != 0 ? 1 : 0);
            this.codes = new byte[ilen];
            char[] seqChar = seqStr.toCharArray();
            int j = 0;
            int k = 0;
            int s = 0;
            for (int i = 0; i < seqChar.length; ++i) {
                s = (byte)(s << 2);
                s = (byte)(s | BASE2CODE[seqChar[i]]);
                if (++k < 4) continue;
                this.codes[j] = s;
                k = 0;
                ++j;
                s = 0;
            }
            if (k < 4 && k != 0) {
                this.codes[j] = s = (int)((byte)(s << 2 * (4 - k)));
            }
        }
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        char[] c = new char[this.length];
        for (i = 0; i < this.length; ++i) {
            c[i] = this.getBase(i);
        }
        sb.append(c);
        sb.append("\t");
        for (i = 0; i < this.codes.length; ++i) {
            sb.append(Integer.toHexString(this.codes[i]));
        }
        return sb.toString();
    }
}

