/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.akka;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.routing.RouterConfig;
import akka.routing.SmallestMailboxRouter;
import ca.mcgill.mcb.pcingola.akka.msg.Result;
import ca.mcgill.mcb.pcingola.akka.msg.StartMaster;
import ca.mcgill.mcb.pcingola.akka.msg.Work;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Master<TI, TO>
extends UntypedActor
implements Iterable<TI>,
Iterator<TI> {
    public static int LOAD_FACTOR = 3;
    public static final int DEFAULT_SHOW_EVERY = 1000;
    public static final int DEFAULT_BATCH_SIZE = 10;
    public static boolean debug = false;
    int batchSize;
    int showEvery;
    long nextOutput;
    int countInputObjects;
    int numWorkers;
    int sentWorks = 0;
    ActorRef workerRouter;
    HashMap<Long, Result<TO>> worksBySerial;

    public Master(Props props, int numWorkers) {
        this.numWorkers = numWorkers;
        this.worksBySerial = new HashMap();
        this.nextOutput = 1L;
        this.batchSize = 10;
        this.showEvery = 1000;
        this.countInputObjects = 1;
        SmallestMailboxRouter router = new SmallestMailboxRouter(numWorkers);
        this.workerRouter = this.getContext().actorOf(props.withRouter((RouterConfig)router), "workerRouter");
    }

    @Override
    public abstract boolean hasNext();

    public Iterable<Work<TI>> iterableWork() {
        final Master master = this;
        return new Iterable<Work<TI>>(){

            @Override
            public Iterator<Work<TI>> iterator() {
                return new Iterator<Work<TI>>(){

                    @Override
                    public boolean hasNext() {
                        return master.hasNext();
                    }

                    @Override
                    public Work<TI> next() {
                        Object[] data = new Object[Master.this.batchSize];
                        for (int i = 0; i < Master.this.batchSize && this.hasNext(); ++i) {
                            data[i] = master.next();
                            if (debug) {
                                Gpr.debug("countInputObjects:" + Master.this.countInputObjects);
                            }
                            Gpr.showMark(Master.this.countInputObjects++, Master.this.showEvery);
                        }
                        return new Work<Object>(data);
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("Unimplemented method");
                    }
                };
            }
        };
    }

    @Override
    public Iterator<TI> iterator() {
        return this;
    }

    @Override
    public abstract TI next();

    public void onReceive(Object message) {
        if (message instanceof StartMaster) {
            if (debug) {
                Gpr.debug("Start");
            }
            StartMaster start = (StartMaster)message;
            this.startMaster(start);
        } else if (message instanceof Result) {
            --this.sentWorks;
            Result result = (Result)message;
            if (debug) {
                Gpr.debug("Result: " + result.serialNumber);
            }
            this.processResults(result);
        } else {
            this.unhandled(message);
        }
        int threshold = LOAD_FACTOR * this.numWorkers;
        if (this.sentWorks < threshold) {
            for (Work<TI> work : this.iterableWork()) {
                ++this.sentWorks;
                this.workerRouter.tell(work, this.getSelf());
                if (debug) {
                    Gpr.debug("Sent: " + work.serialNumber);
                }
                if (this.sentWorks < threshold) continue;
                break;
            }
            if (this.sentWorks == 0 && !this.hasNext()) {
                this.shutdown();
            }
        }
    }

    protected void output(Result<TO> result) {
        for (Object t : result.data) {
            if (t == null) continue;
            this.output(t);
        }
    }

    protected void output(TO output) {
        System.out.println(output);
    }

    protected void processResults(Result<TO> result) {
        this.worksBySerial.put(result.serialNumber, result);
        while (this.worksBySerial.containsKey(this.nextOutput)) {
            Result<TO> out = this.worksBySerial.get(this.nextOutput);
            this.output((TO)out);
            this.worksBySerial.remove(this.nextOutput);
            ++this.nextOutput;
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unimplemented method");
    }

    protected void shutdown() {
        if (debug) {
            Gpr.debug("Shutting down");
        }
        this.getContext().system().shutdown();
    }

    protected void startMaster(StartMaster startMaster) {
        this.batchSize = startMaster.batchSize;
        this.showEvery = startMaster.showEvery;
    }
}

