/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.VEP;

import com.tinkerpop.pipes.PipeFunction;
import edu.mayo.bior.util.BiorProperties;
import edu.mayo.exec.AbnormalExitException;
import edu.mayo.exec.UnixStreamCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class VEPEXE
implements PipeFunction<String, String> {
    private static final Logger sLogger = Logger.getLogger(VEPEXE.class);
    private UnixStreamCommand mVep;
    private static final String VEP_BUFFER_SIZE = "1";
    private static final int VCF_REF_COL = 3;
    private static final int VCF_ALT_COL = 4;
    private static final long RECEIVE_TIMEOUT = 10L;
    private int mLinesSent = 0;

    public VEPEXE(String[] vepCmd) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        Map NO_CUSTOM_ENV = Collections.emptyMap();
        this.mVep = new UnixStreamCommand(VEPEXE.getVEPCommand(vepCmd), NO_CUSTOM_ENV, true, true);
        this.mVep.launch();
        this.mVep.send("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO");
        this.mVep.send("chr1\t1588717\trs009\tG\tA\t0.0\t.\t.");
        this.mVep.receive();
        this.mVep.receive();
        this.mVep.receive();
    }

    public VEPEXE() throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        this(VEPEXE.getVEPCommand(null));
    }

    public static String[] getVEPCommand(String[] userOptions) throws IOException {
        BiorProperties biorProps = new BiorProperties();
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(biorProps.get(BiorProperties.Key.BiorVepPerl), biorProps.get(BiorProperties.Key.BiorVep), "-i", "/dev/stdin", "-o", "STDOUT", "-dir", biorProps.get(BiorProperties.Key.BiorVepCache), "-vcf", "--hgnc", "-polyphen", "b", "-sift", "b", "--offline", "--buffer_size", VEP_BUFFER_SIZE));
        if (userOptions != null) {
            command.addAll(Arrays.asList(userOptions));
        }
        command.addAll(VEPEXE.getMacFlagsIfNecessary());
        return command.toArray(new String[command.size()]);
    }

    private static List<String> getMacFlagsIfNecessary() {
        String os = System.getProperty("os.name");
        ArrayList<String> macFlags = new ArrayList<String>();
        if (os.equals("Mac OS X")) {
            macFlags.add("--compress");
            macFlags.add("gunzip -c");
            sLogger.info((Object)String.format("Running on %s.  Adding Mac-specific options.", os));
        }
        return macFlags;
    }

    public String compute(String vcfLine) {
        if (this.bypass(vcfLine)) {
            sLogger.warn((Object)String.format("WARNING!!!!!  Line cannot be processed by VEP!!!!!!   bypassing VCF line: %s", vcfLine));
            return this.getFakeResponse(vcfLine);
        }
        try {
            sLogger.info((Object)("VEP - sending line #" + ++this.mLinesSent + ":  " + this.firstXchars(vcfLine, 100)));
            this.mVep.send(vcfLine);
            sLogger.info((Object)"VEP - Line sent.");
            try {
                sLogger.info((Object)"VEP - Receiving line...");
                String result = this.mVep.receive(10L, TimeUnit.SECONDS);
                String[] vepParts = result.split("\t");
                sLogger.info((Object)("VEP - received line: " + this.firstXchars(result, 100) + "\t....\t" + vepParts[vepParts.length - 1]));
                return result;
            }
            catch (TimeoutException te) {
                sLogger.warn((Object)String.format("Timeout of %s seconds reached for VCF line: %s", 10L, vcfLine));
                return this.getFakeResponse(vcfLine);
            }
        }
        catch (RuntimeException runtimeExc) {
            this.terminate();
            throw runtimeExc;
        }
        catch (Exception ex) {
            this.terminate();
            sLogger.error((Object)ex);
            throw new NoSuchElementException();
        }
    }

    private String firstXchars(String str, int charLimit) {
        if (str == null || str.length() < charLimit) {
            return str;
        }
        return str.substring(0, charLimit);
    }

    private String getFakeResponse(String vcfLine) {
        return vcfLine + "\tCSQ=VEPERR";
    }

    public void terminate() {
        try {
            this.mVep.terminate();
        }
        catch (Exception e) {
            sLogger.error((Object)("Error terminating VEPEXE pipe" + e));
        }
    }

    private boolean bypass(String line) {
        String[] cols = line.split("\t");
        if (cols.length < 5) {
            return true;
        }
        String ref = cols[3].trim();
        String alt = cols[4].trim();
        return alt.length() == 0 || alt.equals(".") || alt.equals(ref);
    }
}

