/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics;

import com.google.gson.JsonObject;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.GenomicObjectUtils;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class BED2JSONPipe
extends AbstractPipe<History, History> {
    private static final Logger sLogger = Logger.getLogger(BED2JSONPipe.class);
    private int mDataLineNumber = 1;
    private boolean first = true;

    private History doHeader(History h) {
        List<ColumnMetaData> columns = History.getMetaData().getColumns();
        if (columns.size() > 2 && h.size() > 2) {
            ColumnMetaData cmd = new ColumnMetaData("chrom");
            columns.set(0, cmd);
            cmd = new ColumnMetaData("chromStart");
            columns.set(1, cmd);
            cmd = new ColumnMetaData("chromEnd");
            columns.set(2, cmd);
            if (h.size() > 3) {
                cmd = new ColumnMetaData("name");
                columns.set(3, cmd);
            }
            if (h.size() > 4) {
                cmd = new ColumnMetaData("score");
                columns.set(4, cmd);
            }
            if (h.size() > 5) {
                cmd = new ColumnMetaData("strand");
                columns.set(5, cmd);
            }
            if (h.size() > 6) {
                cmd = new ColumnMetaData("thickStart");
                columns.set(6, cmd);
            }
            if (h.size() > 7) {
                cmd = new ColumnMetaData("thickEnd");
                columns.set(7, cmd);
            }
            if (h.size() > 8) {
                cmd = new ColumnMetaData("itemRgb");
                columns.set(8, cmd);
            }
            if (h.size() > 9) {
                cmd = new ColumnMetaData("blockCount");
                columns.set(9, cmd);
            }
            if (h.size() > 10) {
                cmd = new ColumnMetaData("blockSizes");
                columns.set(10, cmd);
            }
            if (h.size() > 11) {
                cmd = new ColumnMetaData("blockStarts");
                columns.set(11, cmd);
            }
        }
        return h;
    }

    protected History processNextStart() throws NoSuchElementException {
        History h = (History)this.starts.next();
        if (h.size() < 3) {
            int requiredColCount = 3;
            int actualColCount = h.size();
            StringBuilder sb = new StringBuilder();
            sb.append("Invalid BED data line at data line # %s.\n");
            sb.append("The BED format requires >2 fixed fields per data line, but found only %s field(s).\n");
            sb.append("Make sure the BED file has the necessary %s BED fields delimited by TAB characters.\n");
            sb.append("Invalid BED line content: \"%s\"");
            String errorMesg = String.format(sb.toString(), String.valueOf(this.mDataLineNumber), 3, actualColCount, 3, h.getMergedData("\t"));
            throw new InvalidPipeInputException(errorMesg, (Pipe)this);
        }
        if (this.first) {
            h = this.doHeader(h);
        }
        this.first = false;
        h.add(this.createJson(h).toString());
        ++this.mDataLineNumber;
        return h;
    }

    private JsonObject createJson(History h) {
        JsonObject json = new JsonObject();
        json.addProperty("chrom", (String)h.get(0));
        String chr = GenomicObjectUtils.computechr(((String)h.get(0)).trim());
        json.addProperty(CoreAttributes._landmark.toString(), chr);
        json.addProperty("chromStart", ((String)h.get(1)).trim());
        json.addProperty(CoreAttributes._minBP.toString(), (Number)(new Integer((String)h.get(1)) + 1));
        json.addProperty("chromEnd", ((String)h.get(2)).trim());
        json.addProperty(CoreAttributes._maxBP.toString(), (Number)new Integer((String)h.get(2)));
        if (h.size() > 3) {
            json.addProperty("name", ((String)h.get(3)).trim());
        }
        if (h.size() > 4) {
            json.addProperty("score", ((String)h.get(4)).trim());
        }
        if (h.size() > 5) {
            json.addProperty("strand", ((String)h.get(5)).trim());
        }
        if (h.size() > 6) {
            json.addProperty("thickStart", ((String)h.get(6)).trim());
        }
        if (h.size() > 7) {
            json.addProperty("thickEnd", ((String)h.get(7)).trim());
        }
        if (h.size() > 8) {
            json.addProperty("itemRgb", ((String)h.get(8)).trim());
        }
        if (h.size() > 9) {
            json.addProperty("blockCount", ((String)h.get(9)).trim());
        }
        if (h.size() > 10) {
            json.addProperty("blockSizes", ((String)h.get(10)).trim());
        }
        if (h.size() > 11) {
            json.addProperty("blockStarts", ((String)h.get(11)).trim());
        }
        return json;
    }
}

