/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.genBank;

import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.genBank.Feature;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class Features
implements Iterable<Feature> {
    public static final int MAX_LEN_TO_SHOW = 200;
    public static final String COMPLEMENT = "complement";
    public static final String JOIN = "join";
    String locusName;
    String moleculeType;
    String shape;
    String division;
    String date;
    int sequenceLength;
    String definition = "";
    String accession = "";
    String version = "";
    String keywords = "";
    String source = "";
    String organism = "";
    StringBuffer featuresStr;
    StringBuffer sequence;
    ArrayList<Feature> features;
    ArrayList<StringBuffer> references = new ArrayList();
    LineFileIterator lineFileIterator;

    public Features(LineFileIterator lineFileIterator) {
        this.featuresStr = new StringBuffer();
        this.sequence = new StringBuffer();
        this.features = new ArrayList();
        this.lineFileIterator = lineFileIterator;
        this.readFile();
    }

    public Features(String fileName) {
        this.featuresStr = new StringBuffer();
        this.sequence = new StringBuffer();
        this.features = new ArrayList();
        this.open(fileName);
        this.readFile();
    }

    void addFeature(String typeStr, StringBuilder values) {
        Feature.Type type = Feature.Type.parse(typeStr);
        if (type == null) {
            Gpr.debug("WARNING: Unknown feature '" + typeStr + "', not added.");
            return;
        }
        try {
            Collection<Feature> newFeatures = this.featureFactory(type, values.toString());
            this.features.addAll(newFeatures);
        }
        catch (Exception e) {
            Gpr.debug("Error parsing feature type '" + typeStr + "' -> '" + (Object)((Object)type) + "':\n" + values);
            throw new RuntimeException(e);
        }
    }

    Collection<Feature> featureFactory(Feature.Type type, String def) {
        String[] locs;
        boolean complement = false;
        LinkedList<Feature> features = new LinkedList<Feature>();
        int firstLine = def.indexOf("\n");
        if (def.indexOf("SPAC3C7.03c") > 0) {
            Gpr.debug("def=|" + def + "|\tfirstLine: " + firstLine);
        }
        String locStr = firstLine >= 0 ? def.substring(0, firstLine) : def;
        String locStrPrev = "";
        while (!locStr.equals(locStrPrev)) {
            locStrPrev = locStr;
            if (locStr.startsWith(COMPLEMENT)) {
                complement = true;
                locStr = this.removeStartStr(locStr, COMPLEMENT);
            }
            locStr = this.removeStartStr(locStr, JOIN);
        }
        for (String loc : locs = locStr.split(",")) {
            int end;
            int start;
            String locPrev = "";
            while (!loc.equals(locPrev)) {
                locPrev = loc;
                if (loc.startsWith(COMPLEMENT)) {
                    complement = true;
                    loc = this.removeStartStr(loc, COMPLEMENT);
                }
                loc = this.removeStartStr(loc, JOIN);
            }
            String[] startEnd = (loc = loc.replaceAll("[<>()]", "")).split("[\\.]+");
            if (startEnd.length == 2) {
                start = Gpr.parseIntSafe(startEnd[0]);
                end = Gpr.parseIntSafe(startEnd[1]);
            } else if (startEnd.length == 1) {
                end = start = Gpr.parseIntSafe(startEnd[0]);
            } else {
                throw new RuntimeException("Cannot calculate start & end coordinates: '" + loc + "'");
            }
            Feature feature = new Feature(type, def, start, end, complement);
            features.add(feature);
        }
        return features;
    }

    public String getAccession() {
        return this.accession;
    }

    public String getDate() {
        return this.date;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getDivision() {
        return this.division;
    }

    public ArrayList<Feature> getFeatures() {
        return this.features;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getLocusName() {
        return this.locusName;
    }

    public String getMoleculeType() {
        return this.moleculeType;
    }

    public String getOrganism() {
        return this.organism;
    }

    public ArrayList<StringBuffer> getReferences() {
        return this.references;
    }

    public String getSequence() {
        return this.sequence.toString();
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }

    public String getShape() {
        return this.shape;
    }

    public String getSource() {
        return this.source;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isEmpty() {
        return this.features.isEmpty();
    }

    protected abstract boolean isNewFeature(String var1);

    @Override
    public Iterator<Feature> iterator() {
        return this.features.iterator();
    }

    protected void open(String fileName) {
        if (!Gpr.canRead(fileName)) {
            throw new RuntimeException("Cannot read file '" + fileName + "'");
        }
        if (this.lineFileIterator != null) {
            this.lineFileIterator.close();
        }
        this.lineFileIterator = new LineFileIterator(fileName);
    }

    protected void parseFeatures() {
        if (this.featuresStr.length() <= 0) {
            return;
        }
        String type = null;
        String value = "";
        StringBuilder values = new StringBuilder();
        for (String line : this.featuresStr.toString().split("\n")) {
            if (this.isNewFeature(line)) {
                String[] kv = line.trim().split(" ", 2);
                if (kv.length > 1) {
                    if (type != null) {
                        this.addFeature(type, values);
                        values = new StringBuilder();
                    }
                    type = kv[0];
                    value = kv[1].trim();
                }
            } else {
                value = line.trim();
            }
            if (value.startsWith("/")) {
                values.append("\n");
            }
            values.append(value);
        }
        this.addFeature(type, values);
    }

    protected abstract void readFile();

    String removeStartStr(String str, String startStr) {
        if (str.startsWith(startStr)) {
            return str.substring(startStr.length() + 1, str.length());
        }
        return str;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name            : " + this.locusName + "\n");
        sb.append("Sequence length : " + this.sequence.length() + "\n");
        for (StringBuffer refsb : this.references) {
            sb.append("Reference       :\n");
            for (String l : refsb.toString().split("\n")) {
                sb.append("                 " + l + "\n");
            }
        }
        if (this.sequence.length() <= 200) {
            sb.append("Sequence        : " + this.sequence + "\n");
        } else {
            sb.append("Sequence        : " + this.sequence.substring(0, 200) + "..." + "\n");
        }
        for (Feature f : this.features) {
            sb.append(f);
        }
        return sb.toString();
    }
}

